/*
 * Decompiled with CFR 0.152.
 */
package com.webwag.HTTP;

import com.webwag.utils.UtilMidp;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Cookie {
    public static final String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    public static final String[] days = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
    private String a;
    private String b;
    private String c = null;
    private String d = null;
    private Date a;
    private boolean a = false;

    private Cookie() {
    }

    public Cookie(String string, String string2) {
        Vector vector = UtilMidp.explode(string, ";");
        if (vector.size() < 1) {
            throw new IllegalArgumentException("Bad cookie, no name=value pair found.");
        }
        String string3 = (String)vector.elementAt(0);
        int n = string3.indexOf(61);
        if (n == -1) {
            throw new IllegalArgumentException("Bad cookie. malformed name=value pair");
        }
        this.a = string3.substring(0, n).trim();
        this.b = string3.substring(n + 1).trim();
        for (int i = 1; i < vector.size(); ++i) {
            String string4;
            String string5;
            string3 = (String)vector.elementAt(i);
            n = string3.indexOf(61);
            if (n == -1) {
                string4 = string5 = string3.trim().toLowerCase();
            } else {
                string5 = string3.substring(0, n).trim().toLowerCase();
                string4 = string3.substring(n + 1).trim();
            }
            if (string5.length() == 0) continue;
            if (string5.equals("path")) {
                this.d = string4;
                continue;
            }
            if (string5.equals("domain")) {
                this.c = string4;
                continue;
            }
            if (string5.equals("expires")) {
                String string6 = string4;
                Vector vector2 = UtilMidp.explode(string6, " ");
                if (vector2.size() < 3) {
                    throw new IllegalArgumentException("Bad cookie, malformed expiration date " + string6);
                }
                try {
                    String string7 = (String)vector2.elementAt(0);
                    String string8 = (String)vector2.elementAt(1);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    vector2 = UtilMidp.explode(string7, "-");
                    calendar.set(1, Integer.parseInt((String)vector2.elementAt(2)));
                    String string9 = ((String)vector2.elementAt(1)).toLowerCase();
                    int n2 = 0;
                    for (n2 = 0; n2 < months.length && !months[n2].startsWith(string9); ++n2) {
                    }
                    calendar.set(2, n2);
                    calendar.set(5, Integer.parseInt((String)vector2.elementAt(0)));
                    vector2 = UtilMidp.explode(string8, ":");
                    calendar.set(10, Integer.parseInt((String)vector2.elementAt(0)));
                    calendar.set(12, Integer.parseInt((String)vector2.elementAt(1)));
                    calendar.set(13, Integer.parseInt((String)vector2.elementAt(2)));
                    this.a = calendar.getTime();
                    continue;
                }
                catch (Exception exception) {
                    System.err.println("Failed to parse expiration date of cookie.");
                    throw new IllegalArgumentException("Bad cookie, malformed expiration date " + string6);
                }
            }
            if (string5.equals("secure")) {
                this.a = true;
                continue;
            }
            System.err.println("Unknown cookie attribute " + string3);
        }
        if (this.d == null) {
            this.d = "/";
        }
        if (this.c == null) {
            Vector vector3 = UtilMidp.explode(string2, ".");
            this.c = vector3.size() < 3 ? string2 : "." + vector3.elementAt(vector3.size() - 2) + "." + vector3.elementAt(vector3.size() - 1);
        }
    }

    public static Vector splitCookies(String string) {
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector2 = UtilMidp.explode(string, ",");
        for (int i = 0; i < vector2.size(); ++i) {
            String string2 = (String)vector2.elementAt(i);
            boolean bl = false;
            for (int j = 0; j < days.length; ++j) {
                if (!string2.endsWith(days[j])) continue;
                string2 = string2.substring(0, string2.length() - days[j].length());
                bl = true;
                break;
            }
            stringBuffer.append(string2);
            if (bl) continue;
            vector.addElement(stringBuffer.toString());
            stringBuffer = new StringBuffer();
        }
        return vector;
    }

    public static void serialize(Cookie cookie, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeUTF(cookie.a);
        dataOutputStream.writeUTF(cookie.b);
        dataOutputStream.writeUTF(cookie.c);
        dataOutputStream.writeUTF(cookie.d);
        if (cookie.a != null) {
            dataOutputStream.writeLong(cookie.a.getTime());
        } else {
            dataOutputStream.writeLong(0L);
        }
        dataOutputStream.writeBoolean(cookie.a);
    }

    public static Cookie deSerialize(DataInputStream dataInputStream) throws IOException {
        Cookie cookie = new Cookie();
        cookie.a = dataInputStream.readUTF();
        cookie.b = dataInputStream.readUTF();
        cookie.c = dataInputStream.readUTF();
        cookie.d = dataInputStream.readUTF();
        long l = dataInputStream.readLong();
        cookie.a = l == 0L ? null : new Date(l);
        cookie.a = dataInputStream.readBoolean();
        return cookie;
    }

    public boolean match(String string, String string2) {
        return string.endsWith(this.c) && string2.startsWith(this.d);
    }

    public String toString() {
        return this.a + "=" + this.b;
    }

    public String getName() {
        return this.a;
    }

    public String getValue() {
        return this.b;
    }

    public String getDomain() {
        return this.c;
    }

    public String getPath() {
        return this.d;
    }

    public Date getExpires() {
        return this.a;
    }

    public boolean isSecure() {
        return this.a;
    }
}

