/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class Teclado
extends Canvas
implements Runnable {
    private static final int MAX_PUNTOS = 10;
    private Punto[] puntos;
    private Tecla[] teclas;
    private int blancas;
    private Piano piano;
    private Player p;
    private MIDIControl mc;
    private int offset;
    private boolean barraVisible;
    private boolean barraActiva;
    private int offsetBarra;
    private int lB;
    private int lB2;
    private int iO;
    private int aO;
    private int lO;
    private Image imgBarra;
    private Image imgTeclado;
    private Image imgNegra;
    private Image imgNegra_h;
    private boolean repintarBarra;
    private boolean repintarVolumen;
    private boolean repintarOffset;
    private boolean repintarTeclado;

    public Teclado(Piano piano) throws Exception {
        this.piano = piano;
        this.setFullScreenMode(true);
        if (!this.hasPointerEvents()) {
            throw new Exception(Idioma.texto_error_tactil[piano.getIdioma()]);
        }
        this.puntos = new Punto[10];
        int i = 0;
        while (i < this.puntos.length) {
            this.puntos[i] = new Punto();
            ++i;
        }
        this.offsetBarra = 0;
        this.barraVisible = true;
        this.lB = 60;
        this.lB2 = 30;
        this.p = Manager.createPlayer((String)"device://midi");
        this.crearTeclado();
    }

    protected int getOffset() {
        return this.offset;
    }

    protected void setOffset(int offset) {
        int anchoTecla = 20 * (4 - this.piano.getZoom());
        int offsetAnt = this.offset;
        this.offset = offset > 0 || this.blancas * anchoTecla <= this.getWidth() * this.piano.numTeclados() ? 0 : (offset < this.getWidth() * this.piano.numTeclados() - this.blancas * anchoTecla ? this.getWidth() * this.piano.numTeclados() - this.blancas * anchoTecla : offset);
        if (this.offset != offsetAnt) {
            this.repintarOffset = true;
            this.repintarTeclado = true;
        }
    }

    public void crearTeclado() {
        this.blancas = this.piano.getInstrumento().getBlancas();
        while (Tecla.existeSostenido(this.blancas - 1)) {
            ++this.blancas;
        }
        this.teclas = new Tecla[Tecla.getIndiceTecla(this.blancas, false)];
        int i = 0;
        while (i < this.blancas) {
            this.teclas[Tecla.getIndiceTecla((int)i, (boolean)false)] = new Tecla(i, false, 12 * this.piano.getInstrumento().getOctava() + Tecla.getIndiceTecla(i, false));
            if (Tecla.existeSostenido(i)) {
                this.teclas[Tecla.getIndiceTecla((int)i, (boolean)true)] = new Tecla(i, true, 12 * this.piano.getInstrumento().getOctava() + Tecla.getIndiceTecla(i, true));
            }
            ++i;
        }
        this.crearImagenTeclado();
        this.setOffset(0);
    }

    private void activarTecla(Tecla tecla) {
        if (this.piano.getRecord().grabando()) {
            this.piano.getRecord().grabarEvento(0, Tecla.getIndiceTecla(tecla.getTecla(), tecla.esSostenido()));
        }
        this.mc.shortMidiEvent(144, tecla.getNota(), this.piano.getVolumen() * 127 / 10);
        tecla.setActiva(true);
        if (!this.piano.getRecord().reproduciendo() || this.piano.getModo() != 1) {
            this.repintarTecla(tecla);
        }
    }

    private void desactivarTecla(Tecla tecla) {
        if (this.piano.getRecord().grabando()) {
            this.piano.getRecord().grabarEvento(1, Tecla.getIndiceTecla(tecla.getTecla(), tecla.esSostenido()));
        }
        if (this.piano.getInstrumento().silenciarNota()) {
            this.mc.shortMidiEvent(144, tecla.getNota(), 0);
        }
        tecla.setActiva(false);
        if (!this.piano.getRecord().reproduciendo() || this.piano.getModo() != 1) {
            this.repintarTecla(tecla);
        }
    }

    protected void activarTecla(int tecla) {
        this.activarTecla(this.teclas[tecla]);
    }

    protected void desactivarTecla(int tecla) {
        this.desactivarTecla(this.teclas[tecla]);
    }

    protected void desactivarTeclas() {
        int i = 0;
        while (i < this.teclas.length) {
            if (this.teclas[i].esActiva()) {
                this.desactivarTecla(this.teclas[i]);
            }
            ++i;
        }
    }

    private void comprobarTeclas() {
        int anchoTecla = 20 * (4 - this.piano.getZoom());
        int i = 0;
        while (i < this.teclas.length) {
            if (this.teclas[i].esActiva()) {
                boolean activa = false;
                int j = 0;
                while (j < this.puntos.length) {
                    if (this.puntos[j].activo()) {
                        if (this.teclas[i].equals(this.getControl(this.puntos[j].getX(), this.puntos[j].getY()))) {
                            activa = true;
                            break;
                        }
                        if (this.piano.getProximidad() && this.getControl(this.puntos[j].getX(), this.puntos[j].getY()) instanceof Tecla && (this.teclas[i].equals(this.getControl(this.puntos[j].getX() - anchoTecla / 8, this.puntos[j].getY())) || this.teclas[i].equals(this.getControl(this.puntos[j].getX() + anchoTecla / 8, this.puntos[j].getY())))) {
                            activa = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (!activa) {
                    this.desactivarTecla(this.teclas[i]);
                }
            } else {
                int j = 0;
                while (j < this.puntos.length) {
                    if (this.puntos[j].activo()) {
                        if (this.teclas[i].equals(this.getControl(this.puntos[j].getX(), this.puntos[j].getY()))) {
                            this.activarTecla(this.teclas[i]);
                            break;
                        }
                        if (this.piano.getProximidad() && this.getControl(this.puntos[j].getX(), this.puntos[j].getY()) instanceof Tecla && (this.teclas[i].equals(this.getControl(this.puntos[j].getX() - anchoTecla / 8, this.puntos[j].getY())) || this.teclas[i].equals(this.getControl(this.puntos[j].getX() + anchoTecla / 8, this.puntos[j].getY())))) {
                            this.activarTecla(this.teclas[i]);
                            break;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    protected void crearImagenBarra() {
        this.imgBarra = Image.createImage((int)this.getWidth(), (int)(this.lB + this.lB2));
        Graphics gb = this.imgBarra.getGraphics();
        gb.setClip(0, 0, this.getWidth(), this.lB + this.lB2);
        gb.setColor(0, 0, 0);
        gb.fillRect(0, 0, this.getWidth(), this.lB + this.lB2);
        gb.drawImage(Imagenes.imgVolumen, 0, 0, 20);
        gb.drawImage(Imagenes.imgSalir, this.getWidth(), 0, 24);
        gb.drawImage(Imagenes.imgAjustes, this.getWidth() - this.lB, 0, 24);
        gb.drawImage(this.piano.bloqueo() ? Imagenes.imgDesbloqueo : Imagenes.imgBloqueo, this.getWidth() - 2 * this.lB, 0, 24);
        gb.drawImage(Imagenes.imgZoom, this.getWidth() - 3 * this.lB, 0, 24);
        gb.drawImage(this.piano.dobleTeclado() ? Imagenes.imgSimple : Imagenes.imgDoble, this.getWidth() - 4 * this.lB, 0, 24);
        gb.drawImage(Imagenes.imgInstrumento, this.getWidth() - 5 * this.lB, 0, 24);
        if (!this.piano.getRecord().enPausa()) {
            gb.drawImage(Imagenes.imgSombra, this.getWidth() - this.lB, 0, 24);
            gb.drawImage(Imagenes.imgSombra, this.getWidth() - 2 * this.lB, 0, 24);
            gb.drawImage(Imagenes.imgSombra, this.getWidth() - 3 * this.lB, 0, 24);
            gb.drawImage(Imagenes.imgSombra, this.getWidth() - 4 * this.lB, 0, 24);
            gb.drawImage(Imagenes.imgSombra, this.getWidth() - 5 * this.lB, 0, 24);
        }
        gb.setColor(255, 255, 255);
        gb.drawString(this.piano.getInstrumento().getNombre(this.piano.getIdioma()), this.lB + 6, this.lB - 4, 36);
        gb.setColor(100, 100, 100);
        gb.fillRect(0, this.lB, this.getWidth(), this.lB2);
        if (this.piano.getRecord().grabando()) {
            gb.drawImage(Imagenes.imgRec, 0, this.lB, 20);
        } else if (this.piano.getRecord().reproduciendo()) {
            gb.drawImage(Imagenes.imgPlay, 0, this.lB, 20);
        }
        gb.drawImage(Imagenes.imgTracks[this.piano.getCodigoRecord()], this.lB + 5, this.lB, 20);
        gb.drawImage(this.piano.getRecord().enPausa() && this.piano.getRecord().getLongitud() > 0 ? Imagenes.imgReproducir : Imagenes.imgReproducir_h, this.lB + 55, this.lB, 20);
        gb.drawImage(this.piano.getRecord().enPausa() ? Imagenes.imgGrabar : Imagenes.imgGrabar_h, this.lB + 105, this.lB, 20);
        gb.drawImage(!this.piano.getRecord().enPausa() ? Imagenes.imgParar : Imagenes.imgParar_h, this.lB + 155, this.lB, 20);
        this.iO = this.getWidth() - 5 * this.lB - 10;
        this.aO = Imagenes.imgOffset.getWidth();
        this.lO = this.lB * 4 + 20;
        gb.drawImage(Imagenes.imgScroll, this.iO - 4, this.lB, 24);
        gb.setColor(255, 255, 255);
        gb.drawLine(this.iO + 10, this.lB + this.lB2 / 2, this.iO + this.lO - 10, this.lB + this.lB2 / 2);
        gb.drawImage(this.barraVisible ? (this.piano.getRecord().enPausa() ? Imagenes.imgUp : Imagenes.imgUp_h) : (this.piano.getRecord().enPausa() ? Imagenes.imgDown : Imagenes.imgDown_h), this.getWidth(), this.lB, 24);
        this.repintarBarra = true;
    }

    protected void crearImagenTeclado() {
        int anchoTecla = 20 * (4 - this.piano.getZoom());
        int altoTecla = (this.getHeight() - (this.lB + this.offsetBarra) - this.lB2) / this.piano.numTeclados();
        this.imgTeclado = Image.createImage((int)(this.blancas * anchoTecla), (int)altoTecla);
        Graphics gt = this.imgTeclado.getGraphics();
        gt.setColor(0, 0, 0);
        gt.fillRect(0, 0, this.blancas * anchoTecla, altoTecla);
        this.imgNegra = Image.createImage((int)Imagenes.imgNegra_a[2 - this.piano.getZoom()].getWidth(), (int)(altoTecla / 2));
        this.imgNegra_h = Image.createImage((int)Imagenes.imgNegra_a_h[2 - this.piano.getZoom()].getWidth(), (int)(altoTecla / 2));
        Graphics gn = this.imgNegra.getGraphics();
        Graphics gn_h = this.imgNegra_h.getGraphics();
        int i = 0;
        while (i < altoTecla / (2 * Imagenes.imgNegra_b[2 - this.piano.getZoom()].getHeight())) {
            gn.drawImage(Imagenes.imgNegra_b[2 - this.piano.getZoom()], 0, i * Imagenes.imgNegra_b[2 - this.piano.getZoom()].getHeight(), 20);
            gn_h.drawImage(Imagenes.imgNegra_b_h[2 - this.piano.getZoom()], 0, i * Imagenes.imgNegra_b_h[2 - this.piano.getZoom()].getHeight(), 20);
            ++i;
        }
        gn.drawImage(Imagenes.imgNegra_a[2 - this.piano.getZoom()], 0, altoTecla / 2 - Imagenes.imgNegra_a[2 - this.piano.getZoom()].getHeight(), 20);
        gn_h.drawImage(Imagenes.imgNegra_a_h[2 - this.piano.getZoom()], 0, altoTecla / 2 - Imagenes.imgNegra_a_h[2 - this.piano.getZoom()].getHeight(), 20);
        i = 0;
        while (i < this.teclas.length) {
            this.repintarTecla(this.teclas[i]);
            ++i;
        }
        this.repintarTeclado = true;
    }

    private void repintarTecla(Tecla tecla) {
        Graphics gt = this.imgTeclado.getGraphics();
        int anchoTecla = 20 * (4 - this.piano.getZoom());
        int altoTecla = (this.getHeight() - (this.lB + this.offsetBarra) - this.lB2) / this.piano.numTeclados();
        if (!tecla.esSostenido()) {
            int tipo = 0;
            if (!Tecla.existeSostenido(tecla.getTecla())) {
                tipo = 1;
            } else if (tecla.getTecla() > 0) {
                if (!Tecla.existeSostenido(tecla.getTecla() - 1)) {
                    tipo = 2;
                }
            } else {
                tipo = 2;
            }
            if (tecla.esActiva()) {
                switch (tipo) {
                    case 0: {
                        gt.setColor(230, 230, 230);
                        gt.fillRect(tecla.getTecla() * anchoTecla + this.imgNegra.getWidth() / 2, 0, anchoTecla - this.imgNegra.getWidth(), this.imgNegra.getHeight());
                        break;
                    }
                    case 1: {
                        gt.setColor(0, 0, 0);
                        gt.fillRect(tecla.getTecla() * anchoTecla + this.imgNegra.getWidth() / 2, 0, anchoTecla - this.imgNegra.getWidth() / 2, this.imgNegra.getHeight());
                        gt.setColor(230, 230, 230);
                        gt.fillRect(tecla.getTecla() * anchoTecla + this.imgNegra.getWidth() / 2, 0, (int)((double)anchoTecla * 0.95) - this.imgNegra.getWidth() / 2, this.imgNegra.getHeight());
                        break;
                    }
                    case 2: {
                        gt.setColor(0, 0, 0);
                        gt.fillRect(tecla.getTecla() * anchoTecla, 0, anchoTecla - this.imgNegra.getWidth() / 2, this.imgNegra.getHeight());
                        gt.setColor(230, 230, 230);
                        gt.fillRect(tecla.getTecla() * anchoTecla + (int)((double)anchoTecla * 0.05), 0, (int)((double)anchoTecla * 0.95) - this.imgNegra.getWidth() / 2, this.imgNegra.getHeight());
                        break;
                    }
                }
                gt.setColor(0, 0, 0);
                gt.fillRect(tecla.getTecla() * anchoTecla, this.imgNegra.getHeight(), anchoTecla, altoTecla - this.imgNegra.getHeight());
                gt.setColor(230, 230, 230);
                gt.fillRect(tecla.getTecla() * anchoTecla + (int)((double)anchoTecla * 0.05), this.imgNegra.getHeight(), (int)((double)anchoTecla * 0.9), altoTecla - this.imgNegra.getHeight());
                gt.setColor(100, 100, 100);
                gt.fillRect(tecla.getTecla() * anchoTecla + (int)((double)anchoTecla * 0.05), altoTecla - (int)((double)anchoTecla * 0.1), (int)((double)anchoTecla * 0.9), (int)((double)anchoTecla * 0.1));
            } else {
                gt.setColor(255, 255, 255);
                switch (tipo) {
                    case 0: {
                        gt.fillRect(tecla.getTecla() * anchoTecla + this.imgNegra.getWidth() / 2, 0, anchoTecla - this.imgNegra.getWidth(), this.imgNegra.getHeight());
                        break;
                    }
                    case 1: {
                        gt.fillRect(tecla.getTecla() * anchoTecla + this.imgNegra.getWidth() / 2, 0, (int)((double)anchoTecla * 0.975) - this.imgNegra.getWidth() / 2, this.imgNegra.getHeight());
                        break;
                    }
                    case 2: {
                        gt.fillRect(tecla.getTecla() * anchoTecla + (int)((double)anchoTecla * 0.025), 0, (int)Math.ceil((double)anchoTecla * 0.975) - this.imgNegra.getWidth() / 2, this.imgNegra.getHeight());
                        break;
                    }
                }
                gt.fillRect(tecla.getTecla() * anchoTecla + (int)((double)anchoTecla * 0.025), this.imgNegra.getHeight(), (int)((double)anchoTecla * 0.95), altoTecla - this.imgNegra.getHeight());
                gt.setColor(100, 100, 100);
                gt.fillRect(tecla.getTecla() * anchoTecla + (int)((double)anchoTecla * 0.025), altoTecla - (int)((double)anchoTecla * 0.2), (int)((double)anchoTecla * 0.95), (int)((double)anchoTecla * 0.2));
                gt.setColor(160, 160, 160);
                gt.fillRect(tecla.getTecla() * anchoTecla + (int)((double)anchoTecla * 0.025), altoTecla - (int)((double)anchoTecla * 0.12), (int)((double)anchoTecla * 0.95), (int)((double)anchoTecla * 0.12));
            }
        } else if (tecla.esActiva()) {
            gt.drawImage(this.imgNegra_h, (tecla.getTecla() + 1) * anchoTecla - this.imgNegra.getWidth() / 2, 0, 20);
        } else {
            gt.drawImage(this.imgNegra, (tecla.getTecla() + 1) * anchoTecla - this.imgNegra.getWidth() / 2, 0, 20);
        }
        this.repintarTeclado = true;
    }

    public void paint(Graphics g) {
        int anchoTecla = 20 * (4 - this.piano.getZoom());
        int altoTecla = (this.getHeight() - (this.lB + this.offsetBarra + this.lB2)) / this.piano.numTeclados();
        if (this.repintarBarra) {
            this.repintarBarra = false;
            this.repintarVolumen = false;
            this.repintarOffset = false;
            g.drawImage(this.imgBarra, 0, this.offsetBarra, 20);
            g.setColor(0, 0, 0);
            g.fillRect(20, this.offsetBarra + 10, 20, (10 - this.piano.getVolumen()) * 5);
            if (Imagenes.imgScroll.getWidth() + 12 <= this.getWidth() - 6 * this.lB && anchoTecla * this.blancas > this.getWidth() * this.piano.numTeclados()) {
                g.drawImage(Imagenes.imgOffset, this.iO - (this.lO - this.aO) * this.offset / (this.blancas * anchoTecla - this.getWidth() * this.piano.numTeclados()), this.lB + this.offsetBarra + this.lB2 / 2, 6);
            }
        } else {
            if (this.repintarVolumen) {
                this.repintarVolumen = false;
                g.setColor(0, 0, 0);
                g.fillRect(0, 0, this.lB, this.lB);
                g.drawImage(Imagenes.imgVolumen, 0, this.offsetBarra, 20);
                g.fillRect(20, this.offsetBarra + 10, 20, (10 - this.piano.getVolumen()) * 5);
            }
            if (this.repintarOffset) {
                this.repintarOffset = false;
                g.setColor(100, 100, 100);
                g.fillRect(this.iO, this.lB + this.offsetBarra, this.lO, this.lB2);
                g.setColor(255, 255, 255);
                g.drawLine(this.iO + 10, this.lB + this.offsetBarra + this.lB2 / 2, this.iO + this.lO - 10, this.lB + this.offsetBarra + this.lB2 / 2);
                if (Imagenes.imgScroll.getWidth() + 12 <= this.getWidth() - 6 * this.lB && anchoTecla * this.blancas > this.getWidth() * this.piano.numTeclados()) {
                    g.drawImage(Imagenes.imgOffset, this.iO - (this.lO - this.aO) * this.offset / (this.blancas * anchoTecla - this.getWidth() * this.piano.numTeclados()), this.lB + this.offsetBarra + this.lB2 / 2, 6);
                }
            }
        }
        if (this.repintarTeclado) {
            this.repintarTeclado = false;
            g.setColor(0, 0, 0);
            g.fillRect(0, this.lB + this.offsetBarra + this.lB2, this.getWidth(), altoTecla * this.piano.numTeclados());
            g.setClip(0, this.lB + this.offsetBarra + this.lB2, this.getWidth(), altoTecla);
            g.drawImage(this.imgTeclado, this.offset, this.lB + this.offsetBarra + this.lB2, 20);
            if (this.barraActiva) {
                g.drawImage(this.imgTeclado, this.offset, this.lB + this.offsetBarra + this.lB2 + altoTecla - this.imgTeclado.getHeight(), 20);
                g.setClip(0, this.lB + this.offsetBarra + this.lB2, this.getWidth(), 3 * altoTecla / 4);
                g.drawImage(this.imgTeclado, this.offset, this.lB + this.offsetBarra + this.lB2 + (altoTecla - this.imgTeclado.getHeight()) / 2, 20);
            }
            if (this.piano.dobleTeclado()) {
                g.setClip(0, this.lB + this.offsetBarra + this.lB2 + altoTecla, this.getWidth(), altoTecla);
                g.drawImage(this.imgTeclado, this.offset - this.getWidth(), this.lB + this.offsetBarra + this.lB2 + altoTecla, 20);
                if (this.barraActiva) {
                    g.drawImage(this.imgTeclado, this.offset - this.getWidth(), this.lB + this.offsetBarra + this.lB2 + 2 * altoTecla - this.imgTeclado.getHeight(), 20);
                    g.setClip(0, this.lB + this.offsetBarra + this.lB2 + altoTecla, this.getWidth(), 3 * altoTecla / 4);
                    g.drawImage(this.imgTeclado, this.offset - this.getWidth(), this.lB + this.offsetBarra + this.lB2 + altoTecla + (altoTecla - this.imgTeclado.getHeight()) / 2, 20);
                }
                g.setClip(0, this.lB + this.offsetBarra + this.lB2, this.getWidth(), altoTecla * 2);
                g.drawImage(Imagenes.imgFlecha, this.getWidth(), this.lB + this.offsetBarra + this.lB2 + (int)(((double)altoTecla - (double)anchoTecla * 0.2) / 2.0), 10);
                g.drawImage(Imagenes.imgFlecha, 0, this.lB + this.offsetBarra + this.lB2 + altoTecla + (int)(((double)altoTecla - (double)anchoTecla * 0.2) / 2.0), 6);
            }
        }
    }

    public void update(Graphics g) {
    }

    private Object getControl(int x, int y) {
        int anchoTecla = 20 * (4 - this.piano.getZoom());
        if (y <= this.lB + this.offsetBarra) {
            if (this.barraVisible) {
                if (x > this.getWidth() - this.lB) {
                    return "salir";
                }
                if (x > this.getWidth() - this.lB * 2) {
                    if (this.piano.getRecord().enPausa()) {
                        return "ajustes";
                    }
                } else if (x > this.getWidth() - this.lB * 3) {
                    if (this.piano.getRecord().enPausa()) {
                        return "bloqueo";
                    }
                } else if (x > this.getWidth() - this.lB * 4) {
                    if (this.piano.getRecord().enPausa()) {
                        return "zoom";
                    }
                } else if (x > this.getWidth() - this.lB * 5) {
                    if (this.piano.getRecord().enPausa()) {
                        return "doble";
                    }
                } else if (x > this.getWidth() - this.lB * 6) {
                    if (this.piano.getRecord().enPausa()) {
                        return "instrumento";
                    }
                } else if (x > 15 && x < 45) {
                    return "volumen";
                }
            }
        } else if (y <= this.lB + this.offsetBarra + this.lB2) {
            if (x > this.getWidth() - 50) {
                if (this.piano.getRecord().enPausa()) {
                    return "barra";
                }
            } else if (x > this.iO && x < this.iO + this.lO) {
                if (!this.piano.getRecord().reproduciendo() && this.blancas * anchoTecla > this.getWidth() * this.piano.numTeclados()) {
                    return "offset";
                }
            } else if (x > this.lB + 150 && x < this.lB + 200) {
                if (!this.piano.getRecord().enPausa()) {
                    return "parar";
                }
            } else if (x > this.lB + 100 && x < this.lB + 150) {
                if (this.piano.getRecord().enPausa()) {
                    return "grabar";
                }
            } else if (x > this.lB + 50 && x < this.lB + 100) {
                if (this.piano.getRecord().enPausa() && this.piano.getRecord().getLongitud() > 0) {
                    return "reproducir";
                }
            } else if (x > this.lB && x < this.lB + 50) {
                return "track";
            }
        } else {
            int altoTecla = (this.getHeight() - (this.lB + this.offsetBarra) - this.lB2) / this.piano.numTeclados();
            int seccion = 2 * (y - (this.lB + this.offsetBarra) - this.lB2) / altoTecla;
            if (x < this.offset + this.blancas * anchoTecla - this.getWidth() * (seccion / 2) && !this.piano.getRecord().reproduciendo()) {
                boolean sostenido;
                int blanca;
                if (seccion % 2 != 0) {
                    blanca = (x - this.offset + seccion / 2 * this.getWidth()) / anchoTecla;
                    sostenido = false;
                } else {
                    blanca = (x - this.offset + seccion / 2 * this.getWidth() + anchoTecla / 2) / anchoTecla - 1;
                    if (blanca < 0 || !Tecla.existeSostenido(blanca)) {
                        blanca = (x - this.offset + seccion / 2 * this.getWidth()) / anchoTecla;
                        sostenido = false;
                    } else {
                        sostenido = true;
                    }
                }
                return this.teclas[Tecla.getIndiceTecla(blanca, sostenido)];
            }
        }
        return null;
    }

    protected void pointerPressed(int x, int y) {
        int numPunto;
        if (this.barraActiva) {
            return;
        }
        int n = numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        if (numPunto < 10) {
            this.puntos[numPunto].setPos(x, y);
            Object control = this.getControl(x, y);
            int anchoTecla = 20 * (4 - this.piano.getZoom());
            if (control instanceof String) {
                if (control.equals("volumen")) {
                    this.piano.setVolumen(10 - (y - 10) / 5 > 10 ? 10 : 10 - (y - 10) / 5);
                    this.repintarVolumen = true;
                    this.repaint();
                } else if (control.equals("salir")) {
                    this.piano.confirmarSalida();
                } else if (control.equals("ajustes")) {
                    this.piano.ajustes();
                } else if (control.equals("zoom")) {
                    if (this.piano.getZoom() < 2) {
                        this.piano.setZoom(this.piano.getZoom() + 1);
                        this.setOffset(this.offset * (4 - this.piano.getZoom()) / (5 - this.piano.getZoom()));
                    } else {
                        this.piano.setZoom(0);
                        this.setOffset(this.offset * 2);
                    }
                    this.crearImagenTeclado();
                    this.comprobarTeclas();
                    this.repintarOffset = true;
                    this.repaint();
                } else if (control.equals("bloqueo")) {
                    this.piano.setBloqueo(!this.piano.bloqueo());
                    this.crearImagenBarra();
                    this.repaint();
                } else if (control.equals("instrumento")) {
                    this.piano.selInstrumento();
                } else if (control.equals("doble")) {
                    this.piano.setDobleTeclado(!this.piano.dobleTeclado());
                    this.setOffset(this.offset);
                    this.crearImagenBarra();
                    this.crearImagenTeclado();
                    this.comprobarTeclas();
                    this.repaint();
                } else if (control.equals("track")) {
                    this.piano.selTrack();
                } else if (control.equals("parar")) {
                    this.piano.getRecord().parar();
                } else if (control.equals("grabar")) {
                    this.piano.getRecord().grabar(this.piano.getCodigoInstrumento(), this.piano.numTeclados(), this.piano.getZoom(), this.offset);
                } else if (control.equals("reproducir")) {
                    this.piano.getRecord().reproducir();
                } else if (control.equals("offset")) {
                    int offsetAnt = this.offset;
                    this.setOffset(this.offset + (x - (this.iO - (this.lO - this.aO) * this.offset / (this.blancas * anchoTecla - this.getWidth() * this.piano.numTeclados())) - this.aO / 2) * (this.getWidth() * this.piano.numTeclados() - anchoTecla * this.blancas) / (this.lO - this.aO));
                    if (this.offset != offsetAnt) {
                        if (this.piano.getRecord().grabando()) {
                            this.piano.getRecord().grabarEvento(2, this.offset - offsetAnt);
                        }
                        this.comprobarTeclas();
                        this.repaint();
                    }
                } else if (control.equals("barra") && !this.barraActiva) {
                    new Thread(this).start();
                }
            } else if (control instanceof Tecla) {
                this.comprobarTeclas();
                this.repaint();
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        int numPunto;
        if (this.barraActiva) {
            return;
        }
        int n = numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        if (numPunto < 10) {
            Object control = this.getControl(x, y);
            Object control2 = this.getControl(this.puntos[numPunto].getX(), this.puntos[numPunto].getY());
            boolean comprobarTeclas = false;
            int anchoTecla = 20 * (4 - this.piano.getZoom());
            if (control instanceof Tecla) {
                if (this.piano.bloqueo() || !(control2 instanceof Tecla)) {
                    this.puntos[numPunto].setPos(x, y);
                    comprobarTeclas = true;
                } else if (Math.abs(this.puntos[numPunto].getX() - x) >= (5 - this.piano.getSensibilidad()) * anchoTecla / 20) {
                    int offsetAnt = this.offset;
                    int puntosOffset = 0;
                    long tiempo = System.currentTimeMillis();
                    int i = 0;
                    while (i < this.puntos.length) {
                        if (i != numPunto && tiempo - this.puntos[i].getTime() < 50L && this.puntos[i].getOffset() != 0 && (x - this.puntos[numPunto].getX()) / this.puntos[i].getOffset() > 0 && puntosOffset / this.puntos[i].getOffset() < 1) {
                            puntosOffset = this.puntos[i].getOffset();
                        }
                        ++i;
                    }
                    if (Math.abs(puntosOffset) > Math.abs(x - this.puntos[numPunto].getX())) {
                        puntosOffset = x - this.puntos[numPunto].getX();
                    }
                    this.setOffset(this.offset + x - this.puntos[numPunto].getX() - puntosOffset);
                    this.puntos[numPunto].setPos(x, y);
                    this.puntos[numPunto].setOffset(this.offset - offsetAnt);
                    comprobarTeclas = true;
                    if (this.offset != offsetAnt && this.piano.getRecord().grabando()) {
                        this.piano.getRecord().grabarEvento(2, this.offset - offsetAnt);
                    }
                }
            } else {
                this.puntos[numPunto].setPos(x, y);
                if (control2 instanceof Tecla) {
                    comprobarTeclas = true;
                }
                if (control instanceof String) {
                    if (control.equals("offset")) {
                        int offsetAnt = this.offset;
                        this.setOffset(this.offset + (x - (this.iO - (this.lO - this.aO) * this.offset / (this.blancas * anchoTecla - this.getWidth() * this.piano.numTeclados())) - this.aO / 2) * (this.getWidth() * this.piano.numTeclados() - anchoTecla * this.blancas) / (this.lO - this.aO));
                        if (this.offset != offsetAnt) {
                            if (this.piano.getRecord().grabando()) {
                                this.piano.getRecord().grabarEvento(2, this.offset - offsetAnt);
                            }
                            comprobarTeclas = true;
                        }
                    } else if (control.equals("volumen")) {
                        this.piano.setVolumen(10 - (y - 10) / 5 > 10 ? 10 : 10 - (y - 10) / 5);
                        this.repintarVolumen = true;
                    }
                }
            }
            if (comprobarTeclas) {
                this.comprobarTeclas();
            }
            this.repaint();
        }
    }

    protected void pointerReleased(int x, int y) {
        int numPunto;
        if (this.barraActiva) {
            return;
        }
        int n = numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        if (numPunto < 10) {
            Object control = this.getControl(this.puntos[numPunto].getX(), this.puntos[numPunto].getY());
            this.puntos[numPunto].desactivar();
            if (control instanceof Tecla) {
                this.comprobarTeclas();
            }
            this.repaint();
        }
    }

    protected void sizeChanged(int w, int h) {
        this.crearImagenBarra();
        this.crearImagenTeclado();
        this.repaint();
    }

    protected void showNotify() {
        if (this.p.getState() != 300) {
            try {
                this.p.prefetch();
                this.mc = (MIDIControl)this.p.getControl("MIDIControl");
            }
            catch (Exception e) {
                this.piano.mostrarError(new Exception(Idioma.texto_error_midi[this.piano.getIdioma()]));
            }
        }
        this.mc.setProgram(0, 15488, this.piano.getInstrumento().getInstrumento());
        this.crearImagenBarra();
        this.crearImagenTeclado();
        this.setOffset(this.offset);
        this.repaint();
        this.serviceRepaints();
    }

    protected void hideNotify() {
        if (!this.piano.getRecord().enPausa()) {
            this.piano.getRecord().parar();
        } else {
            this.desactivarTeclas();
        }
        this.repaint();
        if (this.p.getState() == 300) {
            this.p.deallocate();
        }
    }

    public void run() {
        this.desactivarTeclas();
        this.barraActiva = true;
        while (this.barraActiva) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.offsetBarra += (this.barraVisible ? -1 : 1) * this.lB / 10;
            if (this.offsetBarra > 0) {
                this.offsetBarra = 0;
                this.crearImagenTeclado();
                this.barraActiva = false;
                this.barraVisible = true;
                this.crearImagenBarra();
            } else if (this.offsetBarra < -this.lB) {
                this.offsetBarra = -this.lB;
                this.crearImagenTeclado();
                this.barraActiva = false;
                this.barraVisible = false;
                this.crearImagenBarra();
            }
            this.repintarBarra = true;
            this.repintarTeclado = true;
            this.repaint();
        }
    }
}

