/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.MIDIControl;

public class Cuerdas
extends Canvas
implements Runnable {
    private static final int MAX_PUNTOS = 10;
    private int ciclos;
    private boolean mostrar_rec;
    private int numTrastes;
    private int traste;
    private int acorde;
    private Punto[] puntos;
    private Cuerda[] cuerdas;
    private String[] descTrastes;
    private Guitarra guitarra;
    private Player p;
    private MIDIControl mc;
    private int margenX;
    private int lB;
    private int lA;
    private int lP;
    private int lT;
    private int iO;
    private int lO;
    private boolean activo;
    private boolean acordeModificado;
    private boolean repintarBarra;
    private boolean repintarAcordes;

    public Cuerdas(Guitarra guitarra) throws Exception {
        this.guitarra = guitarra;
        this.setFullScreenMode(true);
        if (!this.hasPointerEvents()) {
            throw new Exception(Idioma.texto_error_tactil[guitarra.getIdioma()]);
        }
        this.p = Manager.createPlayer((String)"device://midi");
        this.p.realize();
        this.puntos = new Punto[10];
        int i = 0;
        while (i < this.puntos.length) {
            this.puntos[i] = new Punto();
            ++i;
        }
        this.cuerdas = new Cuerda[]{new Cuerda(52), new Cuerda(57), new Cuerda(62), new Cuerda(67), new Cuerda(71), new Cuerda(76)};
        this.descTrastes = new String[]{"I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX", "X", "XI", "XII", "XIII", "XIV", "XV", "XVI", "XVII", "XVIII", "XIX"};
        this.numTrastes = 5;
        this.traste = 1;
        this.acorde = -1;
        this.lB = 60;
        this.lA = 46;
        this.ajustarZoom(guitarra.getZoom());
        this.ajustarBarras(guitarra.numBarras());
        this.ciclos = 0;
        this.mostrar_rec = false;
    }

    public int getWidth() {
        return 360;
    }

    public int getHeight() {
        return 640;
    }

    protected void setTraste(int traste) {
        if (traste > 0 && traste <= this.descTrastes.length - this.numTrastes + 1) {
            if (this.guitarra.getRecord().grabando()) {
                this.guitarra.getRecord().grabarEvento(2, traste);
            }
            this.traste = traste;
        }
    }

    protected void setTraste(int cuerda, int traste) {
        if (this.guitarra.getRecord().grabando()) {
            this.guitarra.getRecord().grabarEvento(1, cuerda * 20 + traste + 1);
        }
        this.cuerdas[cuerda].setTraste(traste);
    }

    private void setTrastes() {
        int min = 0;
        int max = 0;
        int i = 0;
        while (i < this.cuerdas.length) {
            this.setTraste(i, this.acorde > -1 ? this.guitarra.getAcordes()[this.acorde].getTraste(i) : 0);
            if ((min == 0 || this.cuerdas[i].getTraste() < min) && this.cuerdas[i].getTraste() > 0) {
                min = this.cuerdas[i].getTraste();
            }
            if (this.cuerdas[i].getTraste() > max) {
                max = this.cuerdas[i].getTraste();
            }
            ++i;
        }
        if (max > 0) {
            if (max - min >= this.numTrastes) {
                this.setTraste(min);
            } else {
                this.setTraste(max - this.numTrastes > 0 ? max - (this.numTrastes - 1) : 1);
            }
        }
    }

    public int[] getTrastes() {
        int[] trastes = new int[this.cuerdas.length];
        int i = 0;
        while (i < this.cuerdas.length) {
            trastes[i] = this.cuerdas[i].getTraste();
            ++i;
        }
        return trastes;
    }

    public int getAcorde() {
        return this.acorde;
    }

    public void setAcorde(Acorde acorde) {
        this.guitarra.getAcordes()[this.acorde] = acorde;
        this.setTrastes();
    }

    public void ajustarBarras(int numBarrasAcordes) {
        this.iO = this.lB + this.lA * numBarrasAcordes + this.lP + 22;
        this.repintarAcordes = true;
    }

    public void ajustarZoom(int zoom) {
        this.margenX = zoom == 0 ? 80 : 40;
        this.lP = zoom == 0 ? 34 : 40;
        this.lT = zoom == 0 ? 39 : 47;
        this.iO = this.lB + this.lA * this.guitarra.numBarras() + this.lP + Imagenes.imgUp.getHeight();
        this.lO = (this.numTrastes - 1) * this.lT - Imagenes.imgUp.getHeight() - 1;
    }

    protected void activarCuerda(int cuerda) {
        if (this.guitarra.getRecord().grabando()) {
            this.guitarra.getRecord().grabarEvento(0, cuerda);
        }
        this.mc.shortMidiEvent(144, this.guitarra.getOctava() * 12 + this.cuerdas[cuerda].getNota(), this.guitarra.getVolumen() * 127 / 10);
        this.cuerdas[cuerda].activa(true);
    }

    private void desactivarCuerda(Cuerda cuerda) {
        cuerda.activa(false);
    }

    private void desactivarCuerdas() {
        int i = 0;
        while (i < this.cuerdas.length) {
            this.cuerdas[i].activa(false);
            ++i;
        }
    }

    private boolean limpiarCuerdas() {
        boolean limpiarCuerdas = false;
        int i = 0;
        while (i < this.cuerdas.length) {
            if (this.cuerdas[i].getTraste() != 0) {
                limpiarCuerdas = true;
                break;
            }
            ++i;
        }
        return limpiarCuerdas;
    }

    protected void repintarBarra() {
        this.repintarBarra = true;
    }

    protected void reproducir() {
        this.acorde = -1;
        this.setTrastes();
        this.repintarBarra = true;
        this.repintarAcordes = true;
        this.ciclos = 0;
        this.mostrar_rec = true;
        this.guitarra.getRecord().reproducir();
    }

    protected void grabar() {
        this.acorde = -1;
        this.setTrastes();
        this.repintarBarra = true;
        this.repintarAcordes = true;
        this.ciclos = 0;
        this.mostrar_rec = true;
        this.guitarra.getRecord().grabar();
    }

    public void paint(Graphics g) {
        g.setFont(Font.getFont((int)0, (int)0, (int)8));
        if (this.repintarBarra) {
            this.repintarBarra = false;
            g.setColor(0, 0, 0);
            g.fillRect(0, 0, this.getWidth(), this.lB);
            if (this.guitarra.getRecord().enPausa()) {
                g.drawImage(Imagenes.imgVolumen, 0, 0, 20);
            } else {
                g.drawImage(this.guitarra.getRecord().reproduciendo() ? Imagenes.imgPlay : Imagenes.imgRec, 0, 0, 20);
                g.drawImage(Imagenes.imgTracks[this.guitarra.getTrack()], this.lB / 2, this.lB, 33);
            }
            g.drawImage(Imagenes.imgSalir, this.getWidth(), 0, 24);
            g.drawImage(Imagenes.imgAjustes, this.getWidth() - this.lB, 0, 24);
            g.drawImage(Imagenes.imgZoom, this.getWidth() - 2 * this.lB, 0, 24);
            g.drawImage(Imagenes.imgBorrar, this.getWidth() - 3 * this.lB, 0, 24);
            if (!this.limpiarCuerdas()) {
                g.drawImage(Imagenes.imgSombra, this.getWidth() - 3 * this.lB, 0, 24);
            }
            g.drawImage(Imagenes.imgGuardar, this.getWidth() - 4 * this.lB, 0, 24);
            if (!(this.guitarra.grabarAcorde() && this.guitarra.getRecord().enPausa() && this.limpiarCuerdas())) {
                g.drawImage(Imagenes.imgSombra, this.getWidth() - 4 * this.lB, 0, 24);
            }
            if (this.guitarra.getRecord().enPausa()) {
                g.fillRect(20, 10, 20, (10 - this.guitarra.getVolumen()) * 5);
            }
        }
        if (!this.guitarra.getRecord().enPausa()) {
            if (this.mostrar_rec) {
                g.drawImage(this.guitarra.getRecord().reproduciendo() ? Imagenes.imgPlay : Imagenes.imgRec, 0, 0, 20);
            } else {
                g.setColor(0, 0, 0);
                g.fillRect(0, 0, this.lB, this.lB / 2);
            }
        }
        if (this.repintarAcordes) {
            this.repintarAcordes = false;
            g.setColor(0, 0, 0);
            g.fillRect(0, this.lB, this.getWidth(), this.lA * this.guitarra.numBarras());
            g.setColor(255, 255, 255);
            int j = 0;
            while (j < this.guitarra.numBarras()) {
                int i = 0;
                while (i < 6) {
                    g.setClip(i * this.lB, this.lB + j * this.lA, this.lB, this.lA);
                    g.drawImage(this.acorde == j * 6 + i ? (this.acordeModificado ? Imagenes.imgAcorde_h : Imagenes.imgAcorde_s) : Imagenes.imgAcorde, i * this.lB, this.lB + j * this.lA, 20);
                    g.drawString(this.guitarra.getAcordes()[j * 6 + i].getNombre(this.guitarra.getNotacion()), i * this.lB + this.lB / 2, this.lB + j * this.lA + 3 * this.lA / 4, 65);
                    ++i;
                }
                ++j;
            }
            g.setClip(0, 0, this.getWidth(), this.getHeight());
        }
        g.drawImage(Imagenes.imgGuitarra[this.guitarra.getZoom()][this.guitarra.getInstrumento() * 2 + this.guitarra.getSkin()], 0, this.lB + this.lA * this.guitarra.numBarras(), 20);
        g.setColor(255, 255, 255);
        int i = 0;
        while (i < 5) {
            g.drawString(this.descTrastes[i + this.traste - 1], this.margenX - 12 + this.guitarra.getZoom() * 10, this.lB + this.lA * this.guitarra.numBarras() + this.lP + i * this.lT, 24);
            ++i;
        }
        g.setColor(180, 180, 180);
        g.fillRect(0, this.lB + this.lA * this.guitarra.numBarras(), 49, this.lP);
        g.setColor(0, 0, 0);
        g.fillRect(0, this.lB + this.lA * this.guitarra.numBarras(), 48, this.lP - 1);
        if (this.guitarra.getRecord().enPausa()) {
            g.drawImage(Imagenes.imgGrabar, 24, this.lB + this.lA * this.guitarra.numBarras() + this.lP / 2, 3);
        } else {
            g.drawImage(Imagenes.imgParar, 24, this.lB + this.lA * this.guitarra.numBarras() + this.lP / 2, 3);
        }
        g.drawImage(Imagenes.imgUp, this.getWidth() - this.margenX + 10 - this.guitarra.getZoom() * 6, this.lB + this.lA * this.guitarra.numBarras() + this.lP, 20);
        g.drawImage(Imagenes.imgDown, this.getWidth() - this.margenX + 10 - this.guitarra.getZoom() * 6, this.lB + this.lA * this.guitarra.numBarras() + this.lP + this.lT * (this.numTrastes - 1) - 1, 20);
        g.drawImage(Imagenes.imgOffset, this.getWidth() - this.margenX + 11 - this.guitarra.getZoom() * 6, this.iO + 4 + (this.traste - 1) * (this.lO - 48) / (this.descTrastes.length - this.numTrastes), 20);
        boolean pintarAros = false;
        int cejilla = this.descTrastes.length;
        int i2 = 0;
        while (i2 < this.cuerdas.length) {
            if (this.cuerdas[i2].getTraste() > 0) {
                pintarAros = true;
                if (cejilla > -1 && this.cuerdas[i2].getTraste() < cejilla) {
                    cejilla = this.cuerdas[i2].getTraste();
                }
            } else {
                cejilla = -1;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.cuerdas.length) {
            if (i2 < 3 || this.guitarra.getInstrumento() > 0) {
                g.setColor(240, 240, 240);
            } else {
                g.setColor(160, 160, 160);
            }
            g.drawLine(this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras(), this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
            int estado = this.cuerdas[i2].getEstado();
            if (estado > 0) {
                int color;
                if (i2 < 3 || this.guitarra.getInstrumento() > 0) {
                    color = 240 - estado * 12;
                    g.setColor(color, color, color);
                } else {
                    color = 160 - estado * 8;
                    g.setColor(color, color, color);
                }
                if (this.cuerdas[i2].getTraste() < this.traste) {
                    g.drawLine(-1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP, -1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                    g.drawLine(1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP, 1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                } else if (this.cuerdas[i2].getTraste() < this.traste + this.numTrastes) {
                    g.drawLine(-1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP + (this.cuerdas[i2].getTraste() - this.traste) * this.lT + this.lT / 2, -1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                    g.drawLine(1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP + (this.cuerdas[i2].getTraste() - this.traste) * this.lT + this.lT / 2, 1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                } else {
                    g.drawLine(-1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP + this.numTrastes * this.lT, -1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                    g.drawLine(1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP + this.numTrastes * this.lT, 1 + this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.getHeight());
                }
            }
            switch (this.cuerdas[i2].getTraste()) {
                case -1: {
                    g.drawImage(Imagenes.imgCruz, this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP / 2, 3);
                    break;
                }
                case 0: {
                    if (!pintarAros) break;
                    g.drawImage(Imagenes.imgAro, this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP / 2, 3);
                    break;
                }
                default: {
                    if (this.cuerdas[i2].getTraste() < this.traste || this.cuerdas[i2].getTraste() >= this.traste + this.numTrastes) break;
                    g.drawImage(Imagenes.imgPunto, this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i2 + 1) / 12, this.lB + this.lA * this.guitarra.numBarras() + this.lP + (this.cuerdas[i2].getTraste() - this.traste) * this.lT + this.lT / 2 - 1, 3);
                }
            }
            ++i2;
        }
        if (cejilla >= this.traste && cejilla < this.traste + this.numTrastes) {
            g.drawImage(Imagenes.imgCejilla[this.guitarra.getZoom()], this.margenX + (this.getWidth() - 2 * this.margenX) / 2, this.lB + this.lA * this.guitarra.numBarras() + this.lP + (cejilla - this.traste) * this.lT + this.lT / 2 - 1, 3);
        }
    }

    public void update(Graphics g) {
    }

    private Object getControl(int x, int y) {
        if (y < this.lB) {
            if (x > this.getWidth() - this.lB) {
                return "salir";
            }
            if (x > this.getWidth() - this.lB * 2) {
                return "ajustes";
            }
            if (x > this.getWidth() - this.lB * 3) {
                return "zoom";
            }
            if (x > this.getWidth() - this.lB * 4) {
                if (this.limpiarCuerdas()) {
                    return "borrar";
                }
            } else if (x > this.getWidth() - this.lB * 5) {
                if (this.guitarra.getRecord().enPausa() && this.limpiarCuerdas()) {
                    return "guardar";
                }
            } else if (x < this.lB) {
                return this.guitarra.getRecord().enPausa() ? "volumen" : "parar";
            }
        } else if (y < this.lB + this.lA * this.guitarra.numBarras()) {
            if (x < this.getWidth()) {
                return "acordes";
            }
        } else if (y < this.lB + this.lA * this.guitarra.numBarras() + this.lP) {
            if (x < this.margenX) {
                if (this.guitarra.getRecord().enPausa()) {
                    return "tracks";
                }
                return "parar";
            }
            if (x < this.getWidth() - this.margenX) {
                return "plastico";
            }
        } else if (y < this.lB + this.lA * this.guitarra.numBarras() + this.lP + 5 * this.lT) {
            if (x > this.margenX && x < this.getWidth() - this.margenX) {
                return "trastes";
            }
            if (x > this.getWidth() - this.margenX + 10 - this.guitarra.getZoom() * 6 & x < this.getWidth() - this.margenX + 10 - this.guitarra.getZoom() * 6 + 22) {
                if (y < this.iO) {
                    return "up";
                }
                if (y < this.iO + this.lO) {
                    return "offset";
                }
                if (y < this.iO + this.lO + 22) {
                    return "down";
                }
            }
        } else {
            return "cuerdas";
        }
        return null;
    }

    protected void pointerPressed(int x, int y) {
        Object control;
        int numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        this.puntos[numPunto].setPos(x, y);
        this.puntos[numPunto].setDireccion(0);
        if (numPunto < 10 && (control = this.getControl(x, y)) != null) {
            if (control.equals("volumen")) {
                this.guitarra.setVolumen(10 - (y - 10) / 5 > 10 ? 10 : 10 - (y - 10) / 5);
                this.repintarBarra = true;
            } else if (control.equals("salir")) {
                this.guitarra.confirmarSalida();
            } else if (control.equals("ajustes")) {
                this.guitarra.ajustes();
            } else if (control.equals("zoom")) {
                this.guitarra.setZoom(this.guitarra.getZoom() == 0 ? 1 : 0);
            } else if (control.equals("borrar")) {
                this.acorde = -1;
                this.setTrastes();
                this.repintarBarra = true;
                this.repintarAcordes = true;
            } else if (control.equals("guardar")) {
                if (this.guitarra.grabarAcorde()) {
                    this.guitarra.editarNombre(1);
                }
            } else if (control.equals("tracks")) {
                this.guitarra.selTrack();
            } else if (control.equals("parar")) {
                this.guitarra.getRecord().parar();
                this.repintarBarra = true;
            } else if (control.equals("plastico")) {
                int cuerda = (x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX);
                switch (this.cuerdas[cuerda].getTraste()) {
                    case -1: {
                        this.setTraste(cuerda, 0);
                        break;
                    }
                    default: {
                        this.setTraste(cuerda, -1);
                    }
                }
                this.acordeModificado = true;
                this.repintarBarra = true;
                this.repintarAcordes = true;
            } else if (control.equals("trastes")) {
                int cuerda = (x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX);
                int traste = this.traste + (y - (this.lB + this.lA * this.guitarra.numBarras() + this.lP)) / this.lT;
                if (this.cuerdas[cuerda].getTraste() != traste) {
                    this.setTraste(cuerda, traste);
                } else {
                    this.setTraste(cuerda, 0);
                }
                this.acordeModificado = true;
                this.repintarBarra = true;
                this.repintarAcordes = true;
            } else if (control.equals("acordes")) {
                int acorde = (y - this.lB) / this.lA * 6 + x * 6 / this.getWidth();
                if (this.acorde != acorde || this.acordeModificado) {
                    this.acorde = acorde;
                    this.setTrastes();
                    this.acordeModificado = false;
                    this.repintarBarra = true;
                    this.repintarAcordes = true;
                }
            } else if (control.equals("up")) {
                this.setTraste(this.traste - 1);
            } else if (control.equals("down")) {
                this.setTraste(this.traste + 1);
            } else if (control.equals("offset")) {
                this.setTraste(1 + (this.descTrastes.length - this.numTrastes + 1) * (y - this.iO) / this.lO);
            } else if (control.equals("cuerdas")) {
                int cuerda;
                int i = 0;
                while (i < this.cuerdas.length) {
                    this.cuerdas[i].activada(false);
                    ++i;
                }
                if (!(x <= this.margenX || x >= this.getWidth() - this.margenX || this.cuerdas[cuerda = (x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX)].getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                    this.activarCuerda(cuerda);
                }
            }
        }
    }

    protected void pointerDragged(int x, int y) {
        int numPunto;
        int n = numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        if (numPunto < 10) {
            Object control = this.getControl(x, y);
            if (control != null) {
                if (control.equals("volumen")) {
                    this.guitarra.setVolumen(10 - (y - 10) / 5 > 10 ? 10 : 10 - (y - 10) / 5);
                    this.repintarBarra = true;
                } else if (control.equals("offset")) {
                    this.setTraste(1 + (this.descTrastes.length - this.numTrastes + 1) * (y - this.iO) / this.lO);
                } else if (control.equals("cuerdas") && x - this.puntos[numPunto].getX() != 0) {
                    int cuerda;
                    int pos;
                    int i;
                    int direccion = (x - this.puntos[numPunto].getX()) / Math.abs(x - this.puntos[numPunto].getX());
                    if (this.puntos[numPunto].getDireccion() != 0 && this.puntos[numPunto].getDireccion() != direccion) {
                        i = 0;
                        while (i < this.cuerdas.length) {
                            pos = this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i + 1) / 12;
                            if (direccion > 0) {
                                if (pos > x) {
                                    this.cuerdas[i].activada(false);
                                }
                            } else if (direccion < 0 && pos < x) {
                                this.cuerdas[i].activada(false);
                            }
                            ++i;
                        }
                        this.puntos[numPunto].setPos0(x, y);
                    }
                    this.puntos[numPunto].setDireccion(direccion);
                    if (!(x <= this.margenX || x >= this.getWidth() - this.margenX || this.cuerdas[cuerda = (x - this.margenX) * 6 / (this.getWidth() - 2 * this.margenX)].activada() || this.cuerdas[cuerda].getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                        this.activarCuerda(cuerda);
                    }
                    i = 0;
                    while (i < this.cuerdas.length) {
                        pos = this.margenX + (this.getWidth() - 2 * this.margenX) * (2 * i + 1) / 12;
                        if (direccion > 0) {
                            if (!(pos <= this.puntos[numPunto].getX0() || pos >= x || this.cuerdas[i].activada() || this.cuerdas[i].getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                                this.activarCuerda(i);
                            }
                        } else if (!(direccion >= 0 || pos <= x || pos >= this.puntos[numPunto].getX0() || this.cuerdas[i].activada() || this.cuerdas[i].getTraste() <= -1 && this.guitarra.omitirCuerdas())) {
                            this.activarCuerda(i);
                        }
                        ++i;
                    }
                }
            }
            this.puntos[numPunto].setPos(x, y);
        }
    }

    protected void pointerReleased(int x, int y) {
        int numPunto;
        int n = numPunto = System.getProperty("com.nokia.pointer.number") != null ? Integer.parseInt(System.getProperty("com.nokia.pointer.number")) : 0;
        if (numPunto < 10) {
            this.puntos[numPunto].desactivar();
        }
    }

    protected void sizeChanged(int w, int h) {
        this.repintarBarra = true;
        this.repintarAcordes = true;
    }

    protected void showNotify() {
        this.activo = true;
        try {
            this.p.prefetch();
            this.p.start();
            this.mc = (MIDIControl)this.p.getControl("javax.microedition.media.control.MIDIControl");
            this.mc.setProgram(0, 15488, this.guitarra.getProgram());
        }
        catch (Exception e) {
            this.guitarra.mostrarError(new Exception(Idioma.texto_error_midi[this.guitarra.getIdioma()]));
        }
        new Thread(this).start();
    }

    protected void hideNotify() {
        if (!this.guitarra.getRecord().enPausa()) {
            this.guitarra.getRecord().parar();
        }
        this.activo = false;
        this.desactivarCuerdas();
        int i = 0;
        while (i < 10) {
            if (this.puntos[i].activo()) {
                this.puntos[i].desactivar();
            }
            ++i;
        }
        if (this.p.getState() == 400) {
            try {
                this.p.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.p.deallocate();
    }

    public void run() {
        this.repintarBarra = true;
        this.repintarAcordes = true;
        while (this.activo) {
            int i = 0;
            while (i < 10) {
                if (this.puntos[i].activo() && "acordes".equals(this.getControl(this.puntos[i].getX(), this.puntos[i].getY())) && this.puntos[i].getTiempo() > 1000L) {
                    this.acorde = (this.puntos[i].getY() - this.lB) / this.lA * 6 + this.puntos[i].getX() * 6 / this.getWidth();
                    this.guitarra.selAcorde();
                }
                ++i;
            }
            i = 0;
            while (i < this.cuerdas.length) {
                if (this.cuerdas[i].activa()) {
                    if (this.cuerdas[i].getEstado() >= 15) {
                        this.desactivarCuerda(this.cuerdas[i]);
                    } else {
                        this.cuerdas[i].setEstado(this.cuerdas[i].getEstado() + 1);
                    }
                }
                ++i;
            }
            this.repaint();
            ++this.ciclos;
            if (this.ciclos > 4) {
                this.ciclos = 0;
                this.mostrar_rec = !this.mostrar_rec;
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

