/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.RadioButton;
import java.util.Vector;

public class ButtonGroup {
    private Vector buttons = new Vector();
    private int selectedIndex = -1;

    public void add(RadioButton radioButton) {
        if (radioButton == null) {
            return;
        }
        if (!this.buttons.contains(radioButton)) {
            this.buttons.addElement(radioButton);
            if (radioButton.isSelected()) {
                this.setSelected(this.buttons.indexOf(radioButton));
            }
            radioButton.setButtonGroup(this);
        }
    }

    public void remove(RadioButton radioButton) {
        if (radioButton == null) {
            return;
        }
        this.buttons.removeElement(radioButton);
        if (radioButton.isSelected()) {
            this.clearSelection();
        }
        radioButton.setButtonGroup(null);
    }

    public void clearSelection() {
        if (this.selectedIndex != -1) {
            if (this.selectedIndex < this.buttons.size()) {
                ((RadioButton)this.buttons.elementAt(this.selectedIndex)).setSelected(false);
            }
            this.selectedIndex = -1;
        }
    }

    public int getButtonCount() {
        return this.buttons.size();
    }

    public boolean isSelected() {
        return this.selectedIndex != -1;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public RadioButton getRadioButton(int n) {
        if (n >= 0 && n < this.getButtonCount()) {
            return (RadioButton)this.buttons.elementAt(n);
        }
        return null;
    }

    public void setSelected(RadioButton radioButton) {
        if (radioButton != null) {
            int n = this.buttons.indexOf(radioButton);
            if (n < 0) {
                this.add(radioButton);
                n = this.buttons.indexOf(radioButton);
            }
            this.setSelected(n);
        } else {
            this.clearSelection();
        }
    }

    public void setSelected(int n) {
        if (n < 0 || n >= this.getButtonCount()) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        if (this.selectedIndex == n) {
            return;
        }
        if (this.selectedIndex != -1) {
            ((RadioButton)this.buttons.elementAt(this.selectedIndex)).setSelectedImpl(false);
        }
        ((RadioButton)this.buttons.elementAt(n)).setSelectedImpl(true);
        this.selectedIndex = n;
    }
}

