/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.util.Resources;

public final class AnimationObject {
    public static final int MOTION_TYPE_SPLINE = 2;
    public static final int MOTION_TYPE_LINEAR = 1;
    String imageName;
    Resources res;
    Image img;
    Image[] frames;
    Motion motionX;
    Motion motionY;
    Motion orientation;
    Motion width;
    Motion height;
    Motion opacity;
    int frameWidth;
    int frameHeight;
    int frameDelay = -1;
    private boolean framesInitialized = true;
    private int startTime = -1;
    private int endTime = -1;

    private AnimationObject() {
    }

    public AnimationObject copy() {
        AnimationObject animationObject = new AnimationObject();
        animationObject.imageName = this.imageName;
        animationObject.res = this.res;
        animationObject.img = this.img;
        animationObject.frames = this.frames;
        animationObject.motionX = this.motionX;
        animationObject.motionY = this.motionY;
        animationObject.orientation = this.orientation;
        animationObject.width = this.width;
        animationObject.height = this.height;
        animationObject.opacity = this.opacity;
        animationObject.frameWidth = this.frameWidth;
        animationObject.frameHeight = this.frameHeight;
        animationObject.frameDelay = this.frameDelay;
        animationObject.framesInitialized = this.framesInitialized;
        animationObject.startTime = this.startTime;
        animationObject.endTime = this.endTime;
        return animationObject;
    }

    void lock() {
        if (this.img != null) {
            this.img.lock();
        }
    }

    void unlock() {
        if (this.img != null) {
            this.img.unlock();
        }
    }

    public static AnimationObject createAnimationImage(Image image, int n, int n2) {
        AnimationObject animationObject = new AnimationObject();
        animationObject.img = image;
        animationObject.motionX = Motion.createLinearMotion(n, n, 1);
        animationObject.motionX.setStartTime(Long.MAX_VALUE);
        animationObject.motionY = Motion.createLinearMotion(n2, n2, 1);
        animationObject.motionY.setStartTime(Long.MAX_VALUE);
        return animationObject;
    }

    public void defineFrames(int n, int n2, int n3) {
        this.frameWidth = n;
        this.frameHeight = n2;
        this.frameDelay = n3;
        this.framesInitialized = false;
    }

    public static AnimationObject createAnimationImage(String string, Resources resources, int n, int n2) {
        AnimationObject animationObject = new AnimationObject();
        animationObject.imageName = string;
        animationObject.res = resources;
        animationObject.motionX = Motion.createLinearMotion(n, n, 1);
        animationObject.motionX.setStartTime(Long.MAX_VALUE);
        animationObject.motionY = Motion.createLinearMotion(n2, n2, 1);
        animationObject.motionY.setStartTime(Long.MAX_VALUE);
        return animationObject;
    }

    Image getImage() {
        if (this.img == null && this.res != null) {
            this.img = this.res.getImage(this.imageName);
            if (this.img == null) {
                return null;
            }
            this.res = null;
        }
        if (this.frameDelay > -1) {
            int n;
            if (!this.framesInitialized) {
                this.frames = new Image[this.img.getWidth() / this.frameWidth * this.img.getHeight() / this.frameHeight];
                int n2 = 0;
                int n3 = 0;
                for (n = 0; n < this.frames.length; ++n) {
                    this.frames[n] = this.img.subImage(n2, n3, this.frameWidth, this.frameHeight, true);
                    if ((n2 += this.frameWidth) + this.frameWidth <= this.img.getWidth()) continue;
                    n2 = 0;
                    n3 += this.frameHeight;
                }
                if (System.getProperty("microedition.platform") != null) {
                    this.img = null;
                }
            }
            long l = this.motionX.getCurrentMotionTime();
            n = Math.max(1, this.frames.length);
            int n4 = Math.min(Math.max(0, (int)(l / (long)Math.max(1, this.frameDelay) % (long)n)), n - 1);
            return this.frames[n4];
        }
        return this.img;
    }

    private void setTimeNotNull(Motion motion, int n) {
        if (motion != null) {
            motion.setCurrentMotionTime(n);
        }
    }

    void setTime(int n) {
        this.motionX.setCurrentMotionTime(n);
        this.motionY.setCurrentMotionTime(n);
        this.setTimeNotNull(this.orientation, n);
        this.setTimeNotNull(this.width, n);
        this.setTimeNotNull(this.height, n);
        this.setTimeNotNull(this.opacity, n);
    }

    public void defineMotionX(int n, int n2, int n3, int n4, int n5) {
        this.motionX = this.createMotion(n, n2, n3, n4, n5);
    }

    public void defineMotionY(int n, int n2, int n3, int n4, int n5) {
        this.motionY = this.createMotion(n, n2, n3, n4, n5);
    }

    public void defineOrientation(int n, int n2, int n3, int n4, int n5) {
        this.orientation = this.createMotion(n, n2, n3, n4, n5);
    }

    public void defineOpacity(int n, int n2, int n3, int n4, int n5) {
        this.opacity = this.createMotion(n, n2, n3, n4, n5);
    }

    public void defineWidth(int n, int n2, int n3, int n4, int n5) {
        this.width = this.createMotion(n, n2, n3, n4, n5);
    }

    public void defineHeight(int n, int n2, int n3, int n4, int n5) {
        this.height = this.createMotion(n, n2, n3, n4, n5);
    }

    private Motion createMotion(int n, int n2, int n3, int n4, int n5) {
        Motion motion;
        switch (n) {
            case 1: {
                motion = Motion.createLinearMotion(n4, n5, n2 + n3);
                break;
            }
            case 2: {
                motion = Motion.createSplineMotion(n4, n5, n2 + n3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Motion type: " + n);
            }
        }
        motion.setStartTime(n2);
        return motion;
    }

    int getX() {
        return this.motionX.getValue();
    }

    int getY() {
        return this.motionY.getValue();
    }

    int getOrientation() {
        if (this.orientation == null) {
            return 0;
        }
        return this.orientation.getValue();
    }

    int getWidth() {
        if (this.width == null) {
            if (this.getImage() != null) {
                return this.getImage().getWidth();
            }
            return 20;
        }
        return this.width.getValue();
    }

    int getHeight() {
        if (this.height == null) {
            if (this.getImage() != null) {
                return this.getImage().getHeight();
            }
            return 20;
        }
        return this.height.getValue();
    }

    int getOpacity() {
        if (this.opacity == null) {
            return 255;
        }
        return this.opacity.getValue();
    }

    void draw(Graphics graphics, float f, float f2) {
        int n;
        int n2 = this.getOpacity();
        if (n2 == 0) {
            return;
        }
        Image image = this.getImage();
        if (image == null) {
            return;
        }
        int n3 = (int)((float)this.getWidth() * f);
        int n4 = (int)((float)this.getHeight() * f2);
        if (n4 < 1 || n3 < 1) {
            return;
        }
        image = this.getImage().scaled(n3, n4);
        if (n2 != 255) {
            image = image.modifyAlphaWithTranslucency((byte)n2);
        }
        if ((n = this.getOrientation()) != 0) {
            image = image.rotate(n);
        }
        int n5 = this.getX();
        int n6 = this.getY();
        n5 = (int)((float)n5 * f);
        n6 = (int)((float)n6 * f2);
        graphics.drawImage(image, n5, n6);
    }

    public int getStartTime() {
        return this.startTime;
    }

    public void setStartTime(int n) {
        this.startTime = n;
    }

    public int getEndTime() {
        return this.endTime;
    }

    public void setEndTime(int n) {
        this.endTime = n;
    }
}

