/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.animations;

import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Painter;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.AnimationObject;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;

public final class Timeline
extends Image
implements Animation,
Painter {
    private int time;
    private int duration;
    AnimationObject[] animations;
    private Dimension size;
    private Dimension scaledTo;
    private long currentTime = -1L;
    private int animationDelay = 100;
    private boolean pause;
    private boolean loop = true;

    private Timeline() {
        super(null);
    }

    public void lock() {
        if (this.animations != null) {
            for (int i = 0; i < this.animations.length; ++i) {
                this.animations[i].lock();
            }
        }
    }

    public void unlock() {
        if (this.animations != null) {
            for (int i = 0; i < this.animations.length; ++i) {
                this.animations[i].unlock();
            }
        }
    }

    public int[] getRGB() {
        Image image = Image.createImage(this.getWidth(), this.getHeight());
        this.paint(image.getGraphics(), new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        return image.getRGB();
    }

    public int[] getRGBCached() {
        return this.getRGB();
    }

    public static Timeline createTimeline(int n, AnimationObject[] animationObjectArray, Dimension dimension) {
        if (n <= 0) {
            throw new IllegalArgumentException("Illegal duration " + n);
        }
        Timeline timeline = new Timeline();
        timeline.duration = n;
        timeline.animations = animationObjectArray;
        timeline.size = dimension;
        return timeline;
    }

    public void addAnimation(AnimationObject animationObject) {
        AnimationObject[] animationObjectArray = new AnimationObject[this.animations.length + 1];
        System.arraycopy(this.animations, 0, animationObjectArray, 0, this.animations.length);
        animationObjectArray[this.animations.length] = animationObject;
        this.animations = animationObjectArray;
    }

    public void setTime(int n) {
        if (!this.pause && n >= 0 && n <= this.duration) {
            this.time = n;
            this.currentTime = System.currentTimeMillis();
        }
    }

    public int getTime() {
        return this.time;
    }

    public boolean isAnimation() {
        return true;
    }

    public boolean animate() {
        if (!this.pause) {
            if (this.currentTime < 0L) {
                this.currentTime = System.currentTimeMillis();
                this.setTime(0);
                return true;
            }
            long l = System.currentTimeMillis();
            if (l - this.currentTime >= (long)this.animationDelay) {
                int n = (int)((long)this.time + (l - this.currentTime));
                this.currentTime = l;
                if (n > this.duration) {
                    if (!this.loop) {
                        return false;
                    }
                    n = 0;
                }
                this.setTime(n);
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics graphics) {
        this.paint(graphics, null);
    }

    public void paint(Graphics graphics, Rectangle rectangle) {
        float f = 1.0f;
        float f2 = 1.0f;
        if (rectangle != null) {
            f = (float)rectangle.getSize().getWidth() / (float)this.size.getWidth();
            f2 = (float)rectangle.getSize().getHeight() / (float)this.size.getHeight();
        }
        this.paintScaled(graphics, f, f2);
    }

    private void paintScaled(Graphics graphics, float f, float f2) {
        for (int i = 0; i < this.animations.length; ++i) {
            int n;
            int n2 = this.animations[i].getStartTime();
            if (n2 > -1 && n2 > this.time || (n = this.animations[i].getEndTime()) > -1 && n < this.time) continue;
            this.animations[i].setTime(this.time);
            this.animations[i].draw(graphics, f, f2);
        }
    }

    public int getAnimationDelay() {
        return this.animationDelay;
    }

    public void setAnimationDelay(int n) {
        this.animationDelay = n;
    }

    protected void drawImage(Graphics graphics, Object object, int n, int n2) {
        graphics.translate(n, n2);
        if (this.scaledTo != null) {
            float f = (float)this.scaledTo.getWidth() / (float)this.size.getWidth();
            float f2 = (float)this.scaledTo.getHeight() / (float)this.size.getHeight();
            this.paintScaled(graphics, f, f2);
        } else {
            this.paint(graphics);
        }
        graphics.translate(-n, -n2);
    }

    public int getWidth() {
        if (this.scaledTo != null) {
            return this.scaledTo.getWidth();
        }
        return this.size.getWidth();
    }

    public int getHeight() {
        if (this.scaledTo != null) {
            return this.scaledTo.getHeight();
        }
        return this.size.getHeight();
    }

    public Image scaled(int n, int n2) {
        Timeline timeline = new Timeline();
        timeline.animationDelay = this.animationDelay;
        timeline.animations = this.animations;
        timeline.currentTime = this.currentTime;
        timeline.duration = this.duration;
        timeline.size = this.size;
        timeline.time = this.time;
        timeline.scaledTo = new Dimension(n, n2);
        return timeline;
    }

    public boolean isPause() {
        return this.pause;
    }

    public void setPause(boolean bl) {
        this.pause = bl;
    }

    public int getDuration() {
        return this.duration;
    }

    public Dimension getSize() {
        return this.size;
    }

    public int getAnimationCount() {
        return this.animations.length;
    }

    public AnimationObject getAnimation(int n) {
        return this.animations[n];
    }

    public AnimationObject getAnimationAt(int n, int n2) {
        for (int i = 0; i < this.animations.length; ++i) {
            int n3;
            float f = 1.0f;
            float f2 = 1.0f;
            if (this.scaledTo != null) {
                f = (float)this.scaledTo.getWidth() / (float)this.size.getWidth();
                f2 = (float)this.scaledTo.getHeight() / (float)this.size.getHeight();
            }
            int n4 = (int)((float)this.animations[i].getWidth() * f);
            int n5 = (int)((float)this.animations[i].getHeight() * f2);
            int n6 = (int)((float)this.animations[i].getX() * f);
            if (!Rectangle.intersects(n6, n3 = (int)((float)this.animations[i].getY() * f2), n4, n5, n, n2, 1, 1)) continue;
            int[] nArray = this.animations[i].getImage().scaled(n4, n5).getRGB();
            int n7 = n - n6;
            int n8 = n2 - n3;
            int n9 = n7 + n8 * n5;
            if (n9 < 0 || n9 >= nArray.length || (nArray[n9] & 0xFF000000) == 0) continue;
            return this.animations[i];
        }
        return null;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
    }
}

