/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl.midp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class MMAPIPlayer
implements PlayerListener {
    private static int volume;
    private boolean deleted;
    private int lastTime;
    private Player p;
    private static Vector playing;
    private InputStream sourceStream;
    private Runnable onComplete;
    static /* synthetic */ Class class$com$sun$lwuit$impl$midp$MMAPIPlayer;

    private MMAPIPlayer(Player player) {
        this.p = player;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVolume() {
        if (volume > -1) {
            return volume;
        }
        Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
        synchronized (clazz) {
            if (playing != null && playing.size() > 0) {
                MMAPIPlayer mMAPIPlayer = (MMAPIPlayer)playing.elementAt(0);
                VolumeControl volumeControl = (VolumeControl)mMAPIPlayer.p.getControl("VolumeControl");
                if (volumeControl != null) {
                    return volumeControl.getLevel();
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVolume(int n) {
        volume = n;
        if (playing != null) {
            Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
            synchronized (clazz) {
                for (int i = 0; i < playing.size(); ++i) {
                    MMAPIPlayer mMAPIPlayer = (MMAPIPlayer)playing.elementAt(i);
                    VolumeControl volumeControl = (VolumeControl)mMAPIPlayer.p.getControl("VolumeControl");
                    if (volumeControl == null) continue;
                    volumeControl.setLevel(n);
                }
            }
        }
    }

    public static MMAPIPlayer createAudio(String string, Runnable runnable) throws IOException {
        try {
            Player player = Manager.createPlayer((String)string);
            player.realize();
            MMAPIPlayer mMAPIPlayer = new MMAPIPlayer(player);
            mMAPIPlayer.bindPlayerCleanupOnComplete(player, null, runnable);
            return mMAPIPlayer;
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
            throw new IOException(mediaException.toString());
        }
    }

    private void bindPlayerCleanupOnComplete(Player player, InputStream inputStream, Runnable runnable) {
        VolumeControl volumeControl;
        if (volume > -1 && (volumeControl = (VolumeControl)player.getControl("VolumeControl")) != null) {
            volumeControl.setLevel(volume);
        }
        this.sourceStream = inputStream;
        this.onComplete = runnable;
        player.addPlayerListener((PlayerListener)this);
    }

    public static MMAPIPlayer createAudio(InputStream inputStream, String string, Runnable runnable) throws IOException {
        try {
            Player player = Manager.createPlayer((InputStream)inputStream, (String)string);
            player.realize();
            MMAPIPlayer mMAPIPlayer = new MMAPIPlayer(player);
            mMAPIPlayer.bindPlayerCleanupOnComplete(player, inputStream, runnable);
            return mMAPIPlayer;
        }
        catch (MediaException mediaException) {
            if ("audio/mpeg".equals(string)) {
                return MMAPIPlayer.createAudio(inputStream, "audio/mp3", runnable);
            }
            mediaException.printStackTrace();
            throw new IOException(mediaException.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupAudio() {
        if (this.deleted) {
            return;
        }
        this.deleted = true;
        try {
            Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
            synchronized (clazz) {
                playing.removeElement(this);
            }
            try {
                this.p.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.p.close();
            this.p = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playAudio() {
        if (this.deleted) {
            return;
        }
        try {
            if (playing == null) {
                playing = new Vector();
            }
            Class clazz = class$com$sun$lwuit$impl$midp$MMAPIPlayer == null ? (class$com$sun$lwuit$impl$midp$MMAPIPlayer = MMAPIPlayer.class$("com.sun.lwuit.impl.midp.MMAPIPlayer")) : class$com$sun$lwuit$impl$midp$MMAPIPlayer;
            synchronized (clazz) {
                playing.addElement(this);
            }
            this.p.start();
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
            throw new RuntimeException(mediaException.toString());
        }
    }

    public void pauseAudio() {
        if (this.deleted) {
            return;
        }
        try {
            if (this.p != null) {
                this.p.stop();
            }
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
            throw new RuntimeException(mediaException.toString());
        }
    }

    public int getAudioTime() {
        try {
            if (this.p == null || this.deleted) {
                return this.lastTime;
            }
            this.lastTime = (int)(this.p.getMediaTime() / 1000L);
            return this.lastTime;
        }
        catch (Throwable throwable) {
            return this.lastTime;
        }
    }

    public void setAudioTime(int n) {
        if (this.deleted) {
            return;
        }
        try {
            this.p.setMediaTime((long)(n * 1000));
        }
        catch (MediaException mediaException) {
            mediaException.printStackTrace();
        }
    }

    public int getAudioDuration() {
        if (this.p == null || this.deleted) {
            return 1000;
        }
        return (int)(this.p.getDuration() / 1000L);
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (this.deleted) {
            return;
        }
        if ("endOfMedia".equals(string) || "error".equals(string)) {
            this.lastTime = (int)(this.p.getMediaTime() / 1000L);
            this.cleanupAudio();
            if (this.sourceStream != null) {
                try {
                    this.sourceStream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.onComplete != null) {
                this.onComplete.run();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

