/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.TextField;
import com.sun.lwuit.VirtualKeyboard;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.util.EventDispatcher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class UIManager {
    private LookAndFeel current = new DefaultLookAndFeel();
    private Hashtable styles = new Hashtable();
    private Hashtable selectedStyles = new Hashtable();
    private Hashtable themeProps;
    private Hashtable themeConstants = new Hashtable();
    static UIManager instance = new UIManager();
    private Style defaultStyle = new Style();
    private Style defaultSelectedStyle = new Style();
    static boolean accessible = true;
    static boolean localeAccessible = true;
    private Hashtable imageCache = new Hashtable();
    private Hashtable resourceBundle;
    private EventDispatcher themelisteners;

    UIManager() {
        this.resetThemeProps(null);
    }

    public static UIManager getInstance() {
        return instance;
    }

    public LookAndFeel getLookAndFeel() {
        return this.current;
    }

    public void setLookAndFeel(LookAndFeel lookAndFeel) {
        this.current.uninstall();
        this.current = lookAndFeel;
    }

    public void setComponentStyle(String string, Style style) {
        string = string == null || string.length() == 0 ? "" : string + ".";
        this.styles.put(string, style);
    }

    public void setComponentSelectedStyle(String string, Style style) {
        string = string == null || string.length() == 0 ? "" : string + ".";
        this.selectedStyles.put(string, style);
    }

    public Style getComponentStyle(String string) {
        return this.getComponentStyleImpl(string, false, "");
    }

    public Style getComponentSelectedStyle(String string) {
        return this.getComponentStyleImpl(string, true, "sel#");
    }

    public Style getComponentCustomStyle(String string, String string2) {
        return this.getComponentStyleImpl(string, false, string2 + "#");
    }

    private Style getComponentStyleImpl(String string, boolean bl, String string2) {
        try {
            Style style = null;
            string = string == null || string.length() == 0 ? "" : string + ".";
            if (bl) {
                style = (Style)this.selectedStyles.get(string);
                if (style == null) {
                    style = this.createStyle(string, string2, true);
                    this.selectedStyles.put(string, style);
                }
            } else if (string2.length() == 0) {
                style = (Style)this.styles.get(string);
                if (style == null) {
                    style = this.createStyle(string, string2, false);
                    this.styles.put(string, style);
                }
            } else {
                return this.createStyle(string, string2, false);
            }
            return new Style(style);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new Style(this.defaultStyle);
        }
    }

    public String getThemeName() {
        if (this.themeProps != null) {
            return (String)this.themeProps.get("name");
        }
        return null;
    }

    Hashtable getThemeProps() {
        return this.themeProps;
    }

    private void resetThemeProps(Hashtable hashtable) {
        this.themeProps = new Hashtable();
        String string = Integer.toHexString(this.getLookAndFeel().getDisableColor());
        Integer n = new Integer(4);
        Integer n2 = new Integer(3);
        this.themeProps.put("sel#transparency", "255");
        this.themeProps.put("dis#fgColor", string);
        if (hashtable == null || !hashtable.containsKey("Button.derive")) {
            this.themeProps.put("Button.border", Border.getDefaultBorder());
            this.themeProps.put("Button.padding", "4,4,4,4");
        }
        if (hashtable == null || !hashtable.containsKey("Button.press#derive")) {
            this.themeProps.put("Button.press#border", Border.getDefaultBorder().createPressedVersion());
            this.themeProps.put("Button.press#derive", "Button");
        }
        this.themeProps.put("Button.sel#derive", "Button");
        this.themeProps.put("Button.dis#derive", "Button");
        if (hashtable == null || !hashtable.containsKey("CalendarTitle.derive")) {
            this.themeProps.put("CalendarTitle.align", n);
        }
        if (hashtable == null || !hashtable.containsKey("CalendarSelectedDay.derive")) {
            this.themeProps.put("CalendarSelectedDay.border", Border.getDefaultBorder());
        }
        if (hashtable == null || !hashtable.containsKey("ComboBox.derive")) {
            this.themeProps.put("ComboBox.border", Border.getDefaultBorder());
        }
        this.themeProps.put("ComboBox.sel#derive", "ComboBox");
        if (hashtable == null || !hashtable.containsKey("ComboBoxItem.derive")) {
            this.themeProps.put("ComboBoxItem.margin", "0,0,0,0");
            this.themeProps.put("ComboBoxItem.transparency", "0");
        }
        this.themeProps.put("ComboBoxItem.sel#derive", "ComboBoxItem");
        this.themeProps.put("ComboBoxItem.dis#derive", "ComboBoxItem");
        if (hashtable == null || !hashtable.containsKey("ComboBoxList.derive")) {
            this.themeProps.put("ComboBoxList.margin", "0,0,0,0");
            this.themeProps.put("ComboBoxList.padding", "0,0,0,0");
            this.themeProps.put("ComboBoxList.transparency", "0");
        }
        if (hashtable == null || !hashtable.containsKey("ComboBoxPopup.derive")) {
            this.themeProps.put("ComboBoxPopup.border", Border.getDefaultBorder());
        }
        this.themeProps.put("ComboBoxPopup.sel#derive", "ComboBoxPopup");
        if (hashtable == null || !hashtable.containsKey("Command.derive")) {
            this.themeProps.put("Command.margin", "0,0,0,0");
            this.themeProps.put("Command.transparency", "0");
        }
        this.themeProps.put("Command.sel#derive", "Command");
        this.themeProps.put("Command.dis#derive", "Command");
        if (hashtable == null || !hashtable.containsKey("CommandList.derive")) {
            this.themeProps.put("CommandList.margin", "0,0,0,0");
            this.themeProps.put("CommandList.padding", "0,0,0,0");
            this.themeProps.put("CommandList.transparency", "0");
        }
        this.themeProps.put("CommandList.sel#derive", "CommandList");
        if (hashtable == null || !hashtable.containsKey("Container.derive")) {
            this.themeProps.put("Container.transparency", "0");
            this.themeProps.put("Container.margin", "0,0,0,0");
            this.themeProps.put("Container.padding", "0,0,0,0");
        }
        this.themeProps.put("Container.sel#derive", "Container");
        this.themeProps.put("Container.dis#derive", "Container");
        if (hashtable == null || !hashtable.containsKey("ContentPane.derive")) {
            this.themeProps.put("ContentPane.transparency", "0");
            this.themeProps.put("ContentPane.margin", "0,0,0,0");
            this.themeProps.put("ContentPane.padding", "0,0,0,0");
        }
        this.themeProps.put("ContentPane.sel#derive", "ContentPane");
        if (hashtable == null || !hashtable.containsKey("DialogContentPane.derive")) {
            this.themeProps.put("DialogContentPane.margin", "0,0,0,0");
            this.themeProps.put("DialogContentPane.padding", "0,0,0,0");
            this.themeProps.put("DialogContentPane.transparency", "0");
        }
        if (hashtable == null || !hashtable.containsKey("DialogTitle.derive")) {
            this.themeProps.put("DialogTitle.align", n);
        }
        if (hashtable == null || !hashtable.containsKey("Form.derive")) {
            this.themeProps.put("Form.padding", "0,0,0,0");
            this.themeProps.put("Form.margin", "0,0,0,0");
        }
        this.themeProps.put("Form.sel#derive", "Form");
        if (hashtable == null || !hashtable.containsKey("HorizontalScroll.derive")) {
            this.themeProps.put("HorizontalScroll.margin", "0,0,0,0");
            this.themeProps.put("HorizontalScroll.padding", "1,1,1,1");
        }
        if (hashtable == null || !hashtable.containsKey("HorizontalScrollThumb.derive")) {
            this.themeProps.put("HorizontalScrollThumb.padding", "0,0,0,0");
            this.themeProps.put("HorizontalScrollThumb.bgColor", "0");
            this.themeProps.put("HorizontalScrollThumb.margin", "0,0,0,0");
        }
        if (hashtable == null || !hashtable.containsKey("List.derive")) {
            this.themeProps.put("List.transparency", "0");
            this.themeProps.put("List.margin", "0,0,0,0");
        }
        this.themeProps.put("List.sel#derive", "List");
        if (hashtable == null || !hashtable.containsKey("ListRenderer.derive")) {
            this.themeProps.put("ListRenderer.transparency", "0");
        }
        if (hashtable == null || !hashtable.containsKey("ListRenderer.sel#derive")) {
            this.themeProps.put("ListRenderer.sel#transparency", "100");
        }
        this.themeProps.put("ListRenderer.dis#derive", "ListRenderer");
        if (hashtable == null || !hashtable.containsKey("Menu.derive")) {
            this.themeProps.put("Menu.padding", "0,0,0,0");
        }
        this.themeProps.put("Menu.sel#derive", "Menu");
        if (hashtable == null || !hashtable.containsKey("PopupContentPane.derive")) {
            this.themeProps.put("PopupContentPane.transparency", "0");
        }
        if (hashtable == null || !hashtable.containsKey("Scroll.derive")) {
            this.themeProps.put("Scroll.margin", "0,0,0,0");
            this.themeProps.put("Scroll.padding", "1,1,1,1");
        }
        if (hashtable == null || !hashtable.containsKey("ScrollThumb.derive")) {
            this.themeProps.put("ScrollThumb.padding", "0,0,0,0");
            this.themeProps.put("ScrollThumb.margin", "0,0,0,0");
            this.themeProps.put("ScrollThumb.bgColor", "0");
        }
        if (hashtable == null || !hashtable.containsKey("SliderFull.derive")) {
            this.themeProps.put("SliderFull.bgColor", "0");
        }
        this.themeProps.put("SliderFull.sel#derive", "SliderFull");
        if (hashtable == null || !hashtable.containsKey("SoftButton.derive")) {
            this.themeProps.put("SoftButton.transparency", "255");
            this.themeProps.put("SoftButton.margin", "0,0,0,0");
            this.themeProps.put("SoftButton.padding", "0,0,0,0");
        }
        this.themeProps.put("SoftButton.sel#derive", "SoftButton");
        if (hashtable == null || !hashtable.containsKey("SoftButtonCenter.derive")) {
            this.themeProps.put("SoftButtonCenter.align", n);
            this.themeProps.put("SoftButtonCenter.transparency", "0");
            this.themeProps.put("SoftButtonCenter.derive", "SoftButton");
            this.themeProps.put("SoftButtonCenter.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonCenter.sel#derive", "SoftButtonCenter");
        this.themeProps.put("SoftButtonCenter.press#derive", "SoftButtonCenter");
        this.themeProps.put("SoftButtonCenter.dis#derive", "SoftButtonCenter");
        if (hashtable == null || !hashtable.containsKey("SoftButtonLeft.derive")) {
            this.themeProps.put("SoftButtonLeft.transparency", "0");
            this.themeProps.put("SoftButtonLeft.derive", "SoftButton");
            this.themeProps.put("SoftButtonLeft.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonLeft.sel#derive", "SoftButtonLeft");
        this.themeProps.put("SoftButtonLeft.press#derive", "SoftButtonLeft");
        this.themeProps.put("SoftButtonLeft.dis#derive", "SoftButtonLeft");
        if (hashtable == null || !hashtable.containsKey("SoftButtonRight.derive")) {
            this.themeProps.put("SoftButtonRight.align", n2);
            this.themeProps.put("SoftButtonRight.transparency", "0");
            this.themeProps.put("SoftButtonRight.derive", "SoftButton");
            this.themeProps.put("SoftButtonRight.padding", "4,4,4,4");
        }
        this.themeProps.put("SoftButtonRight.sel#derive", "SoftButtonRight");
        this.themeProps.put("SoftButtonRight.press#derive", "SoftButtonRight");
        this.themeProps.put("SoftButtonRight.dis#derive", "SoftButtonRight");
        if (hashtable == null || !hashtable.containsKey("Spinner.derive")) {
            this.themeProps.put("Spinner.border", Border.getDefaultBorder());
        }
        this.themeProps.put("Spinner.sel#derive", "Spinner");
        if (hashtable == null || !hashtable.containsKey("Tab.derive")) {
            this.themeProps.put("Tab.margin", "1,1,1,1");
        }
        if (hashtable == null || !hashtable.containsKey("Tab.sel#derive")) {
            this.themeProps.put("Tab.sel#derive", "Tab");
            this.themeProps.put("Tab.sel#border", Border.createLineBorder(1));
        }
        this.themeProps.put("TabbedPane.margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.padding", "0,0,0,0");
        this.themeProps.put("TabbedPane.transparency", "0");
        this.themeProps.put("TabbedPane.sel#margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.sel#padding", "0,0,0,0");
        if (hashtable == null || !hashtable.containsKey("Table.derive")) {
            this.themeProps.put("Table.border", Border.getDefaultBorder());
        }
        this.themeProps.put("Table.sel#derive", "Table");
        if (hashtable == null || !hashtable.containsKey("TableCell.derive")) {
            this.themeProps.put("TableCell.transparency", "0");
        }
        this.themeProps.put("TableCell.sel#derive", "TableCell");
        if (hashtable == null || !hashtable.containsKey("TableHeader.derive")) {
            this.themeProps.put("TableHeader.transparency", "0");
        }
        this.themeProps.put("TableHeader.sel#derive", "TableHeader");
        if (hashtable == null || !hashtable.containsKey("Tabs.derive")) {
            this.themeProps.put("Tabs.bgColor", "a0a0a0");
            this.themeProps.put("Tabs.padding", "0,0,0,0");
        }
        if (hashtable == null || !hashtable.containsKey("TabsContainer.derive")) {
            this.themeProps.put("TabsContainer.padding", "0,0,0,0");
            this.themeProps.put("TabsContainer.margin", "0,0,0,0");
            this.themeProps.put("TabsContainer.bgColor", "a0a0a0");
        }
        if (hashtable == null || !hashtable.containsKey("TabSelected.derive")) {
            this.themeProps.put("TabSelected.bgColor", "a0a0a0");
            this.themeProps.put("TabSelected.fgColor", "ffffff");
            this.themeProps.put("TabSelected.margin", "1,1,1,1");
        }
        if (hashtable == null || !hashtable.containsKey("TabSelected.sel#derive")) {
            this.themeProps.put("TabSelected.sel#derive", "TabSelected");
            this.themeProps.put("TabSelected.sel#border", Border.createLineBorder(1));
        }
        if (hashtable == null || !hashtable.containsKey("TextArea.derive")) {
            this.themeProps.put("TextArea.border", Border.getDefaultBorder());
        }
        this.themeProps.put("TextArea.sel#derive", "TextArea");
        this.themeProps.put("TextArea.dis#derive", "TextArea");
        if (hashtable == null || !hashtable.containsKey("TextField.derive")) {
            this.themeProps.put("TextField.border", Border.getDefaultBorder());
        }
        this.themeProps.put("TextField.sel#derive", "TextField");
        this.themeProps.put("TextField.dis#derive", "TextField");
        if (hashtable == null || !hashtable.containsKey("TextHint.derive")) {
            this.themeProps.put("TextHint.transparency", "0");
            this.themeProps.put("TextHint.fgColor", "cccccc");
            this.themeProps.put("TextHint.font", Font.createSystemFont(0, 2, 0));
        }
        if (hashtable == null || !hashtable.containsKey("Title.derive")) {
            this.themeProps.put("Title.margin", "0,0,0,0");
            this.themeProps.put("Title.transparency", "255");
            this.themeProps.put("Title.align", n);
        }
        this.themeProps.put("Title.sel#derive", "Title");
        if (hashtable == null || !hashtable.containsKey("TitleArea.derive")) {
            this.themeProps.put("TitleArea.transparency", "0");
            this.themeProps.put("TitleArea.margin", "0,0,0,0");
            this.themeProps.put("TitleArea.padding", "0,0,0,0");
        }
        if (hashtable == null || !hashtable.containsKey("TouchCommand.derive")) {
            this.themeProps.put("TouchCommand.border", Border.getDefaultBorder());
            this.themeProps.put("TouchCommand.padding", "10,10,10,10");
            this.themeProps.put("TouchCommand.margin", "0,0,0,0");
            this.themeProps.put("TouchCommand.align", n);
        }
        if (hashtable == null || !hashtable.containsKey("TouchCommand.press#derive")) {
            this.themeProps.put("TouchCommand.press#border", Border.getDefaultBorder().createPressedVersion());
            this.themeProps.put("TouchCommand.press#derive", "TouchCommand");
        }
        this.themeProps.put("TouchCommand.sel#derive", "TouchCommand");
        if (hashtable == null || !hashtable.containsKey("TouchCommand.dis#derive")) {
            this.themeProps.put("TouchCommand.dis#derive", "TouchCommand");
            this.themeProps.put("TouchCommand.dis#fgColor", string);
        }
        if (hashtable == null || !hashtable.containsKey("VKB.derive")) {
            this.themeProps.put("VKB.bgColor", "666666");
            this.themeProps.put("VKB.padding", "3,6,3,3");
        }
        if (hashtable == null || !hashtable.containsKey("VKBtooltip.derive")) {
            this.themeProps.put("VKBtooltip.padding", "8,8,8,8");
            this.themeProps.put("VKBtooltip.font", Font.createSystemFont(0, 1, 16));
            this.themeProps.put("VKBtooltip.bgColor", "FFFFFF");
            this.themeProps.put("VKBtooltip.fgColor", "0");
            this.themeProps.put("VKBtooltip.border", Border.createRoundBorder(8, 8));
        }
        if (hashtable == null || !hashtable.containsKey("VKBButton.derive")) {
            this.themeProps.put("VKBButton.fgColor", "FFFFFF");
            this.themeProps.put("VKBButton.bgColor", "0");
            this.themeProps.put("VKBButton.border", Border.createRoundBorder(8, 8));
            this.themeProps.put("VKBButton.margin", "2,2,1,1");
            this.themeProps.put("VKBButton.padding", "8,8,4,4");
            this.themeProps.put("VKBButton.font", Font.createSystemFont(0, 1, 0));
        }
        if (hashtable == null || !hashtable.containsKey("VKBButton.sel#derive")) {
            this.themeProps.put("VKBButton.sel#derive", "VKBButton");
            this.themeProps.put("VKBButton.sel#bgType", new Byte(6));
            this.themeProps.put("VKBButton.sel#bgGradient", new Object[]{new Integer(0x666666), new Integer(0), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
        }
        if (hashtable == null || !hashtable.containsKey("VKBButton.press#derive")) {
            this.themeProps.put("VKBButton.press#derive", "VKBButton");
            this.themeProps.put("VKBButton.press#bgType", new Byte(6));
            this.themeProps.put("VKBButton.press#bgGradient", new Object[]{new Integer(0), new Integer(0x666666), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
        }
        if (hashtable == null || !hashtable.containsKey("VKBSpecialButton.derive")) {
            this.themeProps.put("VKBSpecialButton.fgColor", "FFFFFF");
            this.themeProps.put("VKBSpecialButton.bgColor", "0");
            this.themeProps.put("VKBSpecialButton.border", Border.createRoundBorder(8, 8));
            this.themeProps.put("VKBSpecialButton.bgType", new Byte(6));
            this.themeProps.put("VKBSpecialButton.bgGradient", new Object[]{new Integer(0xCCCCCC), new Integer(0x666666), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
            this.themeProps.put("VKBSpecialButton.margin", "2,2,1,1");
            this.themeProps.put("VKBSpecialButton.padding", "6,6,4,4");
            this.themeProps.put("VKBSpecialButton.font", Font.createSystemFont(0, 1, 0));
        }
        this.themeProps.put("VKBSpecialButton.sel#derive", "VKBSpecialButton");
        if (hashtable == null || !hashtable.containsKey("VKBSpecialButton.press#derive")) {
            this.themeProps.put("VKBSpecialButton.press#derive", "VKBSpecialButton");
            this.themeProps.put("VKBSpecialButton.press#bgType", new Byte(6));
            this.themeProps.put("VKBSpecialButton.press#bgGradient", new Object[]{new Integer(0x666666), new Integer(0xCCCCCC), new Float(0.0f), new Float(0.0f), new Float(0.0f)});
        }
        if (hashtable == null || !hashtable.containsKey("VKBTextInput.derive")) {
            this.themeProps.put("VKBTextInput.fgColor", "FFFFFF");
            this.themeProps.put("VKBTextInput.bgColor", "0");
            this.themeProps.put("VKBTextInput.font", Font.createSystemFont(0, 1, 0));
            this.themeProps.put("VKBTextInput.border", Border.getDefaultBorder());
        }
        this.themeProps.put("VKBTextInput.sel#derive", "VKBTextInput");
        if (hashtable == null || !hashtable.containsKey("AdsComponent.sel#derive")) {
            this.themeProps.put("AdsComponent.sel#border", Border.getDefaultBorder());
            this.themeProps.put("AdsComponent.sel#padding", "2,2,2,2");
            this.themeProps.put("AdsComponent.sel#transparency", "0");
        }
        this.themeProps.put("AdsComponent#derive", "Container");
        this.themeProps.put("WebBrowser#derive", "Container");
    }

    public void setThemeProps(Hashtable hashtable) {
        if (accessible) {
            this.setThemePropsImpl(hashtable);
        }
    }

    public void addThemeProps(Hashtable hashtable) {
        if (accessible) {
            this.buildTheme(hashtable);
            this.current.refreshTheme();
        }
    }

    public int getThemeConstant(String string, int n) {
        String string2 = (String)this.themeConstants.get(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        return n;
    }

    public String getThemeConstant(String string, String string2) {
        String string3 = (String)this.themeConstants.get(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    public boolean isThemeConstant(String string, boolean bl) {
        String string2 = this.getThemeConstant(string, null);
        if (string2 == null) {
            return bl;
        }
        return string2.equalsIgnoreCase("true") || string2.equals("1");
    }

    public Image getThemeImageConstant(String string) {
        return (Image)this.themeConstants.get(string);
    }

    void setThemePropsImpl(Hashtable hashtable) {
        this.resetThemeProps(hashtable);
        this.styles.clear();
        this.themeConstants.clear();
        this.selectedStyles.clear();
        this.imageCache.clear();
        if (this.themelisteners != null) {
            this.themelisteners.fireActionEvent(new ActionEvent(hashtable));
        }
        this.buildTheme(hashtable);
        this.current.refreshTheme();
    }

    private void buildTheme(Hashtable hashtable) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("@")) {
                this.themeConstants.put(string.substring(1, string.length()), hashtable.get(string));
                continue;
            }
            this.themeProps.put(string, hashtable.get(string));
        }
        this.defaultStyle = new Style();
        this.defaultStyle = this.createStyle("", "", false);
        this.defaultSelectedStyle = new Style(this.defaultStyle);
        this.defaultSelectedStyle = this.createStyle("", "sel#", true);
    }

    private Style createStyle(String string, String string2, boolean bl) {
        Style style;
        String string3;
        String string4;
        String string5;
        String string6 = string;
        if (string2 != null && string2.length() > 0) {
            string = string + string2;
        }
        if ((string5 = (String)this.themeProps.get(string + "derive")) != null) {
            if (string5.indexOf(46) > -1 && string5.indexOf(35) < 0) {
                string5 = string5 + "#";
            }
            if (!(string5 + ".").equals(string)) {
                int n = string5.indexOf(46);
                if (n > -1) {
                    string4 = string5.substring(0, n);
                    string3 = string5.substring(n + 1);
                    style = new Style(this.getComponentStyleImpl(string4, string3.indexOf("sel") > -1, string3));
                } else {
                    style = new Style(this.getComponentStyle(string5));
                }
            } else {
                string5 = null;
                style = bl ? new Style(this.defaultSelectedStyle) : new Style(this.defaultStyle);
            }
        } else {
            style = bl ? new Style(this.defaultSelectedStyle) : new Style(this.defaultStyle);
        }
        if (this.themeProps != null) {
            Object object;
            String string7 = (String)this.themeProps.get(string + "bgColor");
            string4 = (String)this.themeProps.get(string + "fgColor");
            string3 = this.themeProps.get(string + "border");
            Object v = this.themeProps.get(string + "bgImage");
            String string8 = (String)this.themeProps.get(string + "transparency");
            String string9 = (String)this.themeProps.get(string + "margin");
            String string10 = (String)this.themeProps.get(string + "padding");
            Object v2 = this.themeProps.get(string + "font");
            Integer n = (Integer)this.themeProps.get(string + "align");
            Integer n2 = (Integer)this.themeProps.get(string + "textDecoration");
            Byte by = (Byte)this.themeProps.get(string + "bgType");
            Byte by2 = (Byte)this.themeProps.get(string + "bgAlign");
            Object object2 = (Object[])this.themeProps.get(string + "bgGradient");
            if (string7 != null) {
                style.setBgColor(Integer.valueOf(string7, 16));
            }
            if (string4 != null) {
                style.setFgColor(Integer.valueOf(string4, 16));
            }
            if (string8 != null) {
                style.setBgTransparency(Integer.valueOf(string8));
            } else if (bl && (string8 = (String)this.themeProps.get(string6 + "transparency")) != null) {
                style.setBgTransparency(Integer.valueOf(string8));
            }
            if (string9 != null) {
                object = this.toIntArray(string9.trim());
                style.setMargin(object[0], object[1], object[2], object[3]);
            }
            if (string10 != null) {
                object = this.toIntArray(string10.trim());
                style.setPadding(object[0], object[1], object[2], object[3]);
            }
            if (n != null) {
                style.setAlignment(n);
            }
            if (n2 != null) {
                style.setTextDecoration(n2);
            }
            if (by != null) {
                style.setBackgroundType(by);
            }
            if (by2 != null) {
                style.setBackgroundAlignment(by2);
            }
            if (object2 != null) {
                if (((Object[])object2).length < 5) {
                    object = new Object[5];
                    System.arraycopy(object2, 0, object, 0, ((Object[])object2).length);
                    object2 = object;
                    object2[4] = new Float(1.0f);
                }
                style.setBackgroundGradient((Object[])object2);
            }
            if (v != null) {
                object = null;
                if (v instanceof String) {
                    try {
                        String string11 = (String)v;
                        if (this.imageCache.containsKey(string11)) {
                            object = (Image)this.imageCache.get(string11);
                        } else {
                            object = string11.startsWith("/") ? Image.createImage(string11) : UIManager.parseImage((String)v);
                            this.imageCache.put(string11, object);
                        }
                        this.themeProps.put(string + "bgImage", object);
                    }
                    catch (IOException iOException) {
                        System.out.println("failed to parse image for id = " + string + "bgImage");
                    }
                } else if (v instanceof Image) {
                    object = (Image)v;
                }
                if (string.indexOf("Form") > -1 && (((Image)object).getWidth() != Display.getInstance().getDisplayWidth() || ((Image)object).getHeight() != Display.getInstance().getDisplayHeight()) && style.getBackgroundType() == 1 && accessible) {
                    ((Image)object).scale(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
                }
                style.setBgImage((Image)object);
            }
            if (v2 != null) {
                if (v2 instanceof String) {
                    style.setFont(UIManager.parseFont((String)v2));
                } else {
                    style.setFont((Font)v2);
                }
            }
            if (string3 != null) {
                style.setBorder((Border)((Object)string3));
            }
            style.resetModifiedFlag();
        }
        return style;
    }

    private int[] toIntArray(String string) {
        int[] nArray = new int[4];
        string = string + ",";
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(string.substring(0, string.indexOf(",")));
            string = string.substring(string.indexOf(",") + 1, string.length());
        }
        return nArray;
    }

    private static Image parseImage(String string) throws IOException {
        Object object;
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < string.length(); i += 2) {
            object = string.substring(i, i + 2);
            byArray[i / 2] = Integer.valueOf((String)object, 16).byteValue();
        }
        object = new ByteArrayInputStream(byArray);
        Image image = Image.createImage((InputStream)object);
        ((ByteArrayInputStream)object).close();
        return image;
    }

    private static Font parseFont(String string) {
        if (string.startsWith("System")) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            String string2 = string.substring(string.indexOf("{") + 1, string.indexOf("}"));
            String string3 = string2.substring(0, string2.indexOf(";"));
            string2 = string2.substring(string2.indexOf(";") + 1, string2.length());
            String string4 = string2.substring(0, string2.indexOf(";"));
            String string5 = string2.substring(string2.indexOf(";") + 1, string2.length());
            if (string3.indexOf("FACE_SYSTEM") > -1) {
                n = 0;
            } else if (string3.indexOf("FACE_MONOSPACE") > -1) {
                n = 32;
            } else if (string3.indexOf("FACE_PROPORTIONAL") > -1) {
                n = 64;
            }
            if (string4.indexOf("STYLE_PLAIN") > -1) {
                n2 = 0;
            } else {
                if (string4.indexOf("STYLE_BOLD") > -1) {
                    n2 = 1;
                }
                if (string4.indexOf("STYLE_ITALIC") > -1) {
                    n2 |= 2;
                }
                if (string4.indexOf("STYLE_UNDERLINED") > -1) {
                    n2 |= 4;
                }
            }
            if (string5.indexOf("SIZE_SMALL") > -1) {
                n3 = 8;
            } else if (string5.indexOf("SIZE_MEDIUM") > -1) {
                n3 = 0;
            } else if (string5.indexOf("SIZE_LARGE") > -1) {
                n3 = 16;
            }
            return Font.createSystemFont(n, n2, n3);
        }
        if (string.toLowerCase().startsWith("bitmap")) {
            try {
                String string6 = string.substring(string.indexOf("{") + 1, string.indexOf("}"));
                String string7 = string6.substring(0, string6.length());
                if (string7.toLowerCase().startsWith("highcontrast")) {
                    string7 = string7.substring(string7.indexOf(";") + 1, string7.length());
                    Font font = Font.getBitmapFont(string7);
                    font.addContrast((byte)30);
                    return font;
                }
                return Font.getBitmapFont(string7);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public Hashtable getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(Hashtable hashtable) {
        if (localeAccessible) {
            this.resourceBundle = hashtable;
            if (hashtable != null) {
                String[][] stringArray;
                String[] stringArray2;
                String string;
                String string2 = (String)hashtable.get("@rtl");
                if (string2 != null) {
                    this.getLookAndFeel().setRTL(string2.equalsIgnoreCase("true"));
                    this.current.refreshTheme();
                }
                if ((string = (String)hashtable.get("@vkb")) != null && string.length() > 0) {
                    stringArray2 = this.toStringArray(this.tokenizeString(string, '|'));
                    VirtualKeyboard.setDefaultInputModeOrder(stringArray2);
                    for (int i = 0; i < stringArray2.length; ++i) {
                        String string3 = stringArray2[i];
                        stringArray = this.getInputMode("@vkb-", stringArray2[i], hashtable);
                        if (stringArray == null) continue;
                        VirtualKeyboard.addDefaultInputMode(string3, stringArray);
                    }
                }
                if ((stringArray2 = (String[])hashtable.get("@im")) != null && stringArray2.length() > 0) {
                    String[] stringArray3 = this.toStringArray(this.tokenizeString((String)stringArray2, '|'));
                    TextField.setDefaultInputModeOrder(stringArray3);
                    for (int i = 0; i < stringArray3.length; ++i) {
                        stringArray = stringArray3[i];
                        String string4 = (String)hashtable.get("@im-" + (String)stringArray);
                        if (string4 == null) continue;
                        TextField.addInputMode((String)stringArray, this.parseTextFieldInputMode(string4), Character.isUpperCase(stringArray.charAt(0)));
                    }
                }
            }
        }
    }

    private Hashtable parseTextFieldInputMode(String string) {
        Vector vector = this.tokenizeString(string, '|');
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.elementAt(i);
            int n2 = string2.indexOf(61);
            String string3 = string2.substring(0, n2);
            String string4 = string2.substring(n2 + 1);
            hashtable.put(Integer.valueOf(string3), string4);
        }
        return hashtable;
    }

    private String[][] getInputMode(String string, String string2, Hashtable hashtable) {
        if (hashtable.containsKey(string + string2)) {
            return this.tokenizeMultiArray((String)hashtable.get(string + string2), '|', '\n');
        }
        return null;
    }

    private String[] toStringArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    private String[][] tokenizeMultiArray(String string, char c, char c2) {
        Vector vector = this.tokenizeString(string, c2);
        int n = vector.size();
        String[][] stringArray = new String[n][];
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.elementAt(i);
            stringArray[i] = this.toStringArray(this.tokenizeString(string2, c));
        }
        return stringArray;
    }

    private Vector tokenizeString(String string, char c) {
        Vector<String> vector = new Vector<String>();
        int n = string.length();
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (bl) {
                    stringBuffer.append(c);
                    bl = false;
                    continue;
                }
                bl = true;
                if (stringBuffer.length() <= 0) continue;
                vector.addElement(stringBuffer.toString());
                stringBuffer = new StringBuffer();
                continue;
            }
            bl = false;
            stringBuffer.append(c2);
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        return vector;
    }

    public String localize(String string, String string2) {
        Object v;
        if (this.resourceBundle != null && string != null && (v = this.resourceBundle.get(string)) != null) {
            return (String)v;
        }
        return string2;
    }

    public void addThemeRefreshListener(ActionListener actionListener) {
        if (this.themelisteners == null) {
            this.themelisteners = new EventDispatcher();
        }
        this.themelisteners.addListener(actionListener);
    }

    public void removeThemeRefreshListener(ActionListener actionListener) {
        if (this.themelisteners == null) {
            return;
        }
        this.themelisteners.removeListener(actionListener);
    }
}

