/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.Painter;
import com.sun.lwuit.StaticAnimation;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.FocusListener;
import com.sun.lwuit.events.StyleListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Hashtable;

public class Component
implements Animation,
StyleListener {
    private String selectText = UIManager.getInstance().localize("select", "Select");
    private boolean alwaysTensile;
    private int tensileLength = -1;
    private Component nextFocusDown;
    private Component nextFocusUp;
    private boolean enabled = true;
    private Component nextFocusRight;
    private Component nextFocusLeft;
    private String name;
    boolean hasLead;
    private boolean grabsPointerEvents;
    private boolean tensileDragEnabled = true;
    private boolean tactileTouch;
    public static final int BRB_CONSTANT_ASCENT = 1;
    public static final int BRB_CONSTANT_DESCENT = 2;
    public static final int BRB_CENTER_OFFSET = 3;
    public static final int BRB_OTHER = 4;
    private boolean visible = true;
    private boolean cellRenderer;
    private Rectangle bounds = new Rectangle(0, 0, new Dimension(0, 0));
    private Rectangle painterBounds;
    private int scrollX;
    private int scrollY;
    private boolean sizeRequestedByUser = false;
    private Dimension preferredSize;
    private boolean scrollSizeRequestedByUser = false;
    private Dimension scrollSize;
    private Style unSelectedStyle;
    private Style pressedStyle;
    private Style selectedStyle;
    private Style disabledStyle;
    private Container parent;
    private boolean focused = false;
    private EventDispatcher focusListeners = new EventDispatcher();
    private boolean handlesInput = false;
    boolean shouldCalcPreferredSize = true;
    boolean shouldCalcScrollSize = true;
    private boolean focusable = true;
    private boolean isScrollVisible = true;
    private boolean repaintPending;
    private boolean snapToGrid;
    private int scrollOpacity = 255;
    private int scrollOpacityChangeSpeed = 5;
    private boolean smoothScrolling;
    private int animationSpeed;
    private Motion animationMotion;
    private Motion draggedMotion;
    private int initialPressX;
    private int initialPressY;
    private boolean dragActivated;
    private int initialScrollY = -1;
    private int destScrollY = -1;
    private int lastScrollY;
    private int lastScrollX;
    private boolean initialized;
    public static final int CENTER = 4;
    public static final int TOP = 0;
    public static final int LEFT = 1;
    public static final int BOTTOM = 2;
    public static final int RIGHT = 3;
    private Hashtable clientProperties;
    private Rectangle dirtyRegion = null;
    private final Object dirtyRegionLock = new Object();
    private Label componentLabel;
    private String id;
    private boolean rtl;
    private boolean flatten;
    private Object paintLockImage;
    static /* synthetic */ Class class$com$sun$lwuit$Component$BGPainter;

    protected Component() {
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        this.animationSpeed = lookAndFeel.getDefaultSmoothScrollingSpeed();
        this.rtl = lookAndFeel.isRTL();
        this.tactileTouch = this.isFocusable();
        this.tensileDragEnabled = lookAndFeel.isDefaultTensileDrag();
        this.snapToGrid = UIManager.getInstance().isThemeConstant("snapGridBool", false);
        this.alwaysTensile = UIManager.getInstance().isThemeConstant("alwaysTensileBool", false);
    }

    private void initStyle() {
        this.unSelectedStyle = UIManager.getInstance().getComponentStyle(this.getUIID());
        if (this.unSelectedStyle != null) {
            this.unSelectedStyle.addStyleListener(this);
            if (this.unSelectedStyle.getBgPainter() == null) {
                this.unSelectedStyle.setBgPainter(new BGPainter());
            }
        }
        if (this.disabledStyle != null) {
            this.disabledStyle.addStyleListener(this);
            if (this.disabledStyle.getBgPainter() == null) {
                this.disabledStyle.setBgPainter(new BGPainter());
            }
        }
    }

    public int getX() {
        return this.bounds.getX();
    }

    public int getY() {
        return this.bounds.getY();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public Object getClientProperty(String string) {
        if (this.clientProperties == null) {
            return null;
        }
        return this.clientProperties.get(string);
    }

    Component getLeadComponent() {
        Container container = this.getParent();
        if (container != null) {
            return container.getLeadComponent();
        }
        return null;
    }

    public void putClientProperty(String string, Object object) {
        if (this.clientProperties == null) {
            if (object == null) {
                return;
            }
            this.clientProperties = new Hashtable();
        }
        if (object == null) {
            this.clientProperties.remove(string);
            if (this.clientProperties.size() == 0) {
                this.clientProperties = null;
            }
        } else {
            this.clientProperties.put(string, object);
        }
    }

    public final Rectangle getDirtyRegion() {
        return this.dirtyRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDirtyRegion(Rectangle rectangle) {
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            this.dirtyRegion = rectangle;
        }
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getWidth() {
        return this.bounds.getSize().getWidth();
    }

    public int getHeight() {
        return this.bounds.getSize().getHeight();
    }

    public void setX(int n) {
        this.bounds.setX(n);
    }

    public void setY(int n) {
        this.bounds.setY(n);
    }

    public int getBaseline(int n, int n2) {
        return n2 - this.getStyle().getPadding(false, 2);
    }

    public int getBaselineResizeBehavior() {
        return 4;
    }

    public void setPreferredSize(Dimension dimension) {
        if (dimension == null) {
            this.sizeRequestedByUser = false;
            this.preferredSize = null;
            this.shouldCalcPreferredSize = true;
            return;
        }
        Dimension dimension2 = this.preferredSize();
        dimension2.setWidth(dimension.getWidth());
        dimension2.setHeight(dimension.getHeight());
        this.sizeRequestedByUser = true;
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    Dimension getPreferredSizeWithMargin() {
        Dimension dimension = this.preferredSize();
        Style style = this.getStyle();
        return new Dimension(dimension.getWidth() + style.getMargin(1) + style.getMargin(3), dimension.getHeight() + style.getMargin(0) + style.getMargin(2));
    }

    public Dimension getScrollDimension() {
        if (!this.scrollSizeRequestedByUser && (this.scrollSize == null || this.shouldCalcScrollSize)) {
            this.scrollSize = this.calcScrollSize();
            this.shouldCalcScrollSize = false;
        }
        return this.scrollSize;
    }

    protected Dimension calcScrollSize() {
        return this.calcPreferredSize();
    }

    public void setScrollSize(Dimension dimension) {
        this.scrollSize = dimension;
        this.scrollSizeRequestedByUser = true;
    }

    public void setPreferredW(int n) {
        this.setPreferredSize(new Dimension(n, this.getPreferredH()));
    }

    public void setPreferredH(int n) {
        this.setPreferredSize(new Dimension(this.getPreferredW(), n));
    }

    public int getPreferredW() {
        return this.getPreferredSize().getWidth();
    }

    public int getPreferredH() {
        return this.getPreferredSize().getHeight();
    }

    public void setWidth(int n) {
        this.bounds.getSize().setWidth(n);
    }

    public void setHeight(int n) {
        this.bounds.getSize().setHeight(n);
    }

    public void setSize(Dimension dimension) {
        Dimension dimension2 = this.bounds.getSize();
        dimension2.setWidth(dimension.getWidth());
        dimension2.setHeight(dimension.getHeight());
    }

    public String getUIID() {
        return this.id;
    }

    public void setUIID(String string) {
        String string2 = this.id;
        this.id = string;
        if (string2 != null && !string2.equals(string)) {
            this.initStyle();
        }
        this.selectedStyle = null;
        this.disabledStyle = null;
        this.pressedStyle = null;
    }

    public Container getParent() {
        return this.parent;
    }

    void setParent(Container container) {
        this.parent = container;
    }

    public void addFocusListener(FocusListener focusListener) {
        this.focusListeners.addListener(focusListener);
    }

    public void removeFocusListener(FocusListener focusListener) {
        this.focusListeners.removeListener(focusListener);
    }

    protected void fireClicked() {
    }

    protected boolean isSelectableInteraction() {
        return false;
    }

    void fireFocusGained() {
        this.fireFocusGained(this);
    }

    void fireFocusLost() {
        this.fireFocusLost(this);
    }

    void fireFocusGained(Component component) {
        Form form;
        if (component.isCellRenderer()) {
            return;
        }
        this.focusListeners.fireFocus(component);
        this.focusGainedInternal();
        this.focusGained();
        if (this.isSelectableInteraction() && (form = this.getComponentForm()) != null) {
            form.getMenuBar().addSelectCommand(this.getSelectCommandText());
        }
    }

    public void setSelectCommandText(String string) {
        this.selectText = string;
    }

    public String getSelectCommandText() {
        return this.selectText;
    }

    void fireFocusLost(Component component) {
        Form form;
        if (component.isCellRenderer()) {
            return;
        }
        if (this.isSelectableInteraction() && (form = this.getComponentForm()) != null) {
            form.getMenuBar().removeSelectCommand();
        }
        this.focusListeners.fireFocus(component);
        this.focusLostInternal();
        this.focusLost();
    }

    void fireActionEvent() {
    }

    public void setLabelForComponent(Label label) {
        this.componentLabel = label;
    }

    public Label getLabelForComponent() {
        return this.componentLabel;
    }

    void focusGainedInternal() {
        this.startComponentLableTicker();
    }

    void startComponentLableTicker() {
        if (this.componentLabel != null && this.componentLabel.isTickerEnabled() && this.componentLabel.shouldTickerStart()) {
            this.componentLabel.startTicker(UIManager.getInstance().getLookAndFeel().getTickerSpeed(), true);
        }
    }

    void stopComponentLableTicker() {
        if (this.componentLabel != null && this.componentLabel.isTickerEnabled() && this.componentLabel.isTickerRunning()) {
            this.componentLabel.stopTicker();
        }
    }

    protected void focusGained() {
    }

    protected void focusLost() {
    }

    void focusLostInternal() {
        this.stopComponentLableTicker();
    }

    public void paintBackgrounds(Graphics graphics) {
        this.drawPainters(graphics, this.getParent(), this, this.getAbsoluteX() + this.getScrollX(), this.getAbsoluteY() + this.getScrollY(), this.getWidth(), this.getHeight());
    }

    public int getAbsoluteX() {
        int n = this.getX() - this.getScrollX();
        Container container = this.getParent();
        if (container != null) {
            n += container.getAbsoluteX();
        }
        return n;
    }

    public int getAbsoluteY() {
        int n = this.getY() - this.getScrollY();
        Container container = this.getParent();
        if (container != null) {
            n += container.getAbsoluteY();
        }
        return n;
    }

    final void paintInternal(Graphics graphics) {
        this.paintInternal(graphics, true);
    }

    final void paintInternal(Graphics graphics, boolean bl) {
        if (!this.isVisible()) {
            return;
        }
        if (this.paintLockImage != null) {
            if (this.paintLockImage instanceof Image) {
                Image image = (Image)this.paintLockImage;
                graphics.drawImage(image, this.getX(), this.getY());
            } else {
                Image image = (Image)Display.getInstance().extractHardRef(this.paintLockImage);
                if (image == null) {
                    image = Image.createImage(this.getWidth(), this.getHeight());
                    int n = this.getX();
                    int n2 = this.getY();
                    this.setX(0);
                    this.setY(0);
                    this.paintInternalImpl(image.getGraphics(), bl);
                    this.setX(n);
                    this.setY(n2);
                    this.paintLockImage = Display.getInstance().createSoftWeakRef(image);
                }
                graphics.drawImage(image, this.getX(), this.getY());
            }
            return;
        }
        this.paintInternalImpl(graphics, bl);
    }

    private void paintInternalImpl(Graphics graphics, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = graphics.getClipX();
        if (this.bounds.intersects(n4, n3 = graphics.getClipY(), n2 = graphics.getClipWidth(), n = graphics.getClipHeight())) {
            graphics.clipRect(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            this.paintBackground(graphics);
            if (this.isScrollable()) {
                int n5 = this.getScrollX();
                int n6 = this.getScrollY();
                graphics.translate(-n5, -n6);
                this.paint(graphics);
                graphics.translate(n5, n6);
                if (this.isScrollVisible) {
                    this.paintScrollbars(graphics);
                }
            } else {
                this.paint(graphics);
            }
            if (this.isBorderPainted()) {
                this.paintBorder(graphics);
            }
            if (bl && this.parent != null) {
                this.paintIntersectingComponentsAbove(graphics);
            }
            graphics.setClip(n4, n3, n2, n);
        }
    }

    private void paintIntersectingComponentsAbove(Graphics graphics) {
        Component component = this;
        int n = graphics.getTranslateX();
        int n2 = graphics.getTranslateY();
        graphics.translate(-n, -n2);
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            graphics.translate(container.getAbsoluteX() + container.getScrollX(), container.getAbsoluteY() + container.getScrollY());
            container.paintIntersecting(graphics, component, this.getAbsoluteX() + this.getScrollX(), this.getAbsoluteY() + this.getScrollY(), this.getWidth(), this.getHeight(), true);
            graphics.translate(-container.getAbsoluteX() - container.getScrollX(), -container.getAbsoluteY() - container.getScrollY());
            component = container;
        }
        graphics.translate(n, n2);
    }

    protected void paintScrollbars(Graphics graphics) {
        if (this.isScrollableX()) {
            this.paintScrollbarX(graphics);
        }
        if (this.isScrollableY()) {
            this.paintScrollbarY(graphics);
        }
    }

    protected void paintScrollbarX(Graphics graphics) {
        float f = this.getScrollDimension().getWidth();
        float f2 = (float)this.getWidth() / f;
        float f3 = (float)(this.getScrollX() + this.getWidth()) == f ? 1.0f - f2 : ((float)this.getScrollX() + (float)this.getWidth()) / f - f2;
        UIManager.getInstance().getLookAndFeel().drawHorizontalScroll(graphics, this, f3, f2);
    }

    public int getScrollOpacity() {
        if (Display.getInstance().shouldRenderSelection()) {
            this.scrollOpacity = 255;
        }
        return this.scrollOpacity;
    }

    protected void paintScrollbarY(Graphics graphics) {
        float f = this.getScrollDimension().getHeight();
        float f2 = (float)this.getHeight() / f;
        float f3 = (float)(this.getScrollY() + this.getHeight()) == f ? 1.0f - f2 : ((float)this.getScrollY() + (float)this.getHeight()) / f - f2;
        UIManager.getInstance().getLookAndFeel().drawVerticalScroll(graphics, this, f3, f2);
    }

    public final void paintComponent(Graphics graphics) {
        this.repaintPending = false;
        this.paintComponent(graphics, true);
    }

    public final void paintComponent(Graphics graphics, boolean bl) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        int n5 = 0;
        int n6 = 0;
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            n5 += container.getX();
            n6 += container.getY();
            if (container.isScrollableX()) {
                n5 -= container.getScrollX();
            }
            if (container.isScrollableY()) {
                n6 -= container.getScrollY();
            }
            int n7 = container.getAbsoluteX() + container.getScrollX();
            if (this.isRTL()) {
                n7 += container.getSideGap();
            }
            graphics.clipRect(n7, container.getAbsoluteY() + container.getScrollY(), container.getWidth() - container.getSideGap(), container.getHeight() - container.getBottomGap());
        }
        graphics.clipRect(n5 + this.getX(), n6 + this.getY(), this.getWidth(), this.getHeight());
        if (bl) {
            this.paintBackgrounds(graphics);
        }
        graphics.translate(n5, n6);
        this.paintInternal(graphics);
        graphics.translate(-n5, -n6);
        this.paintGlassImpl(graphics);
        graphics.setClip(n, n2, n3, n4);
    }

    void paintGlassImpl(Graphics graphics) {
        if (this.parent != null) {
            this.parent.paintGlassImpl(graphics);
        }
    }

    private void drawPainters(Graphics graphics, Component component, Component component2, int n, int n2, int n3, int n4) {
        if (this.flatten && this.getWidth() > 0 && this.getHeight() > 0) {
            Image image = (Image)this.getClientProperty("$FLAT");
            int n5 = this.getAbsoluteX() + this.getScrollX();
            int n6 = this.getAbsoluteY() + this.getScrollY();
            if (image == null || image.getWidth() != this.getWidth() || image.getHeight() != this.getHeight()) {
                image = Image.createImage(this.getWidth(), this.getHeight());
                Graphics graphics2 = image.getGraphics();
                this.drawPaintersImpl(graphics2, component, component2, n, n2, n3, n4);
                this.paintBackgroundImpl(graphics2);
                this.putClientProperty("$FLAT", image);
            }
            int n7 = graphics.getTranslateX();
            int n8 = graphics.getTranslateY();
            graphics.translate(-n7 + n5, -n8 + n6);
            graphics.drawImage(image, 0, 0);
            graphics.translate(n7 - n5, n8 - n6);
            return;
        }
        this.drawPaintersImpl(graphics, component, component2, n, n2, n3, n4);
    }

    private void drawPaintersImpl(Graphics graphics, Component component, Component component2, int n, int n2, int n3, int n4) {
        Object object;
        if (component == null) {
            return;
        }
        if (component.getStyle().getBgTransparency() != -1) {
            this.drawPainters(graphics, component.getParent(), component, n, n2, n3, n4);
        }
        if (!component.isVisible()) {
            return;
        }
        int n5 = component.getAbsoluteX() + component.getScrollX();
        int n6 = component.getAbsoluteY() + component.getScrollY();
        graphics.translate(n5, n6);
        ((Container)component).paintIntersecting(graphics, component2, n, n2, n3, n4, false);
        if (component.isBorderPainted() && ((Border)(object = component.getBorder())).isBackgroundPainter()) {
            graphics.translate(-component.getX(), -component.getY());
            ((Border)object).paintBorderBackground(graphics, component);
            ((Border)object).paint(graphics, component);
            graphics.translate(component.getX() - n5, component.getY() - n6);
            return;
        }
        object = component.getStyle().getBgPainter();
        if (object != null) {
            Rectangle rectangle;
            if (this.painterBounds == null) {
                rectangle = this.painterBounds = new Rectangle(0, 0, component.getWidth(), component.getHeight());
            } else {
                rectangle = this.painterBounds;
                rectangle.getSize().setWidth(component.getWidth());
                rectangle.getSize().setHeight(component.getHeight());
            }
            object.paint(graphics, rectangle);
        }
        graphics.translate(-n5, -n6);
    }

    protected Border getBorder() {
        return this.getStyle().getBorder();
    }

    protected void paintBackground(Graphics graphics) {
        if (this.isFlatten()) {
            return;
        }
        this.paintBackgroundImpl(graphics);
    }

    private void paintBackgroundImpl(Graphics graphics) {
        Border border;
        if (this.isBorderPainted() && (border = this.getBorder()) != null && border.isBackgroundPainter()) {
            border.paintBorderBackground(graphics, this);
            return;
        }
        if (this.getStyle().getBgPainter() != null) {
            this.getStyle().getBgPainter().paint(graphics, this.bounds);
        }
    }

    public void paint(Graphics graphics) {
    }

    protected boolean isScrollable() {
        return this.isScrollableX() || this.isScrollableY();
    }

    public boolean isScrollableX() {
        return false;
    }

    public boolean isScrollableY() {
        return false;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public int getScrollY() {
        return this.scrollY;
    }

    protected void setScrollX(int n) {
        this.scrollX = n;
        if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
            this.scrollX = Math.min(this.scrollX, this.getScrollDimension().getWidth() - this.getWidth());
            this.scrollX = Math.max(this.scrollX, 0);
        }
        if (this.isScrollableX()) {
            this.repaint();
        }
    }

    protected void setScrollY(int n) {
        this.scrollY = n;
        if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
            this.scrollY = Math.min(this.scrollY, this.getScrollDimension().getHeight() - this.getHeight());
            this.scrollY = Math.max(this.scrollY, 0);
        }
        if (this.isScrollableY()) {
            this.repaint();
        }
    }

    public int getBottomGap() {
        if (this.isScrollableX() && this.isScrollVisible()) {
            return UIManager.getInstance().getLookAndFeel().getHorizontalScrollHeight();
        }
        return 0;
    }

    public int getSideGap() {
        if (this.isScrollableY() && this.isScrollVisible()) {
            return UIManager.getInstance().getLookAndFeel().getVerticalScrollWidth();
        }
        return 0;
    }

    public boolean contains(int n, int n2) {
        int n3 = this.getAbsoluteX() + this.getScrollX();
        int n4 = this.getAbsoluteY() + this.getScrollY();
        return n >= n3 && n < n3 + this.getWidth() && n2 >= n4 && n2 < n4 + this.getHeight();
    }

    protected Dimension calcPreferredSize() {
        Dimension dimension = new Dimension(0, 0);
        return dimension;
    }

    private Dimension preferredSize() {
        if (!this.sizeRequestedByUser && (this.shouldCalcPreferredSize || this.preferredSize == null)) {
            this.shouldCalcPreferredSize = false;
            this.preferredSize = this.calcPreferredSize();
        }
        return this.preferredSize;
    }

    protected Rectangle getBounds() {
        return this.bounds;
    }

    protected Rectangle getVisibleBounds() {
        return this.bounds;
    }

    public boolean isFocusable() {
        return this.focusable && this.enabled && this.isVisible();
    }

    public void setFocusable(boolean bl) {
        this.focusable = bl;
        Form form = this.getComponentForm();
        if (form != null) {
            form.clearFocusVectors();
        }
    }

    public void setShouldCalcPreferredSize(boolean bl) {
        if (!this.shouldCalcScrollSize) {
            this.shouldCalcScrollSize = bl;
        }
        if (bl != this.shouldCalcPreferredSize) {
            this.shouldCalcPreferredSize = bl;
            this.shouldCalcScrollSize = bl;
            if (bl && this.getParent() != null) {
                this.shouldCalcPreferredSize = bl;
                this.getParent().setShouldLayout(bl);
            }
        }
    }

    public boolean handlesInput() {
        return this.handlesInput;
    }

    public void setHandlesInput(boolean bl) {
        this.handlesInput = bl;
    }

    public boolean hasFocus() {
        return this.focused;
    }

    public void setFocus(boolean bl) {
        this.focused = bl;
    }

    public Form getComponentForm() {
        Form form = null;
        Container container = this.getParent();
        if (container != null) {
            form = container.getComponentForm();
        }
        return form;
    }

    void repaint(Component component) {
        if (this.isCellRenderer() || component.getWidth() <= 0 || component.getHeight() <= 0 || this.paintLockImage != null) {
            return;
        }
        Container container = this.getParent();
        if (container != null) {
            container.repaint(component);
        }
    }

    public void repaint() {
        this.repaintPending = true;
        if (this.dirtyRegion != null) {
            this.setDirtyRegion(null);
        }
        this.repaint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n, int n2, int n3, int n4) {
        Object object = this.dirtyRegionLock;
        synchronized (object) {
            if (this.dirtyRegion == null) {
                if (this.repaintPending) {
                    return;
                }
                Rectangle rectangle = new Rectangle(n, n2, n3, n4);
                this.setDirtyRegion(rectangle);
            } else if (this.dirtyRegion.getX() != n || this.dirtyRegion.getY() != n2 || this.dirtyRegion.getSize().getWidth() != n3 || this.dirtyRegion.getSize().getHeight() != n4) {
                Rectangle rectangle = new Rectangle(this.dirtyRegion);
                Dimension dimension = rectangle.getSize();
                int n5 = Math.min(rectangle.getX(), n);
                int n6 = Math.min(rectangle.getY(), n2);
                int n7 = Math.max(n + n3, rectangle.getX() + dimension.getWidth());
                int n8 = Math.max(n2 + n4, rectangle.getY() + dimension.getHeight());
                rectangle.setX(n5);
                rectangle.setY(n6);
                dimension.setWidth(n7 - n5);
                dimension.setHeight(n8 - n6);
                this.setDirtyRegion(rectangle);
            }
        }
        this.repaint(this);
    }

    protected void longKeyPress(int n) {
    }

    public void keyPressed(int n) {
    }

    public void keyReleased(int n) {
    }

    public void keyRepeated(int n) {
        this.keyPressed(n);
        this.keyReleased(n);
    }

    private void setAnimationMotion(Motion motion) {
        this.animationMotion = motion;
    }

    private Motion getAnimationMotion() {
        return this.animationMotion;
    }

    public int getScrollAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setScrollAnimationSpeed(int n) {
        this.animationSpeed = n;
    }

    public boolean isSmoothScrolling() {
        return this.smoothScrolling;
    }

    public void setSmoothScrolling(boolean bl) {
        this.smoothScrolling = bl;
    }

    public void pointerHover(int[] nArray, int[] nArray2) {
        this.pointerDragged(nArray, nArray2);
    }

    void clearDrag() {
        this.draggedMotion = null;
        Container container = this.getParent();
        if (container != null) {
            container.clearDrag();
        }
    }

    public void pointerHoverReleased(int[] nArray, int[] nArray2) {
        this.pointerReleaseImpl(nArray[0], nArray2[0]);
    }

    public void pointerHoverPressed(int[] nArray, int[] nArray2) {
        this.dragActivated = false;
        this.clearDrag();
    }

    public void pointerDragged(int[] nArray, int[] nArray2) {
        this.pointerDragged(nArray[0], nArray2[0]);
    }

    protected void dragInitiated() {
    }

    public void pointerDragged(int n, int n2) {
        if (this.isScrollable() && this.isSmoothScrolling()) {
            if (!this.dragActivated) {
                this.dragActivated = true;
                this.lastScrollY = n2;
                this.lastScrollX = n;
                Form form = this.getComponentForm();
                form.setDraggedComponent(this);
                form.registerAnimatedInternal(this);
                Component component = form.getFocused();
                if (component != null && component != this) {
                    component.dragInitiated();
                }
            }
            if (this.isScrollableY()) {
                int n3;
                int n4 = this.getTensileLength() > -1 ? this.getTensileLength() : this.getHeight() / 2;
                if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
                    n4 = 0;
                }
                if ((n3 = this.getScrollY() + (this.lastScrollY - n2)) >= -n4 && n3 < this.getScrollDimension().getHeight() - this.getHeight() + n4) {
                    this.setScrollY(n3);
                }
            }
            if (this.isScrollableX()) {
                int n5;
                int n6 = this.getTensileLength() > -1 ? this.getTensileLength() : this.getWidth() / 2;
                if (!this.isSmoothScrolling() || !this.isTensileDragEnabled()) {
                    n6 = 0;
                }
                if ((n5 = this.getScrollX() + (this.lastScrollX - n)) >= -n6 && n5 < this.getScrollDimension().getWidth() - this.getWidth() + n6) {
                    this.setScrollX(n5);
                }
            }
            this.lastScrollY = n2;
            this.lastScrollX = n;
        } else {
            Container container = this.getParent();
            if (!(container instanceof Form)) {
                container.pointerDragged(n, n2);
            }
        }
    }

    private void initScrollMotion() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.registerAnimatedInternal(this);
        }
        Motion motion = Motion.createLinearMotion(this.initialScrollY, this.destScrollY, this.getScrollAnimationSpeed());
        this.setAnimationMotion(motion);
        motion.start();
    }

    public void pointerPressed(int[] nArray, int[] nArray2) {
        this.dragActivated = false;
        this.pointerPressed(nArray[0], nArray2[0]);
        this.initialPressX = nArray[0];
        this.initialPressY = nArray2[0];
        this.scrollOpacity = 255;
    }

    public void pointerPressed(int n, int n2) {
        this.clearDrag();
    }

    public void pointerReleased(int[] nArray, int[] nArray2) {
        this.pointerReleased(nArray[0], nArray2[0]);
    }

    protected void longPointerPress(int n, int n2) {
    }

    public void pointerReleased(int n, int n2) {
        this.pointerReleaseImpl(n, n2);
        this.scrollOpacity = 255;
    }

    public void setTensileDragEnabled(boolean bl) {
        this.tensileDragEnabled = bl;
    }

    public boolean isTensileDragEnabled() {
        return this.tensileDragEnabled;
    }

    void startTensile(int n, int n2) {
        if (this.tensileDragEnabled) {
            this.draggedMotion = Motion.createSplineMotion(n, n2, 150);
            this.draggedMotion.start();
        } else {
            this.draggedMotion = Motion.createLinearMotion(n, n2, 0);
            this.draggedMotion.start();
        }
        Form form = this.getComponentForm();
        if (form != null) {
            form.registerAnimatedInternal(this);
        }
    }

    private boolean chooseScrollXOrY(int n, int n2) {
        boolean bl = this.isScrollableX();
        boolean bl2 = this.isScrollableY();
        if (bl && bl2) {
            return Math.abs(this.initialPressX - n) > Math.abs(this.initialPressY - n2);
        }
        return bl;
    }

    private void pointerReleaseImpl(int n, int n2) {
        Form form;
        if (UIManager.getInstance().getLookAndFeel().isFadeScrollBar() && this.isScrollable() && (form = this.getComponentForm()) != null) {
            form.registerAnimatedInternal(this);
        }
        if (this.dragActivated) {
            int n3 = this.scrollY;
            this.dragActivated = false;
            boolean bl = this.chooseScrollXOrY(n, n2);
            if (bl) {
                n3 = this.scrollX;
                if (n3 < 0) {
                    this.startTensile(n3, 0);
                    return;
                }
                if (n3 > this.getScrollDimension().getWidth() - this.getWidth()) {
                    this.startTensile(n3, this.getScrollDimension().getWidth() - this.getWidth());
                    return;
                }
            } else {
                if (n3 < 0) {
                    this.startTensile(n3, 0);
                    return;
                }
                if (n3 > this.getScrollDimension().getHeight() - this.getHeight()) {
                    this.startTensile(n3, this.getScrollDimension().getHeight() - this.getHeight());
                    return;
                }
            }
            float f = Display.getInstance().getDragSpeed(!bl);
            int n4 = this.getTensileLength() > -1 ? this.getTensileLength() : this.getWidth() / 2;
            if (!this.isTensileDragEnabled()) {
                n4 = 0;
            }
            this.draggedMotion = !bl ? (f < 0.0f ? Motion.createFrictionMotion(n3, -n4, f, 4.0E-4f) : Motion.createFrictionMotion(n3, this.getScrollDimension().getHeight() - this.getHeight() + n4, f, 4.0E-4f)) : (f < 0.0f ? Motion.createFrictionMotion(n3, -n4, f, 4.0E-4f) : Motion.createFrictionMotion(n3, this.getScrollDimension().getWidth() - this.getWidth() + n4, f, 4.0E-4f));
            this.draggedMotion.start();
        }
    }

    public Style getStyle() {
        if (this.unSelectedStyle == null) {
            this.initStyle();
        }
        if (this.hasLead) {
            Component component = this.getLeadComponent();
            if (component != null) {
                if (!component.isEnabled()) {
                    return this.getDisabledStyle();
                }
                if (component.isPressedStyle()) {
                    return this.getPressedStyle();
                }
                if (component.hasFocus() && Display.getInstance().shouldRenderSelection()) {
                    return this.getSelectedStyle();
                }
            }
            return this.unSelectedStyle;
        }
        if (!this.isEnabled()) {
            return this.getDisabledStyle();
        }
        if (this.isPressedStyle()) {
            return this.getPressedStyle();
        }
        if (this.hasFocus() && Display.getInstance().shouldRenderSelection()) {
            return this.getSelectedStyle();
        }
        return this.unSelectedStyle;
    }

    boolean isPressedStyle() {
        return false;
    }

    public Style getPressedStyle() {
        if (this.pressedStyle == null) {
            this.pressedStyle = UIManager.getInstance().getComponentCustomStyle(this.getUIID(), "press");
            this.pressedStyle.addStyleListener(this);
            if (this.pressedStyle.getBgPainter() == null) {
                this.pressedStyle.setBgPainter(new BGPainter());
            }
        }
        return this.pressedStyle;
    }

    public void setPressedStyle(Style style) {
        if (this.pressedStyle != null) {
            this.pressedStyle.removeStyleListener(this);
        }
        this.pressedStyle = style;
        this.pressedStyle.addStyleListener(this);
        if (this.pressedStyle.getBgPainter() == null) {
            this.pressedStyle.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public Style getUnselectedStyle() {
        if (this.unSelectedStyle == null) {
            this.initStyle();
        }
        return this.unSelectedStyle;
    }

    public Style getSelectedStyle() {
        if (this.selectedStyle == null) {
            this.selectedStyle = UIManager.getInstance().getComponentSelectedStyle(this.getUIID());
            this.selectedStyle.addStyleListener(this);
            if (this.selectedStyle.getBgPainter() == null) {
                this.selectedStyle.setBgPainter(new BGPainter());
            }
        }
        return this.selectedStyle;
    }

    public Style getDisabledStyle() {
        if (this.disabledStyle == null) {
            this.disabledStyle = UIManager.getInstance().getComponentCustomStyle(this.getUIID(), "dis");
            this.disabledStyle.addStyleListener(this);
            if (this.disabledStyle.getBgPainter() == null) {
                this.disabledStyle.setBgPainter(new BGPainter());
            }
        }
        return this.disabledStyle;
    }

    public void setUnselectedStyle(Style style) {
        if (this.unSelectedStyle != null) {
            this.unSelectedStyle.removeStyleListener(this);
        }
        this.unSelectedStyle = style;
        this.unSelectedStyle.addStyleListener(this);
        if (this.unSelectedStyle.getBgPainter() == null) {
            this.unSelectedStyle.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public void setSelectedStyle(Style style) {
        if (this.selectedStyle != null) {
            this.selectedStyle.removeStyleListener(this);
        }
        this.selectedStyle = style;
        this.selectedStyle.addStyleListener(this);
        if (this.selectedStyle.getBgPainter() == null) {
            this.selectedStyle.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public void setDisabledStyle(Style style) {
        if (this.disabledStyle != null) {
            this.disabledStyle.removeStyleListener(this);
        }
        this.disabledStyle = style;
        this.disabledStyle.addStyleListener(this);
        if (this.disabledStyle.getBgPainter() == null) {
            this.disabledStyle.setBgPainter(new BGPainter());
        }
        this.setShouldCalcPreferredSize(true);
        this.checkAnimation();
    }

    public void requestFocus() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.requestFocus(this);
        }
    }

    public String toString() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        return string + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        return "x=" + this.getX() + " y=" + this.getY() + " width=" + this.getWidth() + " height=" + this.getHeight();
    }

    public void refreshTheme() {
        this.refreshTheme(this.getUIID());
    }

    protected void refreshTheme(String string) {
        Style style = this.getUnselectedStyle();
        this.setUnselectedStyle(this.mergeStyle(style, UIManager.getInstance().getComponentStyle(string)));
        if (this.selectedStyle != null) {
            this.setSelectedStyle(this.mergeStyle(this.selectedStyle, UIManager.getInstance().getComponentSelectedStyle(string)));
        }
        if (this.disabledStyle != null) {
            this.setDisabledStyle(this.mergeStyle(this.disabledStyle, UIManager.getInstance().getComponentCustomStyle(string, "dis")));
        }
        if (this.pressedStyle != null) {
            this.setPressedStyle(this.mergeStyle(this.pressedStyle, UIManager.getInstance().getComponentCustomStyle(string, "press")));
        }
        this.checkAnimation();
        UIManager.getInstance().getLookAndFeel().bind(this);
    }

    Style mergeStyle(Style style, Style style2) {
        if (style.isModified()) {
            style.merge(style2);
            return style;
        }
        return style2;
    }

    protected boolean isDragActivated() {
        return this.dragActivated;
    }

    void setDragActivated(boolean bl) {
        this.dragActivated = bl;
    }

    void checkAnimation() {
        Image image = this.getStyle().getBgImage();
        if (image != null && image.isAnimation()) {
            Form form = this.getComponentForm();
            if (form != null) {
                form.registerAnimated(this);
            }
        } else {
            Form form;
            Painter painter = this.getStyle().getBgPainter();
            if (painter.getClass() != (class$com$sun$lwuit$Component$BGPainter == null ? (class$com$sun$lwuit$Component$BGPainter = Component.class$("com.sun.lwuit.Component$BGPainter")) : class$com$sun$lwuit$Component$BGPainter) && painter instanceof Animation) {
                Form form2 = this.getComponentForm();
                if (form2 != null) {
                    form2.registerAnimated(this);
                }
            } else if (this.scrollOpacity == 255 && this.isScrollable() && UIManager.getInstance().getLookAndFeel().isFadeScrollBar() && (form = this.getComponentForm()) != null) {
                form.registerAnimatedInternal(this);
            }
        }
    }

    void deregisterAnimatedInternal() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.deregisterAnimatedInternal(this);
        }
    }

    protected int getGridPosY() {
        return this.getScrollY();
    }

    protected int getGridPosX() {
        return this.getScrollX();
    }

    public boolean animate() {
        Image image = this.getStyle().getBgImage();
        boolean bl = image != null && image.isAnimation() && image.animate();
        Motion motion = this.getAnimationMotion();
        if (motion != null && this.destScrollY != -1 && this.destScrollY != this.getScrollY()) {
            this.setScrollY(motion.getValue());
            if (this.destScrollY == this.scrollY) {
                this.destScrollY = -1;
                this.deregisterAnimatedInternal();
            }
            return true;
        }
        if (this.draggedMotion != null) {
            int n = this.draggedMotion.getValue();
            if (this.draggedMotion.isFinished()) {
                if (n < 0) {
                    this.startTensile(n, 0);
                } else if (this.isScrollableY()) {
                    int n2 = this.getScrollDimension().getHeight() - this.getHeight();
                    if (n > n2 && n2 > 0) {
                        this.startTensile(n, this.getScrollDimension().getHeight() - this.getHeight());
                    } else if (this.snapToGrid && this.getScrollY() < n2 && this.getScrollY() > 0) {
                        int n3;
                        int n4 = this.getGridPosY();
                        if (n4 != (n3 = this.getScrollY())) {
                            this.startTensile(n3, n4);
                        } else {
                            this.draggedMotion = null;
                        }
                    } else {
                        this.draggedMotion = null;
                    }
                } else {
                    int n5 = this.getScrollDimension().getWidth() - this.getWidth();
                    if (n > n5) {
                        this.startTensile(n, this.getScrollDimension().getWidth() - this.getWidth());
                    } else if (this.snapToGrid && this.getScrollX() < n5 && this.getScrollX() > 0) {
                        int n6;
                        int n7 = this.getGridPosX();
                        if (n7 != (n6 = this.getScrollX())) {
                            this.startTensile(n6, n7);
                        } else {
                            this.draggedMotion = null;
                        }
                    } else {
                        this.draggedMotion = null;
                    }
                }
            }
            if (this.isScrollableY()) {
                this.scrollY = n;
                return true;
            }
            this.scrollX = n;
            return true;
        }
        if (bl) {
            if (image instanceof StaticAnimation) {
                Rectangle rectangle = ((StaticAnimation)image).getDirtyRegion();
                if (rectangle != null) {
                    rectangle.setX(this.getAbsoluteX());
                    rectangle.setY(this.getAbsoluteY() + rectangle.getY());
                }
                this.setDirtyRegion(rectangle);
            }
        } else {
            Painter painter = this.getStyle().getBgPainter();
            boolean bl2 = painter != null && painter.getClass() != (class$com$sun$lwuit$Component$BGPainter == null ? (class$com$sun$lwuit$Component$BGPainter = Component.class$("com.sun.lwuit.Component$BGPainter")) : class$com$sun$lwuit$Component$BGPainter) && painter instanceof Animation && painter != this && ((Animation)((Object)painter)).animate() ? true : (bl = false);
        }
        if (UIManager.getInstance().getLookAndFeel().isFadeScrollBar() && this.scrollOpacity > 0 && !this.dragActivated) {
            this.scrollOpacity = Math.max(0, this.scrollOpacity - this.scrollOpacityChangeSpeed);
            return true;
        }
        if (!(bl || this.destScrollY != -1 && this.destScrollY != this.scrollY || bl || motion != null || this.draggedMotion != null || this.dragActivated)) {
            this.tryDeregisterAnimated();
        }
        return bl;
    }

    void tryDeregisterAnimated() {
        this.deregisterAnimatedInternal();
    }

    protected void scrollRectToVisible(Rectangle rectangle, Component component) {
        this.scrollRectToVisible(rectangle.getX(), rectangle.getY(), rectangle.getSize().getWidth(), rectangle.getSize().getHeight(), component);
    }

    public void scrollRectToVisible(int n, int n2, int n3, int n4, Component component) {
        if (this.isScrollable()) {
            int n5;
            int n6 = this.getScrollY();
            Style style = this.getStyle();
            int n7 = this.getWidth() - style.getPadding(this.isRTL(), 1) - style.getPadding(this.isRTL(), 3);
            int n8 = this.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2);
            Rectangle rectangle = this.isSmoothScrolling() && this.destScrollY > -1 ? new Rectangle(this.getScrollX(), this.destScrollY, n7, n8) : new Rectangle(this.getScrollX(), this.getScrollY(), n7, n8);
            int n9 = n;
            int n10 = n2;
            Container container = null;
            if (component != null) {
                container = component.getParent();
            }
            if (container == this) {
                if (rectangle.contains(n, n2, n3, n4)) {
                    return;
                }
            } else {
                while (container != this) {
                    if (container == null) {
                        n9 = n;
                        n10 = n2;
                        break;
                    }
                    n9 += container.getX();
                    n10 += container.getY();
                    container = container.getParent();
                }
                if (rectangle.contains(n9, n10, n3, n4)) {
                    return;
                }
            }
            if (this.isScrollableX()) {
                if (this.getScrollX() > n9) {
                    this.setScrollX(n9);
                }
                n5 = n9 + n3 - style.getPadding(1) - style.getPadding(3);
                if (this.getScrollX() + n7 < n5) {
                    this.setScrollX(this.getScrollX() + (n5 - (this.getScrollX() + n7)));
                } else if (this.getScrollX() > n9) {
                    this.setScrollX(n9);
                }
            }
            if (this.isScrollableY()) {
                if (this.getScrollY() > n10) {
                    n6 = n10;
                }
                n5 = n10 + n4 - style.getPadding(0) - style.getPadding(2);
                if (this.getScrollY() + n8 < n5) {
                    n6 = this.getScrollY() + (n5 - (this.getScrollY() + n8));
                } else if (this.getScrollY() > n10) {
                    n6 = n10;
                }
                if (this.isSmoothScrolling()) {
                    this.initialScrollY = this.getScrollY();
                    this.destScrollY = n6;
                    this.initScrollMotion();
                } else {
                    this.setScrollY(n6);
                }
            }
            this.repaint();
        } else {
            Container container = this.getParent();
            if (container != null) {
                container.scrollRectToVisible(this.getAbsoluteX() - container.getAbsoluteX() + n, this.getAbsoluteY() - container.getAbsoluteY() + n2, n3, n4, container);
            }
        }
    }

    private boolean isBorderPainted() {
        return this.getStyle().getBorder() != null;
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            graphics.setColor(this.getStyle().getFgColor());
            border.paint(graphics, this);
        }
    }

    public void setCellRenderer(boolean bl) {
        this.cellRenderer = bl;
    }

    boolean isCellRenderer() {
        return this.cellRenderer;
    }

    public boolean isScrollVisible() {
        return this.isScrollVisible;
    }

    public void setScrollVisible(boolean bl) {
        this.isScrollVisible = bl;
    }

    public void setIsScrollVisible(boolean bl) {
        this.isScrollVisible = bl;
    }

    void initComponentImpl() {
        if (!this.initialized) {
            this.initialized = true;
            Style style = this.getStyle();
            Image image = style.getBgImage();
            if (image != null) {
                image.lock();
            } else {
                Border border = style.getBorder();
                if (border != null) {
                    border.lock();
                }
            }
            UIManager.getInstance().getLookAndFeel().bind(this);
            this.checkAnimation();
            if (this.isRTL() && this.isScrollableX()) {
                this.setScrollX(this.getScrollDimension().getWidth());
            }
            this.initComponent();
        }
    }

    void deinitializeImpl() {
        if (this.isInitialized()) {
            this.paintLockRelease();
            this.setInitialized(false);
            this.setDirtyRegion(null);
            Style style = this.getStyle();
            Image image = style.getBgImage();
            if (image != null) {
                image.unlock();
            } else {
                Border border = style.getBorder();
                if (border != null) {
                    border.unlock();
                }
            }
            this.deinitialize();
        }
    }

    protected void laidOut() {
        if (this.isScrollableY() && this.getScrollY() > 0 && this.getScrollY() + this.getHeight() > this.getScrollDimension().getHeight()) {
            this.setScrollY(this.getScrollDimension().getHeight() - this.getHeight());
        }
        if (this.isScrollableX() && this.getScrollX() > 0 && this.getScrollX() + this.getWidth() > this.getScrollDimension().getWidth()) {
            this.setScrollX(this.getScrollDimension().getWidth() - this.getWidth());
        }
        if (!this.isScrollableY()) {
            this.setScrollY(0);
        }
        if (!this.isScrollableX()) {
            this.setScrollX(0);
        }
    }

    protected void deinitialize() {
    }

    protected void initComponent() {
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    protected void setInitialized(boolean bl) {
        this.initialized = bl;
    }

    public void styleChanged(String string, Style style) {
        if (!this.shouldCalcPreferredSize && style == this.getStyle() && (string.equals("font") || string.equals("margin") || string.equals("padding"))) {
            this.setShouldCalcPreferredSize(true);
            Container container = this.getParent();
            if (container != null && container.getComponentForm() != null) {
                container.revalidate();
            }
        }
    }

    public Component getNextFocusDown() {
        return this.nextFocusDown;
    }

    public void setNextFocusDown(Component component) {
        this.nextFocusDown = component;
    }

    public Component getNextFocusUp() {
        return this.nextFocusUp;
    }

    public void setNextFocusUp(Component component) {
        this.nextFocusUp = component;
    }

    public Component getNextFocusLeft() {
        return this.nextFocusLeft;
    }

    public void setNextFocusLeft(Component component) {
        this.nextFocusLeft = component;
    }

    public Component getNextFocusRight() {
        return this.nextFocusRight;
    }

    public void setNextFocusRight(Component component) {
        this.nextFocusRight = component;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    void onEditComplete(String string) {
    }

    public void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        Form form = this.getComponentForm();
        if (form != null) {
            form.clearFocusVectors();
            this.repaint();
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    protected void initCustomStyle(Style style) {
        style.addStyleListener(this);
        if (style.getBgPainter() == null) {
            style.setBgPainter(new BGPainter());
        }
    }

    protected void deinitializeCustomStyle(Style style) {
        style.removeStyleListener(this);
    }

    public boolean isRTL() {
        return this.rtl;
    }

    public void setRTL(boolean bl) {
        this.rtl = bl;
    }

    protected boolean isTactileTouch(int n, int n2) {
        return this.isTactileTouch();
    }

    public boolean isTactileTouch() {
        return this.tactileTouch;
    }

    public void setTactileTouch(boolean bl) {
        this.tactileTouch = bl;
    }

    public String[] getPropertyNames() {
        return null;
    }

    public Class[] getPropertyTypes() {
        return null;
    }

    public Object getPropertyValue(String string) {
        return null;
    }

    public String setPropertyValue(String string, Object object) {
        return "Unknown: " + string;
    }

    public void paintLockRelease() {
        this.paintLockImage = null;
    }

    public Image paintLock(boolean bl) {
        if ((this.getStyle().getBgTransparency() & 0xFF) != 255) {
            return null;
        }
        if (this.paintLockImage == null) {
            this.paintLockImage = Image.createImage(this.getWidth(), this.getHeight());
            int n = this.getX();
            int n2 = this.getY();
            this.setX(0);
            this.setY(0);
            this.paintInternalImpl(((Image)this.paintLockImage).getGraphics(), false);
            this.setX(n);
            this.setY(n2);
            if (bl) {
                return (Image)this.paintLockImage;
            }
            this.paintLockImage = Display.getInstance().createSoftWeakRef(this.paintLockImage);
        } else if (bl) {
            return (Image)this.paintLockImage;
        }
        return null;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean bl) {
        this.snapToGrid = bl;
    }

    boolean shouldBlockSideSwipe() {
        return false;
    }

    public boolean isFlatten() {
        return this.flatten;
    }

    public void setFlatten(boolean bl) {
        this.flatten = bl;
    }

    public int getTensileLength() {
        return this.tensileLength;
    }

    public void setTensileLength(int n) {
        this.tensileLength = n;
    }

    Label getHintLabelImpl() {
        return null;
    }

    void setHintLabelImpl(Label label) {
    }

    boolean shouldShowHint() {
        return false;
    }

    void paintHint(Graphics graphics) {
        Label label = this.getHintLabelImpl();
        if (label != null && this.shouldShowHint()) {
            label.setX(this.getX());
            label.setY(this.getY());
            label.setWidth(this.getWidth());
            label.setHeight(this.getHeight());
            label.paint(graphics);
        }
    }

    String getHint() {
        Label label = this.getHintLabelImpl();
        if (label != null) {
            return label.getText();
        }
        return null;
    }

    Image getHintIcon() {
        Label label = this.getHintLabelImpl();
        if (label != null) {
            return label.getIcon();
        }
        return null;
    }

    void setHint(String string, Image image) {
        Label label = this.getHintLabelImpl();
        if (label == null) {
            label = new Label(string);
            label.setUIID("TextHint");
            this.setHintLabelImpl(label);
        } else {
            label.setText(string);
        }
        label.setIcon(image);
    }

    public boolean isGrabsPointerEvents() {
        return this.grabsPointerEvents;
    }

    public void setGrabsPointerEvents(boolean bl) {
        this.grabsPointerEvents = bl;
    }

    public int getScrollOpacityChangeSpeed() {
        return this.scrollOpacityChangeSpeed;
    }

    public void setScrollOpacityChangeSpeed(int n) {
        this.scrollOpacityChangeSpeed = n;
    }

    public void growShrink(int n) {
        Motion motion = Motion.createSplineMotion(this.getWidth(), this.getPreferredW(), n);
        Motion motion2 = Motion.createSplineMotion(this.getHeight(), this.getPreferredH(), n);
        motion.start();
        motion2.start();
        this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        this.getComponentForm().registerAnimated(new BGPainter(motion, motion2));
        this.getComponentForm().revalidate();
    }

    public boolean isAlwaysTensile() {
        return this.alwaysTensile;
    }

    public void setAlwaysTensile(boolean bl) {
        this.alwaysTensile = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class BGPainter
    implements Painter,
    Animation {
        private Motion wMotion;
        private Motion hMotion;
        private Form previousTint;
        private Painter painter;

        public BGPainter(Motion motion, Motion motion2) {
            this.wMotion = motion;
            this.hMotion = motion2;
        }

        public BGPainter() {
        }

        public BGPainter(Form form, Painter painter) {
            this.painter = painter;
        }

        public void setPreviousForm(Form form) {
            this.previousTint = form;
        }

        public Form getPreviousForm() {
            return this.previousTint;
        }

        private void drawGradientBackground(Style style, Graphics graphics, int n, int n2, int n3, int n4) {
            switch (style.getBackgroundType()) {
                case 7: {
                    graphics.fillLinearGradient(style.getBackgroundGradientStartColor(), style.getBackgroundGradientEndColor(), n, n2, n3, n4, true);
                    return;
                }
                case 6: {
                    graphics.fillLinearGradient(style.getBackgroundGradientStartColor(), style.getBackgroundGradientEndColor(), n, n2, n3, n4, false);
                    return;
                }
                case 8: {
                    graphics.fillRectRadialGradient(style.getBackgroundGradientStartColor(), style.getBackgroundGradientEndColor(), n, n2, n3, n4, style.getBackgroundGradientRelativeX(), style.getBackgroundGradientRelativeY(), style.getBackgroundGradientRelativeSize());
                    return;
                }
            }
            graphics.setColor(style.getBgColor());
            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
        }

        public void paint(Graphics graphics, Rectangle rectangle) {
            if (this.painter != null) {
                if (this.previousTint != null) {
                    this.previousTint.paint(graphics);
                }
            } else {
                Style style = Component.this.getStyle();
                int n = rectangle.getX();
                int n2 = rectangle.getY();
                int n3 = rectangle.getSize().getWidth();
                int n4 = rectangle.getSize().getHeight();
                if (n3 <= 0 || n4 <= 0) {
                    return;
                }
                Image image = style.getBgImage();
                if (image == null) {
                    if (style.getBackgroundType() >= 6) {
                        this.drawGradientBackground(style, graphics, n, n2, n3, n4);
                        return;
                    }
                    graphics.setColor(style.getBgColor());
                    graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                } else {
                    int n5 = image.getWidth();
                    int n6 = image.getHeight();
                    switch (style.getBackgroundType()) {
                        case 1: {
                            if (n5 != n3 || n6 != n4) {
                                image = image.scaled(n3, n4);
                                style.setBgImage(image, true);
                            }
                            graphics.drawImage(style.getBgImage(), n, n2);
                            return;
                        }
                        case 2: {
                            for (int i = 0; i <= n3; i += n5) {
                                for (int j = 0; j <= n4; j += n6) {
                                    graphics.drawImage(style.getBgImage(), n + i, n2 + j);
                                }
                            }
                            return;
                        }
                        case 4: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            for (int i = 0; i <= n3; i += n5) {
                                graphics.drawImage(style.getBgImage(), n + i, n2);
                            }
                            return;
                        }
                        case 29: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            for (int i = 0; i <= n3; i += n5) {
                                graphics.drawImage(style.getBgImage(), n + i, n2 + (n4 / 2 - n6 / 2));
                            }
                            return;
                        }
                        case 30: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            for (int i = 0; i <= n3; i += n5) {
                                graphics.drawImage(style.getBgImage(), n + i, n2 + (n4 - n6));
                            }
                            return;
                        }
                        case 3: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            for (int i = 0; i <= n4; i += n6) {
                                graphics.drawImage(style.getBgImage(), n, n2 + i);
                            }
                            return;
                        }
                        case 31: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            for (int i = 0; i <= n4; i += n6) {
                                graphics.drawImage(style.getBgImage(), n + (n3 / 2 - n5 / 2), n2 + i);
                            }
                            return;
                        }
                        case 32: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            for (int i = 0; i <= n4; i += n6) {
                                graphics.drawImage(style.getBgImage(), n + n3 - n5, n2 + i);
                            }
                            return;
                        }
                        case 5: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            switch (style.getBackgroundAlignment()) {
                                case -94: {
                                    graphics.drawImage(style.getBgImage(), n + n3 - n5, n2 + (n4 - n6));
                                    return;
                                }
                                case -95: {
                                    graphics.drawImage(style.getBgImage(), n + n3 - n5, n2);
                                    return;
                                }
                                case -93: {
                                    graphics.drawImage(style.getBgImage(), n, n2 + (n4 / 2 - n6 / 2));
                                    return;
                                }
                                case -92: {
                                    graphics.drawImage(style.getBgImage(), n + n3 - n5, n2 + (n4 / 2 - n6 / 2));
                                    return;
                                }
                                case -91: {
                                    graphics.drawImage(style.getBgImage(), n + (n3 / 2 - n5 / 2), n2 + (n4 / 2 - n6 / 2));
                                    return;
                                }
                            }
                            return;
                        }
                        case 20: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n + (n3 / 2 - n5 / 2), n2);
                            return;
                        }
                        case 21: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n + (n3 / 2 - n5 / 2), n2 + (n4 - n6));
                            return;
                        }
                        case 22: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n, n2 + (n4 / 2 - n6 / 2));
                            return;
                        }
                        case 23: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n + n3 - n5, n2 + (n4 / 2 - n6 / 2));
                            return;
                        }
                        case 24: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n + (n3 / 2 - n5 / 2), n2 + (n4 / 2 - n6 / 2));
                            return;
                        }
                        case 25: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n, n2);
                            return;
                        }
                        case 26: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n + n3 - n5, n2);
                            return;
                        }
                        case 27: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n, n2 + (n4 - n6));
                            return;
                        }
                        case 28: {
                            graphics.setColor(style.getBgColor());
                            graphics.fillRect(n, n2, n3, n4, style.getBgTransparency());
                            graphics.drawImage(style.getBgImage(), n + n3 - n5, n2 + (n4 - n6));
                            return;
                        }
                    }
                }
            }
        }

        public boolean animate() {
            if (this.wMotion.isFinished() && this.hMotion.isFinished()) {
                Component.this.getComponentForm().deregisterAnimated(this);
                Component.this.setPreferredSize(null);
                Component.this.getComponentForm().revalidate();
                return false;
            }
            Component.this.setPreferredSize(new Dimension(this.wMotion.getValue(), this.hMotion.getValue()));
            Component.this.getComponentForm().revalidate();
            return false;
        }

        public void paint(Graphics graphics) {
        }
    }
}

