/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.impl;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.IndexedImage;
import com.sun.lwuit.PeerComponent;
import com.sun.lwuit.VideoComponent;
import com.sun.lwuit.animations.Animation;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class LWUITImplementation {
    private static final char RTL_RANGE_BEGIN = '\u0590';
    private static final char RTL_RANGE_END = '\u07bf';
    private Hashtable linearGradientCache;
    private Hashtable radialGradientCache;
    private boolean builtinSoundEnabled = true;
    private int dragActivationCounter = 0;
    private int dragActivationX = 0;
    private int dragActivationY = 0;
    private int dragStartPercentage = 3;
    private Form currentForm;
    private static Object displayLock;
    private Animation[] paintQueue = new Animation[50];
    private Animation[] paintQueueTemp = new Animation[50];
    private int paintQueueFill = 0;
    private Graphics lwuitGraphics;
    private static boolean bidi;
    private int[] xPointerEvent = new int[1];
    private int[] yPointerEvent = new int[1];
    private int pointerPressedX;
    private int pointerPressedY;
    private Hashtable builtinSounds = new Hashtable();

    public abstract void init(Object var1);

    public void initEDT() {
    }

    public void deinitialize() {
    }

    public void playDialogSound(int n) {
    }

    public void vibrate(int n) {
    }

    public void flashBacklight(int n) {
    }

    public abstract int getDisplayWidth();

    public abstract int getDisplayHeight();

    public boolean handleEDTException(Throwable throwable) {
        return false;
    }

    public abstract void editString(Component var1, int var2, int var3, String var4);

    public void saveTextEditingState() {
    }

    public boolean hasPendingPaints() {
        return this.paintQueueFill != 0;
    }

    public Object getVideoControl(Object object) {
        return null;
    }

    public int numAlphaLevels() {
        return 255;
    }

    public int numColors() {
        return 65536;
    }

    public Graphics getComponentScreenGraphics(Component component, Graphics graphics) {
        return graphics;
    }

    protected void paintOverlay(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintDirty() {
        int n = 0;
        Object object = displayLock;
        synchronized (object) {
            n = this.paintQueueFill;
            Animation[] animationArray = this.paintQueue;
            this.paintQueue = this.paintQueueTemp;
            this.paintQueueTemp = animationArray;
            this.paintQueueFill = 0;
        }
        if (n > 0) {
            object = this.getLWUITGraphics();
            int n2 = this.getDisplayWidth();
            int n3 = this.getDisplayHeight();
            int n4 = 0;
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                Animation animation = this.paintQueueTemp[i];
                this.paintQueueTemp[i] = null;
                ((Graphics)object).translate(-((Graphics)object).getTranslateX(), -((Graphics)object).getTranslateY());
                ((Graphics)object).setClip(0, 0, this.getDisplayWidth(), this.getDisplayHeight());
                if (animation instanceof Component) {
                    Component component = (Component)animation;
                    Rectangle rectangle = component.getDirtyRegion();
                    if (rectangle != null) {
                        ((Graphics)object).setClip(rectangle.getX(), rectangle.getY(), rectangle.getSize().getWidth(), rectangle.getSize().getHeight());
                        component.setDirtyRegion(null);
                    }
                    component.paintComponent((Graphics)object);
                    int n6 = component.getAbsoluteX() + component.getScrollX();
                    n2 = Math.min(n6, n2);
                    n4 = Math.max(n6 + component.getWidth(), n4);
                    int n7 = component.getAbsoluteY() + component.getScrollY();
                    n3 = Math.min(n7, n3);
                    n5 = Math.max(n7 + component.getHeight(), n5);
                    continue;
                }
                n4 = this.getDisplayWidth();
                n5 = this.getDisplayHeight();
                n2 = 0;
                n3 = 0;
                animation.paint((Graphics)object);
            }
            this.paintOverlay((Graphics)object);
            this.flushGraphics(n2, n3, n4 - n2, n5 - n3);
        }
    }

    public void edtIdle(boolean bl) {
    }

    public abstract void flushGraphics(int var1, int var2, int var3, int var4);

    public abstract void flushGraphics();

    protected Graphics getLWUITGraphics() {
        return this.lwuitGraphics;
    }

    public void setLWUITGraphics(Graphics graphics) {
        this.lwuitGraphics = graphics;
    }

    public void setDisplayLock(Object object) {
        displayLock = object;
    }

    public Object getDisplayLock() {
        return displayLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(Animation animation) {
        Object object = displayLock;
        synchronized (object) {
            for (int i = 0; i < this.paintQueueFill; ++i) {
                Animation animation2 = this.paintQueue[i];
                if (animation2 != animation) continue;
                return;
            }
            if (this.paintQueueFill >= this.paintQueue.length) {
                System.out.println("Warning paint queue size exceeded, please watch the amount of repaint calls");
                return;
            }
            this.paintQueue[this.paintQueueFill] = animation;
            ++this.paintQueueFill;
            displayLock.notify();
        }
    }

    public abstract void getRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7);

    public abstract Object createImage(int[] var1, int var2, int var3);

    public abstract Object createImage(String var1) throws IOException;

    public abstract Object createImage(InputStream var1) throws IOException;

    public abstract Object createMutableImage(int var1, int var2, int var3);

    public boolean isAlphaMutableImageSupported() {
        return false;
    }

    public abstract Object createImage(byte[] var1, int var2, int var3);

    public abstract int getImageWidth(Object var1);

    public abstract int getImageHeight(Object var1);

    public abstract Object scale(Object var1, int var2, int var3);

    private static int round(double d) {
        double d2 = Math.floor(d);
        double d3 = Math.ceil(d);
        if (d3 - d < d - d2) {
            return (int)d3;
        }
        return (int)d2;
    }

    public Object rotate(Object object, int n) {
        int n2 = this.getImageWidth(object);
        int n3 = this.getImageHeight(object);
        int[] nArray = new int[n2 * n3];
        int[] nArray2 = new int[nArray.length];
        this.getRGB(object, nArray, 0, 0, 0, n2, n3);
        int n4 = n2 / 2;
        int n5 = n3 / 2;
        double d = Math.toRadians(-n);
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6;
                int n7 = LWUITImplementation.round(d2 * (double)(i - n4) - d3 * (double)(j - n5) + (double)n4);
                int n8 = LWUITImplementation.round(d3 * (double)(i - n4) + d2 * (double)(j - n5) + (double)n5);
                if (n7 < 0 || n8 < 0 || n7 >= n2 || n8 >= n3 || (n6 = n7 + n8 * n2) < 0 || n6 >= nArray2.length) continue;
                nArray2[i + j * n2] = nArray[n6];
            }
        }
        return this.createImage(nArray2, n2, n3);
    }

    public abstract int getSoftkeyCount();

    public abstract int[] getSoftkeyCode(int var1);

    public abstract int getClearKeyCode();

    public abstract int getBackspaceKeyCode();

    public abstract int getBackKeyCode();

    public abstract int getGameAction(int var1);

    public abstract int getKeyCode(int var1);

    public abstract boolean isTouchDevice();

    public void setCurrentForm(Form form) {
        this.currentForm = form;
    }

    public void confirmControlView() {
    }

    public Form getCurrentForm() {
        return this.currentForm;
    }

    public boolean isTranslationSupported() {
        return false;
    }

    public void translate(Object object, int n, int n2) {
    }

    public int getTranslateX(Object object) {
        return 0;
    }

    public int getTranslateY(Object object) {
        return 0;
    }

    public abstract int getColor(Object var1);

    public abstract void setColor(Object var1, int var2);

    public abstract void setAlpha(Object var1, int var2);

    public abstract int getAlpha(Object var1);

    public boolean isAlphaGlobal() {
        return false;
    }

    public boolean isAntiAliasingSupported() {
        return false;
    }

    public boolean isAntiAliasedTextSupported() {
        return false;
    }

    public void setAntiAliased(Object object, boolean bl) {
    }

    public boolean isAntiAliased(Object object) {
        return false;
    }

    public void setAntiAliasedText(Object object, boolean bl) {
    }

    public boolean isAntiAliasedText(Object object) {
        return false;
    }

    public abstract void setNativeFont(Object var1, Object var2);

    public Rectangle getClipRect(Object object) {
        return new Rectangle(this.getClipX(object), this.getClipY(object), new Dimension(this.getClipWidth(object), this.getClipHeight(object)));
    }

    public abstract int getClipX(Object var1);

    public abstract int getClipY(Object var1);

    public abstract int getClipWidth(Object var1);

    public abstract int getClipHeight(Object var1);

    public void setClipRect(Object object, Rectangle rectangle) {
        Dimension dimension = rectangle.getSize();
        this.setClip(object, rectangle.getX(), rectangle.getY(), dimension.getWidth(), dimension.getHeight());
    }

    public abstract void setClip(Object var1, int var2, int var3, int var4, int var5);

    public void clipRect(Object object, Rectangle rectangle) {
        Dimension dimension = rectangle.getSize();
        this.clipRect(object, rectangle.getX(), rectangle.getY(), dimension.getWidth(), dimension.getHeight());
    }

    public abstract void clipRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawLine(Object var1, int var2, int var3, int var4, int var5);

    public abstract void fillRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawRect(Object var1, int var2, int var3, int var4, int var5);

    public abstract void drawRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillRoundRect(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void fillArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawArc(Object var1, int var2, int var3, int var4, int var5, int var6, int var7);

    public abstract void drawString(Object var1, String var2, int var3, int var4);

    public abstract void drawImage(Object var1, Object var2, int var3, int var4);

    public void drawImageArea(Object object, Object object2, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = this.getClipX(object);
        int n8 = this.getClipY(object);
        int n9 = this.getClipWidth(object);
        int n10 = this.getClipHeight(object);
        this.clipRect(object, n, n2, n5, n6);
        if (this.getClipWidth(object) > 0 && this.getClipHeight(object) > 0) {
            this.drawImage(object, object2, n - n3, n2 - n4);
        }
        this.setClip(object, n7, n8, n9, n10);
    }

    public void drawImageRotated(Object object, Object object2, int n, int n2, int n3) {
    }

    public boolean isRotationDrawingSupported() {
        return false;
    }

    public void fillTriangle(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillPolygon(object, new int[]{n, n3, n5}, new int[]{n2, n4, n6}, 3);
    }

    public abstract void drawRGB(Object var1, int[] var2, int var3, int var4, int var5, int var6, int var7, boolean var8);

    public abstract Object getNativeGraphics();

    public abstract Object getNativeGraphics(Object var1);

    public abstract int charsWidth(Object var1, char[] var2, int var3, int var4);

    public abstract int stringWidth(Object var1, String var2);

    public abstract int charWidth(Object var1, char var2);

    public abstract int getHeight(Object var1);

    public abstract Object getDefaultFont();

    public int getFace(Object object) {
        return 0;
    }

    public int getSize(Object object) {
        return 0;
    }

    public int getStyle(Object object) {
        return 0;
    }

    public abstract Object createFont(int var1, int var2, int var3);

    protected void keyPressed(int n) {
        Display.getInstance().keyPressed(n);
    }

    protected void keyReleased(int n) {
        Display.getInstance().keyReleased(n);
    }

    protected void pointerDragged(int n, int n2) {
        this.xPointerEvent[0] = n;
        this.yPointerEvent[0] = n2;
        this.pointerDragged(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerPressed(int n, int n2) {
        this.xPointerEvent[0] = n;
        this.yPointerEvent[0] = n2;
        this.pointerPressed(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerReleased(int n, int n2) {
        this.xPointerEvent[0] = n;
        this.yPointerEvent[0] = n2;
        this.pointerReleased(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHover(int[] nArray, int[] nArray2) {
        Display.getInstance().pointerHover(nArray, nArray2);
    }

    protected void pointerHoverReleased(int[] nArray, int[] nArray2) {
        Display.getInstance().pointerHoverReleased(nArray, nArray2);
    }

    protected void pointerHoverReleased(int n, int n2) {
        this.xPointerEvent[0] = n;
        this.yPointerEvent[0] = n2;
        this.pointerHoverReleased(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHoverPressed(int[] nArray, int[] nArray2) {
        Display.getInstance().pointerHoverPressed(nArray, nArray2);
    }

    protected void pointerHoverPressed(int n, int n2) {
        this.xPointerEvent[0] = n;
        this.yPointerEvent[0] = n2;
        this.pointerHoverPressed(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerHover(int n, int n2) {
        this.xPointerEvent[0] = n;
        this.yPointerEvent[0] = n2;
        this.pointerHover(this.xPointerEvent, this.yPointerEvent);
    }

    protected void pointerDragged(int[] nArray, int[] nArray2) {
        if (this.hasDragStarted(nArray, nArray2)) {
            Display.getInstance().pointerDragged(nArray, nArray2);
        }
    }

    protected boolean hasDragStarted(int[] nArray, int[] nArray2) {
        return this.hasDragStarted(nArray[0], nArray2[0]);
    }

    protected boolean hasDragStarted(int n, int n2) {
        if (this.dragActivationCounter == 0) {
            this.dragActivationX = n;
            this.dragActivationY = n2;
            ++this.dragActivationCounter;
            return false;
        }
        ++this.dragActivationCounter;
        if (this.dragActivationCounter > this.getDragAutoActivationThreshold()) {
            return true;
        }
        if ((float)this.getDisplayWidth() / 100.0f * (float)this.getDragStartPercentage() <= (float)Math.abs(this.dragActivationX - n)) {
            this.dragActivationCounter = this.getDragAutoActivationThreshold() + 1;
            return true;
        }
        if ((float)this.getDisplayHeight() / 100.0f * (float)this.getDragStartPercentage() <= (float)Math.abs(this.dragActivationY - n2)) {
            this.dragActivationCounter = this.getDragAutoActivationThreshold() + 1;
            return true;
        }
        return false;
    }

    public int getDragStartPercentage() {
        return this.dragStartPercentage;
    }

    public void setDragStartPercentage(int n) {
        this.dragStartPercentage = n;
    }

    protected int getDragAutoActivationThreshold() {
        return 7;
    }

    protected void pointerPressed(int[] nArray, int[] nArray2) {
        this.pointerPressedX = nArray[0];
        this.pointerPressedY = nArray2[0];
        Display.getInstance().pointerPressed(nArray, nArray2);
    }

    protected void pointerReleased(int[] nArray, int[] nArray2) {
        if (this.dragActivationCounter == 0 && nArray[0] != this.pointerPressedX && nArray2[0] != this.pointerPressedY) {
            this.hasDragStarted(this.pointerPressedX, this.pointerPressedY);
            if (this.hasDragStarted(nArray, nArray2)) {
                this.pointerDragged(this.pointerPressedX, this.pointerPressedY);
                this.pointerDragged(nArray, nArray2);
            }
        }
        this.dragActivationCounter = 0;
        Display.getInstance().pointerReleased(nArray, nArray2);
    }

    protected void sizeChanged(int n, int n2) {
        Display.getInstance().sizeChanged(n, n2);
    }

    protected void hideNotify() {
        Display.getInstance().hideNotify();
    }

    protected void showNotify() {
        Display.getInstance().showNotify();
    }

    private Object findCachedGradient(Hashtable hashtable, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, int n7, int n8, int n9) {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                int[] nArray = (int[])enumeration.nextElement();
                Object v = hashtable.get(nArray);
                if (v == null) {
                    hashtable.remove(nArray);
                    enumeration = hashtable.keys();
                    continue;
                }
                Object object = this.extractHardRef(v);
                if (object == null) {
                    hashtable.remove(nArray);
                    enumeration = hashtable.keys();
                    continue;
                }
                if (nArray[0] != n || nArray[1] != n2 || nArray[2] != n3 || nArray[3] != n4 || nArray[5] != n7 || nArray[6] != n8 || nArray[7] != n9 || this.getImageWidth(object) != n5 || this.getImageHeight(object) != n6 || (!bl || nArray[4] != 1) && (bl || nArray[4] != 0)) continue;
                return object;
            }
        }
        return null;
    }

    private void storeCachedGradient(Object object, Hashtable hashtable, int n, int n2, int n3, int n4, boolean bl, int n5, int n6, int n7) {
        int[] nArray = bl ? new int[]{n, n2, n3, n4, 1, n5, n6, n7} : new int[]{n, n2, n3, n4, 0, n5, n6, n7};
        hashtable.put(nArray, this.createSoftWeakRef(object));
    }

    public void fillRectRadialGradient(Object object, int n, int n2, int n3, int n4, int n5, int n6, float f, float f2, float f3) {
        int n7 = (int)((float)n5 * (1.0f - f));
        int n8 = (int)((float)n6 * (1.0f - f2));
        int n9 = (int)((float)Math.min(n5, n6) * f3);
        int n10 = (int)((float)(n5 / 2) - (float)n9 * f);
        int n11 = (int)((float)(n6 / 2) - (float)n9 * f2);
        boolean bl = this.isAntiAliased(object);
        this.setAntiAliased(object, false);
        if (this.cacheRadialGradients()) {
            Object object2 = this.findCachedGradient(this.radialGradientCache, n, n2, n3, n4, n5, n6, true, n7, n8, n9);
            if (object2 != null) {
                this.drawImage(object, object2, n3, n4);
            } else {
                object2 = this.createMutableImage(n5, n6, -1);
                Object object3 = this.getNativeGraphics(object2);
                this.setColor(object3, n2);
                this.fillRect(object3, 0, 0, n5, n6);
                this.fillRadialGradientImpl(object3, n, n2, n10, n11, n9, n9);
                this.drawImage(object, object2, n3, n4);
                if (this.radialGradientCache == null) {
                    this.radialGradientCache = new Hashtable();
                }
                this.storeCachedGradient(object2, this.radialGradientCache, n, n2, n3, n4, true, n7, n8, n9);
            }
        } else {
            this.setColor(object, n2);
            this.fillRect(object, n3, n4, n5, n6);
            this.fillRadialGradientImpl(object, n, n2, n3 + n10, n4 + n11, n9, n9);
        }
        if (bl) {
            this.setAntiAliased(object, true);
        }
    }

    public void fillRadialGradient(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRadialGradientImpl(object, n, n2, n3, n4, n5, n6);
    }

    private void fillRadialGradientImpl(Object object, int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = this.isAntiAliased(object);
        this.setAntiAliased(object, false);
        int n7 = n >> 16 & 0xFF;
        int n8 = n >> 8 & 0xFF;
        int n9 = n & 0xFF;
        int n10 = n2 >> 16 & 0xFF;
        int n11 = n2 >> 8 & 0xFF;
        int n12 = n2 & 0xFF;
        int n13 = this.getColor(object);
        int n14 = n6;
        while (n5 > 0 && n6 > 0) {
            this.updateGradientColor(object, n7, n8, n9, n10, n11, n12, n14, n6);
            this.fillArc(object, n3, n4, n5, n6, 0, 360);
            ++n3;
            ++n4;
            n5 -= 2;
            n6 -= 2;
        }
        this.setColor(object, n13);
        if (bl) {
            this.setAntiAliased(object, true);
        }
    }

    private void updateGradientColor(Object object, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = this.calculateGraidentChannel(n, n4, n7, n8);
        int n10 = this.calculateGraidentChannel(n2, n5, n7, n8);
        int n11 = this.calculateGraidentChannel(n3, n6, n7, n8);
        int n12 = n9 << 16 & 0xFF0000 | n10 << 8 & 0xFF00 | n11 & 0xFF;
        this.setColor(object, n12);
    }

    private int calculateGraidentChannel(int n, int n2, int n3, int n4) {
        if (n == n2) {
            return n;
        }
        float f = (float)n4 / (float)n3;
        int n5 = (int)((float)Math.abs(n - n2) * f);
        if (n > n2) {
            return n - n5;
        }
        return n + n5;
    }

    public void fillLinearGradient(Object object, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        boolean bl2 = this.isAntiAliased(object);
        this.setAntiAliased(object, false);
        if (this.cacheLinearGradients()) {
            Object object2 = this.findCachedGradient(this.linearGradientCache, n, n2, n3, n4, n5, n6, bl, 0, 0, 0);
            if (object2 != null) {
                this.drawImage(object, object2, n3, n4);
            } else {
                object2 = this.createMutableImage(n5, n6, -1);
                this.fillLinearGradientImpl(this.getNativeGraphics(object2), n, n2, 0, 0, n5, n6, bl);
                this.drawImage(object, object2, n3, n4);
                if (this.linearGradientCache == null) {
                    this.linearGradientCache = new Hashtable();
                }
                this.storeCachedGradient(object2, this.linearGradientCache, n, n2, n3, n4, bl, 0, 0, 0);
            }
        } else {
            this.fillLinearGradientImpl(object, n, n2, n3, n4, n5, n6, bl);
        }
        if (bl2) {
            this.setAntiAliased(object, true);
        }
    }

    private void fillLinearGradientImpl(Object object, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        int n7 = n >> 16 & 0xFF;
        int n8 = n >> 8 & 0xFF;
        int n9 = n & 0xFF;
        int n10 = n2 >> 16 & 0xFF;
        int n11 = n2 >> 8 & 0xFF;
        int n12 = n2 & 0xFF;
        int n13 = this.getColor(object);
        if (bl) {
            for (int i = 0; i < n5; ++i) {
                this.updateGradientColor(object, n7, n8, n9, n10, n11, n12, n5, i);
                this.drawLine(object, n3 + i, n4, n3 + i, n4 + n6);
            }
        } else {
            for (int i = 0; i < n6; ++i) {
                this.updateGradientColor(object, n7, n8, n9, n10, n11, n12, n6, i);
                this.drawLine(object, n3, n4 + i, n3 + n5, n4 + i);
            }
        }
        this.setColor(object, n13);
    }

    private boolean checkIntersection(Object object, int n, int n2, int n3, int n4, int n5, int[] nArray, int n6) {
        if (n > n4 && n < n5 || n > n5 && n < n4) {
            if (n4 == n5) {
                this.drawLine(object, n2, n, n3, n);
                return false;
            }
            nArray[n6] = n2 + (n - n4) * (n3 - n2) / (n5 - n4);
            return true;
        }
        return false;
    }

    private int markIntersectionEdge(Object object, int n, int[] nArray, int[] nArray2, int n2, int[] nArray3, int n3) {
        nArray3[n3] = nArray2[n];
        if ((nArray[n] - nArray[(n + 1) % n2]) * (nArray[n] - nArray[(n + n2 - 1) % n2]) > 0) {
            nArray3[n3 + 1] = nArray2[n];
            return 2;
        }
        if (nArray[n] == nArray[(n + 1) % n2]) {
            this.drawLine(object, nArray2[n], nArray[n], nArray2[(n + 1) % n2], nArray[(n + 1) % n2]);
            if ((nArray[(n + 1) % n2] - nArray[(n + 2) % n2]) * (nArray[n] - nArray[(n + n2 - 1) % n2]) > 0) {
                return 1;
            }
            nArray3[n3 + 1] = nArray2[n];
            return 2;
        }
        return 1;
    }

    public void fillPolygon(Object object, int[] nArray, int[] nArray2, int n) {
        int n2;
        int[] nArray3 = new int[n];
        int n3 = 0;
        int n4 = nArray2[0];
        int n5 = nArray2[0];
        for (n2 = 0; n2 < n; ++n2) {
            n4 = Math.max(n4, nArray2[n2]);
            n5 = Math.min(n5, nArray2[n2]);
        }
        for (n2 = n5; n2 <= n4; ++n2) {
            int n6;
            int n7;
            n3 = 0;
            for (n7 = 1; n7 < n; ++n7) {
                if (!this.checkIntersection(object, n2, nArray[n7 - 1], nArray[n7], nArray2[n7 - 1], nArray2[n7], nArray3, n3)) continue;
                ++n3;
            }
            if (this.checkIntersection(object, n2, nArray[n - 1], nArray[0], nArray2[n - 1], nArray2[0], nArray3, n3)) {
                ++n3;
            }
            for (n7 = 0; n7 < n; ++n7) {
                if (n2 != nArray2[n7]) continue;
                n3 += this.markIntersectionEdge(object, n7, nArray2, nArray, n, nArray3, n3);
            }
            n7 = 0;
            for (n6 = 0; n6 < n3; ++n6) {
                for (int i = n6; i < n3; ++i) {
                    if (nArray3[i] >= nArray3[n6]) continue;
                    n7 = nArray3[n6];
                    nArray3[n6] = nArray3[i];
                    nArray3[i] = n7;
                }
            }
            for (n6 = 1; n6 < n3; n6 += 2) {
                this.drawLine(object, nArray3[n6 - 1], n2, nArray3[n6], n2);
            }
        }
    }

    public void drawPolygon(Object object, int[] nArray, int[] nArray2, int n) {
        for (int i = 1; i < n; ++i) {
            this.drawLine(object, nArray[i - 1], nArray2[i - 1], nArray[i], nArray2[i]);
        }
        this.drawLine(object, nArray[n - 1], nArray2[n - 1], nArray[0], nArray2[0]);
    }

    public int getKeyboardType() {
        return 0;
    }

    public boolean isNativeInputSupported() {
        return false;
    }

    public boolean isMultiTouch() {
        return false;
    }

    public boolean isClickTouchScreen() {
        return false;
    }

    public boolean isNativeIndexed() {
        return false;
    }

    public Object createNativeIndexed(IndexedImage indexedImage) {
        return null;
    }

    public Object createVideoComponent(Object object) {
        return null;
    }

    public int getVideoWidth(Object object) {
        return 0;
    }

    public int getVideoHeight(Object object) {
        return 0;
    }

    public void setVideoVisible(Object object, boolean bl) {
    }

    public void startVideo(Object object, Object object2) {
    }

    public void stopVideo(Object object, Object object2) {
    }

    public void setVideoLoopCount(Object object, int n) {
    }

    public long getMediaTime(Object object) {
        return 0L;
    }

    public long setMediaTime(Object object, long l) {
        return 0L;
    }

    public void setVideoFullScreen(Object object, boolean bl) {
    }

    public void paintVideo(Component component, boolean bl, Object object, Object object2, Object object3) {
    }

    public boolean isOpaque(Image image, Object object) {
        int[] nArray = image.getRGBCached();
        for (int i = 0; i < nArray.length; ++i) {
            if ((nArray[i] & 0xFF000000) == -16777216) continue;
            return false;
        }
        return true;
    }

    public boolean isAffineSupported() {
        return false;
    }

    public void resetAffine(Object object) {
        System.out.println("Affine unsupported");
    }

    public void scale(Object object, float f, float f2) {
        System.out.println("Affine unsupported");
    }

    public void rotate(Object object, float f) {
        System.out.println("Affine unsupported");
    }

    public void shear(Object object, float f, float f2) {
        System.out.println("Affine unsupported");
    }

    public boolean isSVGSupported() {
        return false;
    }

    public Object createSVGImage(String string, byte[] byArray) throws IOException {
        throw new IOException("SVG is not supported by this implementation");
    }

    public Object getSVGDocument(Object object) {
        throw new RuntimeException("SVG is not supported by this implementation");
    }

    public boolean animateImage(Object object, long l) {
        return false;
    }

    public String[] getFontPlatformNames() {
        return new String[]{"MIDP", "MIDP2"};
    }

    public Object loadTrueTypeFont(InputStream inputStream) throws IOException {
        throw new IOException("Unsupported operation");
    }

    public boolean isTrueTypeSupported() {
        return false;
    }

    public Object loadNativeFont(String string) {
        return null;
    }

    public boolean isLookupFontSupported() {
        return false;
    }

    public boolean minimizeApplication() {
        return false;
    }

    public void restoreMinimizedApplication() {
    }

    public boolean isMinimized() {
        return false;
    }

    protected boolean cacheRadialGradients() {
        return true;
    }

    protected boolean cacheLinearGradients() {
        return true;
    }

    public boolean isThirdSoftButton() {
        return false;
    }

    public int getDragPathLength() {
        return 10;
    }

    public int getDragPathTime() {
        return 200;
    }

    public float getDragSpeed(float[] fArray, long[] lArray, int n, int n2) {
        long l = System.currentTimeMillis();
        long l2 = l - (long)this.getDragPathTime();
        int n3 = n - n2;
        if (n3 < 0) {
            n3 = this.getDragPathLength() + n3;
        }
        long l3 = 0L;
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = n2;
        while (n2 > 0) {
            if (lArray[n3] > l2) {
                if (l3 == 0L) {
                    l3 = lArray[n3];
                    f = fArray[n3];
                }
                long l4 = l - l3;
                float f4 = fArray[n3] - f;
                if (l4 > 0L) {
                    float f5 = f4 / (float)l4 * 1.5f;
                    f2 += f5;
                }
            }
            --n2;
            if (++n3 < this.getDragPathLength()) continue;
            n3 = 0;
        }
        f3 = Math.max(1.0f, f3);
        return -f2 / f3;
    }

    public boolean isBidiAlgorithm() {
        return bidi;
    }

    public void setBidiAlgorithm(boolean bl) {
        bidi = bl;
    }

    public String convertBidiLogicalToVisual(String string) {
        if (bidi && string.length() >= 2) {
            char[] cArray = string.toCharArray();
            this.swapBidiChars(cArray, 0, string.length(), -1);
            return new String(cArray);
        }
        return string;
    }

    public int getCharLocation(String string, int n) {
        if (bidi) {
            return this.swapBidiChars(string.toCharArray(), 0, string.length(), n);
        }
        return n;
    }

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\n' || c == '\t' || c == '\n' || c == '\r';
    }

    public boolean isRTLOrWhitespace(char c) {
        if (bidi) {
            return this.isRTL(c) || this.isWhitespace(c);
        }
        return false;
    }

    public boolean isRTL(char c) {
        return c >= '\u0590' && c <= '\u07bf';
    }

    private final int swapBidiChars(char[] cArray, int n, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7 = -1;
        int n8 = n + n2;
        int n9 = n6 = n;
        boolean bl = false;
        for (n5 = n; n5 < n8; ++n5) {
            if (!this.isRTL(cArray[n5])) continue;
            bl = true;
            break;
        }
        if (bl) {
            while (n9 < n8 && (n6 = this.scanSecond(cArray, n9, n8)) >= 0) {
                n9 = n6;
                n6 = this.scanBackFirst(cArray, n9, n8);
                n5 = n9;
                for (n4 = n6 - 1; n5 < n4; ++n5, --n4) {
                    char c = cArray[n5];
                    cArray[n5] = cArray[n4];
                    cArray[n4] = c;
                    if (n3 != n4) continue;
                    n7 = n5;
                    n3 = n5;
                }
                n9 = n6;
            }
        }
        if (bl) {
            n9 = n;
            for (n6 = n8 - 1; n9 <= n6; ++n9, --n6) {
                n5 = cArray[n9];
                cArray[n9] = n4 = cArray[n6];
                cArray[n6] = n5;
                if (n3 == n9) {
                    n7 = n6;
                    continue;
                }
                if (n3 != n6) continue;
                n7 = n9;
            }
        }
        return n7;
    }

    private boolean isRTLBreak(char c) {
        return c == ')' || c == ']' || c == '}' || c == '(' || c == '[' || c == '{';
    }

    private boolean isLTR(char c) {
        return !this.isRTL(c) && !this.isRTLBreak(c);
    }

    private final int scanSecond(char[] cArray, int n, int n2) {
        int n3 = -1;
        for (int i = n; n3 < 0 && i < n2; ++i) {
            if (this.isRTLOrWhitespace(cArray[i])) continue;
            n3 = i;
        }
        return n3;
    }

    private final int scanBackFirst(char[] cArray, int n, int n2) {
        int n3;
        int n4 = n2;
        for (n3 = n + 1; n3 < n2; ++n3) {
            if (!this.isRTL(cArray[n3]) && !this.isRTLBreak(cArray[n3])) continue;
            n4 = n3;
            break;
        }
        for (n3 = n4 - 1; n3 >= n; --n3) {
            if (!this.isLTR(cArray[n3]) || this.isWhitespace(cArray[n3])) continue;
            n4 = n3 + 1;
            break;
        }
        return n4;
    }

    public InputStream getResourceAsStream(Class clazz, String string) {
        return clazz.getResourceAsStream(string);
    }

    public boolean isAnimation(Object object) {
        return false;
    }

    public PeerComponent createNativePeer(Object object) {
        throw new IllegalArgumentException(object.getClass().getName());
    }

    public VideoComponent createVideoPeer(String string) throws IOException {
        throw new IllegalArgumentException("not supported");
    }

    public VideoComponent createVideoPeer(InputStream inputStream, String string) throws IOException {
        throw new IllegalArgumentException("not supported");
    }

    public void setVideoFullScreen(VideoComponent videoComponent, boolean bl) {
    }

    public void showNativeScreen(Object object) {
    }

    public void setNativeCommands(Vector vector) {
    }

    public void exitApplication() {
    }

    public String getProperty(String string, String string2) {
        return string2;
    }

    public void execute(String string) {
    }

    public int getDeviceDensity() {
        int n = this.getDisplayHeight() * this.getDisplayWidth();
        if (n <= 38720) {
            return 10;
        }
        if (n <= 76800) {
            return 20;
        }
        if (n <= 172800) {
            return 30;
        }
        if (n <= 409920) {
            return 40;
        }
        if (n <= 1036800) {
            return 50;
        }
        return 60;
    }

    public void playBuiltinSound(String string) {
        this.playUserSound(string);
    }

    protected boolean playUserSound(String string) {
        Object v = this.builtinSounds.get(string);
        if (v == null) {
            return false;
        }
        this.playAudio(v);
        return true;
    }

    protected void playNativeBuiltinSound(Object object) {
    }

    protected Object convertBuiltinSound(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n > -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public void installBuiltinSound(String string, InputStream inputStream) throws IOException {
        this.builtinSounds.put(string, this.convertBuiltinSound(inputStream));
    }

    public boolean isBuiltinSoundAvailable(String string) {
        return this.builtinSounds.containsKey(string);
    }

    public void setBuiltinSoundsEnabled(boolean bl) {
        this.builtinSoundEnabled = bl;
    }

    public boolean isBuiltinSoundsEnabled() {
        return this.builtinSoundEnabled;
    }

    public Object createAudio(String string, Runnable runnable) throws IOException {
        return null;
    }

    public Object createAudio(InputStream inputStream, String string, Runnable runnable) throws IOException {
        return null;
    }

    public void playAudio(Object object) {
    }

    public void pauseAudio(Object object) {
    }

    public int getAudioTime(Object object) {
        return -1;
    }

    public void setAudioTime(Object object, int n) {
    }

    public int getAudioDuration(Object object) {
        return -1;
    }

    public void cleanupAudio(Object object) {
    }

    public void setVolume(int n) {
    }

    public int getVolume() {
        return -1;
    }

    public Object createSoftWeakRef(Object object) {
        return new WeakReference<Object>(object);
    }

    public Object extractHardRef(Object object) {
        WeakReference weakReference = (WeakReference)object;
        if (weakReference != null) {
            return weakReference.get();
        }
        return null;
    }

    public void notifyCommandBehavior(int n) {
    }

    public boolean hasNativeTheme() {
        return false;
    }

    public void installNativeTheme() {
        throw new RuntimeException();
    }
}

