/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.layouts;

import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Display;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.Layout;
import com.sun.lwuit.plaf.Style;
import java.util.Hashtable;

public class BorderLayout
extends Layout {
    public static final int CENTER_BEHAVIOR_SCALE = 0;
    public static final int CENTER_BEHAVIOR_CENTER = 1;
    public static final int CENTER_BEHAVIOR_CENTER_ABSOLUTE = 2;
    private Component portaraitNorth;
    private Component portaraitSouth;
    private Component portaraitCenter;
    private Component portaraitWest;
    private Component portaraitEast;
    private Hashtable landscapeSwap;
    private int centerBehavior;
    public static final String NORTH = "North";
    public static final String SOUTH = "South";
    public static final String CENTER = "Center";
    public static final String WEST = "West";
    public static final String EAST = "East";

    public void addLayoutComponent(Object object, Component component, Container container) {
        if (object == null) {
            throw new IllegalArgumentException("Cannot add component to BorderLayout Container without constraint parameter");
        }
        Component component2 = null;
        if (CENTER.equals(object)) {
            component2 = this.portaraitCenter;
            this.portaraitCenter = component;
        } else if (NORTH.equals(object)) {
            component2 = this.portaraitNorth;
            this.portaraitNorth = component;
        } else if (SOUTH.equals(object)) {
            component2 = this.portaraitSouth;
            this.portaraitSouth = component;
        } else if (EAST.equals(object)) {
            component2 = this.portaraitEast;
            this.portaraitEast = component;
        } else if (WEST.equals(object)) {
            component2 = this.portaraitWest;
            this.portaraitWest = component;
        } else {
            throw new IllegalArgumentException("cannot add to layout: unknown constraint: " + object);
        }
        if (component2 != null && component2 != component) {
            container.removeComponent(component2);
        }
    }

    public void removeLayoutComponent(Component component) {
        if (component == this.portaraitCenter) {
            this.portaraitCenter = null;
        } else if (component == this.portaraitNorth) {
            this.portaraitNorth = null;
        } else if (component == this.portaraitSouth) {
            this.portaraitSouth = null;
        } else if (component == this.portaraitEast) {
            this.portaraitEast = null;
        } else if (component == this.portaraitWest) {
            this.portaraitWest = null;
        }
    }

    public Object getComponentConstraint(Component component) {
        if (component == this.portaraitCenter) {
            return CENTER;
        }
        if (component == this.portaraitNorth) {
            return NORTH;
        }
        if (component == this.portaraitSouth) {
            return SOUTH;
        }
        if (component == this.portaraitEast) {
            return EAST;
        }
        if (component == this.portaraitWest) {
            return WEST;
        }
        return null;
    }

    public void layoutContainer(Container container) {
        Component component;
        Component component2;
        Style style = container.getStyle();
        int n = style.getPadding(false, 0);
        int n2 = container.getLayoutHeight() - container.getBottomGap() - style.getPadding(false, 2);
        int n3 = style.getPadding(container.isRTL(), 1);
        int n4 = container.getLayoutWidth() - container.getSideGap() - style.getPadding(container.isRTL(), 3);
        int n5 = container.getWidth();
        int n6 = container.getHeight();
        boolean bl = container.isRTL();
        if (bl) {
            n3 += container.getSideGap();
        }
        Component component3 = this.getEast();
        Component component4 = this.getWest();
        Component component5 = this.getSouth();
        Component component6 = this.getNorth();
        Component component7 = this.getCenter();
        if (component6 != null) {
            component2 = component6;
            this.positionTopBottom(container, component2, n4, n3, n6);
            component2.setY(n + component2.getStyle().getMargin(false, 0));
            n += component2.getHeight() + component2.getStyle().getMargin(false, 0) + component2.getStyle().getMargin(false, 2);
        }
        if (component5 != null) {
            component2 = component5;
            this.positionTopBottom(container, component2, n4, n3, n6);
            component2.setY(n2 - component2.getHeight() - component2.getStyle().getMargin(false, 2));
            n2 -= component2.getHeight() + component2.getStyle().getMargin(false, 0) + component2.getStyle().getMargin(false, 2);
        }
        component2 = component3;
        Component component8 = component4;
        if (bl) {
            component2 = component4;
            component8 = component3;
        }
        if (component2 != null) {
            component = component2;
            this.positionLeftRight(component2, n5, n2, n);
            component.setX(n4 - component.getWidth() - component.getStyle().getMargin(container.isRTL(), 3));
            n4 -= component.getWidth() + component.getStyle().getMargin(false, 1) + component.getStyle().getMargin(false, 3);
        }
        if (component8 != null) {
            component = component8;
            this.positionLeftRight(component8, n5, n2, n);
            component.setX(n3 + component.getStyle().getMargin(container.isRTL(), 1));
            n3 += component.getWidth() + component.getStyle().getMargin(false, 1) + component.getStyle().getMargin(false, 3);
        }
        if (component7 != null) {
            component = component7;
            int n7 = n4 - n3 - component.getStyle().getMargin(false, 1) - component.getStyle().getMargin(false, 3);
            int n8 = n2 - n - component.getStyle().getMargin(false, 0) - component.getStyle().getMargin(false, 2);
            int n9 = n3 + component.getStyle().getMargin(container.isRTL(), 1);
            int n10 = n + component.getStyle().getMargin(false, 0);
            switch (this.centerBehavior) {
                case 2: {
                    int n11;
                    Dimension dimension = component.getPreferredSize();
                    if (dimension.getWidth() < n7) {
                        n11 = n5 / 2 - dimension.getWidth() / 2;
                        if (n11 > n9) {
                            n9 = n11;
                        }
                        n7 = dimension.getWidth();
                    }
                    if (dimension.getHeight() >= n8) break;
                    n11 = n6 / 2 - dimension.getHeight() / 2;
                    if (n11 > n10) {
                        n10 = n11;
                    }
                    n8 = dimension.getHeight();
                    break;
                }
                case 1: {
                    Dimension dimension = component.getPreferredSize();
                    if (dimension.getWidth() < n7) {
                        n9 += n7 / 2 - dimension.getWidth() / 2;
                        n7 = dimension.getWidth();
                    }
                    if (dimension.getHeight() >= n8) break;
                    n10 += n8 / 2 - dimension.getHeight() / 2;
                    n8 = dimension.getHeight();
                }
            }
            component.setWidth(n7);
            component.setHeight(n8);
            component.setX(n9);
            component.setY(n10);
        }
    }

    private void positionLeftRight(Component component, int n, int n2, int n3) {
        component.setWidth(Math.min(n, component.getPreferredW()));
        component.setHeight(n2 - n3 - component.getStyle().getMargin(false, 0) - component.getStyle().getMargin(false, 2));
        component.setY(n3 + component.getStyle().getMargin(false, 0));
    }

    private void positionTopBottom(Component component, Component component2, int n, int n2, int n3) {
        component2.setWidth(n - n2 - component2.getStyle().getMargin(false, 1) - component2.getStyle().getMargin(false, 3));
        component2.setHeight(Math.min(n3, component2.getPreferredH()));
        component2.setX(n2 + component2.getStyle().getMargin(component.isRTL(), 1));
    }

    public Dimension getPreferredSize(Container container) {
        Dimension dimension = new Dimension(0, 0);
        Component component = this.getEast();
        Component component2 = this.getWest();
        Component component3 = this.getSouth();
        Component component4 = this.getNorth();
        Component component5 = this.getCenter();
        if (component != null) {
            dimension.setWidth(component.getPreferredW() + component.getStyle().getMargin(false, 1) + component.getStyle().getMargin(false, 3));
            dimension.setHeight(Math.max(component.getPreferredH() + component.getStyle().getMargin(false, 0) + component.getStyle().getMargin(false, 2), dimension.getHeight()));
        }
        if (component2 != null) {
            dimension.setWidth(dimension.getWidth() + component2.getPreferredW() + component2.getStyle().getMargin(false, 1) + component2.getStyle().getMargin(false, 3));
            dimension.setHeight(Math.max(component2.getPreferredH() + component2.getStyle().getMargin(false, 0) + component2.getStyle().getMargin(false, 2), dimension.getHeight()));
        }
        if (component5 != null) {
            dimension.setWidth(dimension.getWidth() + component5.getPreferredW() + component5.getStyle().getMargin(false, 1) + component5.getStyle().getMargin(false, 3));
            dimension.setHeight(Math.max(component5.getPreferredH() + component5.getStyle().getMargin(false, 0) + component5.getStyle().getMargin(false, 2), dimension.getHeight()));
        }
        if (component4 != null) {
            dimension.setWidth(Math.max(component4.getPreferredW() + component4.getStyle().getMargin(false, 1) + component4.getStyle().getMargin(false, 3), dimension.getWidth()));
            dimension.setHeight(dimension.getHeight() + component4.getPreferredH() + component4.getStyle().getMargin(false, 0) + component4.getStyle().getMargin(false, 2));
        }
        if (component3 != null) {
            dimension.setWidth(Math.max(component3.getPreferredW() + component3.getStyle().getMargin(false, 1) + component3.getStyle().getMargin(false, 3), dimension.getWidth()));
            dimension.setHeight(dimension.getHeight() + component3.getPreferredH() + component3.getStyle().getMargin(false, 0) + component3.getStyle().getMargin(false, 2));
        }
        dimension.setWidth(dimension.getWidth() + container.getStyle().getPadding(false, 1) + container.getStyle().getPadding(false, 3));
        dimension.setHeight(dimension.getHeight() + container.getStyle().getPadding(false, 0) + container.getStyle().getPadding(false, 2));
        return dimension;
    }

    private boolean isLandscape() {
        Display display = Display.getInstance();
        return display.getDisplayWidth() > display.getDisplayHeight();
    }

    private Component getComponentAtIgnoreLandscape(String string) {
        if (string != null) {
            if (string.equals(NORTH)) {
                return this.portaraitNorth;
            }
            if (string.equals(SOUTH)) {
                return this.portaraitSouth;
            }
            if (string.equals(EAST)) {
                return this.portaraitEast;
            }
            if (string.equals(WEST)) {
                return this.portaraitWest;
            }
            if (string.equals(CENTER)) {
                return this.portaraitCenter;
            }
        }
        return null;
    }

    private Component getComponentImpl(Component component, String string) {
        String string2;
        if (this.landscapeSwap != null && this.isLandscape() && (string2 = (String)this.landscapeSwap.get(string)) != null) {
            return this.getComponentAtIgnoreLandscape(string2);
        }
        return component;
    }

    public Component getSouth() {
        return this.getComponentImpl(this.portaraitSouth, SOUTH);
    }

    public Component getCenter() {
        return this.getComponentImpl(this.portaraitCenter, CENTER);
    }

    public Component getNorth() {
        return this.getComponentImpl(this.portaraitNorth, NORTH);
    }

    public Component getEast() {
        return this.getComponentImpl(this.portaraitEast, EAST);
    }

    public Component getWest() {
        return this.getComponentImpl(this.portaraitWest, WEST);
    }

    public String toString() {
        return "BorderLayout";
    }

    public void defineLandscapeSwap(String string, String string2) {
        if (this.landscapeSwap == null) {
            this.landscapeSwap = new Hashtable();
        }
        this.landscapeSwap.put(string, string2);
        this.landscapeSwap.put(string2, string);
    }

    public String getLandscapeSwap(String string) {
        if (this.landscapeSwap == null) {
            return null;
        }
        return (String)this.landscapeSwap.get(string);
    }

    public boolean equals(Object object) {
        if (super.equals(object) && this.centerBehavior == ((BorderLayout)object).centerBehavior) {
            if (this.landscapeSwap == ((BorderLayout)object).landscapeSwap) {
                return true;
            }
            if (this.landscapeSwap != null) {
                return ((Object)this.landscapeSwap).equals(((BorderLayout)object).landscapeSwap);
            }
        }
        return false;
    }

    public boolean isAbsoluteCenter() {
        return this.centerBehavior == 1;
    }

    public void setAbsoluteCenter(boolean bl) {
        if (bl) {
            this.setCenterBehavior(1);
        } else {
            this.setCenterBehavior(0);
        }
    }

    public int getCenterBehavior() {
        return this.centerBehavior;
    }

    public void setCenterBehavior(int n) {
        this.centerBehavior = n;
    }
}

