/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import java.util.Hashtable;

class CustomFont
extends Font {
    private static final int COLOR_CACHE_SIZE = 20;
    private Hashtable colorCache = new Hashtable();
    private String charsets;
    private int color;
    Image cache;
    int[] cutOffsets;
    int[] charWidth;
    private int imageWidth;
    private int imageHeight;
    private Object imageArrayRef;

    private int[] getImageArray() {
        int[] nArray;
        if (this.imageArrayRef != null && (nArray = (int[])Display.getInstance().extractHardRef(this.imageArrayRef)) != null) {
            return nArray;
        }
        nArray = this.cache.getRGBCached();
        this.imageArrayRef = Display.getInstance().createSoftWeakRef(nArray);
        return nArray;
    }

    public CustomFont(Image image, int[] nArray, int[] nArray2, String string) {
        this.cutOffsets = nArray;
        this.charWidth = nArray2;
        this.charsets = string;
        this.imageWidth = image.getWidth();
        this.imageHeight = image.getHeight();
        int[] nArray3 = new int[this.imageWidth * this.imageHeight];
        image.getRGB(nArray3, 0, 0, 0, this.imageWidth, this.imageHeight);
        for (int i = 0; i < nArray3.length; ++i) {
            nArray3[i] = (nArray3[i] & 0xFF0000) << 8;
        }
        this.cache = Image.createImage(nArray3, this.imageWidth, this.imageHeight);
        this.imageArrayRef = Display.getInstance().createSoftWeakRef(nArray3);
    }

    public int charWidth(char c) {
        int n = this.charsets.indexOf(c);
        if (n < 0) {
            return 0;
        }
        return this.charWidth[n];
    }

    public int getHeight() {
        return this.imageHeight;
    }

    private boolean checkCacheCurrentColor(int n) {
        Integer n2 = new Integer(this.color);
        Integer n3 = new Integer(n);
        if (this.colorCache.get(n2) == null) {
            this.colorCache.put(n2, Display.getInstance().createSoftWeakRef(this.cache));
        }
        this.color = n;
        Object object = Display.getInstance().extractHardRef(this.colorCache.get(n3));
        if (object != null) {
            Image image = (Image)object;
            if (image != null) {
                this.cache = image;
                if (this.colorCache.size() > 20) {
                    this.colorCache.remove(this.colorCache.keys().nextElement());
                }
                return true;
            }
            this.colorCache.remove(n3);
        }
        if (this.colorCache.size() > 20) {
            this.colorCache.remove(this.colorCache.keys().nextElement());
        }
        return false;
    }

    private void initColor(Graphics graphics) {
        int n = graphics.getColor();
        if (n != this.color && !this.checkCacheCurrentColor(n)) {
            this.color = n & 0xFFFFFF;
            int[] nArray = this.getImageArray();
            for (int i = 0; i < nArray.length; ++i) {
                nArray[i] = this.color | nArray[i] & 0xFF000000;
            }
            this.cache = Image.createImage(nArray, this.imageWidth, this.imageHeight);
        }
    }

    void drawChar(Graphics graphics, char c, int n, int n2) {
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = this.charsets.indexOf(c);
        if (n7 > -1) {
            this.initColor(graphics);
            graphics.clipRect(n, n2, this.charWidth[n7], this.imageHeight);
            graphics.drawImage(this.cache, n - this.cutOffsets[n7], n2);
        }
        graphics.setClip(n3, n4, n5, n6);
    }

    public void addContrast(byte by) {
        int[] nArray = this.getImageArray();
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i] >> 24 & 0xFF;
            if (n == 0) continue;
            n = Math.min(n + by, 255);
            nArray[i] = n << 24 & 0xFF000000 | this.color;
        }
    }

    void drawChars(Graphics graphics, char[] cArray, int n, int n2, int n3, int n4) {
        int n5;
        if (Display.getInstance().isBidiAlgorithm()) {
            for (n5 = n; n5 < n2; ++n5) {
                if (!Display.getInstance().isRTL(cArray[n5])) continue;
                String string = Display.getInstance().convertBidiLogicalToVisual(new String(cArray, n, n2));
                cArray = string.toCharArray();
                n = 0;
                n2 = string.length();
                break;
            }
        }
        this.initColor(graphics);
        n5 = graphics.getClipX();
        int n6 = graphics.getClipY();
        int n7 = graphics.getClipWidth();
        int n8 = graphics.getClipHeight();
        if (n6 <= n4 + this.getHeight() && n6 + n8 >= n4) {
            for (int i = 0; i < n2; ++i) {
                char c = cArray[n + i];
                int n9 = this.charsets.indexOf(c);
                if (n9 < 0) continue;
                graphics.clipRect(n3, n4, this.charWidth[n9], this.imageHeight);
                if (graphics.getClipWidth() > 0 && graphics.getClipHeight() > 0) {
                    graphics.drawImage(this.cache, n3 - this.cutOffsets[n9], n4);
                }
                n3 += this.charWidth[n9];
                graphics.setClip(n5, n6, n7, n8);
            }
        }
    }

    public String getCharset() {
        return this.charsets;
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 += this.charWidth(cArray[i + n]);
        }
        return n3;
    }

    public int substringWidth(String string, int n, int n2) {
        return this.charsWidth(string.toCharArray(), n, n2);
    }

    public int stringWidth(String string) {
        if (string == null || string.length() == 0) {
            return 0;
        }
        return this.substringWidth(string, 0, string.length());
    }

    public int getFace() {
        return 0;
    }

    public int getSize() {
        return 0;
    }

    public int getStyle() {
        return 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            CustomFont customFont = (CustomFont)object;
            if (this.charsets.equals(customFont.charsets)) {
                for (int i = 0; i < this.cutOffsets.length; ++i) {
                    if (this.cutOffsets[i] == customFont.cutOffsets[i]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }
}

