/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.RGBImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class EncodedImage
extends Image {
    private byte[] imageData;
    private int width = -1;
    private int height = -1;
    private boolean opaqueChecked = false;
    private boolean opaque = false;
    private Object cache;
    private Image hardCache;
    private boolean locked;
    static /* synthetic */ Class class$com$sun$lwuit$EncodedImage;

    private EncodedImage(byte[] byArray) {
        super(null);
        this.imageData = byArray;
    }

    protected EncodedImage(int n, int n2) {
        super(null);
        this.width = n;
        this.height = n2;
    }

    protected void resetCache() {
        this.cache = null;
    }

    public byte[] getImageData() {
        return this.imageData;
    }

    public static EncodedImage create(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        return new EncodedImage(byArray);
    }

    public static EncodedImage create(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[4096];
        int n = inputStream.read(byArray);
        while (n > -1) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        byteArrayOutputStream.close();
        return new EncodedImage(byteArrayOutputStream.toByteArray());
    }

    private Image getInternalImpl() {
        if (this.hardCache != null) {
            return this.hardCache;
        }
        Image image = this.getInternal();
        if (this.locked) {
            this.hardCache = image;
        }
        return image;
    }

    protected Image getInternal() {
        Image image;
        if (this.cache != null && (image = (Image)Display.getInstance().extractHardRef(this.cache)) != null) {
            return image;
        }
        try {
            byte[] byArray = this.getImageData();
            image = Image.createImage(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            image = Image.createImage(5, 5);
        }
        this.cache = Display.getInstance().createSoftWeakRef(image);
        return image;
    }

    public void lock() {
        this.locked = true;
        if (this.cache != null) {
            this.hardCache = (Image)Display.getInstance().extractHardRef(this.cache);
        }
    }

    public void unlock() {
        if (this.hardCache != null && (this.cache == null || Display.getInstance().extractHardRef(this.cache) == null)) {
            this.cache = Display.getInstance().createSoftWeakRef(this.hardCache);
        }
        this.locked = false;
    }

    public static EncodedImage create(String string) throws IOException {
        return EncodedImage.create(Display.getInstance().getResourceAsStream(class$com$sun$lwuit$EncodedImage == null ? (class$com$sun$lwuit$EncodedImage = EncodedImage.class$("com.sun.lwuit.EncodedImage")) : class$com$sun$lwuit$EncodedImage, string));
    }

    public Image subImage(int n, int n2, int n3, int n4, boolean bl) {
        return this.getInternalImpl().subImage(n, n2, n3, n4, bl);
    }

    public Image rotate(int n) {
        return this.getInternalImpl().rotate(n);
    }

    public Image modifyAlpha(byte by) {
        return this.getInternalImpl().modifyAlpha(by);
    }

    public Image modifyAlpha(byte by, int n) {
        return this.getInternalImpl().modifyAlpha(by, n);
    }

    public Graphics getGraphics() {
        return null;
    }

    public int getWidth() {
        if (this.width > -1) {
            return this.width;
        }
        this.width = this.getInternalImpl().getWidth();
        return this.width;
    }

    public int getHeight() {
        if (this.height > -1) {
            return this.height;
        }
        this.height = this.getInternalImpl().getHeight();
        return this.height;
    }

    protected void drawImage(Graphics graphics, Object object, int n, int n2) {
        this.getInternalImpl().drawImage(graphics, object, n, n2);
    }

    void getRGB(int[] nArray, int n, int n2, int n3, int n4, int n5) {
        this.getInternalImpl().getRGB(nArray, n, n2, n3, n4, n5);
    }

    public void toRGB(RGBImage rGBImage, int n, int n2, int n3, int n4, int n5, int n6) {
        this.getInternalImpl().toRGB(rGBImage, n, n2, n3, n4, n5, n6);
    }

    public Image scaledWidth(int n) {
        return this.getInternalImpl().scaledWidth(n);
    }

    public Image scaledHeight(int n) {
        return this.getInternalImpl().scaledHeight(n);
    }

    public Image scaledSmallerRatio(int n, int n2) {
        return this.getInternalImpl().scaledSmallerRatio(n, n2);
    }

    public Image scaled(int n, int n2) {
        return this.getInternalImpl().scaled(n, n2);
    }

    public void scale(int n, int n2) {
        this.getInternalImpl().scale(n, n2);
    }

    public boolean isAnimation() {
        return false;
    }

    public boolean isOpaque() {
        if (this.opaqueChecked) {
            return this.opaque;
        }
        this.opaque = this.getInternalImpl().isOpaque();
        return this.opaque;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

