/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.animations.Motion;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.events.SelectionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.DefaultListCellRenderer;
import com.sun.lwuit.list.DefaultListModel;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.list.ListModel;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Vector;

public class List
extends Component {
    public static final int FIXED_NONE = 0;
    public static final int FIXED_NONE_CYCLIC = 1;
    public static final int FIXED_NONE_ONE_ELEMENT_MARGIN_FROM_EDGE = 2;
    private static final int FIXED_NONE_BOUNDRY = 9;
    public static final int FIXED_LEAD = 10;
    public static final int FIXED_TRAIL = 11;
    public static final int FIXED_CENTER = 12;
    private Object renderingPrototype;
    private int fixedSelection;
    private ListModel model;
    private ListCellRenderer renderer = new DefaultListCellRenderer();
    private int orientation = 0;
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    static final int COMBO = 2;
    EventDispatcher dispatcher = new EventDispatcher();
    Object eventSource = this;
    private Dimension elemSize;
    private Dimension selectedElemSize;
    private boolean inputOnFocus = true;
    private boolean numericKeyActions = true;
    private boolean paintFocusBehindList = true;
    private int listSizeCalculationSampleCount = 5;
    private int minElementHeight = 0;
    private int itemGap = 2;
    private Listeners listener;
    private int animationPosition;
    private int fixedDraggedAnimationPosition;
    private int fixedDraggedPosition;
    private Motion fixedDraggedMotion;
    private int destination;
    private Motion listMotion;
    private static boolean defaultFireOnClick = true;
    private boolean fireOnClick = defaultFireOnClick;
    private boolean fireOnRelease;
    private int fixedDraggedSelection = 0;
    private boolean commandList;
    private static boolean defaultIgnoreFocusComponentWhenUnfocused = true;
    private boolean ignoreFocusComponentWhenUnfocused = defaultIgnoreFocusComponentWhenUnfocused;
    boolean disposeDialogOnSelection;
    private boolean mutableRendererBackgrounds;
    private boolean scrollToSelected = true;
    private Label hintLabel;

    public static boolean isDefaultIgnoreFocusComponentWhenUnfocused() {
        return defaultIgnoreFocusComponentWhenUnfocused;
    }

    public static void setDefaultIgnoreFocusComponentWhenUnfocused(boolean bl) {
        defaultIgnoreFocusComponentWhenUnfocused = bl;
    }

    public static boolean isDefaultFireOnClick() {
        return defaultFireOnClick;
    }

    public static void setDefaultFireOnClick(boolean bl) {
        defaultFireOnClick = bl;
    }

    public List(Vector vector) {
        this(new DefaultListModel(vector));
    }

    public List(Object[] objectArray) {
        this(new DefaultListModel(objectArray));
    }

    public List() {
        this(new DefaultListModel());
    }

    public List(ListModel listModel) {
        this.setUIID("List");
        this.setModel(listModel);
        LookAndFeel lookAndFeel = UIManager.getInstance().getLookAndFeel();
        this.setSmoothScrolling(lookAndFeel.isDefaultSmoothScrolling());
        this.fixedSelection = UIManager.getInstance().getThemeConstant("fixedSelectionInt", this.fixedSelection);
    }

    void initComponentImpl() {
        this.dataChanged(0, 0);
        this.bindListeners();
        super.initComponentImpl();
        int n = this.model.getSelectedIndex();
        if (n >= 0) {
            this.model.setSelectedIndex(n);
            this.selectElement(n);
        }
    }

    protected void laidOut() {
        int n;
        super.laidOut();
        if (this.isScrollable() && this.isInitialized() && this.scrollToSelected && (n = this.model.getSelectedIndex()) >= 0) {
            this.selectElement(n);
        }
    }

    void deinitializeImpl() {
        super.deinitializeImpl();
        if (this.listener != null) {
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.listener = null;
        }
    }

    protected void modelChanged(int n, int n2) {
    }

    protected void listSelectionChanged(int n, int n2) {
    }

    public boolean isScrollableY() {
        return (this.getScrollDimension().getHeight() > this.getHeight() || this.isAlwaysTensile()) && this.getHeight() > 0 && this.fixedSelection < 9 && this.orientation != 1;
    }

    public boolean isScrollableX() {
        return (this.getScrollDimension().getWidth() > this.getWidth() || this.isAlwaysTensile()) && this.fixedSelection < 9 && this.orientation == 1;
    }

    public int getMinElementHeight() {
        return this.minElementHeight;
    }

    public void setMinElementHeight(int n) {
        this.minElementHeight = n;
    }

    public int size() {
        return this.model.getSize();
    }

    private int getCurrentSelected() {
        if (this.fixedSelection > 9 && this.isDragActivated()) {
            return this.fixedDraggedSelection;
        }
        return this.model.getSelectedIndex();
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        this.setSelectedIndex(n, true);
    }

    protected Rectangle getVisibleBounds() {
        Rectangle rectangle = new Rectangle();
        Dimension dimension = this.getElementSize(false, true);
        Style style = this.getStyle();
        int n = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap();
        this.calculateComponentPosition(this.getCurrentSelected(), n, rectangle, dimension, this.getElementSize(true, true), true);
        rectangle.setX(rectangle.getX() + this.getX());
        rectangle.setY(rectangle.getY() + this.getY());
        return rectangle;
    }

    public void setSelectedIndex(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("Selection index is negative:" + n);
        }
        this.model.setSelectedIndex(n);
        if (bl && this.isInitialized()) {
            this.selectElement(n);
        }
    }

    public Object getSelectedItem() {
        int n = this.model.getSelectedIndex();
        if (n < this.model.getSize() && n > -1) {
            return this.model.getItemAt(n);
        }
        return null;
    }

    public void setSelectedItem(Object object) {
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object object2 = this.model.getItemAt(i);
            if (object2 != object && (object2 == null || !object2.equals(object))) continue;
            this.model.setSelectedIndex(i);
            break;
        }
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setShouldCalcPreferredSize(boolean bl) {
        super.setShouldCalcPreferredSize(bl);
        this.elemSize = null;
        this.selectedElemSize = null;
        if (bl) {
            Object object;
            ListCellRenderer listCellRenderer = this.getRenderer();
            if (this.renderingPrototype != null) {
                object = this.renderingPrototype;
            } else if (this.getModel().getSize() > 0) {
                object = this.getModel().getItemAt(0);
            } else {
                return;
            }
            Component component = listCellRenderer.getListCellRendererComponent(this, object, 0, false);
            component.setShouldCalcPreferredSize(bl);
            component = listCellRenderer.getListCellRendererComponent(this, object, 0, true);
            component.setShouldCalcPreferredSize(bl);
        }
    }

    void dataChanged(int n, int n2) {
        this.setShouldCalcPreferredSize(true);
        if (this.getSelectedIndex() >= this.model.getSize()) {
            this.setSelectedIndex(Math.max(this.model.getSize() - 1, 0));
        }
        this.modelChanged(n, n2);
        this.repaint();
    }

    private void bindListeners() {
        if (this.listener == null) {
            this.listener = new Listeners();
            this.model.addDataChangedListener(this.listener);
            this.model.addSelectionListener(this.listener);
        }
    }

    public void setModel(ListModel listModel) {
        if (this.model != null) {
            this.setShouldCalcPreferredSize(true);
            this.model.removeDataChangedListener(this.listener);
            this.model.removeSelectionListener(this.listener);
            this.model = listModel;
            this.listener = null;
            if (this.getScrollDimension().getHeight() < this.getScrollY() + this.getHeight()) {
                this.setScrollY(0);
            }
            if (this.getScrollDimension().getWidth() < this.getScrollX() + this.getWidth()) {
                this.setScrollX(0);
            }
        }
        this.model = listModel;
        if (this.isInitialized()) {
            this.bindListeners();
        }
        this.repaint();
    }

    public boolean isNumericKeyActions() {
        return this.numericKeyActions;
    }

    public void setNumericKeyActions(boolean bl) {
        this.numericKeyActions = bl;
    }

    public boolean isCommandList() {
        return this.commandList;
    }

    public void setCommandList(boolean bl) {
        this.commandList = bl;
    }

    public boolean isIgnoreFocusComponentWhenUnfocused() {
        return this.ignoreFocusComponentWhenUnfocused;
    }

    public void setIgnoreFocusComponentWhenUnfocused(boolean bl) {
        this.ignoreFocusComponentWhenUnfocused = bl;
    }

    public boolean isMutableRendererBackgrounds() {
        return this.mutableRendererBackgrounds;
    }

    public void setMutableRendererBackgrounds(boolean bl) {
        this.mutableRendererBackgrounds = bl;
    }

    public int getListSizeCalculationSampleCount() {
        return this.listSizeCalculationSampleCount;
    }

    public void setListSizeCalculationSampleCount(int n) {
        this.listSizeCalculationSampleCount = n;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        this.setListCellRenderer(listCellRenderer);
    }

    public void setListCellRenderer(ListCellRenderer listCellRenderer) {
        if (this.renderer != null) {
            this.elemSize = null;
            this.selectedElemSize = null;
            this.setShouldCalcPreferredSize(true);
        }
        this.renderer = listCellRenderer;
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void refreshTheme() {
        this.fixedSelection = UIManager.getInstance().getThemeConstant("fixedSelectionInt", this.fixedSelection);
        this.itemGap = UIManager.getInstance().getThemeConstant("listItemGapInt", this.itemGap);
        ListCellRenderer listCellRenderer = this.getRenderer();
        if (this.renderingPrototype != null) {
            listCellRenderer.getListCellRendererComponent(this, this.renderingPrototype, 0, false).refreshTheme();
        } else if (this.getModel().getSize() > 0) {
            listCellRenderer.getListCellRendererComponent(this, this.getModel().getItemAt(0), 0, false).refreshTheme();
        } else {
            listCellRenderer.getListCellRendererComponent(this, "", 0, false).refreshTheme();
        }
        Component component = listCellRenderer.getListFocusComponent(this);
        if (component != null) {
            component.refreshTheme();
        }
        super.refreshTheme();
    }

    public void setOrientation(int n) {
        this.orientation = n;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        if (this.fixedSelection < 9) {
            Rectangle rectangle2 = this.orientation != 1 ? new Rectangle(this.getScrollX(), rectangle.getY(), rectangle.getSize().getWidth(), rectangle.getSize().getHeight() + this.itemGap) : new Rectangle(rectangle.getX(), this.getScrollY(), rectangle.getSize().getWidth() + this.itemGap, rectangle.getSize().getHeight());
            super.scrollRectToVisible(rectangle2, this);
        }
    }

    public void setHandlesInput(boolean bl) {
        Form form = this.getComponentForm();
        if (form != null) {
            super.setHandlesInput(bl || form.isSingleFocusMode());
        } else {
            super.setHandlesInput(bl);
        }
    }

    void setHandlesInputParent(boolean bl) {
        super.setHandlesInput(bl);
    }

    protected void fireClicked() {
        boolean bl = this.handlesInput();
        this.setHandlesInput(!bl);
        if (bl) {
            this.fireActionEvent();
        }
        this.repaint();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void keyReleased(int n) {
        int n2;
        int n3 = Display.getInstance().getGameAction(n);
        if (n3 == 8) {
            boolean bl = this.handlesInput();
            this.setHandlesInput(!bl);
            if (bl) {
                this.fireActionEvent();
            }
            this.repaint();
            return;
        }
        if (this.numericKeyActions && n3 != 2 && n3 != 5 && n3 != 1 && n3 != 6 && n >= 49 && n <= 57 && (n2 = n - 49) < this.getModel().getSize()) {
            this.setSelectedIndex(n2);
            this.fireActionEvent();
        }
    }

    public void keyPressed(int n) {
        int n2;
        int n3;
        if (!this.handlesInput()) {
            return;
        }
        int n4 = Display.getInstance().getGameAction(n);
        if (this.getOrientation() != 1) {
            n3 = 6;
            n2 = 1;
            if (n4 == 2 || n4 == 5) {
                this.setHandlesInput(false);
            }
        } else {
            if (this.isRTL()) {
                n3 = 2;
                n2 = 5;
            } else {
                n3 = 5;
                n2 = 2;
            }
            if (n4 == 6 || n4 == 1) {
                this.setHandlesInput(false);
            }
        }
        int n5 = this.model.getSelectedIndex();
        if (n4 == n2) {
            if (--n5 < 0) {
                if (this.fixedSelection != 0 && this.fixedSelection != 2) {
                    n5 = this.size() - 1;
                } else {
                    n5 = 0;
                    this.setHandlesInput(false);
                }
            }
        } else if (n4 == n3 && ++n5 >= this.size()) {
            if (this.fixedSelection != 0 && this.fixedSelection != 2) {
                n5 = 0;
            } else {
                n5 = this.size() - 1;
                this.setHandlesInput(false);
            }
        }
        if (n5 != this.model.getSelectedIndex()) {
            int n6;
            this.model.setSelectedIndex(n5);
            int n7 = n6 = n4 == n3 ? 1 : -1;
            if (this.isRTL() && this.getOrientation() == 1) {
                n6 = -n6;
            }
            this.updateAnimationPosition(n6);
            if (this.fixedSelection == 0 || this.fixedSelection == 1) {
                this.selectElement(n5);
            }
            if (this.fixedSelection == 2) {
                if (n3 == n4) {
                    this.selectElement(Math.min(n5 + 1, this.getModel().getSize() - 1));
                } else {
                    this.selectElement(Math.max(n5 - 1, 0));
                }
            }
        }
        this.repaint();
    }

    void selectElement(int n) {
        Rectangle rectangle;
        Dimension dimension = this.getElementSize(false, true);
        if (this.getOrientation() != 1) {
            rectangle = new Rectangle(this.getX(), (dimension.getHeight() + this.itemGap) * n, this.getElementSize(true, true));
        } else {
            int n2 = (dimension.getWidth() + this.itemGap) * n;
            if (this.isRTL() && this.isScrollableX()) {
                n2 = this.getScrollDimension().getWidth() - n2 - (dimension.getWidth() + this.itemGap);
            }
            rectangle = new Rectangle(n2, this.getY(), this.getElementSize(true, true));
        }
        this.scrollRectToVisible(rectangle);
    }

    private void updateAnimationPosition(int n) {
        if (this.animationPosition != 0) {
            this.animationPosition = 0;
            this.animate();
        }
        if (this.isSmoothScrolling()) {
            this.animationPosition = this.orientation != 1 ? (this.animationPosition += n * this.getElementSize(false, true).getHeight()) : (this.animationPosition += n * this.getElementSize(false, true).getWidth());
            this.destination = Math.abs(this.animationPosition);
            this.initListMotion();
        }
    }

    private void initListMotion() {
        Form form = this.getComponentForm();
        if (form != null) {
            form.registerAnimatedInternal(this);
        }
        this.listMotion = Motion.createSplineMotion(0, this.destination, this.getScrollAnimationSpeed());
        this.listMotion.start();
    }

    private void calculateComponentPosition(int n, int n2, Rectangle rectangle, Dimension dimension, Dimension dimension2, boolean bl) {
        Style style = this.getStyle();
        int n3 = style.getPadding(false, 0);
        int n4 = style.getPadding(false, 1);
        boolean bl2 = this.isRTL();
        if (bl2) {
            n4 += this.getSideGap();
        }
        int n5 = this.getCurrentSelected();
        Dimension dimension3 = rectangle.getSize();
        if (this.orientation != 1) {
            int n6 = dimension.getHeight();
            int n7 = dimension2.getHeight() - n6;
            rectangle.setX(n4);
            dimension3.setHeight(n6);
            dimension3.setWidth(n2);
            int n8 = 0;
            int n9 = this.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2);
            int n10 = (n6 + this.itemGap) * this.getModel().getSize() + n7;
            switch (this.fixedSelection) {
                case 12: {
                    n8 = n9 / 2 - (n6 + this.itemGap + n7) / 2 + (n - n5) * (n6 + this.itemGap);
                    if (!bl) {
                        n8 += n7;
                    }
                    n8 = this.recalcOffset(n8, n10, n9, n6 + this.itemGap);
                    break;
                }
                case 11: {
                    n8 = n9 - (n6 + this.itemGap + n7);
                }
                case 10: {
                    n8 += (n - n5) * (n6 + this.itemGap);
                    if (n - n5 > 0) {
                        n8 += n7;
                    }
                    n8 = this.recalcOffset(n8, n10, n9, n6 + this.itemGap);
                    break;
                }
                default: {
                    n8 = n * (n6 + this.itemGap);
                    if (bl) break;
                    n8 += n7;
                }
            }
            rectangle.setY(n8 + n3);
            if (n == n5) {
                dimension3.setHeight(dimension3.getHeight() + n7);
            }
        } else {
            int n11 = dimension.getWidth();
            int n12 = dimension2.getWidth() - n11;
            rectangle.setY(n3);
            dimension3.setHeight(this.getHeight() - style.getPadding(false, 0) - style.getPadding(false, 2));
            dimension3.setWidth(n11);
            int n13 = 0;
            int n14 = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1);
            int n15 = (n11 + this.itemGap) * this.getModel().getSize() + n12;
            switch (this.fixedSelection) {
                case 12: {
                    n13 = n14 / 2 - (n11 + this.itemGap + n12) / 2 + (n - n5) * (n11 + this.itemGap);
                    if (!bl) {
                        n13 += n12;
                    }
                    if (bl2) {
                        n13 = n14 - n13 - n11;
                    }
                    n13 = this.recalcOffset(n13, n15, n14, n11 + this.itemGap);
                    break;
                }
                case 11: {
                    n13 = n14 - (n11 + this.itemGap + n12);
                }
                case 10: {
                    n13 += (n - n5) * (n11 + this.itemGap);
                    if (n - n5 > 0) {
                        n13 += n12;
                    }
                    if (bl2) {
                        n13 = n14 - n13 - n11;
                    }
                    n13 = this.recalcOffset(n13, n15, n14, n11 + this.itemGap);
                    break;
                }
                default: {
                    n13 = n * (n11 + this.itemGap);
                    if (bl) break;
                    n13 += n12;
                }
            }
            int n16 = n4 + n13;
            if (bl2 && this.fixedSelection < 9) {
                n16 = n4 + n15 - (n13 - n4) - (n11 + this.itemGap);
                if (n == this.getCurrentSelected()) {
                    n16 -= n12;
                }
                if (n15 < n14) {
                    n16 += n14 - n15;
                }
            }
            rectangle.setX(n16);
            if (n == n5) {
                dimension3.setWidth(dimension3.getWidth() + n12);
            }
        }
    }

    private int recalcOffset(int n, int n2, int n3, int n4) {
        if (n + this.animationPosition % n4 + this.fixedDraggedAnimationPosition % n4 >= n3) {
            n -= n2;
        } else if (n + this.animationPosition % n4 + this.fixedDraggedAnimationPosition % n4 < 1 - n4) {
            n += n2;
        }
        return n;
    }

    public void paint(Graphics graphics) {
        Object object;
        Component component;
        Object object2;
        int n;
        int n2;
        int n3;
        UIManager.getInstance().getLookAndFeel().drawList(graphics, this);
        Style style = this.getStyle();
        int n4 = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap();
        if (this.isScrollableX()) {
            n4 = Math.max(n4, this.getScrollDimension().getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap());
        }
        if ((n3 = this.model.getSize()) == 0) {
            this.paintHint(graphics);
            return;
        }
        int n5 = this.getX();
        int n6 = this.getY();
        graphics.translate(n5, n6);
        Rectangle rectangle = new Rectangle();
        Dimension dimension = this.getElementSize(false, true);
        if (this.fixedSelection > 9 && (this.animationPosition != 0 || this.isDragActivated())) {
            if (this.orientation != 1) {
                n6 += this.animationPosition + this.fixedDraggedAnimationPosition;
                graphics.translate(0, this.animationPosition + this.fixedDraggedAnimationPosition);
            } else {
                n5 += this.animationPosition + this.fixedDraggedAnimationPosition;
                graphics.translate(this.animationPosition + this.fixedDraggedAnimationPosition, 0);
            }
        }
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        boolean bl = false;
        int n11 = 0;
        if (this.fixedSelection < 9) {
            n2 = n7 + this.getAbsoluteX();
            if (this.isRTL()) {
                n2 += this.getWidth();
            }
            n11 = Math.max(0, this.pointerSelect(n2, n8 + this.getAbsoluteY()) - 1);
        }
        n2 = 0;
        int n12 = n3;
        if (this.mutableRendererBackgrounds) {
            for (n = n11; n < n3; ++n) {
                if (n == this.getCurrentSelected() && this.animationPosition == 0 && this.fixedDraggedAnimationPosition == 0) {
                    if (!bl) {
                        n2 = n;
                    }
                    n12 = n;
                    bl = true;
                    continue;
                }
                this.calculateComponentPosition(n, n4, rectangle, dimension, this.getElementSize(true, true), n <= this.getCurrentSelected());
                if (rectangle.intersects(n7, n8, n9, n10)) {
                    if (!bl) {
                        n2 = n;
                    }
                    n12 = n;
                    object2 = rectangle.getSize();
                    Component component2 = this.renderer.getListCellRendererComponent(this, this.getModel().getItemAt(n), n, n == this.getCurrentSelected());
                    this.renderComponentBackground(graphics, component2, rectangle.getX(), rectangle.getY(), ((Dimension)object2).getWidth(), ((Dimension)object2).getHeight());
                    bl = true;
                    continue;
                }
                if (!bl || this.fixedSelection >= 9) {
                    continue;
                }
                break;
            }
        } else {
            Object object3 = this.getModel().getItemAt(0);
            int n13 = this.getSelectedIndex();
            object2 = n13 > -1 && n13 < n3 ? this.renderer.getListCellRendererComponent(this, this.getModel().getItemAt(n13), 0, true) : this.renderer.getListCellRendererComponent(this, object3, 0, true);
            component = this.renderer.getListCellRendererComponent(this, object3, 0, false);
            for (int i = n11; i < n3; ++i) {
                if (i == this.getCurrentSelected() && this.animationPosition == 0) {
                    if (!bl) {
                        n2 = i;
                    }
                    n12 = i;
                    bl = true;
                    continue;
                }
                this.calculateComponentPosition(i, n4, rectangle, dimension, this.getElementSize(true, true), i <= this.getCurrentSelected());
                if (rectangle.intersects(n7, n8, n9, n10)) {
                    if (!bl) {
                        n2 = i;
                    }
                    n12 = i;
                    if (i == this.getCurrentSelected()) {
                        object = rectangle.getSize();
                        this.renderComponentBackground(graphics, (Component)object2, rectangle.getX(), rectangle.getY(), ((Dimension)object).getWidth(), ((Dimension)object).getHeight());
                    } else {
                        object = rectangle.getSize();
                        this.renderComponentBackground(graphics, component, rectangle.getX(), rectangle.getY(), ((Dimension)object).getWidth(), ((Dimension)object).getHeight());
                    }
                    bl = true;
                    continue;
                }
                if (!bl || this.fixedSelection >= 9) {
                    continue;
                }
                break;
            }
        }
        n = this.renderer.getListFocusComponent(this) == null && this.fixedSelection < 9 || this.animationPosition == 0 && this.model.getSize() > 0 ? 1 : 0;
        object2 = new Rectangle();
        this.calculateComponentPosition(this.getCurrentSelected(), n4, (Rectangle)object2, dimension, this.getElementSize(true, true), true);
        Dimension dimension2 = ((Rectangle)object2).getSize();
        if (n != 0) {
            component = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(this.getCurrentSelected()), this.getCurrentSelected(), true);
            this.renderComponentBackground(graphics, component, ((Rectangle)object2).getX(), ((Rectangle)object2).getY(), dimension2.getWidth(), dimension2.getHeight());
        }
        if (this.paintFocusBehindList) {
            this.paintFocus(graphics, n4, rectangle, dimension);
        }
        for (int i = n2; i <= n12; ++i) {
            if (i == this.getCurrentSelected() && this.animationPosition == 0) continue;
            this.calculateComponentPosition(i, n4, rectangle, dimension, this.getElementSize(true, true), i <= this.getCurrentSelected());
            Object object4 = this.model.getItemAt(i);
            object = this.renderer.getListCellRendererComponent(this, object4, i, false);
            ((Component)object).setCellRenderer(true);
            Dimension dimension3 = rectangle.getSize();
            this.renderComponent(graphics, (Component)object, rectangle.getX(), rectangle.getY(), dimension3.getWidth(), dimension3.getHeight());
        }
        if (n != 0) {
            Component component3 = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(this.getCurrentSelected()), this.getCurrentSelected(), true);
            this.renderComponent(graphics, component3, ((Rectangle)object2).getX(), ((Rectangle)object2).getY(), dimension2.getWidth(), dimension2.getHeight());
        }
        if (!this.paintFocusBehindList) {
            this.paintFocus(graphics, n4, rectangle, dimension);
        }
        graphics.translate(-n5, -n6);
    }

    private void paintFocus(Graphics graphics, int n, Rectangle rectangle, Dimension dimension) {
        if (this.ignoreFocusComponentWhenUnfocused && !this.hasFocus()) {
            return;
        }
        if (!Display.getInstance().shouldRenderSelection()) {
            return;
        }
        this.calculateComponentPosition(this.getCurrentSelected(), n, rectangle, dimension, this.getElementSize(true, true), true);
        Dimension dimension2 = rectangle.getSize();
        Component component = this.renderer.getListFocusComponent(this);
        if (component != null) {
            component.setCellRenderer(true);
            int n2 = rectangle.getX();
            int n3 = rectangle.getY();
            if (this.orientation != 1) {
                n3 -= this.animationPosition + this.fixedDraggedAnimationPosition;
            } else {
                n2 -= this.animationPosition + this.fixedDraggedAnimationPosition;
            }
            this.renderComponentBackground(graphics, component, n2, n3, dimension2.getWidth(), dimension2.getHeight());
            this.renderComponent(graphics, component, n2, n3, dimension2.getWidth(), dimension2.getHeight());
        }
    }

    private void renderComponent(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        Style style = component.getStyle();
        int n5 = style.getMargin(this.isRTL(), 1);
        int n6 = style.getMargin(false, 0);
        component.setWidth(n3 - n5 - style.getMargin(this.isRTL(), 3));
        component.setHeight(n4 - n6 - style.getMargin(false, 2));
        component.setX(n + n5);
        component.setY(n2 + n6);
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        graphics.clipRect(component.getX(), component.getY(), component.getWidth(), component.getHeight());
        component.paint(graphics);
        Border border = style.getBorder();
        if (border != null && !border.isBackgroundPainter()) {
            component.paintBorder(graphics);
        }
        graphics.setClip(n7, n8, n9, n10);
    }

    private void renderComponentBackground(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        Style style = component.getStyle();
        int n5 = style.getMargin(this.isRTL(), 1);
        int n6 = style.getMargin(false, 0);
        component.setWidth(n3 - n5 - style.getMargin(this.isRTL(), 3));
        component.setHeight(n4 - n6 - style.getMargin(false, 2));
        component.setX(n + n5);
        component.setY(n2 + n6);
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        graphics.clipRect(component.getX(), component.getY(), component.getWidth(), component.getHeight());
        component.paintBackground(graphics);
        graphics.setClip(n7, n8, n9, n10);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.model.addSelectionListener(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.model.removeSelectionListener(selectionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.dispatcher.addListener(actionListener);
    }

    public Vector getActionListeners() {
        return this.dispatcher.getListenerVector();
    }

    public void removeActionListener(ActionListener actionListener) {
        this.dispatcher.removeListener(actionListener);
    }

    protected void fireActionEvent() {
        if (this.isEnabled()) {
            Object object;
            if (this.disposeDialogOnSelection) {
                ((Dialog)this.getComponentForm()).dispose();
            }
            super.fireActionEvent();
            ActionEvent actionEvent = new ActionEvent(this.eventSource);
            this.dispatcher.fireActionEvent(actionEvent);
            if (this.isCommandList() && !actionEvent.isConsumed() && (object = this.getSelectedItem()) != null && object instanceof Command && ((Command)object).isEnabled()) {
                Form form;
                ((Command)object).actionPerformed(actionEvent);
                if (!actionEvent.isConsumed() && (form = this.getComponentForm()) != null) {
                    form.actionCommandImpl((Command)object);
                }
            }
            if (((Display)(object = Display.getInstance())).isBuiltinSoundsEnabled()) {
                ((Display)object).playBuiltinSound("press");
            }
        }
    }

    public void setInputOnFocus(boolean bl) {
        this.inputOnFocus = bl;
    }

    public void setPaintFocusBehindList(boolean bl) {
        this.paintFocusBehindList = bl;
    }

    void focusGainedInternal() {
        super.focusGainedInternal();
        if (this.inputOnFocus) {
            this.setHandlesInput(true);
        }
    }

    void focusLostInternal() {
        super.focusLostInternal();
    }

    public int getItemGap() {
        return this.itemGap;
    }

    public void setItemGap(int n) {
        this.itemGap = n;
    }

    public void setRenderingPrototype(Object object) {
        this.renderingPrototype = object;
    }

    public Object getRenderingPrototype() {
        return this.renderingPrototype;
    }

    Dimension getElementSize(boolean bl, boolean bl2) {
        if (bl) {
            if (this.selectedElemSize == null) {
                if (this.renderingPrototype == null && this.model.getSize() == 0) {
                    if (bl2) {
                        return new Label("XXXXXX").getPreferredSizeWithMargin();
                    }
                    return new Label("XXXXXX").getPreferredSize();
                }
                this.selectedElemSize = this.calculateElementSize(true, bl2);
            }
            return this.selectedElemSize;
        }
        if (this.elemSize == null) {
            if (this.renderingPrototype == null && this.model.getSize() == 0) {
                Label label = new Label("XXXXXX");
                if (bl2) {
                    return label.getPreferredSizeWithMargin();
                }
                return label.getPreferredSize();
            }
            this.elemSize = this.calculateElementSize(false, bl2);
        }
        return this.elemSize;
    }

    private Dimension calculateElementSize(boolean bl, boolean bl2) {
        if (this.renderingPrototype != null) {
            Component component = this.renderer.getListCellRendererComponent(this, this.renderingPrototype, 0, bl);
            if (bl2) {
                return component.getPreferredSizeWithMargin();
            }
            return component.getPreferredSize();
        }
        int n = 0;
        int n2 = 0;
        int n3 = Math.min(this.listSizeCalculationSampleCount, this.model.getSize());
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            Component component = this.renderer.getListCellRendererComponent(this, this.model.getItemAt(i), i, bl);
            if (component instanceof Container) {
                component.setShouldCalcPreferredSize(true);
            }
            Dimension dimension = component.getPreferredSize();
            n = Math.max(n, dimension.getWidth());
            n2 = Math.max(n2, dimension.getHeight());
            if (i != 0) continue;
            Style style = component.getStyle();
            n4 = style.getMargin(0) + style.getMargin(2);
            n5 = style.getMargin(1) + style.getMargin(3);
        }
        return new Dimension(n + n5, n2 + n4);
    }

    protected void longPointerPress(int n, int n2) {
        int n3 = this.pointerSelect(n, n2);
        if (n3 > -1) {
            this.model.setSelectedIndex(n3);
        }
    }

    public void pointerPressed(int n, int n2) {
        int n3;
        if (this.fixedSelection > 9 && this.isSmoothScrolling()) {
            this.fixedDraggedPosition = this.orientation != 1 ? n2 : n;
            if (this.isDragActivated()) {
                n3 = this.getCurrentSelected();
                this.model.setSelectedIndex(n3);
                this.fixedDraggedMotion = null;
                this.fixedDraggedAnimationPosition = 0;
            }
            this.fixedDraggedSelection = this.getModel().getSelectedIndex();
        }
        this.setDragActivated(false);
        n3 = this.model.getSelectedIndex();
        int n4 = this.pointerSelect(n, n2);
        if (n4 > -1 && this.fixedSelection < 9) {
            this.model.setSelectedIndex(n4);
        }
        this.fireOnRelease = n3 == n4;
        super.pointerPressed(n, n2);
    }

    public void pointerHover(int[] nArray, int[] nArray2) {
        int n;
        this.clearDrag();
        if (!this.isDragActivated() && (n = this.pointerSelect(nArray[0], nArray2[0])) > -1) {
            this.model.setSelectedIndex(n);
        }
        this.pointerDraggedImpl(nArray[0], nArray2[0]);
    }

    public void pointerDragged(int n, int n2) {
        this.pointerDraggedImpl(n, n2);
    }

    private void pointerDraggedImpl(int n, int n2) {
        if (this.isSmoothScrolling()) {
            if (this.fixedSelection < 9) {
                super.pointerDragged(n, n2);
            } else {
                int n3;
                int n4;
                boolean bl;
                if (!this.isDragActivated()) {
                    this.setDragActivated(true);
                }
                Dimension dimension = this.getElementSize(false, true);
                boolean bl2 = bl = this.orientation == 0;
                if (bl) {
                    n4 = n2;
                    n3 = dimension.getHeight();
                } else {
                    n4 = n;
                    n3 = dimension.getWidth();
                }
                this.fixedDraggedAnimationPosition -= this.fixedDraggedPosition - n4;
                this.fixedDraggedPosition = n4;
                if (this.fixedDraggedAnimationPosition <= -n3) {
                    ++this.fixedDraggedSelection;
                    if (this.fixedDraggedSelection >= this.model.getSize()) {
                        this.fixedDraggedSelection = 0;
                    }
                } else if (this.fixedDraggedAnimationPosition >= n3) {
                    --this.fixedDraggedSelection;
                    if (this.fixedDraggedSelection < 0) {
                        this.fixedDraggedSelection = this.model.getSize() - 1;
                    }
                }
                this.fixedDraggedAnimationPosition %= n3;
            }
        } else {
            int n5 = this.pointerSelect(n, n2);
            if (n5 > -1) {
                this.model.setSelectedIndex(n5);
            }
        }
    }

    private int pointerSelect(int n, int n2) {
        int n3 = -1;
        int n4 = this.getModel().getSize();
        Style style = this.getStyle();
        Dimension dimension = this.getElementSize(false, true);
        Dimension dimension2 = this.getElementSize(true, true);
        Rectangle rectangle = new Rectangle();
        int n5 = this.getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1) - this.getSideGap();
        if (this.isScrollableX()) {
            n5 = Math.max(n5, this.getScrollDimension().getWidth() - style.getPadding(false, 3) - style.getPadding(false, 1) - this.getSideGap());
        }
        n2 -= this.getAbsoluteY();
        n -= this.getAbsoluteX();
        if (this.fixedSelection < 9) {
            this.calculateComponentPosition(this.getSelectedIndex(), n5, rectangle, dimension, this.getElementSize(true, true), true);
            if (this.orientation != 1) {
                if (n2 < rectangle.getY()) {
                    n3 = n2 / (dimension.getHeight() + this.itemGap);
                } else {
                    int n6 = this.getSelectedIndex();
                    n3 = n2 < rectangle.getY() + dimension2.getHeight() ? n6 : n6 + 1 + (n2 - (rectangle.getY() + dimension2.getHeight())) / (dimension.getHeight() + this.itemGap);
                }
            } else if (this.isRTL()) {
                if (n > rectangle.getX() + dimension2.getWidth()) {
                    int n7 = n - (rectangle.getX() + dimension2.getWidth());
                    n3 = this.getSelectedIndex() - 1 - (n7 /= dimension.getWidth() + this.itemGap);
                } else if (n >= rectangle.getX()) {
                    n3 = this.getSelectedIndex();
                } else {
                    int n8 = rectangle.getX() - n;
                    n3 = this.getSelectedIndex() + 1 + (n8 /= dimension.getWidth() + this.itemGap);
                }
            } else if (n < rectangle.getX()) {
                n3 = n / (dimension.getWidth() + this.itemGap);
            } else {
                int n9 = this.getSelectedIndex();
                n3 = n < rectangle.getX() + dimension2.getWidth() ? n9 : n9 + 1 + (n - (rectangle.getX() + dimension2.getWidth())) / (dimension.getWidth() + this.itemGap);
            }
        } else {
            for (int i = 0; i < n4; ++i) {
                this.calculateComponentPosition(i, n5, rectangle, dimension, dimension2, true);
                if (!rectangle.contains(n, n2)) continue;
                n3 = i;
                break;
            }
        }
        if (n3 < 0 || n3 >= this.size()) {
            return -1;
        }
        return n3;
    }

    public void setFireOnClick(boolean bl) {
        this.fireOnClick = bl;
    }

    public void pointerHoverReleased(int[] nArray, int[] nArray2) {
        this.pointerReleasedImpl(nArray[0], nArray2[0], true);
    }

    private void pointerReleasedImpl(int n, int n2, boolean bl) {
        if (this.isDragActivated()) {
            if (this.fixedSelection < 9) {
                super.pointerReleased(n, n2);
            } else {
                boolean bl2 = this.getOrientation() == 0;
                float f = Display.getInstance().getDragSpeed(bl2);
                this.fixedDraggedMotion = bl2 ? Motion.createFrictionMotion(-this.fixedDraggedAnimationPosition, this.getElementSize(false, true).getHeight() * this.getModel().getSize(), f, 4.0E-4f) : Motion.createFrictionMotion(-this.fixedDraggedAnimationPosition, this.getElementSize(false, true).getWidth() * this.getModel().getSize(), f, 4.0E-4f);
                this.fixedDraggedPosition = this.fixedDraggedAnimationPosition;
                Form form = this.getComponentForm();
                if (form != null) {
                    form.registerAnimatedInternal(this);
                }
                this.fixedDraggedMotion.start();
            }
            return;
        }
        if (!bl && this.pointerSelect(n, n2) > -1 && (this.fireOnClick && this.fixedSelection < 9 || this.fireOnRelease)) {
            Component component;
            Component component2 = this.renderer.getListCellRendererComponent(this, this.getSelectedItem(), this.getSelectedIndex(), true);
            Style style = this.getStyle();
            int n3 = this.getWidth() - style.getPadding(this.isRTL(), 3) - style.getPadding(this.isRTL(), 1) - this.getSideGap();
            Rectangle rectangle = new Rectangle();
            Dimension dimension = this.getElementSize(false, true);
            this.calculateComponentPosition(this.getSelectedIndex(), n3, rectangle, dimension, this.getElementSize(true, true), true);
            int n4 = this.getAbsoluteX();
            int n5 = rectangle.getX();
            int n6 = this.getAbsoluteY();
            int n7 = rectangle.getY();
            int n8 = n - n4 - n5;
            int n9 = n2 - n6 - n7;
            component2.setX(0);
            component2.setY(0);
            if (component2 instanceof Container && (component = ((Container)component2).getComponentAt(n8, n9)) != null) {
                component2 = component;
            }
            component2.pointerPressed(n8, n9);
            component2.pointerReleased(n8, n9);
            this.fireActionEvent();
        }
    }

    public void pointerReleased(int n, int n2) {
        this.pointerReleasedImpl(n, n2, false);
    }

    protected Dimension calcPreferredSize() {
        Label label;
        if (this.shouldShowHint() && (label = this.getHintLabelImpl()) != null) {
            Dimension dimension = UIManager.getInstance().getLookAndFeel().getListPreferredSize(this);
            Dimension dimension2 = label.getPreferredSize();
            return new Dimension(dimension.getWidth() + dimension2.getWidth(), dimension.getHeight() + dimension2.getHeight());
        }
        return UIManager.getInstance().getLookAndFeel().getListPreferredSize(this);
    }

    public void addItem(Object object) {
        this.model.addItem(object);
    }

    public int getFixedSelection() {
        return this.fixedSelection;
    }

    public void setFixedSelection(int n) {
        this.fixedSelection = n;
    }

    void deregisterAnimatedInternal() {
        if (this.animationPosition == 0) {
            super.deregisterAnimatedInternal();
        }
    }

    public boolean animate() {
        boolean bl = super.animate();
        if (this.animationPosition != 0 && this.listMotion != null && !this.isDragActivated()) {
            this.animationPosition = this.animationPosition < 0 ? Math.min(this.listMotion.getValue() - this.destination, 0) : Math.max(this.destination - this.listMotion.getValue(), 0);
            if (this.animationPosition == 0) {
                this.listMotion = null;
                this.deregisterAnimatedInternal();
            }
            return true;
        }
        if (this.fixedDraggedMotion != null) {
            int n = -this.fixedDraggedMotion.getValue();
            this.fixedDraggedAnimationPosition -= this.fixedDraggedPosition - n;
            this.fixedDraggedPosition = n;
            Dimension dimension = this.getElementSize(false, true);
            int n2 = this.orientation == 0 ? dimension.getHeight() : dimension.getWidth();
            if (this.fixedDraggedAnimationPosition <= -n2) {
                ++this.fixedDraggedSelection;
                if (this.fixedDraggedSelection >= this.model.getSize()) {
                    this.fixedDraggedSelection = 0;
                }
                this.fixedDraggedPosition = n;
            } else if (this.fixedDraggedAnimationPosition >= n2) {
                --this.fixedDraggedSelection;
                if (this.fixedDraggedSelection < 0) {
                    this.fixedDraggedSelection = this.model.getSize() - 1;
                }
                this.fixedDraggedPosition = n;
            }
            this.fixedDraggedAnimationPosition %= n2;
            if (this.fixedDraggedMotion.isFinished()) {
                this.deregisterAnimatedInternal();
                if (this.fixedDraggedAnimationPosition != 0) {
                    this.destination = this.fixedDraggedAnimationPosition < 0 ? -this.fixedDraggedAnimationPosition : this.fixedDraggedAnimationPosition;
                    this.animationPosition = this.fixedDraggedAnimationPosition;
                    this.initListMotion();
                    this.fixedDraggedAnimationPosition = 0;
                }
                this.setSelectedIndex(this.fixedDraggedSelection);
                this.setDragActivated(false);
                this.fixedDraggedMotion = null;
            }
            return true;
        }
        return bl;
    }

    protected boolean isTactileTouch(int n, int n2) {
        int n3;
        return this.isTactileTouch() && (n3 = this.pointerSelect(n, n2)) > -1;
    }

    public void setScrollToSelected(boolean bl) {
        this.scrollToSelected = bl;
    }

    protected int getGridPosY() {
        int n = this.getElementSize(false, true).getHeight() + this.itemGap;
        int n2 = this.getScrollY();
        return this.calcGrid(n2, n);
    }

    private int calcGrid(int n, int n2) {
        int n3 = n % n2;
        if (Math.abs(n3 - n2) > 2) {
            if (n3 > n2 / 2) {
                return n + n2 - n3;
            }
            return n - n3;
        }
        return n;
    }

    protected int getGridPosX() {
        int n = this.getElementSize(false, true).getWidth() + this.itemGap;
        int n2 = this.getScrollX();
        return this.calcGrid(n2, n);
    }

    protected String paramString() {
        String string = "element size = ";
        if (this.elemSize != null) {
            string = string + this.elemSize.toString();
        }
        return super.paramString() + ", " + string + ", itemGap = " + this.itemGap + ", orientation = " + this.orientation + ", selected index = " + this.getSelectedIndex() + ", size = " + this.size();
    }

    public void setHint(String string) {
        super.setHint(string, this.getHintIcon());
    }

    public String getHint() {
        return super.getHint();
    }

    public void setHintIcon(Image image) {
        this.setHint(this.getHint(), image);
    }

    public Image getHintIcon() {
        return super.getHintIcon();
    }

    public void setHint(String string, Image image) {
        super.setHint(string, image);
    }

    Label getHintLabelImpl() {
        return this.hintLabel;
    }

    void setHintLabelImpl(Label label) {
        this.hintLabel = label;
    }

    boolean shouldShowHint() {
        return this.getModel().getSize() == 0;
    }

    private class Listeners
    implements DataChangedListener,
    SelectionListener {
        private Listeners() {
        }

        public void dataChanged(int n, int n2) {
            List.this.dataChanged(n, n2);
        }

        public void selectionChanged(int n, int n2) {
            List.this.repaint();
            List.this.listSelectionChanged(n, n2);
        }
    }
}

