/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.util;

import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Form;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.layouts.BorderLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class Log {
    public static final int DEBUG = 1;
    public static final int INFO = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    private int level = 1;
    private static Log instance = new Log();
    private long zeroTime = System.currentTimeMillis();
    private Writer output;
    private boolean fileWriteEnabled = false;
    private String fileURL = null;

    public static void install(Log log) {
        instance = log;
    }

    public static void p(String string) {
        Log.p(string, 1);
    }

    public static void p(String string, int n) {
        instance.print(string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void print(String string, int n) {
        if (this.level > n) {
            return;
        }
        string = this.getThreadAndTimeStamp() + " - " + string;
        System.out.println(string);
        if (this.isFileWriteEnabled()) {
            try {
                Log log = this;
                synchronized (log) {
                    Writer writer = this.getWriter();
                    writer.write(string + "\n");
                    writer.close();
                    this.output = null;
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.setFileWriteEnabled(false);
            }
        } else {
            try {
                Log log = this;
                synchronized (log) {
                    RecordStore recordStore = RecordStore.openRecordStore((String)"log", (boolean)true);
                    byte[] byArray = string.getBytes();
                    recordStore.addRecord(byArray, 0, byArray.length);
                    recordStore.closeRecordStore();
                }
            }
            catch (RecordStoreException recordStoreException) {
                recordStoreException.printStackTrace();
            }
        }
    }

    protected Writer createWriter() throws IOException {
        try {
            FileConnection fileConnection;
            if (instance.getFileURL() == null) {
                instance.setFileURL("file:///" + FileSystemRegistry.listRoots().nextElement() + "/lwuit.log");
            }
            if ((fileConnection = (FileConnection)Connector.open((String)instance.getFileURL(), (int)3)).exists()) {
                return new OutputStreamWriter(fileConnection.openOutputStream(fileConnection.fileSize()));
            }
            fileConnection.create();
            return new OutputStreamWriter(fileConnection.openOutputStream());
        }
        catch (Exception exception) {
            this.setFileWriteEnabled(false);
            return new OutputStreamWriter(new ByteArrayOutputStream());
        }
    }

    private Writer getWriter() throws IOException {
        if (this.output == null) {
            this.output = this.createWriter();
        }
        return this.output;
    }

    protected String getThreadAndTimeStamp() {
        long l = System.currentTimeMillis() - this.zeroTime;
        long l2 = l % 1000L;
        long l3 = (l /= 1000L) % 60L;
        long l4 = (l /= 60L) % 60L;
        long l5 = (l /= 60L) % 60L;
        return "[" + Thread.currentThread().getName() + "] " + l5 + ":" + l4 + ":" + l3 + "," + l2;
    }

    public static void setLevel(int n) {
        Log.instance.level = n;
    }

    public static int getLevel() {
        return Log.instance.level;
    }

    public static String getLogContent() {
        try {
            String string = "";
            if (instance.isFileWriteEnabled()) {
                if (instance.getFileURL() == null) {
                    instance.setFileURL("file:///" + FileSystemRegistry.listRoots().nextElement() + "/lwuit.log");
                }
                FileConnection fileConnection = (FileConnection)Connector.open((String)instance.getFileURL(), (int)1);
                InputStreamReader inputStreamReader = new InputStreamReader(fileConnection.openInputStream());
                char[] cArray = new char[1024];
                int n = inputStreamReader.read(cArray);
                while (n > -1) {
                    string = string + new String(cArray, 0, n);
                    n = inputStreamReader.read(cArray);
                }
                ((Reader)inputStreamReader).close();
            } else {
                RecordStore recordStore = RecordStore.openRecordStore((String)"log", (boolean)true);
                int n = recordStore.getNumRecords();
                for (int i = 1; i <= n; ++i) {
                    string = string + new String(recordStore.getRecord(i));
                }
                recordStore.closeRecordStore();
            }
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static void showLog() {
        try {
            String string = Log.getLogContent();
            TextArea textArea = new TextArea(string, 5, 20);
            Form form = new Form("Log");
            form.setScrollable(false);
            final Form form2 = Display.getInstance().getCurrent();
            Command command = new Command("Back"){

                public void actionPerformed(ActionEvent actionEvent) {
                    form2.show();
                }
            };
            form.addCommand(command);
            form.setBackCommand(command);
            form.setLayout(new BorderLayout());
            form.addComponent("Center", (Component)textArea);
            form.show();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static Log getInstance() {
        return instance;
    }

    public boolean isFileWriteEnabled() {
        return this.fileWriteEnabled;
    }

    public void setFileWriteEnabled(boolean bl) {
        this.fileWriteEnabled = bl;
    }

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String string) {
        this.fileURL = string;
    }
}

