/*
 * Decompiled with CFR 0.152.
 */
package core;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Command;
import com.sun.lwuit.Component;
import com.sun.lwuit.Container;
import com.sun.lwuit.Form;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.RadioButton;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.TextField;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.layouts.BoxLayout;
import com.sun.lwuit.layouts.FlowLayout;
import core.ListModel;
import framework.Common;
import framework.Network;
import framework.NetworkListener;
import framework.XMLParser;

public class ProfileManager
implements ActionListener,
NetworkListener {
    public Form frmProfile;
    Form frmFindPeople;
    Form frmEditProfile;
    private TextField txtPersonName;
    TextField txtProfileName;
    TextField txtProfileCity;
    TextField txtProfileBorn;
    TextArea txtBio;
    Command cmdUpdateProfile;
    Command cmdEditProfile;
    Command cmdAddAsFriend;
    Command cmdBack;
    Command cmdViewProfile;
    RadioButton radSignupMale;
    RadioButton radSignupFemale;
    ButtonGroup btnGroupSignup;
    Button btnFind;
    Button btnAddAsFriend;
    XMLParser _xmlParser;
    Common _common;
    Object _prevList;
    int _userID;
    int _operation = -1;
    static int SAVE_PROFILE = 1;
    static int FIND_PEOPLE = 2;
    static int ADD_FRIEND = 3;
    static int VIEW_PROFILE = 4;
    ListModel _listModel;

    public ProfileManager(Common common) {
        this._common = common;
        this._listModel = new ListModel(common);
        this.cmdBack = new Command("Back");
    }

    public void onDataReceived(String string) {
        this._common.hideProgress();
        if (this._operation == FIND_PEOPLE) {
            this._listModel.buildList(string, "uid", "name", "extra", false);
            if (this._listModel.getList() == null) {
                this._common.showDialog("Unable to show the list, try again", 0);
                return;
            }
            if (this._prevList != null) {
                this.frmFindPeople.removeComponent((Component)this._prevList);
            }
            this._prevList = this._listModel.getList();
            this._common.debug("Total list items:" + this._listModel.getList().getModel().getSize());
            this.frmFindPeople.addComponent(this._listModel.getList());
            this.cmdAddAsFriend = new Command("Add as Friend");
            this.frmFindPeople.addCommand(this.cmdAddAsFriend);
            this.cmdViewProfile = new Command("View Profile");
            this.frmFindPeople.addCommand(this.cmdViewProfile);
            this._common.showForm(this.frmFindPeople);
        } else if (this._operation == VIEW_PROFILE) {
            if (string == null || string.indexOf("<err>") != -1) {
                this._common.showDialog(string, 0);
                return;
            }
            this._xmlParser = XMLParser.parse(string);
            String string2 = this._xmlParser.getTagValue("name");
            String string3 = this._xmlParser.getTagValue("photo");
            String string4 = this._xmlParser.getTagValue("loc");
            String string5 = this._xmlParser.getTagValue("gender");
            String string6 = this._xmlParser.getTagValue("about");
            string6 = this._xmlParser.getTagValue("bio");
            if (string6 == null) {
                string6 = "Bio not available currently";
            }
            Label label = null;
            Image image = Network.getImage(Common._baseURL + string3);
            label = image == null ? new Label("Photo not loaded") : new Label(image);
            this.frmProfile = new Form(string2 + " Profile");
            this.frmProfile.setLayout(new BoxLayout(2));
            Container container = new Container();
            container.setLayout(new FlowLayout());
            container.addComponent(label);
            Container container2 = new Container();
            container2.setLayout(new BoxLayout(2));
            container2.addComponent(new Label(string2));
            container2.addComponent(new Label(string5));
            container2.addComponent(new Label(string4));
            container.addComponent(container2);
            this.frmProfile.addComponent(container);
            this.frmProfile.addComponent(new Label(string6));
            if (this._userID != -1) {
                this.btnAddAsFriend = new Button("Add as Friend");
                this.btnAddAsFriend.getUnselectedStyle().setAlignment(4);
                this.btnAddAsFriend.getSelectedStyle().setAlignment(4);
                this.btnAddAsFriend.getPressedStyle().setAlignment(4);
                this.frmProfile.addComponent(this.btnAddAsFriend);
            } else if (this._userID == -1) {
                this.cmdEditProfile = new Command("Edit");
                this.frmProfile.addCommand(this.cmdEditProfile);
            } else {
                this.frmProfile.addCommand(new Command(""));
            }
            this.frmProfile.addCommand(this.cmdBack);
            this.frmProfile.addCommandListener(this);
            this._common.showForm(this.frmProfile);
        }
    }

    public void onNetworkError(String string) {
        this._common.hideProgress();
        this._common.showDialog("Network error", 0);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdUpdateProfile) {
            this._operation = SAVE_PROFILE;
            this._common.showProgress();
            Network.post2(Common._baseURL + "m_editprofile.php", "name=" + this.txtProfileName.getText() + "&gender=" + (this.btnGroupSignup.getSelectedIndex() + 1) + "&year=" + this.txtProfileBorn.getText() + "&city=" + this.txtProfileCity.getText() + "&bio=" + this.txtBio.getText(), false, (NetworkListener)this);
            this._common.hideProgress();
            this._common.showDialog("Profile Updated", 0);
        } else if (actionEvent.getSource() == this.btnFind) {
            this._operation = FIND_PEOPLE;
            this._common.showProgress();
            this._listModel.fetchList("m_results.php?query=" + this.txtPersonName.getText(), "uid", "name", "extra", false, this);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdEditProfile) {
            this.showEditProfile();
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdViewProfile) {
            String string = this._listModel.getSelectedItemID();
            if (string == null) {
                return;
            }
            try {
                int n = Integer.parseInt(string);
                this.showProfilePage(n);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (actionEvent.getSource() == this.btnAddAsFriend) {
            this._operation = ADD_FRIEND;
            this._common.showProgress();
            Network.get2(Common._baseURL + "m_results.php?addperson=1&targetuid=" + this._userID, false, this);
            this._common.hideProgress();
            this._common.showDialog("Approval Pending", 0);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand() == this.cmdAddAsFriend) {
            String string = this._listModel.getSelectedItemID();
            if (string == null) {
                this._common.showDialog("Unable to send invitation, try again", 0);
                return;
            }
            this._operation = ADD_FRIEND;
            this._common.showProgress();
            Network.get2(Common._baseURL + "m_results.php?addperson=1&targetuid=" + string, false, this);
            this._common.hideProgress();
            this._common.showDialog("Approval Pending", 0);
        } else if (actionEvent.getCommand() != null && actionEvent.getCommand().getCommandName().equals("Back")) {
            this._common.showPreviousScreen();
        }
    }

    public void showFindPeople() {
        this.frmFindPeople = new Form("Find People");
        this.frmFindPeople.setLayout(new BoxLayout(2));
        this.frmFindPeople.addComponent(new Label("Type some name"));
        this.txtPersonName = new TextField();
        this.txtPersonName.setConstraint(0);
        this.frmFindPeople.addComponent(this.txtPersonName);
        this.btnFind = new Button("Search");
        this.btnFind.getStyle().setAlignment(4);
        this.btnFind.getSelectedStyle().setAlignment(4);
        this.btnFind.getPressedStyle().setAlignment(4);
        this.btnFind.addActionListener(this);
        this.frmFindPeople.addComponent(this.btnFind);
        this.frmFindPeople.addCommand(new Command(""));
        this.frmFindPeople.addCommand(this.cmdBack);
        this.frmFindPeople.addCommandListener(this);
        this._common.showForm(this.frmFindPeople);
    }

    public void showProfilePage(int n) {
        this._userID = n;
        String string = "m_viewprofile.php";
        if (n != -1) {
            string = string + "?uid=" + n;
        }
        this._operation = VIEW_PROFILE;
        this._common.showProgress();
        Network.get2(Common._baseURL + string, true, this);
    }

    public void showEditProfile() {
        this.txtProfileName = new TextField();
        this.txtProfileCity = new TextField();
        this.txtProfileBorn = new TextField();
        this.txtBio = new TextArea(3, 40);
        this.txtProfileName.setConstraint(0);
        this.txtProfileCity.setConstraint(0);
        this.txtProfileBorn.setConstraint(2);
        this.txtBio.setConstraint(0);
        this.radSignupMale = new RadioButton("Male");
        this.radSignupMale.setSelected(true);
        this.radSignupFemale = new RadioButton("Female");
        this.btnGroupSignup = new ButtonGroup();
        this.btnGroupSignup.add(this.radSignupMale);
        this.btnGroupSignup.add(this.radSignupFemale);
        this.frmEditProfile = new Form("Edit Profile");
        this.frmEditProfile.setLayout(new BoxLayout(2));
        this.frmEditProfile.addComponent(new Label("Name:"));
        this.frmEditProfile.addComponent(this.txtProfileName);
        this.frmEditProfile.addComponent(new Label("City:"));
        this.frmEditProfile.addComponent(this.txtProfileCity);
        this.frmEditProfile.addComponent(new Label("Birth Year:"));
        this.frmEditProfile.addComponent(this.txtProfileBorn);
        this.frmEditProfile.addComponent(new Label("Gender:"));
        this.frmEditProfile.addComponent(this.radSignupMale);
        this.frmEditProfile.addComponent(this.radSignupFemale);
        this.frmEditProfile.addComponent(new Label("Your Bio:"));
        this.frmEditProfile.addComponent(this.txtBio);
        this.cmdUpdateProfile = new Command("Update");
        this.frmEditProfile.addCommandListener(this);
        this.frmEditProfile.addCommand(this.cmdUpdateProfile);
        this.frmEditProfile.addCommand(this.cmdBack);
        this._common.showForm(this.frmEditProfile);
    }
}

