/*
 * Decompiled with CFR 0.152.
 */
package Main;

import Main.ControlManager;
import Main.ScreenDisplay;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class Calculator
extends Canvas {
    protected int w;
    protected int h;
    protected int backW;
    protected int backH;
    protected int backX;
    protected int backY;
    protected int iW;
    protected int iH;
    protected int iXMin;
    protected int iYMin;
    protected int[] iX = new int[48];
    protected int[] iY = new int[48];
    protected String[] sym = new String[]{"T(", "^(-1)", "^2", "^3", "^(", "R(", ")Q(", "sin(", "cos(", "tan(", "|", "x10^(", "asin(", "acos(", "atan(", "", "", "log(", "ln(", "e^(", "(", ")", "abs(", "", "", "7", "8", "9", "", "", "4", "5", "6", "x", "/", "1", "2", "3", "+", "-", "0", ".", "?", "-", "", "", ""};
    protected byte[] spacing = new byte[]{2, 5, 2, 2, 2, 2, 3, 4, 4, 4, 1, 5, 5, 5, 5, 0, 0, 4, 3, 3, 1, 1, 4, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0};
    protected boolean highlight = false;
    protected boolean busy = false;
    protected boolean store = false;
    protected boolean recall = false;
    protected boolean hyp = false;
    protected Font font = Font.getFont((int)32, (int)0, (int)8);
    protected Image back = null;
    protected Image back2 = null;
    protected Image back3 = null;
    protected Image blur = null;
    protected Image rev = null;
    protected Image forw = null;
    protected Image prev = null;
    protected Image[] prevImg = new Image[65];
    protected double d = 0.0;
    protected double xD = 0.0;
    protected double yD = 0.0;
    protected double lenght1 = 90000.0;
    protected byte selIcon = 0;
    MIDlet mainMid = null;
    ControlManager controls = null;
    ScreenDisplay myDigits = null;

    public Calculator(MIDlet mainMidIN) {
        this.setFullScreenMode(true);
        this.mainMid = mainMidIN;
        this.myDigits = new ScreenDisplay();
        this.controls = new ControlManager();
        this.loadImages();
        this.getInfo();
    }

    public void loadImages() {
        try {
            this.back = Image.createImage((String)"/Images/ClaculaterBack.PNG");
            this.back2 = Image.createImage((String)"/Images/ClaculaterBack2.PNG");
            this.back3 = Image.createImage((String)"/Images/ClaculaterBack3.PNG");
            this.blur = Image.createImage((String)"/Images/Blur2.PNG");
            this.rev = Image.createImage((String)"/Images/Rev.PNG");
            this.forw = Image.createImage((String)"/Images/Forw.PNG");
            this.prev = Image.createImage((String)"/Images/Prev.PNG");
            int prevC = 0;
            int prevW = 64;
            int prevH = 57;
            int prevX = -prevW;
            int prevY = -prevH;
            int[] prevInfo = new int[(prevH + 1) * (prevW + 1)];
            for (int i = 0; i < 12; ++i) {
                prevX = -prevW;
                prevY += prevH;
                int j = 0;
                while (j < 5 & prevC < 65) {
                    this.prev.getRGB(prevInfo, 0, prevW + 1, (prevX += prevW) + j, prevY + i, prevW + 1, prevH + 1);
                    this.prevImg[prevC] = Image.createRGBImage((int[])prevInfo, (int)(prevW + 1), (int)(prevH + 1), (boolean)false);
                    ++prevC;
                    ++j;
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void getInfo() {
        this.w = this.getWidth();
        this.h = this.getHeight();
        int hash = 35;
        String info = "";
        int count = 0;
        int countX = 0;
        int countY = 0;
        try {
            int in;
            InputStream fis = ((Object)((Object)this)).getClass().getResourceAsStream("/Info/Calculater.txt");
            while ((in = fis.read()) != -1) {
                if (in != hash) {
                    info = info + (char)in;
                    continue;
                }
                if (count == 0) {
                    this.backW = Integer.parseInt(info);
                    this.backX = (int)((double)(this.w - this.backW) / 2.0);
                } else if (count == 1) {
                    this.backH = Integer.parseInt(info);
                    this.backY = (int)((double)(this.h - this.backH) / 2.0);
                } else if (count == 2) {
                    this.iW = Integer.parseInt(info);
                } else if (count == 3) {
                    this.iH = Integer.parseInt(info);
                } else if (count % 2 == 0) {
                    this.iX[countX] = Integer.parseInt(info) + this.backX;
                    ++countX;
                } else {
                    this.iY[countY] = Integer.parseInt(info) + this.backY;
                    ++countY;
                }
                info = "";
                ++count;
            }
            this.iXMin = (int)((double)this.iW / 2.0) + 1;
            this.iYMin = (int)((double)this.iH / 2.0) + 1;
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void pointerPressed(int x, int y) {
        this.lenght1 = 90000.0;
        this.busy = true;
        for (int i = 0; i < 48; i = (int)((byte)(i + 1))) {
            this.xD = this.iX[i] - x;
            this.yD = this.iY[i] - y;
            this.d = Math.sqrt(this.xD * this.xD + this.yD * this.yD);
            if (!(this.d < this.lenght1)) continue;
            this.lenght1 = this.d;
            this.selIcon = (byte)i;
        }
        this.highlight = true;
        this.repaint();
    }

    protected void pointerDragged(int x, int y) {
        this.lenght1 = 90000.0;
        this.busy = true;
        for (int i = 0; i < 48; i = (int)((byte)(i + 1))) {
            this.xD = this.iX[i] - x;
            this.yD = this.iY[i] - y;
            this.d = Math.sqrt(this.xD * this.xD + this.yD * this.yD);
            if (!(this.d < this.lenght1)) continue;
            this.lenght1 = this.d;
            this.selIcon = (byte)i;
        }
        this.highlight = true;
        this.repaint();
    }

    protected void pointerReleased(int x, int y) {
        if (!this.store & !this.recall & !this.hyp) {
            if (this.selIcon == 23) {
                this.controls.nextDRG();
            } else if (this.selIcon == 47) {
                this.mainMid.notifyDestroyed();
            } else if (this.selIcon == 29) {
                this.controls.clearAll();
            } else if (this.selIcon == 46) {
                this.controls.moveRight();
            } else if (this.selIcon == 45) {
                this.controls.moveLeft();
            } else if (this.selIcon == 44 & this.controls.lengthFun > 1) {
                this.controls.calculateAnsw();
            } else if (this.selIcon == 28) {
                this.controls.deleteSymbol();
            } else if (this.selIcon == 15) {
                this.store = true;
            } else if (this.selIcon == 16) {
                this.recall = true;
            } else if (this.selIcon == 24) {
                this.hyp = true;
            } else {
                this.controls.addSymbol(this.sym[this.selIcon], this.spacing[this.selIcon]);
            }
        } else if (this.store) {
            this.controls.storeAns(this.selIcon);
            this.store = false;
        } else if (this.recall) {
            this.controls.recallAns(this.selIcon);
            this.recall = false;
        } else if (this.hyp) {
            this.controls.addHyp(this.selIcon, this.sym[this.selIcon]);
            this.hyp = false;
        }
        this.highlight = false;
        this.busy = false;
        this.repaint();
    }

    protected void paint(Graphics g) {
        int move = 0;
        int sel = 0;
        g.setColor(0, 0, 0);
        g.fillRect(0, 0, 1000, 1000);
        if (this.store | this.recall) {
            g.drawImage(this.back2, this.backX, this.backY, 20);
        } else if (this.hyp) {
            g.drawImage(this.back3, this.backX, this.backY, 20);
        } else {
            g.drawImage(this.back, this.backX, this.backY, 20);
        }
        if (this.controls.indexStart > 0) {
            g.drawImage(this.rev, 20, 28, 20);
        }
        if (this.controls.indexStop < this.controls.lengthFun & this.controls.lengthFun > 25) {
            g.drawImage(this.forw, 320, 28, 20);
        }
        g.setColor(255, 255, 255);
        g.setFont(this.font);
        for (int i = 0; i < this.controls.print.length(); ++i) {
            sel = this.myDigits.getImgKey(this.controls.print.charAt(i));
            g.drawImage(this.myDigits.img[sel], 35 + move, 18, 20);
            move += this.myDigits.wid[sel];
        }
        g.drawString(this.controls.answ, 35, 60, 20);
        g.setColor(128, 128, 128);
        g.drawString(this.controls.DRGSym, 300, 60, 20);
        if (this.highlight) {
            g.drawImage(this.blur, this.iX[this.selIcon] - this.iXMin, this.iY[this.selIcon] - this.iYMin, 20);
            if ((this.store | this.recall) & this.selIcon >= 17 & this.selIcon <= 24) {
                g.drawImage(this.prevImg[this.selIcon + 31], this.iX[this.selIcon] - 32, this.iY[this.selIcon] - 82, 20);
            } else if (this.hyp & (this.selIcon >= 7 & this.selIcon <= 9 | this.selIcon >= 12 & this.selIcon <= 14)) {
                g.drawImage(this.prevImg[this.selIcon], this.iX[this.selIcon] - 32, this.iY[this.selIcon] - 82, 20);
            } else if (!this.store & !this.recall & !this.hyp) {
                if (this.selIcon >= 0 & this.selIcon <= 24) {
                    g.drawImage(this.prevImg[this.selIcon], this.iX[this.selIcon] - 32, this.iY[this.selIcon] - 82, 20);
                } else {
                    g.drawImage(this.prevImg[this.selIcon], this.iX[this.selIcon] - 32, this.iY[this.selIcon] - 86, 20);
                }
            }
        }
    }

    public void run() {
    }
}

