/*
 * Decompiled with CFR 0.152.
 */
package bars;

import bars.BarsMIDlet;
import java.io.IOException;
import java.io.InputStream;

public abstract class BarsVolumeCalculator {
    private BarsMIDlet midlet;
    private int[] vol;
    private boolean outOfMesh;
    private boolean success;
    private long v;

    public BarsVolumeCalculator(BarsMIDlet midlet) {
        this.midlet = midlet;
        this.vol = new int[this.GetLengthFragmentationSize()];
        this.success = false;
    }

    public boolean VolumeIsCalculated() {
        return this.success;
    }

    public long GetVolume() {
        return this.v;
    }

    public String GetVolumeAsString() {
        return BarsVolumeCalculator.GetAsString(this.v, 10);
    }

    public void CalcVolume(int d, int l, int q) {
        int j;
        int i;
        this.outOfMesh = false;
        this.success = false;
        for (i = 0; i < this.GetDiameterFragmentationSize() - 1 && this.GetDiameter(i) < d; ++i) {
        }
        if (i == 0 && d < this.GetMinDiameter()) {
            this.outOfMesh = true;
        }
        if (i == this.GetDiameterFragmentationSize() - 1 && this.GetMaxDiameter() < d) {
            this.outOfMesh = true;
        }
        for (j = 0; j < this.GetLengthFragmentationSize() - 1 && this.GetLength(j) < l; ++j) {
        }
        if (j == 0 && l < this.GetMinLength()) {
            this.outOfMesh = true;
        }
        if (j == this.GetLengthFragmentationSize() - 1 && this.GetMaxLength() < l) {
            this.outOfMesh = true;
        }
        if (!this.outOfMesh) {
            if (this.GetDiameter(i) == d) {
                this.LoadVolumes(i + 1);
                if (this.GetLength(j) == l) {
                    this.v = this.vol[j];
                    if (this.v == 0L) {
                        return;
                    }
                    this.v = 1000000L * this.v;
                } else {
                    if (this.vol[j] == 0 || this.vol[j - 1] == 0) {
                        return;
                    }
                    long a = (l - this.GetLength(j - 1)) * (this.vol[j] - this.vol[j - 1]);
                    long b = this.vol[j - 1];
                    this.v = 1000000L * a / (long)(this.GetLength(j) - this.GetLength(j - 1)) + 1000000L * b;
                }
            } else if (this.GetLength(j) == l) {
                this.LoadVolumes(i);
                long v0 = this.vol[j];
                this.LoadVolumes(i + 1);
                long v1 = this.vol[j];
                if (v0 == 0L || v1 == 0L) {
                    return;
                }
                long a = (long)(d - this.GetDiameter(i - 1)) * (v1 - v0);
                this.v = 1000000L * a / (long)(this.GetDiameter(i) - this.GetDiameter(i - 1)) + 1000000L * v0;
            } else {
                this.LoadVolumes(i);
                long v00 = this.vol[j - 1];
                v00 = (long)((d - this.GetDiameter(i)) * (l - this.GetLength(j))) * v00;
                long v01 = this.vol[j];
                v01 = (long)((this.GetDiameter(i) - d) * (l - this.GetLength(j - 1))) * v01;
                this.LoadVolumes(i + 1);
                long v10 = this.vol[j - 1];
                v10 = (long)((d - this.GetDiameter(i - 1)) * (this.GetLength(j) - l)) * v10;
                long v11 = this.vol[j];
                if (v00 == 0L || v01 == 0L || v10 == 0L || v11 == 0L) {
                    return;
                }
                v11 = (long)((d - this.GetDiameter(i - 1)) * (l - this.GetLength(j - 1))) * v11;
                this.v = 1000000L * (v11 + v00 + v10 + v01) / (long)((this.GetDiameter(i) - this.GetDiameter(i - 1)) * (this.GetLength(j) - this.GetLength(j - 1)));
            }
            this.v *= (long)q;
            this.success = true;
        }
    }

    private void LoadVolumes(int n) {
        String resName = "/res/" + this.GetResourcePrefix() + Integer.toString(n) + ".bin";
        InputStream is = ((Object)((Object)this.midlet)).getClass().getResourceAsStream(resName);
        if (is != null) {
            long total = 0L;
            try {
                total = is.available();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            if (total == (long)(4 * this.GetLengthFragmentationSize())) {
                byte[] buf = new byte[4];
                for (int i = 0; i < this.GetLengthFragmentationSize(); ++i) {
                    try {
                        is.read(buf, 0, 4);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    this.vol[i] = (buf[3] & 0xFF) << 24 | (buf[2] & 0xFF) << 16 | (buf[1] & 0xFF) << 8 | buf[0] & 0xFF;
                }
            }
            try {
                is.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static String GetAsString(long v, int orders) {
        String sv = Long.toString(v);
        if (sv.length() <= orders) {
            while (sv.length() < orders) {
                sv = "0".concat(sv);
            }
            sv = "0.".concat(sv);
        } else {
            String m = sv.substring(0, sv.length() - orders);
            String n = sv.substring(sv.length() - orders);
            sv = m.concat(".".concat(n));
        }
        while (sv.length() > 0 && sv.charAt(sv.length() - 1) == '0') {
            sv = sv.substring(0, sv.length() - 1);
        }
        if (sv.length() > 0 && sv.charAt(sv.length() - 1) == '.') {
            sv = sv.substring(0, sv.length() - 1);
        }
        return sv;
    }

    public abstract int GetDiameterFragmentationSize();

    public abstract int GetMinDiameter();

    public abstract int GetMaxDiameter();

    public abstract int GetDiameter(int var1);

    public abstract int GetLengthFragmentationSize();

    public abstract int GetMinLength();

    public abstract int GetMaxLength();

    public abstract int GetLength(int var1);

    public abstract String GetResourcePrefix();
}

