/*
 * Decompiled with CFR 0.152.
 */
package net.sf.zipme;

import java.io.IOException;
import java.io.OutputStream;
import net.sf.zipme.Deflater;

public class DeflaterOutputStream
extends OutputStream {
    protected OutputStream out;
    protected byte[] buf;
    protected Deflater def;

    protected void deflate() throws IOException {
        int len;
        while (!this.def.needsInput() && (len = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, len);
        }
        if (!this.def.needsInput()) {
            throw new Error("Can't deflate all input?");
        }
    }

    public DeflaterOutputStream(OutputStream out) {
        this(out, new Deflater(), 4096);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl) {
        this(out, defl, 4096);
    }

    public DeflaterOutputStream(OutputStream out, Deflater defl, int bufsize) {
        this.out = out;
        if (bufsize <= 0) {
            throw new IllegalArgumentException("bufsize <= 0");
        }
        this.buf = new byte[bufsize];
        this.def = defl;
    }

    public void flush() throws IOException {
        this.def.flush();
        this.deflate();
        this.out.flush();
    }

    public void finish() throws IOException {
        int len;
        this.def.finish();
        while (!this.def.finished() && (len = this.def.deflate(this.buf, 0, this.buf.length)) > 0) {
            this.out.write(this.buf, 0, len);
        }
        if (!this.def.finished()) {
            throw new Error("Can't deflate all input?");
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.finish();
        this.out.close();
    }

    public void write(int bval) throws IOException {
        byte[] b = new byte[]{(byte)bval};
        this.write(b, 0, 1);
    }

    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) throws IOException {
        this.def.setInput(buf, off, len);
        this.deflate();
    }
}

