/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Command;
import com.sun.lwuit.Display;
import com.sun.lwuit.EventDispatcher;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.UIManager;

public class Button
extends Label {
    public static final int STATE_ROLLOVER = 0;
    public static final int STATE_PRESSED = 1;
    public static final int STATE_DEFAULT = 2;
    private static String id = "Button";
    private EventDispatcher dispatcher = new EventDispatcher();
    private int state = 2;
    private Image pressedIcon;
    private Image rolloverIcon;
    private Command cmd;

    public Button() {
        this("");
    }

    public Button(String text) {
        this(text, (Image)null);
    }

    public Button(Command cmd) {
        this(cmd.getCommandName(), cmd.getIcon());
        this.addActionListener(cmd);
        this.cmd = cmd;
    }

    public Button(Image icon) {
        this("", icon);
    }

    public Button(String text, Image icon) {
        super(text);
        this.setFocusable(true);
        this.setIcon(icon);
        this.pressedIcon = icon;
        this.rolloverIcon = icon;
    }

    void focusGainedInternal() {
        this.state = 0;
    }

    void focusLostInternal() {
        this.state = 2;
    }

    protected String getUIID() {
        return id;
    }

    public int getState() {
        return this.state;
    }

    public Image getPressedIcon() {
        return this.pressedIcon;
    }

    public Image getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Image rolloverIcon) {
        this.rolloverIcon = rolloverIcon;
        this.setShouldCalcPreferredSize(true);
        this.repaint();
    }

    public void setPressedIcon(Image pressedIcon) {
        this.pressedIcon = pressedIcon;
        this.setShouldCalcPreferredSize(true);
        this.repaint();
    }

    public void addActionListener(ActionListener l) {
        this.dispatcher.addListener(l);
    }

    public void removeActionListener(ActionListener l) {
        this.dispatcher.removeListener(l);
    }

    void fireActionEvent() {
        super.fireActionEvent();
        if (this.cmd != null) {
            this.dispatcher.fireActionEvent(new ActionEvent(this.cmd));
        } else {
            this.dispatcher.fireActionEvent(new ActionEvent(this));
        }
    }

    void pressed() {
        if (this.isEnabled()) {
            this.state = 1;
            this.repaint();
        }
    }

    void released() {
        if (this.isEnabled()) {
            this.state = 0;
            this.repaint();
            this.fireActionEvent();
        }
    }

    public void keyPressed(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.pressed();
        }
    }

    public void keyReleased(int keyCode) {
        if (Display.getInstance().getGameAction(keyCode) == 8) {
            this.released();
        }
    }

    protected void fireClicked() {
        this.pressed();
        this.released();
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    public void pointerPressed(int x, int y) {
        this.pressed();
    }

    public void pointerReleased(int x, int y) {
        this.released();
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawButton(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getButtonPreferredSize(this);
    }

    protected Border getBorder() {
        if (this.getState() != 1) {
            return super.getBorder();
        }
        return this.getStyle().getBorder().createPressedVersion();
    }
}

