/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Dimension;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class MediaComponent
extends Component {
    private Player player;
    private VideoControl vidc;
    private boolean fullscreen = false;

    public MediaComponent(Player player) {
        this.player = player;
        this.setFocusable(false);
        if (player.getState() < 200) {
            throw new IllegalArgumentException("player must be in a realized state");
        }
        this.vidc = (VideoControl)Display.getInstance().getVideoControl(player);
    }

    protected void initComponent() {
        this.getComponentForm().registerMediaComponent(this);
    }

    protected void deinitialize() {
        this.getComponentForm().deregisterMediaComponent(this);
    }

    public void paint(Graphics g) {
        this.updateScreen(this.fullscreen);
    }

    protected void paintBackground(Graphics g) {
    }

    public void paintBackgrounds(Graphics g) {
    }

    protected Dimension calcPreferredSize() {
        return new Dimension(this.vidc.getSourceWidth(), this.vidc.getSourceHeight());
    }

    public void setVisible(boolean visible) {
        if (this.vidc != null) {
            this.vidc.setVisible(visible);
        }
    }

    public void start() {
        try {
            this.vidc.setVisible(true);
            this.player.start();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.player.stop();
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }

    public void setLoopCount(int count) {
        this.player.setLoopCount(count);
    }

    public long getMediaTime() {
        return this.player.getMediaTime();
    }

    public long setMediaTime(long now) throws MediaException {
        return this.player.setMediaTime(now);
    }

    public void setFullScreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
        this.repaint();
    }

    private void updateScreen(boolean fullscreen) {
        try {
            if (fullscreen) {
                this.vidc.setDisplayLocation(0, 0);
                this.vidc.setDisplaySize(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
            } else {
                this.vidc.setDisplayLocation(this.getAbsoluteX(), this.getAbsoluteY());
                int w = this.getWidth();
                int h = this.getHeight();
                if (this.vidc.getDisplayWidth() != w || this.vidc.getDisplayHeight() != h) {
                    this.vidc.setDisplaySize(w, h);
                }
            }
        }
        catch (MediaException ex) {
            ex.printStackTrace();
        }
    }
}

