/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.ButtonGroup;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.plaf.UIManager;

public class RadioButton
extends Button {
    private static final String id = "RadioButton";
    private boolean selected = false;
    private ButtonGroup group;

    public RadioButton(String text) {
        this(text, (Image)null);
    }

    public RadioButton() {
        this("");
    }

    public RadioButton(Image icon) {
        this("", icon);
    }

    public RadioButton(String text, Image icon) {
        super(text, icon);
    }

    public String toString() {
        return "Radio Button " + this.getText();
    }

    protected String getUIID() {
        return id;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.repaint();
    }

    void released() {
        if (!this.isSelected()) {
            this.setSelected(true);
        }
        super.released();
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawRadioButton(g, this);
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getRadioButtonPreferredSize(this);
    }

    void setGroup(ButtonGroup group) {
        this.group = group;
    }

    void fireActionEvent() {
        if (this.group != null) {
            this.group.setSelected(this);
        }
        super.fireActionEvent();
    }
}

