// ==UserScript==
// @name        MusicFond helper for Opera 8 - 9
// @version     2.01
// @date        2008-04-07
// @author      Mike Samokhvalov <mikivanch@gmail.com>
// @download    http://www.puzzleclub.ru/files/musicfond_com.js
// @include     http://musicfond.com/*
// ==/UserScript==

(function(){
  ///////////////////////////////////////////////////////////////////
  // SETTINGS

  var autoGetDownloadLinks = false;
  var getExactMP3Links = false;

  ///////////////////////////////////////////////////////////////////
  // DO NOT EDIT

  var submitValue = '&#1055;&#1086;&#1083;&#1091;&#1095;&#1080;&#1090;&#1100;&#32;&#1089;&#1089;&#1099;&#1083;&#1082;&#1091;&#33;';  
  
  var count = 0;
  function addStyle(css)
  {
    if(!document || !document.documentElement)
    {
      if(count < 500)
      {
        setTimeout(addStyle, 25, css);
        count++;
      }
      return;
    }
      
    var s = document.createElement('style');
    s.setAttribute('type', 'text/css');
    s.setAttribute('style', 'display:none !important;');			
    s.appendChild(document.createTextNode(css));
    document.documentElement.appendChild(s); 
  };
  
  window.opera.addEventListener('BeforeExternalScript', function (e) {      
    var src = e.element.getAttribute('src', false);
    if(src.indexOf('http://readme.ru/') != -1)
      e.preventDefault();
    else if(src.indexOf('http://js.redtram.com/') != -1)
      e.preventDefault();
      
    autoClickButton();
  }, false);
    
  window.opera.addEventListener('BeforeScript', function(e){
    var t = e.element.text;
    if(t.search(/document\.write\x28(?:\s+)?[\x22\x27]?(?:<table|<iframe|<img|<a|<sc)/i) != -1)  
    {    
      e.preventDefault();
    }
    autoClickButton();
  }, false);
  
  function createDownloadButtons()
  {
    count = 0;
    var a = document.getElementsByTagName('a');
    for(var i = 0; i < a.length; i++)
    {
      if(a[i].href && a[i].href.search(/\/music\.phtml\x3Fid=\d+$/i) != -1)
      {
        var id1 = 'ujs_get_download_link_btn_' + count.toString();
        var id2 = 'ujs_links_info_' + count.toString();
        count++;

        var btn = document.createElement('a');
        btn.id = id1;
        btn.href = 'javascript:window.ujs_mf_getDownloadLink(\'' + a[i].href + '\', \'' + id2 + '\', window.ujs_mf_showLinks);';
        btn.innerHTML = '&rsaquo;&rsaquo;&rsaquo;';
        btn.setAttribute('style', 'margin-left: 20px; text-decoration: none; font-family: tahoma, verdana, helvetica, sans-serif; font-weight: normal; font-size: 11pt; line-height: 0.9; padding: 0;', false);
        a[i].parentNode.appendChild(btn);

        var info = document.createElement('span');
        info.id = id2;
        info.innerHTML = '   ';
        info.setAttribute('style', 'margin-left: 10px;', false);
        a[i].parentNode.appendChild(info);        
        
        if(autoGetDownloadLinks)
          btn.click();
      }
    }
  }
  
  window.ujs_mf_showAllLinks = function(){
    count = 0;
    var obj = null;
    while(obj = document.getElementById('ujs_get_download_link_btn_' + count.toString()))
    {
      obj.click();
      count++;
    }
  };
  
  
  function showLinks(links, id)
  {
    var obj = document.getElementById(id);
    if(obj)
    {
      if(links)
      {        
        var html = '', sep = '', text = ['[mp3]', '[zip]', '[doc]'];
        for(var i = 0; i < links.length; i++)
        {
          if(links[i])
          {
            html += sep + '<a href="' + links[i] + '">' + text[i] + '</a>';
            sep = ' &nbsp;';
          }
        }
        obj.innerHTML = html;
      }
      else
      {
        obj.innerHTML = '\u043e\u0448\u0438\u0431\u043a\u0430'; // error
      }
    }
  }
  window.ujs_mf_showLinks = showLinks;
  
  
  function getDownloadLink(url, id, callback)
  {
    var busy = function(id)
    {
      var parent = document.getElementById(id);
      if(!parent)
        return;

      parent.innerHTML = '';  
      var e = document.createElement('span');
      e = parent.appendChild(e);
      e.setAttribute('style', 'font-family: "courier new", "lucida console", monospace;', false);
      
      var i = 0;
      var text = ['&nbsp;&nbsp;&nbsp;','.&nbsp;&nbsp;','..&nbsp;','...','..&nbsp;','.&nbsp;&nbsp;'];      
      var setText = function()
      {
        if(i >= text.length)
        {
          i = 0;
        }
        e.innerHTML = text[i];
        i++;
        setTimeout(setText, 200);
      }
      setText();
    };
    busy(id);
    
    var request1 = function(req)
    {
      if(req.responseText.search(/name=\x22go\x22/) != -1)
      {
        var go = req.responseText.match(/name=\x22go\x22\s*value=\x22([a-f0-9]+)\x22/i);
        if(go && go.length > 1)
        {
          sendRequest(url, request2, 'POST', url, 'go=' + go[1]);
          return;
        }
      }
      callback(null, id);
    };
    
    var request2 = function(req)
    {
      if(req.responseText.search(/startcountdown/i) != -1)
      {
        var p = req.responseText.match(/startCountdown\s*\x28(\d+)\s*,\s*[\x22\x27]([a-f0-9]+)[\x22\x27]\x29/i);
        if(p && p.length > 2)
        {
          var url2 = 'http://' + window.location.host + '/link.phtml?title_id=' + p[1] + '&cookie=' + p[2];
          setTimeout(function(){sendRequest(url2, request3, '', url);}, 10000);
          return;
        }
      }
      callback(null, id);
    };
    
    var request3 = function(req)
    {
      if(req.responseText.search(/\/dl\.phtml\//i) != -1)
      {
        var mp3 = '', zip = '', doc = '';
        req.responseText.replace(/href\s*=\s*[\x22\x27]([^\x22\x27]+)[\x22\x27]/ig, function(s, p){
          if(p)
          {
            if(p.search(/\.mp3$/i) != -1)
              mp3 = p;
            else if(p.search(/\.zip$/i) != -1)  
              zip = p;
            else if(p.search(/\.doc$/i) != -1)  
              doc = p;
          }
          return s;
        });
        
        if(getExactMP3Links)
        {
          sendRequest(mp3, function(req){
            if(req.getResponseHeader('Location'))            
              mp3 = req.getResponseHeader('Location');
            
            callback([mp3, zip, doc], id);
            return;
          }, 'HEAD', window.location.href);
        }
        
        callback([mp3, zip, doc], id);
        return;
      }
      callback(null, id);
    };

    sendRequest(url, request1, '', window.location.href);
  }
  window.ujs_mf_getDownloadLink = getDownloadLink;
  
  
  function autoClickButton()
  {
    var a = document.createElement('a');
    a.innerHTML = submitValue;
    
    var input = document.getElementsByTagName('input');
    for(var i = input.length - 1; i >= 0; i--)
    {
      if(input[i].type == 'submit' && input[i].value == a.innerText)      
      {
        input[i].click();
        break;
      }
    }
  }
  
  
  function onLoad()
  {
    createDownloadButtons();
    autoClickButton();
  }
  
  
  function sendRequest(url, callback, method, referer, post, cookie, user_agent, header)
  {
    var req = new XMLHttpRequest();
    if (!req)
      return;

    method = method ? method : ((post) ? 'POST' : 'GET');
    user_agent = user_agent ? user_agent : navigator.userAgent;
    
    req.open(method, url, true);
    
    req.setRequestHeader('User-Agent', user_agent);
    if(referer)
    {
      req.setRequestHeader('Referer', referer);
    }
    if(cookie)
    {
      req.setRequestHeader('Cookie', cookie);
    }
    if (post)
    {
      req.setRequestHeader('Content-type', 'application/x-www-form-urlencoded');
      req.setRequestHeader("Content-Length", post.length);
    }
    if(header)
    {
      for(var i = 0; i < header.length; i++)
      {
        req.setRequestHeader(header[i][0], header[i][1]);
      }
    }
    
    req.onreadystatechange = function ()
    {
      if (req.readyState != 4)
        return;
      
      callback(req);
    };
    
    if (req.readyState == 4)
    {
      return;
    }  
    
    if(post)
      req.send(post);
    else
      req.send();
  }
  
  
  var css = 'noindex *, iframe, noscript iframe, div#rtn4pmc_len1, div#rtn4pmc_len2 {display: none !important;}';
  if(typeof(window.opera.version) == 'function' && window.opera.version() >= 9)
  {
   css += ' div[id*="rdminfrm_"] {display: none !important;}';
  }
  addStyle(css);  
  
  if(typeof(window.opera.version) == 'function' && window.opera.version() >= 9)
    document.addEventListener('DOMContentLoaded', onLoad, false);  
  else
    document.addEventListener('load', onLoad, false);
})();