/*
 * Decompiled with CFR 0.152.
 */
import fileselector.FileSelectListener;
import fileselector.FileSelectMenu;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextBox;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.InvalidRecordIDException;
import javax.microedition.rms.RecordStore;
import rheise.jftpd.Server;

public class FTPServer
extends MIDlet
implements CommandListener,
FileSelectListener {
    private static Display display;
    private static TextBox t;
    private static int count;
    private Server server;
    private Form mainScreen;
    private Form loginScreen;
    private TextField userField;
    private TextField passField;
    private StringItem userStrIt;
    private StringItem passStrIt;
    private StringItem dirStrIt;
    private String user;
    private String pass;
    private String dir;
    private String ipstring;
    private Form helpForm;

    public void startApp() {
        int n = 21;
        display = Display.getDisplay((MIDlet)this);
        Server.textBox = t = new TextBox("FTPServer", "", 1024, 0);
        boolean bl = false;
        if (System.getProperty("microedition.io.file.FileConnection.version") == null) {
            Alert alert = new Alert("Error", "Fatal error: this device does not appear to have a filesystem.", null, AlertType.ERROR);
            alert.setCommandListener((CommandListener)this);
            alert.setTimeout(-2);
            display.setCurrent((Displayable)alert);
            return;
        }
        try {
            this.readUserData();
        }
        catch (SecurityException securityException) {
            Alert alert = new Alert("Error", "Cannot continue without permission to read filesystem. Please start application again, and select \"never ask\" if available.", null, AlertType.ERROR);
            alert.setCommandListener((CommandListener)this);
            alert.setTimeout(-2);
            display.setCurrent((Displayable)alert);
            return;
        }
        catch (IOException iOException) {
            bl = true;
        }
        try {
            this.server = new Server(n, this.dir);
        }
        catch (SecurityException securityException) {
            Alert alert = new Alert("Error", "Cannot continue without permission to access network. Please start application again, and select \"yes\" to allow networking.", null, AlertType.ERROR);
            alert.setCommandListener((CommandListener)this);
            display.setCurrent((Displayable)alert);
            alert.setTimeout(-2);
            return;
        }
        catch (IOException iOException) {
            Alert alert = new Alert("Error", "Cannot continue because an unknown network error occured: " + iOException.getMessage(), null, AlertType.ERROR);
            alert.setCommandListener((CommandListener)this);
            alert.setTimeout(-2);
            display.setCurrent((Displayable)alert);
            return;
        }
        this.server.setUser(this.user);
        this.server.setPass(this.pass);
        this.setupMainScreen();
        this.setupLoginScreen();
        this.setupHelpForm();
        if (!bl) {
            display.setCurrent((Displayable)this.mainScreen);
        } else {
            FileSelectMenu fileSelectMenu = new FileSelectMenu("/", 1, this);
            fileSelectMenu.display(display);
        }
        this.server.start();
    }

    private void readUserData() throws IOException {
        RecordStore recordStore;
        this.user = "Anonymous";
        this.pass = "none";
        this.dir = "/";
        try {
            recordStore = RecordStore.openRecordStore((String)"FTPRecords", (boolean)true);
            try {
                byte[] byArray = recordStore.getRecord(1);
                this.user = new String(byArray);
                byte[] byArray2 = recordStore.getRecord(2);
                this.pass = new String(byArray2);
                byte[] byArray3 = recordStore.getRecord(3);
                this.dir = new String(byArray3);
                if (this.dir.charAt(0) != '/') {
                    this.dir = "/" + this.dir;
                }
                if (this.dir.charAt(this.dir.length() - 1) != '/') {
                    this.dir = this.dir + "/";
                }
            }
            catch (InvalidRecordIDException invalidRecordIDException) {
                recordStore.addRecord(this.user.getBytes(), 0, this.user.length());
                recordStore.addRecord(this.pass.getBytes(), 0, this.pass.length());
                recordStore.addRecord(this.dir.getBytes(), 0, this.dir.length());
                throw new IOException("No records found");
            }
            catch (NullPointerException nullPointerException) {
                recordStore.addRecord(this.user.getBytes(), 0, this.user.length());
                recordStore.addRecord(this.pass.getBytes(), 0, this.pass.length());
                recordStore.addRecord(this.dir.getBytes(), 0, this.dir.length());
                throw new IOException("No records found");
            }
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            throw new IOException("Unable to open recordstore");
        }
        try {
            recordStore = (FileConnection)Connector.open((String)("file://" + this.dir));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Invalid directory name");
        }
        if (!recordStore.isDirectory()) {
            throw new IOException("Stored location not a valid directory");
        }
        recordStore.close();
    }

    private void setupMainScreen() {
        this.mainScreen = new Form("MobShareFTP Server");
        this.ipstring = this.server.getServerAddress();
        this.mainScreen.append((Item)new StringItem("Connect to: ", "ftp://" + this.ipstring));
        this.userStrIt = new StringItem("Username: ", this.user);
        this.mainScreen.append((Item)this.userStrIt);
        this.passStrIt = new StringItem("Password: ", this.pass);
        this.mainScreen.append((Item)this.passStrIt);
        this.dirStrIt = new StringItem("Access folder: ", FileSelectMenu.top(this.dir));
        this.mainScreen.append((Item)this.dirStrIt);
        this.mainScreen.addCommand(new Command("Directory", 8, 1));
        this.mainScreen.addCommand(new Command("Set login", 8, 1));
        this.mainScreen.addCommand(new Command("Quit", 7, 1));
        this.mainScreen.addCommand(new Command("Help", 5, 1));
        this.mainScreen.setCommandListener((CommandListener)this);
    }

    private void setupLoginScreen() {
        this.loginScreen = new Form("Change login");
        this.userField = new TextField("Username", this.user, 20, 0);
        this.loginScreen.append((Item)this.userField);
        this.passField = new TextField("Password", this.pass, 20, 0);
        this.loginScreen.append((Item)this.passField);
        this.loginScreen.addCommand(new Command("Ok", 4, 1));
        this.loginScreen.addCommand(new Command("Cancel", 3, 1));
        this.loginScreen.setCommandListener((CommandListener)this);
    }

    private void setupHelpForm() {
        this.helpForm = new Form("Help");
        this.helpForm.append("If this is the first time you use this application, follow the steps below. Otherwise, jump straight to step 5.");
        this.helpForm.append("1. Make sure your phone's WiFi is connected.\n");
        this.helpForm.append("2. Your phone will ask for permission to read the filesystem. If possible, answer \"yes, never ask\".");
        this.helpForm.append("3. Select \"Directory\" to change the folder you want to send and receive files from. The client (computer) will have access to this folder and all its subfolders.");
        this.helpForm.append("4. Select \"Set login\" to change the user name and password the client (computer) must use to connect to the phone. If the user name is \"anonymous\", no user name and password is required.");
        this.helpForm.append("5. On your computer, open any folder (such as \"my documents\" or \"my computer\"), click the address field and type in exactly what it says in the \"connect to\" field in this app (i.e. ftp://" + this.ipstring + "). Voila! " + "If you use a Mac, go to finder and select Go/Connect to Server.");
        this.helpForm.append("Hint: You can set up the settings on your phone to never ask permission for reading from the filesystem. If you don't, the phone might constantly bug you about permissions.");
        this.helpForm.append("Hint: Instead of the ip-address of the phone, you may use the phone's network name to connect. You will find this name in your phone's settings. For example, if your phone name is \"w995\", you can connect by typing \"ftp://w995\" in any folder on your computer. You can also use this address to map your phone as a network drive, so you never have to type anything again.");
        this.helpForm.append("Hint: Changes to the access directory and login take place only after you reconnect.");
        this.helpForm.setCommandListener((CommandListener)this);
        this.helpForm.addCommand(new Command("Ok", 4, 0));
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command.getCommandType() == 7 || command == Alert.DISMISS_COMMAND) {
            this.destroyApp(false);
            this.notifyDestroyed();
        }
        if (command.getCommandType() == 5) {
            display.setCurrent((Displayable)this.helpForm);
        }
        if (command.getLabel().equals("Set login")) {
            this.userField.setString(this.user);
            this.passField.setString(this.pass);
            display.setCurrent((Displayable)this.loginScreen);
        }
        if (command.getLabel().equals("Directory")) {
            new FileSelectMenu(FileSelectMenu.cdup(this.dir), 1, this).display(display);
        }
        if (displayable == this.helpForm) {
            display.setCurrent((Displayable)this.mainScreen);
        }
        if (displayable == this.loginScreen) {
            if (command.getCommandType() == 3) {
                display.setCurrent((Displayable)this.mainScreen);
            } else if (command.getCommandType() == 4) {
                this.user = this.userField.getString();
                this.pass = this.passField.getString();
                try {
                    RecordStore recordStore = RecordStore.openRecordStore((String)"FTPRecords", (boolean)true);
                    recordStore.setRecord(1, this.user.getBytes(), 0, this.user.length());
                    recordStore.setRecord(2, this.pass.getBytes(), 0, this.pass.length());
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {
                    System.out.println(exception);
                }
                this.server.setUser(this.user);
                this.server.setPass(this.pass);
                this.userStrIt.setText(this.user);
                this.passStrIt.setText(this.pass);
                display.setCurrent((Displayable)this.mainScreen);
            }
        }
    }

    public void fileSelectAction(String string) {
        if (string == null) {
            display.setCurrent((Displayable)this.mainScreen);
            return;
        }
        this.dir = string;
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"FTPRecords", (boolean)true);
            recordStore.setRecord(3, this.dir.getBytes(), 0, this.dir.length());
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        this.dirStrIt.setText(FileSelectMenu.top(this.dir));
        this.server.setPath(this.dir);
        display.setCurrent((Displayable)this.mainScreen);
    }

    public void destroyApp(boolean bl) {
        try {
            this.server.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void pauseApp() {
    }

    static {
        count = 0;
    }
}

