/*
 * Decompiled with CFR 0.152.
 */
package rheise.jftpd;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.SocketConnection;
import javax.microedition.io.file.FileConnection;
import rheise.jftpd.CommandException;
import rheise.jftpd.PassiveConnector;
import rheise.jftpd.PassiveConnectorKiller;
import rheise.jftpd.Representation;
import rheise.jftpd.ServerPI;
import rheise.jftpd.TransmissionMode;

public class ServerDTP {
    private ServerPI serverPI;
    private String dataHost;
    private int dataPort = -1;
    private static final int passiveTimeout = 10000;
    public static final boolean PASSIVE = false;
    public static final boolean PORT = true;
    private boolean mode = true;
    private PassiveConnector passiveConnector = null;
    private TransmissionMode transmissionMode = TransmissionMode.STREAM;
    private Representation representation = Representation.ASCII;

    public ServerDTP(ServerPI serverPI) {
        this.serverPI = serverPI;
    }

    public void setTransmissionMode(TransmissionMode transmissionMode) {
        this.transmissionMode = transmissionMode;
    }

    public void setDataStructure(char c) {
    }

    public void setMode(boolean bl) {
        this.mode = bl;
    }

    public void setPassiveConnector(PassiveConnector passiveConnector) {
        this.passiveConnector = passiveConnector;
    }

    public Representation getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(Representation representation) {
        this.representation = representation;
    }

    private SocketConnection openConnection() throws CommandException {
        SocketConnection socketConnection;
        if (this.mode) {
            if (this.dataPort == -1) {
                throw new CommandException(500, "Can't establish data connection: no PORT specified.");
            }
            try {
                socketConnection = (SocketConnection)Connector.open((String)("socket://" + this.dataHost + ":" + Integer.toString(this.dataPort)));
            }
            catch (ConnectionNotFoundException connectionNotFoundException) {
                throw new CommandException(425, "Can't open data connection.");
            }
            catch (IOException iOException) {
                throw new CommandException(426, "Error opening connection: " + iOException.getMessage());
            }
            finally {
                this.dataPort = -1;
            }
        }
        if (this.passiveConnector == null) {
            throw new CommandException(500, "Can't establish data connection: no port negotiated through PASV");
        }
        if (this.passiveConnector.isAlive()) {
            new PassiveConnectorKiller(this.passiveConnector, 10000);
            try {
                this.passiveConnector.join();
            }
            catch (InterruptedException interruptedException) {
                System.out.println(interruptedException);
            }
        }
        socketConnection = this.passiveConnector.getSocket();
        this.passiveConnector = null;
        if (socketConnection == null) {
            throw new CommandException(426, "Error establishing passive connection");
        }
        return socketConnection;
    }

    public void setDataPort(String string, int n) {
        this.dataHost = string;
        this.dataPort = n;
    }

    public int receiveFile(String string) throws CommandException {
        int n = 0;
        OutputStream outputStream = null;
        SocketConnection socketConnection = null;
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file://" + string), (int)2);
            fileConnection.create();
            outputStream = fileConnection.openOutputStream();
            socketConnection = this.openConnection();
            this.serverPI.reply(150, "Opening " + this.representation.getName() + " mode data connection.");
            this.transmissionMode.receiveFile(socketConnection, outputStream, this.representation);
            n = this.serverPI.reply(226, "Transfer complete.");
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            throw new CommandException(550, "Error opening file");
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            throw new CommandException(550, "Can't write to file");
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
                if (socketConnection != null) {
                    socketConnection.close();
                }
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    public int sendFile(String string) throws CommandException {
        int n = 0;
        InputStream inputStream = null;
        SocketConnection socketConnection = null;
        FileConnection fileConnection = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file://" + string), (int)1);
            if (!fileConnection.exists() || fileConnection.isDirectory()) {
                throw new CommandException(550, "Not a plain file.");
            }
            inputStream = fileConnection.openInputStream();
            socketConnection = this.openConnection();
            this.serverPI.reply(150, "Opening " + this.representation.getName() + " mode data connection.");
            this.transmissionMode.sendFile(inputStream, socketConnection, this.representation);
            n = this.serverPI.reply(226, "Transfer complete.");
            fileConnection.close();
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            throw new CommandException(550, "No such file.");
        }
        catch (IOException iOException) {
            throw new CommandException(553, "Not a regular file.");
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (socketConnection != null) {
                    socketConnection.close();
                }
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    public int sendNameList(String string) throws CommandException {
        int n = 0;
        SocketConnection socketConnection = null;
        FileConnection fileConnection = null;
        PrintStream printStream = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file://" + string));
            Enumeration enumeration = fileConnection.list();
            socketConnection = this.openConnection();
            Representation representation = Representation.ASCII;
            printStream = new PrintStream(representation.getOutputStream(socketConnection));
            this.serverPI.reply(150, "Opening " + representation.getName() + " mode data connection.");
            while (enumeration.hasMoreElements()) {
                printStream.print((String)enumeration.nextElement());
                printStream.print('\n');
            }
            printStream.flush();
            n = this.serverPI.reply(226, "Transfer complete.");
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            throw new CommandException(425, "Can't open data connection.");
        }
        catch (Exception exception) {
            throw new CommandException(550, "No such directory.");
        }
        finally {
            try {
                if (socketConnection != null) {
                    socketConnection.close();
                }
                if (printStream != null) {
                    printStream.close();
                }
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    public int sendList(String string) throws CommandException {
        int n = 0;
        SocketConnection socketConnection = null;
        FileConnection fileConnection = null;
        OutputStream outputStream = null;
        try {
            fileConnection = (FileConnection)Connector.open((String)("file://" + string));
            Enumeration enumeration = fileConnection.list();
            String[] stringArray = new String[512];
            int n2 = 0;
            while (enumeration.hasMoreElements() && n2 < 512) {
                stringArray[n2++] = (String)enumeration.nextElement();
            }
            socketConnection = this.openConnection();
            Representation representation = Representation.ASCII;
            outputStream = representation.getOutputStream(socketConnection);
            this.serverPI.reply(150, "Opening " + representation.getName() + " mode data connection.");
            outputStream.write(new String("total " + n2 + "\n").getBytes());
            String string2 = string;
            if (string2.charAt(string2.length() - 1) != '/') {
                string2 = string2 + "/";
            }
            for (int i = 0; i < n2; ++i) {
                String string3 = stringArray[i];
                FileConnection fileConnection2 = (FileConnection)Connector.open((String)("file://" + string2 + string3));
                this.listFile(fileConnection2, outputStream);
                fileConnection2.close();
            }
            outputStream.flush();
            n = this.serverPI.reply(226, "Transfer complete.");
        }
        catch (ConnectionNotFoundException connectionNotFoundException) {
            throw new CommandException(425, "Can't open data connection.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new CommandException(550, "No such directory." + exception);
        }
        finally {
            try {
                if (socketConnection != null) {
                    socketConnection.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
                if (fileConnection != null) {
                    fileConnection.close();
                }
            }
            catch (IOException iOException) {}
        }
        return n;
    }

    private void listFile(FileConnection fileConnection, OutputStream outputStream) {
        Date date = new Date(fileConnection.lastModified());
        String string = this.formatDate(date);
        long l = 0L;
        try {
            l = fileConnection.fileSize();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        String string2 = Long.toString(l);
        int n = Math.max(8 - string2.length(), 0);
        String string3 = ServerDTP.pad(n) + string2;
        this.print(fileConnection.isDirectory() ? "d" : "-", outputStream);
        this.print("rwxrwxrwx", outputStream);
        this.print(" ", outputStream);
        this.print("  1", outputStream);
        this.print(" ", outputStream);
        this.print("ftp     ", outputStream);
        this.print(" ", outputStream);
        this.print("ftp     ", outputStream);
        this.print(" ", outputStream);
        this.print(string3, outputStream);
        this.print(" ", outputStream);
        this.print(string, outputStream);
        this.print(" ", outputStream);
        String string4 = fileConnection.getName();
        if (string4.charAt(string4.length() - 1) == '/') {
            string4 = string4.substring(0, string4.length() - 1);
        }
        this.print(string4, outputStream);
        this.print("\n", outputStream);
    }

    private String formatDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2);
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        String string = "";
        switch (n2) {
            case 0: {
                string = "Jan";
                break;
            }
            case 1: {
                string = "Feb";
                break;
            }
            case 2: {
                string = "Mar";
                break;
            }
            case 3: {
                string = "Apr";
                break;
            }
            case 4: {
                string = "May";
                break;
            }
            case 5: {
                string = "Jun";
                break;
            }
            case 6: {
                string = "Jul";
                break;
            }
            case 7: {
                string = "Aug";
                break;
            }
            case 8: {
                string = "Sep";
                break;
            }
            case 9: {
                string = "Oct";
                break;
            }
            case 10: {
                string = "Nov";
                break;
            }
            case 11: {
                string = "Dec";
                break;
            }
            default: {
                string = "Jan";
            }
        }
        long l = -1109469184L;
        string = new Date().getTime() > date.getTime() + l ? string + " " + this.zeropad(n3, 2) + "  " + this.zeropad(n, 4) : string + " " + this.zeropad(n3, 2) + " " + this.zeropad(n4, 2) + ":" + this.zeropad(n5, 2);
        return string;
    }

    private String zeropad(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    private void print(String string, OutputStream outputStream) {
        try {
            outputStream.write(string.getBytes());
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private static String pad(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }
}

