/*
 * Decompiled with CFR 0.152.
 */
package org.qcontinuum.compass;

import henson.midp.Float;
import java.util.Date;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import org.qcontinuum.astro.HorizontalPosition;
import org.qcontinuum.astro.RiseSetTime;
import org.qcontinuum.compass.Compass;
import org.qcontinuum.compass.InfoDisplay;
import org.qcontinuum.compass.Location;
import org.qcontinuum.compass.Progress;
import org.qcontinuum.compass.SunMoonPosition;

public class InfoMoon
extends Progress {
    private Displayable a;

    public InfoMoon(Displayable displayable) {
        super("\u041b\u0443\u043d\u0430", displayable);
        this.a = displayable;
        this.start();
    }

    public void run() {
        Date date = Compass.getDate();
        SunMoonPosition sunMoonPosition = new SunMoonPosition(date);
        HorizontalPosition horizontalPosition = sunMoonPosition.getMoonPosition();
        Float float_ = sunMoonPosition.getMoonPhase();
        Location location = Compass.getPreferences().getLocation();
        RiseSetTime riseSetTime = new RiseSetTime(1, location.getGmt(date), location.getDstOffset(date), location.getEarthPosition());
        InfoDisplay infoDisplay = new InfoDisplay("\u041b\u0443\u043d\u0430", this.a);
        infoDisplay.append((Item)new StringItem("\u0410\u0437\u0438\u043c\u0443\u0442:", Compass.getFloat(horizontalPosition.getAzimuthFloat(), 1) + "\u00b0\n"));
        infoDisplay.append((Item)new StringItem("\u0412\u044b\u0441\u043e\u0442\u0430:", Compass.getFloat(horizontalPosition.getElevationFloat(), 1) + "\u00b0\n"));
        infoDisplay.append((Item)new StringItem("\u0424\u0430\u0437\u0430:", Compass.getFloat(float_.Mul(100L), 1) + "%\n"));
        infoDisplay.append((Item)new StringItem(null, " \n"));
        infoDisplay.append((Item)new StringItem("\u0412\u043e\u0441\u0445\u043e\u0434:", Compass.getTime(riseSetTime.getRiseTime()) + "\n"));
        infoDisplay.append((Item)new StringItem("\u0417\u0430\u0445\u043e\u0434:", Compass.getTime(riseSetTime.getSetTime())));
        if (this.isShown()) {
            Compass.display((Displayable)infoDisplay);
        }
    }
}

