/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class AnimSprites {
    static final int ANIM_FRAME_ID_OFFSET = 0;
    static final int ANIM_DX = 1;
    static final int ANIM_DY = 2;
    static final int ANIM_SIZE = 3;
    static byte[] data;
    int dataOffset;
    int maxFrame;
    int minPictureId;
    public int x;
    public int y;
    public int curFrame;

    public void init(int n, int n2, int n3, int n4) {
        data = Sprites.data;
        this.x = n2;
        this.y = n3;
        this.curFrame = n4;
        this.dataOffset = 245;
        for (int i = 0; i < n; ++i) {
            int n5 = BaseClass.readIntBE(data, this.dataOffset, 2);
            this.dataOffset += 2;
            if (i + 1 == n) {
                this.minPictureId = BaseClass.readIntBE(data, this.dataOffset, 2);
                this.maxFrame = (n5 - 2) / 3;
                this.dataOffset += 2;
                break;
            }
            this.dataOffset += n5;
        }
    }

    public void draw(Graphics graphics) {
        if (this.curFrame >= 0 && this.curFrame < this.maxFrame) {
            Sprites.draw(graphics, this.minPictureId + data[this.dataOffset + this.curFrame * 3 + 0], this.x, this.y, 384);
        }
    }

    public void turn() {
        if (this.curFrame < this.maxFrame) {
            ++this.curFrame;
            if (this.curFrame < this.maxFrame) {
                int n = this.dataOffset + this.curFrame * 3;
                this.x += data[n + 1];
                this.y += data[n + 2];
            }
        }
    }

    public boolean isEnd() {
        return this.curFrame >= this.maxFrame;
    }

    public boolean isHalf() {
        return 2 * this.curFrame == this.maxFrame;
    }

    public void resetFrame() {
        this.curFrame = 0;
    }

    public void end() {
        this.curFrame = this.maxFrame;
    }
}

