/*
 * Decompiled with CFR 0.152.
 */
public class Parking
extends GameLayer {
    private static final byte STATE_NONE = 0;
    private static final byte STATE_INVITATION = 1;
    private static final byte STATE_TUTORIAL = 2;
    private static final byte STATE_GAMEOVER = 3;
    StaticImage bg;
    Button leftSoft;
    Button rightSoft;
    Scroll scroll;
    long timer;
    StaticImage fadeOutImage;
    StaticImage fadeInImage;
    StaticImage[] sparkles;
    StaticImage[] fireworks;
    StaticImage[] particles;
    int[][] fireworkPosition;
    int[][] fireworkSpeed;
    int[] fireworkTimer;
    int particleIndex;
    byte state = 0;

    public Parking() {
        if (Game.parkingInvitation) {
            this.scroll = new Scroll(40, 60, 160, 210, ResourceManager.getText(37).concat("\n\n").concat(ResourceManager.getText(60)), 1, 22);
            this.leftSoft = new Button(Game.rm.getSprite(2), 3);
            this.state = 1;
        } else if (Game.parkingTutorial) {
            this.scroll = new Scroll(40, 60, 160, 210, ResourceManager.getText(39), 1, 22);
            this.leftSoft = new Button(Game.rm.getSprite(2), 3);
            this.state = (byte)2;
        } else if (Game.gameOver) {
            this.scroll = new Scroll(40, 60, 160, 210, ResourceManager.getText(61), 1, -1);
            if (this.scroll.getTextHeight() < this.scroll.getHeight()) {
                this.scroll.fitHeightToText();
                this.scroll.setPosition(this.scroll.getX(), Game.canvasCenterY - this.scroll.getHeight() / 2);
            }
            this.leftSoft = new Button(Game.rm.getSprite(2), 0);
            this.state = (byte)3;
        } else {
            this.leftSoft = new Button(Game.rm.getSprite(2), 3);
        }
        this.bg = new StaticImage(Game.rm.getImage(15));
        this.leftSoft.setPosition(0, Game.canvasHeight - this.leftSoft.getHeight());
        this.rightSoft = new Button(Game.rm.getSprite(2), 2);
        this.rightSoft.setPosition(Game.canvasWidth - this.rightSoft.getWidth(), Game.canvasHeight - this.rightSoft.getHeight());
    }

    void addNotify() {
        Game.layerManager.add(this.bg);
        if (this.state == 1) {
            Game.layerManager.add(this.scroll);
            Game.layerManager.add(this.leftSoft);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
            Game.layerManager.setKeyFireListener(this);
            Game.layerManager.setKeySoft1Listener(this);
        } else if (this.state == 2) {
            Game.layerManager.add(this.scroll);
            Game.layerManager.add(this.leftSoft);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
            Game.layerManager.setKeyFireListener(this);
            Game.layerManager.setKeySoft1Listener(this);
        } else if (this.state == 3) {
            this.createFireworks();
            this.showGameItems();
        } else {
            this.showGameItems();
            Game.layerManager.add(this.leftSoft);
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            Game.layerManager.setKeyFireListener(this);
            Game.layerManager.setKeySoft1Listener(this);
            Game.layerManager.setKeySoft2Listener(this);
        }
    }

    void addGameItem(GameItem gameItem) {
        if (gameItem == null) {
            return;
        }
        if (gameItem == Game.currGameItem) {
            GameItem gameItem2 = Game.getPrevSoldItem(gameItem);
            if (gameItem2 != null) {
                this.fadeOutImage = new StaticImage(Game.rm.getImage(gameItem2.parkingImageId));
                this.fadeOutImage.setPosition(gameItem2.parkingX, gameItem2.parkingY);
                this.fadeOutImage.setAlpha(100);
                Game.layerManager.add(this.fadeOutImage);
            }
            this.fadeInImage = new StaticImage(Game.rm.getImage(gameItem.parkingImageId));
            this.fadeInImage.setPosition(gameItem.parkingX, gameItem.parkingY);
            this.fadeInImage.setAlpha(0);
            Game.layerManager.add(this.fadeInImage);
            this.sparkles = new StaticImage[5];
            for (int i = 0; i < this.sparkles.length; ++i) {
                this.sparkles[i] = new StaticImage(Game.rm.getSprite(20));
                this.sparkles[i].setPosition(this.fadeInImage.getX() + Game.rand(this.fadeInImage.getWidth()) - this.sparkles[i].getWidth() / 2, this.fadeInImage.getY() + Game.rand(this.fadeInImage.getHeight()) - this.sparkles[i].getHeight() / 2);
                this.sparkles[i].setFrame(Game.rand(this.sparkles[i].getFrameCount()), Game.rand(8));
                Game.layerManager.add(this.sparkles[i]);
            }
        } else {
            StaticImage staticImage = new StaticImage(Game.rm.getImage(gameItem.parkingImageId));
            staticImage.setPosition(gameItem.parkingX, gameItem.parkingY);
            Game.layerManager.add(staticImage);
        }
    }

    void showGameItems() {
        this.addGameItem(Game.getLastSoldItem(1));
        this.addGameItem(Game.getLastSoldItem(2));
        this.addGameItem(Game.getLastSoldItem(0));
        this.addGameItem(Game.getLastSoldItem(3));
    }

    void createFireworks() {
        int n;
        int n2 = 5;
        this.fireworkPosition = new int[n2][2];
        this.fireworkSpeed = new int[n2][2];
        this.fireworkTimer = new int[n2];
        this.particles = new StaticImage[n2 * 3];
        this.fireworks = new StaticImage[n2];
        for (n = 0; n < this.fireworks.length; ++n) {
            this.fireworks[n] = new StaticImage(Game.rm.getSprite(20));
            this.fireworks[n].setVisible(false);
            this.resetFirework(n);
            Game.layerManager.add(this.fireworks[n]);
        }
        for (n = 0; n < this.particles.length; ++n) {
            this.particles[n] = new StaticImage(Game.rm.getSprite(20));
            this.particles[n].setVisible(false);
            Game.layerManager.add(this.particles[n]);
        }
    }

    void resetFirework(int n) {
        if (Game.rand(2) == 0) {
            this.fireworks[n].setPosition(0 - this.fireworks[n].getWidth() / 2, Game.canvasHeight / 3);
            this.fireworkSpeed[n][0] = 393216;
        } else {
            this.fireworks[n].setPosition(Game.canvasWidth - this.fireworks[n].getWidth() / 2, Game.canvasHeight / 3);
            this.fireworkSpeed[n][0] = -393216;
        }
        this.fireworkPosition[n][0] = this.fireworks[n].getX() << 16;
        this.fireworkPosition[n][1] = this.fireworks[n].getY() << 16;
        this.fireworkSpeed[n][1] = -10 - Game.rand(10) << 16;
        this.fireworkTimer[n] = 5 + Game.rand(10);
        this.fireworks[n].setFrame(0, Game.rand(8));
    }

    void startFireworks() {
        for (int i = 0; i < this.fireworks.length; ++i) {
            this.fireworks[i].setVisible(true);
        }
    }

    void animate() {
        int n;
        int n2;
        if (this.timer != 0L && System.currentTimeMillis() >= this.timer) {
            this.timer = 0L;
            this.keyFire();
        }
        if (this.fadeOutImage != null && (n2 = this.fadeOutImage.getAlpha()) > 0) {
            if ((n2 -= 10) < 0) {
                n2 = 0;
            }
            this.fadeOutImage.setAlpha(n2);
            if (n2 == 0) {
                Game.layerManager.remove(this.fadeOutImage);
                this.fadeOutImage.release();
                this.fadeOutImage = null;
            }
        }
        if (this.fadeInImage != null && (n2 = this.fadeInImage.getAlpha()) < 100) {
            if ((n2 += 10) > 100) {
                n2 = 100;
            }
            this.fadeInImage.setAlpha(n2);
            if (this.state == 3 && n2 == 100) {
                this.startFireworks();
                Game.layerManager.add(this.scroll);
                Game.layerManager.add(this.leftSoft);
                Game.layerManager.setKeyLeftListener(this.scroll);
                Game.layerManager.setKeyRightListener(this.scroll);
                Game.layerManager.setKeyFireListener(this);
                Game.layerManager.setKeySoft1Listener(this);
            }
        }
        if (this.sparkles != null) {
            n2 = 0;
            for (n = 0; n < this.sparkles.length; ++n) {
                if (this.sparkles[n] == null) continue;
                ++n2;
                if (this.sparkles[n].isNextFrame()) {
                    this.sparkles[n].setFrame(this.sparkles[n].frame + 1, Game.rand(8));
                    continue;
                }
                if (this.fadeInImage.getAlpha() < 100) {
                    this.sparkles[n].setPosition(this.fadeInImage.getX() + Game.rand(this.fadeInImage.getWidth()) - this.sparkles[n].getWidth() / 2, this.fadeInImage.getY() + Game.rand(this.fadeInImage.getHeight()) - this.sparkles[n].getHeight() / 2);
                    this.sparkles[n].setFrame(Game.rand(this.sparkles[n].getFrameCount()), Game.rand(8));
                    continue;
                }
                Game.layerManager.remove(this.sparkles[n]);
                this.sparkles[n].release();
                this.sparkles[n] = null;
            }
            if (n2 == 0) {
                this.sparkles = null;
            }
        }
        if (this.fireworks != null && this.fireworks[0].isVisible()) {
            for (n2 = 0; n2 < this.particles.length; ++n2) {
                if (!this.particles[n2].isVisible()) continue;
                if (this.particles[n2].frame < 7) {
                    this.particles[n2].setFrame(this.particles[n2].frame + 1, Game.rand(8));
                    continue;
                }
                this.particles[n2].setVisible(false);
            }
            n2 = 65536;
            for (n = 0; n < this.fireworks.length; ++n) {
                if (this.fireworks[n] == null) continue;
                int[] nArray = this.fireworkSpeed[n];
                nArray[1] = nArray[1] + n2;
                int[] nArray2 = this.fireworkPosition[n];
                nArray2[0] = nArray2[0] + this.fireworkSpeed[n][0];
                int[] nArray3 = this.fireworkPosition[n];
                nArray3[1] = nArray3[1] + this.fireworkSpeed[n][1];
                this.fireworks[n].setPosition(this.fireworkPosition[n][0] >> 16, this.fireworkPosition[n][1] >> 16);
                if (this.fireworkTimer[n] > 0) {
                    int n3 = n;
                    this.fireworkTimer[n3] = this.fireworkTimer[n3] - 1;
                    this.fireworks[n].setFrame(0, Game.rand(8));
                    continue;
                }
                if (this.fireworks[n].frame < 7) {
                    this.fireworks[n].setFrame(this.fireworks[n].frame + 1, Game.rand(8));
                    if (this.fireworks[n].frame != 5) continue;
                    for (int i = 0; i < 3; ++i) {
                        this.particles[this.particleIndex].setPosition(this.fireworks[n].getX() + Game.rand() % 30, this.fireworks[n].getY() + Game.rand() % 30);
                        this.particles[this.particleIndex].setFrame(Game.rand(3), Game.rand(8));
                        this.particles[this.particleIndex].setVisible(true);
                        ++this.particleIndex;
                        if (this.particleIndex != this.particles.length) continue;
                        this.particleIndex = 0;
                    }
                    continue;
                }
                this.resetFirework(n);
            }
        }
    }

    void keyFire() {
        if (this.state == 1) {
            Game.layerManager.remove(this.scroll);
            this.scroll = new Scroll(40, 60, 160, 210, ResourceManager.getText(39), 1, 22);
            Game.layerManager.add(this.scroll);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
            this.state = (byte)2;
            Game.parkingInvitation = false;
            return;
        }
        if (this.state == 2) {
            Game.layerManager.remove(this.scroll);
            this.scroll.release();
            this.scroll = null;
            this.leftSoft.setFrame(3, 0);
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.setKeyLeftListener(null);
            Game.layerManager.setKeyRightListener(null);
            Game.layerManager.setKeySoft2Listener(this);
            Game.parkingTutorial = false;
            this.showGameItems();
            this.state = 0;
            this.timer = System.currentTimeMillis() + 2000L;
            return;
        }
        if (this.state == 3) {
            Game.layerManager.remove(this.scroll);
            this.scroll.release();
            this.scroll = null;
            Game.layerManager.remove(this.leftSoft);
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.setKeyLeftListener(null);
            Game.layerManager.setKeyRightListener(null);
            Game.layerManager.setKeyFireListener(null);
            Game.layerManager.setKeySoft1Listener(null);
            Game.layerManager.setKeySoft2Listener(this);
        } else if (this.state == 0) {
            Game.event(new Event(39));
        }
    }

    void keySoft1() {
        this.keyFire();
    }

    void keySoft2() {
        Game.event(new Event(22));
    }

    void release() {
        super.release();
    }
}

