/*
 * Decompiled with CFR 0.152.
 */
public class City
extends GameLayer {
    StaticImage bg;
    Button leftSoft;
    Button rightSoft;
    Scroll scroll;
    StaticImage[] neons;
    Label label;
    Menu menu;
    int selected;
    boolean[] neonBlink = new boolean[]{true, true, true, false, false, true, true, false, true, false, true, false, false};
    int blinkIndex;

    public City() {
        if (Game.cityTutorial) {
            this.scroll = new Scroll(40, 60, 160, 210, ResourceManager.getText(25), 1, 24);
        }
        this.menu = new Menu(4);
        this.menu.add(new Label(ResourceManager.getText(50), 180), new Button(Game.rm.getSprite(11), 0), new Event(38));
        this.menu.add(new Label(ResourceManager.getText(51), 180), new Button(Game.rm.getSprite(11), 6), new Event(22));
        this.menu.setPosition(20, 105);
        this.menu.setBackground(true);
        this.bg = new StaticImage(Game.rm.getImage(21));
        this.leftSoft = new Button(Game.rm.getSprite(2), Game.cityTutorial ? 3 : 0);
        this.leftSoft.setPosition(0, Game.canvasHeight - this.leftSoft.getHeight());
        this.rightSoft = new Button(Game.rm.getSprite(2), 2);
        this.rightSoft.setPosition(Game.canvasWidth - this.rightSoft.getWidth(), Game.canvasHeight - this.rightSoft.getHeight());
        this.neons = new StaticImage[4];
        this.neons[0] = new StaticImage(Game.rm.getImage(22));
        this.neons[1] = new StaticImage(Game.rm.getImage(23));
        this.neons[2] = new StaticImage(Game.rm.getImage(24));
        this.neons[3] = new StaticImage(Game.rm.getImage(25));
        this.neons[0].setPosition(188, 134);
        this.neons[1].setPosition(11, 162);
        this.neons[2].setPosition(68, 86);
        this.neons[3].setPosition(168, 84);
        this.label = new Label("");
        this.selected = Game.itemCategory;
        Game.currGameItem = null;
    }

    void addNotify() {
        Game.layerManager.add(this.bg);
        for (int i = 0; i < 4; ++i) {
            Game.layerManager.add(this.neons[i]);
            this.neons[i].setVisible(false);
        }
        if (Game.cityTutorial) {
            Game.layerManager.add(this.scroll);
            Game.layerManager.setKeyLeftListener(this.scroll);
            Game.layerManager.setKeyRightListener(this.scroll);
        } else {
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeySoft2Listener(this);
        }
        Game.layerManager.add(this.leftSoft);
        Game.layerManager.add(this.label);
        this.menu.setVisible(false);
        Game.layerManager.add(this.menu);
        Game.layerManager.setKeyFireListener(this);
        Game.layerManager.setKeySoft1Listener(this);
        this.setSelected(this.selected);
    }

    void setSelected(int n) {
        this.neons[this.selected].setVisible(false);
        this.neons[n].setVisible(true);
        this.label.setText(ResourceManager.getText(31 + n), Game.canvasWidth - this.leftSoft.getWidth() - this.rightSoft.getWidth());
        this.label.setPosition(Game.canvasCenterX - this.label.getWidth() / 2, Game.canvasHeight - this.label.getHeight() - 2);
        this.blinkIndex = 0;
        this.selected = n;
    }

    void animate() {
        if (Game.cityTutorial || this.menu.isVisible()) {
            return;
        }
        this.neons[this.selected].setVisible(this.neonBlink[this.blinkIndex]);
        ++this.blinkIndex;
        if (this.blinkIndex == this.neonBlink.length) {
            this.blinkIndex = 0;
        }
    }

    void keyFire() {
        if (Game.cityTutorial) {
            Game.layerManager.remove(this.scroll);
            this.scroll.release();
            this.scroll = null;
            this.leftSoft.setFrame(0, 0);
            Game.layerManager.add(this.rightSoft);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
            Game.layerManager.setKeySoft2Listener(this);
            Game.cityTutorial = false;
            return;
        }
        Game.itemCategory = (byte)this.selected;
        Game.event(new Event(40));
    }

    void keySoft1() {
        this.keyFire();
    }

    void keySoft2() {
        if (this.menu.isVisible()) {
            this.menu.setVisible(false);
            this.label.setVisible(true);
            this.leftSoft.setFrame(0, 0);
            Game.layerManager.setKeyFireListener(this);
            Game.layerManager.setKeySoft1Listener(this);
            Game.layerManager.setKeyUpListener(this);
            Game.layerManager.setKeyDownListener(this);
            Game.layerManager.setKeyLeftListener(this);
            Game.layerManager.setKeyRightListener(this);
        } else {
            this.menu.setVisible(true);
            this.label.setVisible(false);
            this.leftSoft.setFrame(0, 0);
            Game.layerManager.setKeyFireListener(this.menu);
            Game.layerManager.setKeySoft1Listener(this.menu);
            Game.layerManager.setKeyUpListener(this.menu);
            Game.layerManager.setKeyDownListener(this.menu);
            Game.layerManager.setKeyLeftListener(null);
            Game.layerManager.setKeyRightListener(null);
        }
    }

    void keyRight() {
        this.keyDown();
    }

    void keyLeft() {
        this.keyUp();
    }

    void keyUp() {
        int n = this.selected - 1;
        if (n < 0) {
            n = this.neons.length - 1;
        }
        this.setSelected(n);
    }

    void keyDown() {
        int n = this.selected + 1;
        if (n > this.neons.length - 1) {
            n = 0;
        }
        this.setSelected(n);
    }

    void release() {
        super.release();
    }
}

