/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class GameLayerManager {
    Vector layers = new Vector(50);
    Vector dirtyRegions = new Vector(50);
    int viewX;
    int viewY;
    int viewW;
    int viewH;
    boolean flush;
    GameLayer keyFireListener;
    GameLayer keySoft1Listener;
    GameLayer keySoft2Listener;
    GameLayer keyUpListener;
    GameLayer keyDownListener;
    GameLayer keyLeftListener;
    GameLayer keyRightListener;

    void setViewWindow(int n, int n2, int n3, int n4) {
        this.viewX = n;
        this.viewY = n2;
        this.viewW = n3;
        this.viewH = n4;
    }

    void add(GameLayer gameLayer) {
        if (gameLayer != null && !this.layers.contains(gameLayer)) {
            this.layers.addElement(gameLayer);
            gameLayer.addNotify();
            this.redrawRegion(gameLayer.getX(), gameLayer.getY(), gameLayer.getWidth(), gameLayer.getHeight());
        }
    }

    void remove(GameLayer gameLayer) {
        if (gameLayer != null && this.layers.contains(gameLayer)) {
            this.redrawRegion(gameLayer.getX(), gameLayer.getY(), gameLayer.getWidth(), gameLayer.getHeight());
            this.layers.removeElement(gameLayer);
            gameLayer.removeNotify();
        }
    }

    void moveToTop(GameLayer gameLayer) {
        this.remove(gameLayer);
        this.add(gameLayer);
    }

    boolean containsLayer(GameLayer gameLayer) {
        return this.layers.contains(gameLayer);
    }

    void clear() {
        for (int i = 0; i < this.layers.size(); ++i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            gameLayer.release();
        }
        this.layers.removeAllElements();
        this.dirtyRegions.removeAllElements();
        this.keyFireListener = null;
        this.keySoft1Listener = null;
        this.keySoft2Listener = null;
        this.keyUpListener = null;
        this.keyDownListener = null;
        this.keyLeftListener = null;
        this.keyRightListener = null;
        this.redrawRegion(this.viewX, this.viewY, this.viewW, this.viewH);
    }

    void setKeyFireListener(GameLayer gameLayer) {
        this.keyFireListener = gameLayer;
    }

    void setKeySoft1Listener(GameLayer gameLayer) {
        this.keySoft1Listener = gameLayer;
    }

    void setKeySoft2Listener(GameLayer gameLayer) {
        this.keySoft2Listener = gameLayer;
    }

    void setKeyUpListener(GameLayer gameLayer) {
        this.keyUpListener = gameLayer;
    }

    void setKeyDownListener(GameLayer gameLayer) {
        this.keyDownListener = gameLayer;
    }

    void setKeyLeftListener(GameLayer gameLayer) {
        this.keyLeftListener = gameLayer;
    }

    void setKeyRightListener(GameLayer gameLayer) {
        this.keyRightListener = gameLayer;
    }

    GameLayer getKeyFireListener() {
        return this.keyFireListener;
    }

    GameLayer getKeySoft1Listener() {
        return this.keySoft1Listener;
    }

    GameLayer getKeySoft2Listener() {
        return this.keySoft2Listener;
    }

    GameLayer getKeyUpListener() {
        return this.keyUpListener;
    }

    GameLayer getKeyDownListener() {
        return this.keyDownListener;
    }

    GameLayer getKeyLeftListener() {
        return this.keyLeftListener;
    }

    GameLayer getKeyRightListener() {
        return this.keyRightListener;
    }

    void redrawRegion(int n, int n2, int n3, int n4) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        Rect rect = new Rect(n, n2, n3, n4);
        rect.clipTo(this.viewX, this.viewY, this.viewW, this.viewH);
        this.dirtyRegions.addElement(rect);
    }

    void animate() {
        for (int i = 0; i < this.layers.size(); ++i) {
            GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
            gameLayer.animate();
        }
    }

    boolean needsFlush() {
        return this.flush;
    }

    void paint(Graphics graphics) {
        int n;
        boolean bl = false;
        block0: while (!bl) {
            bl = true;
            for (n = 0; n < this.dirtyRegions.size(); ++n) {
                Rect rect = (Rect)this.dirtyRegions.elementAt(n);
                for (int i = n + 1; i < this.dirtyRegions.size(); ++i) {
                    Rect rect2 = (Rect)this.dirtyRegions.elementAt(i);
                    if (!rect.collidesWith(rect2)) continue;
                    rect.join(rect2);
                    this.dirtyRegions.removeElement(rect2);
                    bl = false;
                    break;
                }
                if (!bl) continue block0;
            }
        }
        this.flush = this.dirtyRegions.size() != 0;
        for (n = 0; n < this.dirtyRegions.size(); ++n) {
            Rect rect = (Rect)this.dirtyRegions.elementAt(n);
            for (int i = 0; i < this.layers.size(); ++i) {
                GameLayer gameLayer = (GameLayer)this.layers.elementAt(i);
                if (!gameLayer.isVisible()) continue;
                GameLayer.clipRegion.set(rect.x, rect.y, rect.w, rect.h);
                gameLayer.clipRect(GameLayer.clipRegion);
                if (!rect.collidesWith(GameLayer.clipRegion)) continue;
                graphics.setClip(GameLayer.clipRegion.x, GameLayer.clipRegion.y, GameLayer.clipRegion.w, GameLayer.clipRegion.h);
                gameLayer.paint(graphics);
            }
        }
        this.dirtyRegions.removeAllElements();
    }
}

