/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Scroll
extends GameLayer {
    int align;
    int textHeight;
    int scroll;
    Vector lines;
    int bgColor = 0;
    int visibleLines;
    int page = 0;
    int numPages;
    Button left;
    Button right;
    StaticImage borderTL;
    StaticImage borderTR;
    StaticImage borderBL;
    StaticImage borderBR;
    StaticImage borderL;
    StaticImage borderR;
    StaticImage borderT;
    StaticImage borderB;
    Label header;
    Rect clip;
    short headerTextId = (short)-1;

    public Scroll(int n, int n2, int n3, int n4, String string, int n5, int n6) {
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.align = n5;
        this.clip = new Rect();
        BitmapFont bitmapFont = Game.rm.getFont(0);
        Sprite sprite = Game.rm.getSprite(7);
        this.lines = bitmapFont.stringToLines(string, n3);
        this.textHeight = this.lines.size() * bitmapFont.getHeight();
        this.visibleLines = n4 / bitmapFont.getHeight();
        this.numPages = this.lines.size() / this.visibleLines;
        if (this.lines.size() % this.visibleLines != 0) {
            ++this.numPages;
        }
        this.borderTL = new StaticImage(sprite, 0, 0);
        this.borderTR = new StaticImage(sprite, 0, 5);
        this.borderBR = new StaticImage(sprite, 0, 3);
        this.borderBL = new StaticImage(sprite, 0, 6);
        this.borderT = new StaticImage(sprite, 1, 0, n3, sprite.getHeight());
        this.borderB = new StaticImage(sprite, 1, 3, n3, sprite.getHeight());
        this.borderL = new StaticImage(sprite, 1, 6, sprite.getWidth(), n4);
        this.borderR = new StaticImage(sprite, 1, 5, sprite.getWidth(), n4);
        this.left = new Button(Game.rm.getSprite(11), 0);
        this.right = new Button(Game.rm.getSprite(11), 0, 2);
        this.left.setAnimation((byte)1);
        this.right.setAnimation((byte)2);
        if (n6 >= 0) {
            this.headerTextId = (short)n6;
            this.header = new Label(ResourceManager.getText(this.headerTextId) + " " + (this.page + 1) + "/" + this.numPages);
        }
    }

    int getTextHeight() {
        return this.textHeight;
    }

    void fitHeightToText() {
        this.height = this.textHeight;
        this.visibleLines = this.lines.size();
        this.borderL.setHeight(this.height);
        this.borderR.setHeight(this.height);
        this.numPages = 1;
    }

    void keyLeft() {
        if (this.page > 0) {
            --this.page;
        }
        this.repaint();
        this.setButtonsVisibility();
        this.updateHeader();
    }

    void keyRight() {
        if (this.page < this.numPages - 1) {
            ++this.page;
        }
        this.repaint();
        this.setButtonsVisibility();
        this.updateHeader();
    }

    void updateHeader() {
        if (this.header != null) {
            this.header.setText(ResourceManager.getText(this.headerTextId) + " " + (this.page + 1) + "/" + this.numPages);
            this.header.setPosition(this.x + this.width / 2 - this.header.getWidth() / 2, this.y - this.borderT.getHeight() - this.header.getHeight() - 2);
        }
    }

    void setPosition(int n, int n2) {
        super.setPosition(n, n2);
        this.positionChildren();
    }

    void addNotify() {
        Game.layerManager.add(this.borderTL);
        Game.layerManager.add(this.borderTR);
        Game.layerManager.add(this.borderBL);
        Game.layerManager.add(this.borderBR);
        Game.layerManager.add(this.borderL);
        Game.layerManager.add(this.borderR);
        Game.layerManager.add(this.borderT);
        Game.layerManager.add(this.borderB);
        Game.layerManager.add(this.left);
        Game.layerManager.add(this.right);
        if (this.header != null) {
            Game.layerManager.add(this.header);
        }
        this.positionChildren();
        this.setButtonsVisibility();
    }

    void removeNotify() {
        Game.layerManager.remove(this.borderTL);
        Game.layerManager.remove(this.borderTR);
        Game.layerManager.remove(this.borderBL);
        Game.layerManager.remove(this.borderBR);
        Game.layerManager.remove(this.borderL);
        Game.layerManager.remove(this.borderR);
        Game.layerManager.remove(this.borderT);
        Game.layerManager.remove(this.borderB);
        Game.layerManager.remove(this.left);
        Game.layerManager.remove(this.right);
        if (this.header != null) {
            Game.layerManager.remove(this.header);
        }
    }

    private void positionChildren() {
        this.left.setPosition(this.x - this.left.getWidth() - 1, this.y + this.height / 2 - this.left.getHeight() / 2);
        this.right.setPosition(this.x + this.width + 1, this.y + this.height / 2 - this.right.getHeight() / 2);
        this.borderTL.setPosition(this.x - this.borderTL.getWidth(), this.y - this.borderTL.getHeight());
        this.borderTR.setPosition(this.x + this.width, this.y - this.borderTR.getHeight());
        this.borderBL.setPosition(this.x - this.borderBL.getWidth(), this.y + this.height);
        this.borderBR.setPosition(this.x + this.width, this.y + this.height);
        this.borderT.setPosition(this.x, this.y - this.borderT.getHeight());
        this.borderB.setPosition(this.x, this.y + this.height);
        this.borderL.setPosition(this.x - this.borderL.getWidth(), this.y);
        this.borderR.setPosition(this.x + this.width, this.y);
        if (this.header != null) {
            this.header.setPosition(this.x + this.width / 2 - this.header.getWidth() / 2, this.y - this.borderT.getHeight() - this.header.getHeight() - 2);
        }
    }

    private void setButtonsVisibility() {
        this.left.setVisible(this.page > 0);
        this.right.setVisible(this.page < this.numPages - 1);
    }

    void paint(Graphics graphics) {
        BitmapFont bitmapFont = Game.rm.getFont(0);
        int n = this.page * this.visibleLines;
        int n2 = n + this.visibleLines;
        if (n2 > this.lines.size()) {
            n2 = this.lines.size();
        }
        int n3 = graphics.getClipX();
        int n4 = graphics.getClipY();
        int n5 = graphics.getClipWidth();
        int n6 = graphics.getClipHeight();
        int n7 = this.x;
        int n8 = this.y;
        int n9 = 0;
        int n10 = bitmapFont.getHeight();
        if (this.align == 4) {
            n7 = this.x;
            n9 = 20;
        } else if (this.align == 1) {
            n7 = this.x + this.width / 2;
            n9 = 17;
        } else if (this.align == 8) {
            n7 = this.x + this.width;
            n9 = 24;
        }
        this.clip.x = this.x;
        this.clip.w = this.width;
        this.clip.h = n10;
        for (int i = n; i < n2; ++i) {
            this.clip.y = n8;
            if (this.clip.collidesWith(n3, n4, n5, n6)) {
                graphics.clipRect(this.clip.x, this.clip.y, this.clip.w, this.clip.h);
                String string = (String)this.lines.elementAt(i);
                graphics.setColor(this.bgColor);
                graphics.fillRect(this.x, n8, this.width, n10);
                bitmapFont.drawText(string, n7, n8, n9, graphics);
                graphics.setClip(n3, n4, n5, n6);
            }
            n8 += n10;
        }
        if (n8 < this.y + this.height) {
            this.clip.y = n8;
            this.clip.h = this.y + this.height - n8;
            if (this.clip.collidesWith(n3, n4, n5, n6)) {
                graphics.clipRect(this.clip.x, this.clip.y, this.clip.w, this.clip.h);
                graphics.setColor(this.bgColor);
                graphics.fillRect(this.clip.x, this.clip.y, this.clip.w, this.clip.h);
                graphics.setClip(n3, n4, n5, n6);
            }
        }
        graphics.setClip(n3, n4, n5, n6);
    }

    void release() {
        this.lines = null;
        this.left = null;
        this.right = null;
        this.borderTL = null;
        this.borderTR = null;
        this.borderBL = null;
        this.borderBR = null;
        this.borderL = null;
        this.borderR = null;
        this.borderT = null;
        this.borderB = null;
    }
}

