/*
 * Decompiled with CFR 0.152.
 */
package main;

import game.Apearance;
import game.Scenario;
import java.util.Stack;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Fonts;
import lib.Lib;
import main.Configuration;
import main.Main;
import main.MusicManager;
import screens.DialogScreen;
import screens.FinishGameScreen;
import screens.GetMoreGamesScreen;
import screens.HelpScreen;
import screens.LogoScreen;
import screens.MenuScreen;
import screens.OptionsScreen;
import screens.elements.MenuField;

public class GameManager
extends Canvas {
    public static int KEY_SOFTKEY1;
    public static int KEY_SOFTKEY2;
    public static int KEY_SOFTKEY3;
    public static GameManager current;
    public static final int SCREEN_LOGO = 1;
    public static final int SCREEN_LANG_MENU = 2;
    public static final int SCREEN_MENU_MAIN = 3;
    public static final int SCREEN_MENU_ABOUT = 4;
    public static final int SCREEN_MENU_HELP = 5;
    public static final int SCREEN_MENU_OPTIONS = 6;
    public static final int SCREEN_GAME_DIALOG = 10;
    public static final int SCREEN_FINISH_GAME = 89;
    public static final int SCREEN_ERROR = 99;
    public static final int SCREEN_GET_MORE_GAMES = 12;
    public static boolean gameStarted;
    public static boolean gamePaused;
    public static Image imgCurrentBackground;
    public static Image imgCurrentImage;
    public static Image imgIconsMain;
    public static Image imgFaces;
    public static Image imgArrows;
    public static Image[] imgClothesParts;
    public static Image imgHud;
    public static Image imgFilmFrame;
    public static Image imgTransparent;
    public static int currentScreen;
    public static Stack previousScreenStack;
    public static boolean isContinueIconEnabled;
    public static boolean isSleeping;
    public static boolean flashState;
    public static boolean isFlashing;
    public static boolean stopFlashing;
    public long previousBeginTime = 0L;
    public static int FLASH_INTERVAL;
    public static boolean keysBlocked;
    private String errorMessage = null;
    private boolean isErrorShown = false;

    public GameManager() {
        current = this;
        Fonts.init();
        GetMoreGamesScreen.init();
        currentScreen = 1;
        this.setFullScreenMode(true);
    }

    public void paint(Graphics g) {
        switch (currentScreen) {
            case 1: {
                LogoScreen.paint_LogoScreen(g);
                break;
            }
            case 99: {
                this.paint_ErrorScreen(g);
                break;
            }
            case 3: {
                MenuScreen.paint_Menu(g);
                break;
            }
            case 6: {
                OptionsScreen.paint_Options(g);
                break;
            }
            case 4: {
                HelpScreen.paint_HelpAbout(g);
                break;
            }
            case 5: {
                HelpScreen.paint_HelpAbout(g);
                break;
            }
            case 10: {
                DialogScreen.paint_GameDialog(g);
                break;
            }
            case 12: {
                GetMoreGamesScreen.paint_GetMoreGames(g);
                break;
            }
            case 89: {
                FinishGameScreen.paint_Finish(g);
            }
        }
        keysBlocked = false;
    }

    public static void repaintCurrent() {
        current.repaint();
    }

    protected void keyPressed(int key) {
        if (keysBlocked || MenuField.isAnimationFieldResizeInProgress) {
            return;
        }
        keysBlocked = true;
        if (key == 42) {
            key = KEY_SOFTKEY1;
        }
        if (key == 35) {
            key = KEY_SOFTKEY2;
        }
        if (key == KEY_SOFTKEY3) {
            key = KEY_SOFTKEY1;
        }
        switch (currentScreen) {
            case 1: {
                LogoScreen.keyPressed_LogoScreen(key);
                break;
            }
            case 2: {
                System.out.println("KeyOnLangMenuHandling");
                break;
            }
            case 99: {
                this.keyPressed_ErrorScreen(key);
                break;
            }
            case 3: {
                MenuScreen.keyPressed_Menu(key);
                break;
            }
            case 6: {
                OptionsScreen.keyPressed_Options(key);
                break;
            }
            case 4: {
                HelpScreen.keyPressed_HelpAbout(key);
                break;
            }
            case 5: {
                HelpScreen.keyPressed_HelpAbout(key);
                break;
            }
            case 10: {
                try {
                    DialogScreen.keyPressed_GameDialog(key);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 89: {
                FinishGameScreen.keyPressed_Finish(key);
                break;
            }
            case 12: {
                GetMoreGamesScreen.keyPressed_GetMoreGames(key);
            }
        }
    }

    protected void keyRepeated(int key) {
        if (MenuScreen.isAnimationIconsInProgress && MenuScreen.itemSelected != MenuScreen.itemDest) {
            return;
        }
        if (this.getGameAction(key) == 8) {
            return;
        }
        this.keyPressed(key);
    }

    public int getGameAction(int key) {
        if (key == KEY_SOFTKEY1) {
            return 8;
        }
        try {
            return super.getGameAction(key);
        }
        catch (IllegalArgumentException er) {
            return 0;
        }
    }

    public void startApp() {
        new OperationThread(1).start();
    }

    public OperationThread startOperation(int requiredOperation, int requestedScreen) {
        OperationThread op = new OperationThread(requiredOperation, requestedScreen);
        op.start();
        return op;
    }

    public OperationThread startOperation(int requiredOperation) {
        OperationThread op = new OperationThread(requiredOperation);
        op.start();
        return op;
    }

    private void opLoadGame() {
        MusicManager.init();
        LogoScreen.imgLogoBrand = Lib.loadImage("/brand_logo.png");
        this.repaint();
        imgArrows = Lib.loadImage("/arrows.png");
        Configuration.loadConfFile();
        Configuration.initializeConstants();
        Configuration.clear();
        GetMoreGamesScreen.applyGMGIcon();
        new OperationThread(0).start();
        LogoScreen.imgLogoGame = Lib.loadImage("/title.png");
        this.repaint();
        if (GetMoreGamesScreen.gmgStartupEnabled && GetMoreGamesScreen.logoDisabled) {
            currentScreen = -1;
            GetMoreGamesScreen.showGmgScreen();
        }
        LogoScreen.loadingProgress = 10;
        this.repaint();
        Scenario.loadScenario();
        Scenario.initFrameStates();
        LogoScreen.loadingProgress = 35;
        this.repaint();
        imgFaces = Lib.loadImage("/heads.png");
        LogoScreen.loadingProgress = 40;
        this.repaint();
        imgIconsMain = Lib.loadImage("/icons_main.png");
        LogoScreen.loadingProgress = 45;
        this.repaint();
        int[] pixels = new int[76800];
        for (int px = 0; px < pixels.length; ++px) {
            pixels[px] = -855638017;
        }
        imgTransparent = Image.createRGBImage((int[])pixels, (int)240, (int)320, (boolean)true);
        LogoScreen.loadingProgress = 55;
        this.repaint();
        DialogScreen.imgLadyBlured = Lib.loadImage("/Zb.png");
        LogoScreen.loadingProgress = 65;
        this.repaint();
        imgHud = Lib.loadImage("/hud.png");
        LogoScreen.loadingProgress = 70;
        this.repaint();
        imgFilmFrame = Lib.loadImage("/film.png");
        LogoScreen.loadingProgress = 75;
        this.repaint();
        GameManager.pause(500);
        for (int cp = 0; cp < Apearance.CLOTHES_PARTS_POSITIONS_X.length; ++cp) {
            GameManager.imgClothesParts[cp] = Lib.loadImage("/part" + (cp + 1) + ".png");
            LogoScreen.loadingProgress = 80 + cp * 20 / Apearance.CLOTHES_PARTS_POSITIONS_X.length;
            this.repaint();
        }
        LogoScreen.loadingProgress = 99;
        this.repaint();
        GameManager.pause(500);
        LogoScreen.loadingProgress = 100;
        new OperationThread(7).start();
        this.repaint();
    }

    protected void hideNotify() {
        gamePaused = true;
        if (gameStarted && MusicManager.isEnabledMusic && MusicManager.playerMusic != null) {
            if (MusicManager.playerMusic.getState() == 400) {
                MusicManager.musicStop();
            }
        }
    }

    protected void showNotify() {
        if (gameStarted && MusicManager.isEnabledMusic && MusicManager.playerMusic != null) {
            if (MusicManager.playerMusic.getState() != 400) {
                MusicManager.musicStart();
            }
        }
        gamePaused = false;
    }

    public static void showErrorScreen(String errorMessage) {
        current.showErrorScreenLoc(errorMessage);
    }

    public void showErrorScreenLoc(String errorMessage) {
        currentScreen = 99;
        if (!this.isErrorShown) {
            this.errorMessage = errorMessage;
            this.isErrorShown = true;
        }
        this.repaint();
    }

    private void paint_ErrorScreen(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 240, 320);
        g.setColor(0);
        Lib.drawTextLines(g, Fonts.fontDialog.wrapString(Fonts.fontMapper.mapString(this.errorMessage), 216, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT), 120, 160, Fonts.fontDialog, true, 0);
    }

    private void keyPressed_ErrorScreen(int key) {
        Main.currentMidlet.destroyApp(true);
    }

    public static void pause(int time) {
        try {
            Thread.sleep(time);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    static {
        current = null;
        gameStarted = false;
        gamePaused = false;
        imgCurrentBackground = null;
        imgCurrentImage = null;
        imgIconsMain = null;
        imgFaces = null;
        imgArrows = null;
        imgClothesParts = new Image[Apearance.CLOTHES_PARTS_POSITIONS_X.length];
        imgHud = null;
        imgFilmFrame = null;
        imgTransparent = null;
        currentScreen = -1;
        previousScreenStack = new Stack();
        isContinueIconEnabled = false;
        isSleeping = false;
        flashState = false;
        isFlashing = false;
        stopFlashing = false;
        FLASH_INTERVAL = 750;
        keysBlocked = false;
    }

    public class OperationThread
    extends Thread {
        public int operation = -1;
        public static final int OP_DELAYED_SECOND_LOGO = 0;
        public static final int OP_LOADING_APP = 1;
        public static final int OP_OPEN_MENU_ANIMATION = 2;
        public static final int OP_CLOSE_MENU_ANIMATION = 3;
        public static final int OP_CHANGE_SCREEN = 4;
        public static final int OP_ANIMATE_ICONS_AND_ARROWS = 5;
        public static final int OP_ANIMATE_GAME = 6;
        public static final int OP_FLASH = 7;
        public static final int OP_SLEEP = 8;
        public static final int OP_ANIMATE_COLORS = 9;
        public static final int OP_EXIT = 99;
        public static final int OP_START_MUSIC = 10;
        public static final int OP_STOP_MUSIC = 11;
        public int nextScreen = -1;

        public OperationThread(int requiredOperation) {
            this.operation = requiredOperation;
        }

        public OperationThread(int requiredOperation, int requestedScreen) {
            this.operation = requiredOperation;
            this.nextScreen = requestedScreen;
            MenuField.menuFieldHeightCurrentMax = MenuField.menuFieldHeightCurrent;
            switch (requestedScreen) {
                case 3: {
                    MenuField.menuFieldHeightRequested = MenuScreen.MENU_FIELD_HEIGHT;
                    System.out.println("Screen menu main requested");
                    break;
                }
                case 4: {
                    MenuField.menuFieldHeightRequested = HelpScreen.HELP_FIELD_HEIGHT;
                    break;
                }
                case 5: {
                    MenuField.menuFieldHeightRequested = HelpScreen.HELP_FIELD_HEIGHT;
                    break;
                }
                case 6: {
                    MenuField.menuFieldHeightRequested = OptionsScreen.OPTIONS_FIELD_HEIGHT;
                    break;
                }
                case 89: {
                    MenuField.menuFieldHeightRequested = FinishGameScreen.FINISH_FIELD_HEIGHT;
                    break;
                }
                case 12: {
                    MenuField.menuFieldHeightRequested = 161;
                }
            }
        }

        public synchronized void run() {
            try {
                switch (this.operation) {
                    case 1: {
                        GameManager.this.opLoadGame();
                        break;
                    }
                    case 0: {
                        OperationThread.sleep(LogoScreen.BRAND_LOGO_DISPLAY_TIME);
                        LogoScreen.requestSecondLogoDisplayed = true;
                        if (GetMoreGamesScreen.gmgStartupEnabled && !GetMoreGamesScreen.logoDisabled) {
                            currentScreen = -1;
                            GetMoreGamesScreen.showGmgScreen();
                        }
                        GameManager.this.repaint();
                        break;
                    }
                    case 7: {
                        isFlashing = true;
                        flashState = true;
                        while (!stopFlashing) {
                            flashState = !flashState;
                            OperationThread.sleep(FLASH_INTERVAL);
                            GameManager.this.repaint();
                        }
                        isFlashing = false;
                        stopFlashing = false;
                        break;
                    }
                    case 2: {
                        MenuField.menuOpenAnimation();
                        break;
                    }
                    case 3: {
                        MenuField.menuCloseAnimation();
                        break;
                    }
                    case 4: {
                        if (MenuField.isAnimationFieldResizeInProgress) {
                            return;
                        }
                        MenuField.isAnimationFieldResizeInProgress = true;
                        if (currentScreen == 3 || currentScreen == 4 || currentScreen == 5 || currentScreen == 6 || currentScreen == 12 || currentScreen == 2 || currentScreen == 89) {
                            MenuField.menuCloseAnimation();
                        }
                        if (currentScreen == 12) {
                            GetMoreGamesScreen.unload();
                        }
                        currentScreen = this.nextScreen;
                        GameManager.this.repaint();
                        MenuScreen.changeItems();
                        if (this.nextScreen == 3 || currentScreen == 4 || currentScreen == 5 || currentScreen == 6 || currentScreen == 12 || currentScreen == 2 || currentScreen == 89) {
                            MenuField.menuOpenAnimation();
                        }
                        if (!(this.nextScreen != 3 && this.nextScreen != 5 && this.nextScreen != 6 && currentScreen != 12 || MenuScreen.isAnimationIconsInProgress)) {
                            new OperationThread(5).start();
                        }
                        MenuField.isAnimationFieldResizeInProgress = false;
                        break;
                    }
                    case 5: {
                        MenuScreen.opAnimateIconsAndArrows();
                        break;
                    }
                    case 6: {
                        DialogScreen.opAnimateGame();
                        break;
                    }
                    case 10: {
                        MusicManager.opStartMusicInternal();
                        break;
                    }
                    case 11: {
                        MusicManager.opStopMusicInternal();
                        break;
                    }
                    case 99: {
                        MenuField.menuCloseAnimation();
                        OperationThread.sleep(200L);
                        currentScreen = -1;
                        Main.currentMidlet.destroyApp(false);
                    }
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
    }
}

