/*
 * Decompiled with CFR 0.152.
 */
package game;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import lib.Fonts;
import lib.TextInputStream;
import main.FrameOfScenario;
import main.GameManager;
import main.Main;

public class Scenario {
    private static Vector scenario = null;
    private static int[] framesStates;

    public static FrameOfScenario elementAt(int i) {
        return (FrameOfScenario)scenario.elementAt(i);
    }

    public static FrameOfScenario firstElement() {
        return (FrameOfScenario)scenario.firstElement();
    }

    public static int getFramesStates(int i) {
        return framesStates[i];
    }

    public static void initFrameStates() {
        framesStates = new int[scenario.size()];
    }

    public static void loadScenario() {
        Scenario.loadScenario("/scenario.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void loadScenario(String filename) {
        TextInputStream tis;
        InputStream is = ((Object)((Object)Main.currentMidlet)).getClass().getResourceAsStream(filename);
        if (is == null) {
            GameManager.showErrorScreen("Scenario file missing!");
            return;
        }
        try {
            tis = new TextInputStream(is);
        }
        catch (Throwable ex) {
            GameManager.showErrorScreen("Scenario file missing!");
            return;
        }
        if (tis == null) {
            GameManager.showErrorScreen("Scenario file missing!");
            return;
        }
        scenario = new Vector(100);
        String header = null;
        FrameOfScenario fos = null;
        try {
            while (true) {
                int i;
                int count;
                if ((header = tis.readLine()).length() == 0) {
                    continue;
                }
                int id = Integer.parseInt(header.substring(1, 4));
                if (scenario.size() > id && scenario.elementAt(id) != null) {
                    GameManager.showErrorScreen("Frame " + id + " already exists!");
                    return;
                }
                char imageId = header.charAt(5);
                char type = header.charAt(6);
                int paramCount = count = header.charAt(8) - 48;
                if (type == 'A') {
                    paramCount = 2 * count + 1;
                    count += 2;
                } else if (type == 'C') {
                    paramCount = count + 1;
                } else if (type == 'J') {
                    ++paramCount;
                    ++paramCount;
                    ++count;
                }
                fos = new FrameOfScenario(id, imageId, type, count, paramCount);
                for (i = 0; i < count * 2; ++i) {
                    fos.headIds[i] = header.charAt(10 + i) - 65;
                }
                for (i = 0; i < paramCount; ++i) {
                    fos.nextId[i] = Integer.parseInt(header.substring(count * 2 + 11 + i * 4, count * 2 + 14 + i * 4));
                }
                for (i = 0; i < count; ++i) {
                    int textWidthSecond;
                    String text = null;
                    text = tis.readLine();
                    if (type == 'I') {
                        int textWidth = 224;
                        fos.textPlayer[i] = Fonts.fontDialog.wrapString(Fonts.fontMapper.mapString(text), textWidth, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
                        continue;
                    }
                    int textWidthFirst = textWidthSecond = 224;
                    if (count > 1 && (type == 'D' || type == 'C' || type == 'J' || type == 'V') || count > 3 && type == 'A') {
                        textWidthFirst = 240 - GameManager.imgArrows.getWidth() - 12;
                    }
                    int[] textMappedFirst = Fonts.fontMapper.mapString(text.substring(0, text.indexOf(35)));
                    int[] textMappedSecond = Fonts.fontMapper.mapString(text.substring(text.indexOf(35) + 1));
                    fos.textPlayer[i] = Fonts.fontDialog.wrapString(textMappedFirst, textWidthFirst, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
                    fos.textLady[i] = Fonts.fontDialog.wrapString(textMappedSecond, textWidthSecond, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
                }
                if (scenario.size() < id + 1) {
                    scenario.setSize(id + 1);
                }
                scenario.setElementAt(fos, id);
                continue;
                break;
            }
        }
        catch (EOFException ex) {
            return;
        }
        catch (NumberFormatException ex) {
            ex.printStackTrace();
            GameManager.showErrorScreen("Can't parse some numbers at\\" + header);
            return;
        }
        catch (StringIndexOutOfBoundsException ex) {
            ex.printStackTrace();
            GameManager.showErrorScreen("Can't parse header at\\" + header);
            return;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            GameManager.showErrorScreen("Can't read frame at\\" + header);
            return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            GameManager.showErrorScreen("Unknown error.\\" + ex.getMessage());
            return;
        }
        finally {
            try {
                tis.close();
            }
            catch (IOException ex) {}
            tis = null;
            is = null;
        }
    }

    public static void setFramesStates(int id, int value) {
        Scenario.framesStates[id] = value;
    }

    public static int size() {
        return scenario.size();
    }
}

