/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class AnimatedObject {
    private AnimatedObject pNext;
    private AnimatedObjectData pAnimatedObjectData;
    int nAObjectDataType;
    short nScreenPosX;
    short nScreenPosY;
    byte nFrameTick;
    short nCurrentAction;
    short nNextAction = (short)-1;
    short nCurrentFrame;
    byte nFlags;
    byte nDelay = 1;
    boolean bLoop = true;
    static AnimatedObject pLowPriorityRoot;
    static boolean bDrawn;

    AnimatedObject(int n, int n2, boolean bl) {
        GameCanvasEx.RM_Load(n);
        GameCanvasEx.RM_Synchronize();
        this.pAnimatedObjectData = AnimatedObjectData.loadData(GameCanvasEx.RM_GetResource_Array_Byte(n), n2, bl);
        this.nAObjectDataType = this.pAnimatedObjectData.nType;
        if (bl) {
            GameCanvasEx.RM_Free(n);
            GameCanvasEx.RM_Synchronize();
        }
    }

    AnimatedObject(int n, int n2) {
        GameCanvasEx.RM_Load(n);
        GameCanvasEx.RM_Synchronize();
        this.pAnimatedObjectData = AnimatedObjectData.loadData(GameCanvasEx.RM_GetResource_Array_Byte(n), n2);
        this.nAObjectDataType = this.pAnimatedObjectData.nType;
        GameCanvasEx.RM_Free(n);
        GameCanvasEx.RM_Synchronize();
    }

    private void play() {
        this.nFrameTick = (byte)(this.nFrameTick + 1);
        if (this.nNextAction != -1) {
            this.nCurrentAction = this.nNextAction;
            this.nCurrentFrame = 0;
            this.nFrameTick = 0;
            this.nNextAction = (short)-1;
        } else if (this.nFrameTick >= this.nDelay) {
            this.nFrameTick = 0;
            this.nCurrentFrame = (short)(this.nCurrentFrame + 1);
            if (this.nCurrentFrame >= AnimatedObjectData.getFrameCountInAction(this.nAObjectDataType, this.nCurrentAction)) {
                this.nCurrentFrame = this.bLoop ? (short)0 : (short)(this.nCurrentFrame - 1);
            }
        }
        this.nDelay = (byte)AnimatedObjectData.getFrameDuration(this.nAObjectDataType, AnimatedObjectData.getFrameIdInAction(this.nAObjectDataType, this.nCurrentAction, this.nCurrentFrame));
    }

    void setNextAction(int n) {
        this.nNextAction = (short)n;
        this.bLoop = true;
    }

    void setLooping(boolean bl) {
        this.bLoop = bl;
    }

    void setPosition(int n, int n2) {
        this.nScreenPosX = (short)n;
        this.nScreenPosY = (short)n2;
    }

    void addToDrawList(boolean bl) {
        AnimatedObject.AnimationPlayer_Play(this, bl);
    }

    boolean isEndOfAnimation() {
        return this.nCurrentFrame == AnimatedObjectData.getFrameCountInAction(this.nAObjectDataType, this.nCurrentAction) - 1 || this.nNextAction != -1;
    }

    void rewind() {
        this.nCurrentFrame = 0;
        this.nFrameTick = this.nDelay;
    }

    void drawFrame(int n, Graphics graphics) {
        int n2 = AnimatedObjectData.getFrameNumberOfSprite(this.nAObjectDataType, n);
        short s = this.pAnimatedObjectData.nType;
        for (int i = 0; i < n2; ++i) {
            int n3 = AnimatedObjectData.getSpritePosX(this.nAObjectDataType, n, i);
            int n4 = AnimatedObjectData.getSpritePosY(this.nAObjectDataType, n, i);
            int n5 = AnimatedObjectData.getSpriteModuleIndex(this.nAObjectDataType, n, i);
            int n6 = 0;
            int n7 = this.nScreenPosX + n3;
            int n8 = this.nScreenPosY + n4;
            AnimatedObjectData.drawModule(this.nAObjectDataType, n5, n7, n8, n6, graphics);
        }
    }

    static void AnimationPlayer_InitFrame() {
        pLowPriorityRoot = null;
        bDrawn = false;
    }

    static void AnimationPlayer_Play(AnimatedObject animatedObject, boolean bl) {
        if (animatedObject == null) {
            return;
        }
        animatedObject.pNext = pLowPriorityRoot;
        pLowPriorityRoot = animatedObject;
    }

    static void AnimationPlayer_Execute(Graphics graphics) {
        if (bDrawn) {
            return;
        }
        AnimatedObject animatedObject = pLowPriorityRoot;
        while (animatedObject != null) {
            if (graphics == null) {
                animatedObject.play();
            } else {
                bDrawn = true;
                int n = AnimatedObjectData.getFrameIdInAction(animatedObject.nAObjectDataType, animatedObject.nCurrentAction, animatedObject.nCurrentFrame);
                animatedObject.drawFrame(n, graphics);
            }
            animatedObject = animatedObject.pNext;
        }
    }

    void Free() {
        if (this.pAnimatedObjectData != null) {
            AnimatedObjectData.Free(this.pAnimatedObjectData.nType);
            this.pAnimatedObjectData = null;
        }
        AnimatedObject.AnimationPlayer_InitFrame();
    }
}

