/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.common.midp20;

import com.kitmaker.games.common.ISoundController;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundController
implements ISoundController {
    private Player[] aH;

    public void initializeSound(byte by) {
        this.destroy();
        this.aH = new Player[by];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte loadMIDI(InputStream inputStream) {
        int n = -1;
        if (this.aH != null) {
            n = 0;
            boolean bl = false;
            while (n < this.aH.length && !bl) {
                if (this.aH[n] == null) {
                    bl = true;
                    continue;
                }
                n = (byte)(n + 1);
            }
            if (!bl) {
                n = -1;
            } else {
                try {
                    this.aH[n] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                    this.aH[n].realize();
                }
                catch (Exception exception) {
                    this.aH[n] = null;
                    n = -1;
                }
            }
        }
        return (byte)n;
    }

    public boolean prefetch(byte by) {
        boolean bl = false;
        if (this.aH != null && by > -1 && by < this.aH.length && this.aH[by] != null && this.aH[by].getState() == 200) {
            try {
                this.aH[by].prefetch();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(byte by) {
        boolean bl = false;
        if (this.aH != null && by > -1 && by < this.aH.length && this.aH[by] != null) {
            try {
                this.aH[by].close();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
            finally {
                this.aH[by] = null;
            }
        }
        return bl;
    }

    public boolean deallocate(byte by) {
        boolean bl = false;
        if (this.aH != null && by > -1 && by < this.aH.length && this.aH[by] != null && this.aH[by].getState() == 300) {
            try {
                this.aH[by].deallocate();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public boolean play(byte by) {
        boolean bl = false;
        if (this.aH != null && by > -1 && by < this.aH.length && this.aH[by] != null) {
            try {
                this.aH[by].setLoopCount(1);
                this.aH[by].start();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public byte getPlayerState(byte by) {
        int n = -1;
        if (this.aH != null && by > -1 && by < this.aH.length && this.aH[by] != null) {
            switch (this.aH[by].getState()) {
                case 200: {
                    n = 1;
                    break;
                }
                case 300: {
                    n = 0;
                    break;
                }
                case 400: {
                    n = 2;
                    break;
                }
                default: {
                    n = -1;
                }
            }
        }
        return (byte)n;
    }

    public boolean stop(byte by) {
        boolean bl = false;
        if (this.aH != null && by > -1 && by < this.aH.length && this.aH[by] != null && this.aH[by].getState() == 400) {
            try {
                this.aH[by].stop();
                bl = true;
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    public void destroy() {
        if (this.aH != null) {
            for (int i = 0; i < this.aH.length; ++i) {
                if (this.aH[i] == null) continue;
                this.aH[i].close();
                this.aH[i] = null;
            }
        }
    }

    public byte getFirstPrefetchedPlayer() {
        byte by = -1;
        if (this.aH != null) {
            for (int i = 0; i < this.aH.length; ++i) {
                Player player;
                int n;
                if (this.aH[i] == null || (n = (player = this.aH[i]).getState()) == 300 || n == 400) continue;
                by = (byte)i;
                break;
            }
        }
        return by;
    }

    public boolean isSoundSupported() {
        return true;
    }
}

