/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import lib.Fonts;
import lib.TextInputStream;
import main.GameManager;
import main.Main;
import screens.FinishGameScreen;
import screens.HelpScreen;
import screens.LogoScreen;
import screens.MenuScreen;
import screens.OptionsScreen;
import screens.elements.Hint;

public class Configuration {
    private static Hashtable conf = new Hashtable();

    public static void loadConfFile() {
        Configuration.loadConfFile("/lang.txt");
    }

    public static void loadConfFile(String string) {
        TextInputStream textInputStream = null;
        conf = new Hashtable();
        String[] stringArray = new String[]{string, "/conf.txt", "/about.txt"};
        int n = -1;
        for (n = 0; n < stringArray.length; ++n) {
            try {
                textInputStream = new TextInputStream(((Object)((Object)Main.currentMidlet)).getClass().getResourceAsStream(stringArray[n]));
                if (textInputStream == null) {
                    GameManager.showErrorScreen("Can't load conf file!");
                    return;
                }
                String string2 = null;
                while ((string2 = textInputStream.readLine()) != null) {
                    if (string2.length() <= 0 || string2.indexOf(61) < 0) continue;
                    conf.put(string2.substring(0, string2.indexOf(61)), string2.substring(string2.indexOf(61) + 1));
                }
                textInputStream.close();
                continue;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                GameManager.showErrorScreen("Wrong encoding for reading text file!!");
                unsupportedEncodingException.printStackTrace();
                continue;
            }
            catch (EOFException eOFException) {
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                GameManager.showErrorScreen("Array index OoB ex!!");
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GameManager.showErrorScreen("Illega argu!!");
                continue;
            }
            catch (IllegalStateException illegalStateException) {
                GameManager.showErrorScreen("Illegal state!!");
                continue;
            }
            catch (IOException iOException) {
                GameManager.showErrorScreen("IOExeption reading text file!!");
                iOException.printStackTrace();
                continue;
            }
            catch (Exception exception) {
                GameManager.showErrorScreen("Another exceprion reading text file!!" + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    public static void initializeConstants() {
        String string;
        MenuScreen.MENU_FIELD_HEIGHT = Configuration.getConfInt("MENU_FIELD_HEIGHT");
        MenuScreen.MENU_FIELD_BORDER_COLOR = Configuration.getConfInt("MENU_FIELD_BORDER_COLOR");
        MenuScreen.MENU_TEXT_MARGIN = Configuration.getConfInt("MENU_TEXT_MARGIN");
        MenuScreen.MENU_ICONS_POSITION = Configuration.getConfInt("MENU_ICONS_POSITION");
        MenuScreen.MENU_ANIMATION_BASE_INTERVAL = Configuration.getConfInt("MENU_ANIMATION_BASE_INTERVAL");
        MenuScreen.MENU_ANIMATION_OPENING_SPEED = Configuration.getConfInt("MENU_ANIMATION_OPENING_SPEED");
        MenuScreen.MENU_ANIMATION_CLOSING_SPEED = Configuration.getConfInt("MENU_ANIMATION_CLOSING_SPEED");
        MenuScreen.MENU_ANIMATION_OPENING_MIN_SPEED = Configuration.getConfInt("MENU_ANIMATION_OPENING_MIN_SPEED");
        MenuScreen.MENU_ICONS_WIDTH = Configuration.getConfInt("MENU_ICONS_WIDTH");
        MenuScreen.MENU_ICONS_SMALL_WIDTH = Configuration.getConfInt("MENU_ICONS_SMALL_WIDTH");
        MenuScreen.MENU_ARROW_MOVEMENT_SIZE = Configuration.getConfInt("MENU_ARROW_MOVEMENT_SIZE");
        MenuScreen.MENU_ARROW_MOVEMENT_STEP = Configuration.getConfInt("MENU_ARROW_MOVEMENT_STEP");
        MenuScreen.TEXT_MENU_MAIN_START = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_MAIN_START"));
        MenuScreen.TEXT_MENU_INSTRUCTIONS = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_INSTRUCTIONS"));
        MenuScreen.TEXT_MENU_ABOUT = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_ABOUT"));
        MenuScreen.TEXT_MENU_EXIT = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_EXIT"));
        MenuScreen.TEXT_MENU_CONTINUE = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_CONTINUE"));
        MenuScreen.TEXT_MENU_OPTIONS = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_OPTIONS"));
        MenuScreen.TEXT_MENU_GOTO_MAIN = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_GOTO_MAIN"));
        MenuScreen.TEXT_MENU_ARCADE = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_ARCADE"));
        MenuScreen.TEXT_MENU_FOTO_DEBUG_1 = Fonts.fontMapper.mapString("azjatka");
        MenuScreen.TEXT_MENU_FOTO_DEBUG_2 = Fonts.fontMapper.mapString("ciemna");
        MenuScreen.TEXT_MUSIC_ON = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MUSIC_ON"));
        MenuScreen.TEXT_MUSIC_OFF = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MUSIC_OFF"));
        MenuScreen.TEXT_MENU_GET_MORE_GAMES = Fonts.fontMapper.mapString(Configuration.getConfString("TEXT_MENU_GET_MORE_GAMES"));
        MenuScreen.MENU_ITEMS_MAIN = new int[][]{MenuScreen.TEXT_MENU_MAIN_START, MenuScreen.TEXT_MENU_OPTIONS, MenuScreen.TEXT_MENU_INSTRUCTIONS, MenuScreen.TEXT_MENU_ABOUT, MenuScreen.TEXT_MENU_EXIT};
        MenuScreen.MENU_ITEMS_MAIN_ICONS_INDEXES = new int[]{0, 3, 1, 2, 5};
        MenuScreen.MENU_ITEMS_MAIN_WITH_ARCADE = new int[][]{MenuScreen.TEXT_MENU_ARCADE, MenuScreen.TEXT_MENU_MAIN_START, MenuScreen.TEXT_MENU_OPTIONS, MenuScreen.TEXT_MENU_INSTRUCTIONS, MenuScreen.TEXT_MENU_ABOUT, MenuScreen.TEXT_MENU_EXIT};
        MenuScreen.MENU_ITEMS_MAIN_ARCADE_ICONS_INDEXES = new int[]{6, 0, 3, 1, 2, 5};
        MenuScreen.MENU_ITEMS_INGAME = new int[][]{MenuScreen.TEXT_MENU_CONTINUE, MenuScreen.TEXT_MENU_OPTIONS, MenuScreen.TEXT_MENU_INSTRUCTIONS, MenuScreen.TEXT_MENU_ABOUT, MenuScreen.TEXT_MENU_GOTO_MAIN};
        MenuScreen.MENU_ITEMS_INGAME_ICONS_INDEXES = new int[]{6, 3, 1, 2, 4};
        MenuScreen.MENU_ITEMS_ENABLE_SOUND = new int[][]{MenuScreen.TEXT_MUSIC_OFF, MenuScreen.TEXT_MUSIC_ON};
        MenuScreen.MENU_ITEMS_ENABLE_SOUND_ICONS_INDEXES = new int[]{8, 7};
        OptionsScreen.OPTION_TEXT_MUSIC = Configuration.getConfString("OPTION_TEXT_MUSIC");
        OptionsScreen.OPTION_TEXT_SOUND = Configuration.getConfString("OPTION_TEXT_SOUND");
        OptionsScreen.OPTION_TEXT_ENABLE_SOUND = Configuration.getConfString("OPTION_TEXT_ENABLE_SOUND");
        OptionsScreen.OPTION_TEXT_OK = Configuration.getConfString("OPTION_TEXT_OK");
        OptionsScreen.OPTION_TEXT_OFF = Configuration.getConfString("OPTION_TEXT_OFF");
        OptionsScreen.OPTION_TEXT_YES = Configuration.getConfString("OPTION_TEXT_YES");
        OptionsScreen.OPTION_TEXT_NO = Configuration.getConfString("OPTION_TEXT_NO");
        OptionsScreen.OPTIONS_TEXTS = new String[]{OptionsScreen.OPTION_TEXT_OK, OptionsScreen.OPTION_TEXT_ENABLE_SOUND, OptionsScreen.OPTION_TEXT_MUSIC};
        OptionsScreen.optionInterline = 6;
        OptionsScreen.OPTIONS_FIELD_HEIGHT = (OptionsScreen.OPTIONS_TEXTS.length * (Fonts.fontMenu.getHeight() + OptionsScreen.optionInterline) + OptionsScreen.optionInterline * 2) / 2;
        HelpScreen.HELP_FIELD_HEIGHT = Configuration.getConfInt("HELP_FIELD_HEIGHT");
        HelpScreen.HELP_TEXT_WIDTH = Configuration.getConfInt("HELP_TEXT_WIDTH");
        HelpScreen.ABOUT_FIELD_HEIGHT = Configuration.getConfInt("ABOUT_FIELD_HEIGHT");
        HelpScreen.HELP_TEXT_LINES = Fonts.fontHelpPlain.wrapString(Fonts.fontMapper.mapString(Configuration.getConfString("help.text")), 240 * HelpScreen.HELP_TEXT_WIDTH / 100 - GameManager.imgArrows.getWidth() / 2, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
        HelpScreen.helpTextLinesOnScreen = HelpScreen.HELP_FIELD_HEIGHT * 2 / (Fonts.fontHelpPlain.getHeight() + HelpScreen.HELP_TEXT_INTERLINE);
        HelpScreen.HELP_FIELD_HEIGHT = ((Fonts.fontHelpPlain.getHeight() + HelpScreen.HELP_TEXT_INTERLINE) * HelpScreen.helpTextLinesOnScreen + HelpScreen.HELP_TEXT_TOP_MARGIN * 2 + 1) / 2 + 1;
        String string2 = Configuration.getConfString("ABOUT_TEXT");
        int n = string2.indexOf(string = "%%app-spec%%");
        if (n != -1) {
            string2 = string2.substring(0, n) + string2.substring(n + string.length(), string2.length());
        }
        HelpScreen.ABOUT_TEXT_LINES = Fonts.fontHelpPlain.wrapString(Fonts.fontMapper.mapString(string2), 240 * HelpScreen.HELP_TEXT_WIDTH / 100 - GameManager.imgArrows.getWidth() / 2, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
        int n2 = Configuration.getConfInt("HINTS_COUNT");
        Hint.HINTS_TEXTS = new int[n2][];
        for (int i = 0; i < n2; ++i) {
            Hint.HINTS_TEXTS[i] = Fonts.fontMapper.mapString(Configuration.getConfString("HINT_TEXT_" + i));
        }
        FinishGameScreen.FINISH_FIELD_HEIGHT = Configuration.getConfInt("FINISH_FIELD_HEIGHT");
        FinishGameScreen.FINISH_MARGIN = Configuration.getConfInt("FINISH_MARGIN");
        FinishGameScreen.FINISH_END_TEXT = Fonts.fontMapper.mapString(Configuration.getConfString("FINISH_END_TEXT"));
        LogoScreen.LOGO_TEXT_LOADING = Fonts.fontMapper.mapString(Configuration.getConfString("LOGO_TEXT_LOADING"));
        int[][] nArray = Fonts.fontHelpPlain.wrapString(Fonts.fontMapper.mapString(Configuration.getConfString("LOGO_TEXT_PRESS")), 228, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT);
        LogoScreen.LOGO_TEXT_PRESS = nArray[0];
        if (nArray.length > 1) {
            LogoScreen.LOGO_TEXT_PRESS_2 = nArray[1];
        } else {
            LogoScreen.LOGO_BAR_COLOR = Configuration.getConfHex("LOGO_BAR_COLOR");
        }
        LogoScreen.LOGO_BAR_WIDTH = Configuration.getConfInt("LOGO_BAR_WIDTH");
        LogoScreen.LOGO_BAR_HEIGHT = Configuration.getConfInt("LOGO_BAR_HEIGHT");
        LogoScreen.LOGO_BAR_POS = Configuration.getConfInt("LOGO_BAR_POS");
        LogoScreen.LOGO_TEXT_POS = Configuration.getConfInt("LOGO_TEXT_POS");
    }

    public static int getConfInt(Object object) {
        try {
            return Integer.parseInt((String)conf.get(object));
        }
        catch (Exception exception) {
            GameManager.showErrorScreen("Can't read " + object);
            return 0;
        }
    }

    public static int getConfHex(Object object) {
        try {
            return Integer.parseInt((String)conf.get(object), 16);
        }
        catch (Exception exception) {
            GameManager.showErrorScreen("Can't read " + object);
            return 0;
        }
    }

    public static String getConfString(Object object) {
        String string = (String)conf.get(object);
        if (string == null) {
            GameManager.showErrorScreen("Can't read '" + object);
            return null;
        }
        return string;
    }

    public static void clear() {
        conf.clear();
        conf = null;
    }
}

