/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;
import main.GameManager;
import main.Main;
import screens.DialogScreen;

public class MusicManager {
    public static boolean isEnabledMusic = false;
    public static Player playerMusic = null;
    public static int VOLUME_MAX = 10;
    public static int volumeMusic = VOLUME_MAX / 2;

    public static void loadSettings() {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)false);
            byte[] byArray = recordStore.getRecord(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            isEnabledMusic = dataInputStream.readBoolean();
            volumeMusic = dataInputStream.readInt();
            dataInputStream.close();
            recordStore.closeRecordStore();
        }
        catch (Throwable throwable) {
            isEnabledMusic = true;
            GameManager.isContinueIconEnabled = false;
            DialogScreen.continueFrameId = -1;
            volumeMusic = VOLUME_MAX / 2;
        }
    }

    public static void writeSettings() {
        try {
            RecordStore.deleteRecordStore((String)"Settings");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeBoolean(isEnabledMusic);
            dataOutputStream.writeInt(volumeMusic);
            dataOutputStream.flush();
            recordStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            dataOutputStream.close();
            recordStore.closeRecordStore();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void musicStart() {
        GameManager.current.startOperation(10);
    }

    public static void musicStop() {
        GameManager.current.startOperation(11);
    }

    public static void init() {
        MusicManager.loadMusicPlayer();
    }

    public static void loadMusicPlayer() {
        try {
            playerMusic = Manager.createPlayer((InputStream)((Object)((Object)Main.currentMidlet)).getClass().getResourceAsStream("/melody.mid"), (String)"audio/midi");
            if (playerMusic == null) {
                isEnabledMusic = false;
                return;
            }
            playerMusic.realize();
            playerMusic.setLoopCount(-1);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            GameManager.showErrorScreen("Can't load music file!\\" + throwable.getMessage());
            return;
        }
        MusicManager.setMusicVolume(volumeMusic);
    }

    public static void opStartMusicInternal() {
        try {
            playerMusic.start();
            MusicManager.setMusicVolume(volumeMusic);
        }
        catch (Exception exception) {
            playerMusic.close();
            System.gc();
            MusicManager.loadMusicPlayer();
            try {
                playerMusic.start();
                MusicManager.setMusicVolume(volumeMusic);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void opStopMusicInternal() {
        try {
            playerMusic.stop();
            playerMusic.deallocate();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setMusicVolume(int n) {
        volumeMusic = n;
        try {
            VolumeControl volumeControl = (VolumeControl)playerMusic.getControl("VolumeControl");
            if (volumeControl != null) {
                volumeControl.setLevel(volumeMusic * 10);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

