/*
 * Decompiled with CFR 0.152.
 */
package main;

import com.nokia.mid.ui.FullCanvas;
import game.Apearance;
import java.util.Stack;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import lib.Fonts;
import lib.Lib;
import main.Configuration;
import main.Main;
import main.MusicManager;
import screens.DialogScreen;
import screens.FinishGameScreen;
import screens.GetMoreGamesScreen;
import screens.HelpScreen;
import screens.LogoScreen;
import screens.MenuScreen;
import screens.OptionsScreen;
import screens.elements.MassageSessionModus;
import screens.elements.MenuField;

public class GameManager
extends FullCanvas {
    public static GameManager current = null;
    public static final int SCREEN_LOGO = 1;
    public static final int SCREEN_LANG_MENU = 2;
    public static final int SCREEN_MENU_MAIN = 3;
    public static final int SCREEN_MENU_ABOUT = 4;
    public static final int SCREEN_MENU_HELP = 5;
    public static final int SCREEN_MENU_OPTIONS = 6;
    public static final int SCREEN_GAME_DIALOG = 10;
    public static final int SCREEN_FINISH_GAME = 89;
    public static final int SCREEN_ERROR = 99;
    public static final int SCREEN_GET_MORE_GAMES = 12;
    public static boolean gameStarted = false;
    public static boolean gamePaused = false;
    public static boolean gameSystemPaused = false;
    public static Image imgCurrentBackground = null;
    public static Image imgCurrentImage = null;
    public static Image imgIconsMain = null;
    public static Image imgFaces = null;
    public static Image imgArrows = null;
    public static Image[] imgClothesParts = new Image[Apearance.CLOTHES_PARTS_POSITIONS_X.length];
    public static Image imgIconsSmall = null;
    public static Image imgTransparent = null;
    public static int currentScreen = -1;
    public static Stack previousScreenStack = new Stack();
    public static boolean isContinueIconEnabled = false;
    public static boolean isSleeping = false;
    public static boolean flashState = false;
    public static boolean isFlashing = false;
    public static boolean stopFlashing = false;
    public long previousBeginTime = 0L;
    public static int FLASH_INTERVAL = 750;
    public static boolean keysBlocked = false;
    public static boolean isKeyPressed = false;
    public static int keyPressed = 0;
    private String errorMessage = null;
    private boolean isErrorShown = false;

    public GameManager() {
        current = this;
        Fonts.init();
        GetMoreGamesScreen.init();
        currentScreen = 1;
    }

    public void paint(Graphics graphics) {
        switch (currentScreen) {
            case 1: {
                LogoScreen.paint_LogoScreen(graphics);
                break;
            }
            case 99: {
                this.paint_ErrorScreen(graphics);
                break;
            }
            case 3: {
                MenuScreen.paint_Menu(graphics);
                break;
            }
            case 6: {
                OptionsScreen.paint_Options(graphics);
                break;
            }
            case 4: {
                HelpScreen.paint_HelpAbout(graphics);
                break;
            }
            case 5: {
                HelpScreen.paint_HelpAbout(graphics);
                break;
            }
            case 10: {
                DialogScreen.paint_GameDialog(graphics);
                break;
            }
            case 12: {
                GetMoreGamesScreen.paint_GetMoreGames(graphics);
                break;
            }
            case 89: {
                FinishGameScreen.paint_Finish(graphics);
            }
        }
        keysBlocked = false;
    }

    public static void repaintCurrent() {
        current.repaint();
    }

    protected void keyReleased(int n) {
        if (n == keyPressed) {
            isKeyPressed = false;
            keyPressed = 0;
            MassageSessionModus.arrowSpeed = 1;
            MassageSessionModus.arrowAcceleration = 0;
        }
    }

    protected void keyPressed(int n) {
        if (keysBlocked || MenuField.isAnimationFieldResizeInProgress) {
            return;
        }
        keysBlocked = true;
        isKeyPressed = true;
        keyPressed = n;
        switch (currentScreen) {
            case 1: {
                LogoScreen.keyPressed_LogoScreen(n);
                break;
            }
            case 2: {
                System.out.println("KeyOnLangMenuHandling");
                break;
            }
            case 99: {
                this.keyPressed_ErrorScreen(n);
                break;
            }
            case 3: {
                MenuScreen.keyPressed_Menu(n);
                break;
            }
            case 6: {
                OptionsScreen.keyPressed_Options(n);
                break;
            }
            case 4: {
                HelpScreen.keyPressed_HelpAbout(n);
                break;
            }
            case 5: {
                HelpScreen.keyPressed_HelpAbout(n);
                break;
            }
            case 10: {
                try {
                    DialogScreen.keyPressed_GameDialog(n);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                break;
            }
            case 89: {
                FinishGameScreen.keyPressed_Finish(n);
                break;
            }
            case 12: {
                GetMoreGamesScreen.keyPressed_GetMoreGames(n);
            }
        }
    }

    protected void keyRepeated(int n) {
        if (MenuScreen.isAnimationIconsInProgress && MenuScreen.itemSelected != MenuScreen.itemDest) {
            return;
        }
        if (this.getGameAction(n) == 8) {
            return;
        }
        this.keyPressed(n);
    }

    public int getGameAction(int n) {
        if (n == -6) {
            return 8;
        }
        try {
            return super.getGameAction(n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 0;
        }
    }

    public void startApp() {
        new OperationThread(1).start();
    }

    public OperationThread startOperation(int n, int n2) {
        OperationThread operationThread = new OperationThread(n, n2);
        operationThread.start();
        return operationThread;
    }

    public OperationThread startOperation(int n) {
        OperationThread operationThread = new OperationThread(n);
        operationThread.start();
        return operationThread;
    }

    private void opLoadGame() {
        MusicManager.init();
        LogoScreen.imgLogoBrand = Lib.loadImage("/brand_logo.png");
        this.repaint();
        imgArrows = Lib.loadImage("/arrows.png");
        Configuration.loadConfFile();
        Configuration.initializeConstants();
        Configuration.clear();
        GetMoreGamesScreen.applyGMGIcon();
        new OperationThread(0).start();
        LogoScreen.imgLogoGame = Lib.loadImage("/title.png");
        this.repaint();
        if (GetMoreGamesScreen.gmgStartupEnabled && GetMoreGamesScreen.logoDisabled) {
            currentScreen = -1;
            GetMoreGamesScreen.showGmgScreen();
        }
        LogoScreen.loadingProgress = 10;
        this.repaint();
        LogoScreen.loadingProgress = 35;
        this.repaint();
        imgFaces = Lib.loadImage("/heads.png");
        LogoScreen.loadingProgress = 40;
        this.repaint();
        imgIconsMain = Lib.loadImage("/icons_main.png");
        LogoScreen.loadingProgress = 45;
        this.repaint();
        imgIconsSmall = Lib.loadImage("/icons_main_small.png");
        LogoScreen.loadingProgress = 46;
        this.repaint();
        imgTransparent = Lib.loadImage("/transparent.png");
        LogoScreen.loadingProgress = 50;
        this.repaint();
        MassageSessionModus.imgHand = Lib.loadImage("/hand.png");
        LogoScreen.loadingProgress = 55;
        this.repaint();
        LogoScreen.loadingProgress = 65;
        this.repaint();
        LogoScreen.loadingProgress = 70;
        this.repaint();
        LogoScreen.loadingProgress = 75;
        this.repaint();
        GameManager.pause(500);
        for (int i = 0; i < Apearance.CLOTHES_PARTS_POSITIONS_X.length; ++i) {
            GameManager.imgClothesParts[i] = Lib.loadImage("/part" + (i + 1) + ".png");
            LogoScreen.loadingProgress = 80 + i * 20 / Apearance.CLOTHES_PARTS_POSITIONS_X.length;
            this.repaint();
        }
        LogoScreen.loadingProgress = 99;
        this.repaint();
        GameManager.pause(500);
        LogoScreen.loadingProgress = 100;
        new OperationThread(7).start();
        this.repaint();
    }

    protected void hideNotify() {
        gamePaused = true;
        gameSystemPaused = true;
        if (gameStarted && MusicManager.isEnabledMusic && MusicManager.playerMusic != null) {
            if (MusicManager.playerMusic.getState() == 400) {
                MusicManager.musicStop();
            }
        }
    }

    protected void showNotify() {
        if (gameStarted && MusicManager.isEnabledMusic && MusicManager.playerMusic != null) {
            if (MusicManager.playerMusic.getState() != 400) {
                MusicManager.musicStart();
            }
        }
        gamePaused = false;
        gameSystemPaused = false;
    }

    public static void showErrorScreen(String string) {
        current.showErrorScreenLoc(string);
    }

    public void showErrorScreenLoc(String string) {
        currentScreen = 99;
        if (!this.isErrorShown) {
            this.errorMessage = string;
            this.isErrorShown = true;
        }
        this.repaint();
    }

    private void paint_ErrorScreen(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(0, 0, 240, 320);
        graphics.setColor(0);
        Lib.drawTextLines(graphics, Fonts.fontDialog.wrapString(Fonts.fontMapper.mapString(this.errorMessage), 216, Fonts.SPLIT_CHAR_INT, Fonts.BREAK_LINE_CHAR_INT), 120, 160, Fonts.fontDialog, true, 0);
    }

    private void keyPressed_ErrorScreen(int n) {
        Main.currentMidlet.destroyApp(true);
    }

    public static void pause(int n) {
        try {
            Thread.sleep(n);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public class OperationThread
    extends Thread {
        public int operation = -1;
        public static final int OP_DELAYED_SECOND_LOGO = 0;
        public static final int OP_LOADING_APP = 1;
        public static final int OP_OPEN_MENU_ANIMATION = 2;
        public static final int OP_CLOSE_MENU_ANIMATION = 3;
        public static final int OP_CHANGE_SCREEN = 4;
        public static final int OP_ANIMATE_ICONS_AND_ARROWS = 5;
        public static final int OP_ANIMATE_GAME = 6;
        public static final int OP_FLASH = 7;
        public static final int OP_SLEEP = 8;
        public static final int OP_ANIMATE_COLORS = 9;
        public static final int OP_COUNTDOWN = 50;
        public static final int OP_ARROW_MOVE = 51;
        public static final int OP_EXIT = 99;
        public static final int OP_START_MUSIC = 10;
        public static final int OP_STOP_MUSIC = 11;
        public int nextScreen = -1;

        public OperationThread(int n) {
            this.operation = n;
        }

        public OperationThread(int n, int n2) {
            this.operation = n;
            this.nextScreen = n2;
            MenuField.menuFieldHeightCurrentMax = MenuField.menuFieldHeightCurrent;
            switch (n2) {
                case 3: {
                    MenuField.menuFieldHeightRequested = MenuScreen.MENU_FIELD_HEIGHT;
                    System.out.println("Screen menu main requested");
                    break;
                }
                case 4: {
                    MenuField.menuFieldHeightRequested = HelpScreen.HELP_FIELD_HEIGHT;
                    break;
                }
                case 5: {
                    MenuField.menuFieldHeightRequested = HelpScreen.HELP_FIELD_HEIGHT;
                    break;
                }
                case 6: {
                    MenuField.menuFieldHeightRequested = OptionsScreen.OPTIONS_FIELD_HEIGHT;
                    break;
                }
                case 89: {
                    MenuField.menuFieldHeightRequested = FinishGameScreen.FINISH_FIELD_HEIGHT;
                    break;
                }
                case 12: {
                    MenuField.menuFieldHeightRequested = 161;
                }
            }
        }

        public synchronized void run() {
            try {
                switch (this.operation) {
                    case 1: {
                        GameManager.this.opLoadGame();
                        break;
                    }
                    case 0: {
                        OperationThread.sleep(LogoScreen.BRAND_LOGO_DISPLAY_TIME);
                        LogoScreen.requestSecondLogoDisplayed = true;
                        if (GetMoreGamesScreen.gmgStartupEnabled && !GetMoreGamesScreen.logoDisabled) {
                            currentScreen = -1;
                            GetMoreGamesScreen.showGmgScreen();
                        }
                        GameManager.this.repaint();
                        break;
                    }
                    case 7: {
                        isFlashing = true;
                        flashState = true;
                        while (!stopFlashing) {
                            flashState = !flashState;
                            OperationThread.sleep(FLASH_INTERVAL);
                            GameManager.this.repaint();
                        }
                        isFlashing = false;
                        stopFlashing = false;
                        break;
                    }
                    case 2: {
                        MenuField.menuOpenAnimation();
                        break;
                    }
                    case 3: {
                        MenuField.menuCloseAnimation();
                        break;
                    }
                    case 4: {
                        if (MenuField.isAnimationFieldResizeInProgress) {
                            return;
                        }
                        MenuField.isAnimationFieldResizeInProgress = true;
                        if (currentScreen == 3 || currentScreen == 4 || currentScreen == 5 || currentScreen == 6 || currentScreen == 12 || currentScreen == 2 || currentScreen == 89) {
                            MenuField.menuCloseAnimation();
                        }
                        if (currentScreen == 12) {
                            GetMoreGamesScreen.unload();
                        }
                        currentScreen = this.nextScreen;
                        GameManager.this.repaint();
                        MenuScreen.changeItems();
                        if (this.nextScreen == 3 || currentScreen == 4 || currentScreen == 5 || currentScreen == 6 || currentScreen == 12 || currentScreen == 2 || currentScreen == 89) {
                            MenuField.menuOpenAnimation();
                        }
                        if (!(this.nextScreen != 3 && this.nextScreen != 5 && this.nextScreen != 6 && currentScreen != 12 || MenuScreen.isAnimationIconsInProgress)) {
                            new OperationThread(5).start();
                        }
                        MenuField.isAnimationFieldResizeInProgress = false;
                        break;
                    }
                    case 5: {
                        MenuScreen.opAnimateIconsAndArrows();
                        break;
                    }
                    case 6: {
                        DialogScreen.opAnimateGame();
                        break;
                    }
                    case 50: {
                        System.out.println("+ OP_COUNTDOWN started");
                        MassageSessionModus.op_countdown();
                        break;
                    }
                    case 51: {
                        System.out.println("+ OP_ARROW_MOVE started");
                        while (DialogScreen.isArcadeModeActive) {
                            MassageSessionModus.op_animateArrows();
                            OperationThread.sleep(40L);
                        }
                        System.out.println("+ OP_ARROW_MOVE stopped");
                        break;
                    }
                    case 10: {
                        MusicManager.opStartMusicInternal();
                        break;
                    }
                    case 11: {
                        MusicManager.opStopMusicInternal();
                        break;
                    }
                    case 99: {
                        MenuField.menuCloseAnimation();
                        OperationThread.sleep(200L);
                        currentScreen = -1;
                        Main.currentMidlet.destroyApp(false);
                    }
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

