/*
 * Decompiled with CFR 0.152.
 */
package main;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;
import main.GameManager;
import main.Main;
import screens.DialogScreen;

public class MusicManager {
    public static boolean isEnabledMusic = false;
    public static Player playerMusic = null;
    public static Player playerFx = null;
    public static int VOLUME_MAX = 10;
    public static int volumeMusic = VOLUME_MAX / 2;

    public static void loadSettings() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Settings", (boolean)false);
            byte[] input = rs.getRecord(1);
            ByteArrayInputStream bais = new ByteArrayInputStream(input);
            DataInputStream dis = new DataInputStream(bais);
            isEnabledMusic = dis.readBoolean();
            volumeMusic = dis.readInt();
            dis.close();
            rs.closeRecordStore();
        }
        catch (Throwable ex) {
            isEnabledMusic = true;
            GameManager.isContinueIconEnabled = false;
            DialogScreen.continueFrameId = -1;
            volumeMusic = VOLUME_MAX / 2;
        }
    }

    public static void writeSettings() {
        try {
            RecordStore.deleteRecordStore((String)"Settings");
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Settings", (boolean)true);
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bao);
            dos.writeBoolean(isEnabledMusic);
            dos.writeInt(volumeMusic);
            dos.flush();
            rs.addRecord(bao.toByteArray(), 0, bao.toByteArray().length);
            dos.close();
            rs.closeRecordStore();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    public static void musicStart() {
        GameManager.current.startOperation(10);
    }

    public static void musicStop() {
        GameManager.current.startOperation(11);
    }

    public static void init() {
        MusicManager.loadMusicPlayer();
        MusicManager.loadFxPlayer();
    }

    public static void playFX() {
        if (isEnabledMusic) {
            try {
                playerMusic.stop();
                GameManager.pause(100);
                playerFx.start();
                GameManager.pause(400);
                GameManager.pause(50);
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
            try {
                playerMusic.start();
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
        GameManager.pause(150);
    }

    public static void setFxVolume(int volumeMusic) {
        try {
            VolumeControl vc = (VolumeControl)playerFx.getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(MusicManager.volumeMusic * 10);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void loadMusicPlayer() {
        try {
            playerMusic = Manager.createPlayer((InputStream)((Object)((Object)Main.currentMidlet)).getClass().getResourceAsStream("/melody.mid"), (String)"audio/midi");
            if (playerMusic == null) {
                isEnabledMusic = false;
                return;
            }
            playerMusic.realize();
            playerMusic.setLoopCount(-1);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            GameManager.showErrorScreen("Can't load music file!\\" + ex.getMessage());
            return;
        }
        MusicManager.setMusicVolume(volumeMusic);
    }

    public static void opStartMusicInternal() {
        try {
            playerMusic.start();
            MusicManager.setMusicVolume(volumeMusic);
        }
        catch (Exception ex) {
            playerMusic.close();
            System.gc();
            MusicManager.loadMusicPlayer();
            try {
                playerMusic.start();
                MusicManager.setMusicVolume(volumeMusic);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void opStopMusicInternal() {
        try {
            playerMusic.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setMusicVolume(int vol) {
        volumeMusic = vol;
        try {
            VolumeControl vc = (VolumeControl)playerMusic.getControl("VolumeControl");
            if (vc != null) {
                vc.setLevel(volumeMusic * 10);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void loadFxPlayer() {
        try {
            playerFx = Manager.createPlayer((InputStream)((Object)((Object)Main.currentMidlet)).getClass().getResourceAsStream("/shutter.wav"), (String)"audio/x-wav");
            if (playerFx != null) {
                playerFx.realize();
            }
            playerFx.prefetch();
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            GameManager.showErrorScreen("Can't load sound file!\\" + ex.getMessage());
            return;
        }
        VolumeControl vc2 = (VolumeControl)playerFx.getControl("VolumeControl");
        vc2.setLevel(volumeMusic * 10);
    }
}

