/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.common;

import com.kitmaker.games.common.IPainter;
import javax.microedition.lcdui.Image;

public class Sprite {
    private Image[] m_images;
    private short[][] m_frameSize;
    private short[][][] m_animations;
    private static short[] m_auxShortArray = new short[2];

    public Sprite(Image[] images, short[][] numFrames, byte[] numAnimations) {
        int i;
        this.m_images = images;
        this.m_frameSize = new short[images.length][2];
        for (i = 0; i < this.m_frameSize.length; ++i) {
            this.m_frameSize[i][0] = (short)(images[i].getWidth() / numFrames[i][0]);
            this.m_frameSize[i][1] = (short)(images[i].getHeight() / numFrames[i][1]);
        }
        this.m_animations = new short[images.length][][];
        for (i = 0; i < numAnimations.length; ++i) {
            this.m_animations[i] = new short[numAnimations[i]][3];
        }
    }

    public void destroy() {
        this.m_animations = null;
        this.m_images = null;
        this.m_frameSize = null;
    }

    public void addAnimation(short imageIndex, short animationIndex, short firstFrame, short numFrames, byte fps) {
        this.m_animations[imageIndex][animationIndex][0] = firstFrame;
        this.m_animations[imageIndex][animationIndex][1] = numFrames;
        this.m_animations[imageIndex][animationIndex][2] = fps;
    }

    public short getFrameWidth(short imageIndex) {
        return this.m_frameSize[imageIndex][0];
    }

    public short getFrameHeight(short imageIndex) {
        return this.m_frameSize[imageIndex][1];
    }

    public short getFPS(short imageIndex, short animationIndex) {
        return this.m_animations[imageIndex][animationIndex][2];
    }

    public short getFrameCount(short imageIndex, short animationIndex) {
        return this.m_animations[imageIndex][animationIndex][1];
    }

    protected void getStartingCoords(short imageIndex, short animationIndex, short frame, short[] res) {
        short firstFrame = this.m_animations[imageIndex][animationIndex][0];
        short numFrames = this.m_animations[imageIndex][animationIndex][1];
        short framesPerRow = (short)(this.m_images[imageIndex].getWidth() / this.m_frameSize[imageIndex][0]);
        int startingY = (firstFrame + frame) / framesPerRow;
        int startingX = (firstFrame + frame) % framesPerRow;
        res[1] = (short)(startingY * this.m_frameSize[imageIndex][1]);
        res[0] = (short)(startingX * this.m_frameSize[imageIndex][0]);
    }

    public void drawFrame(Object g, IPainter painter, short x, short y, short imageIndex, short animationIndex, short frame, byte flip) {
        this.getStartingCoords(imageIndex, animationIndex, frame, m_auxShortArray);
        painter.drawRegion(g, this.m_images[imageIndex], m_auxShortArray[0], m_auxShortArray[1], x, y, this.m_frameSize[imageIndex][0], this.m_frameSize[imageIndex][1], flip);
    }
}

