/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.Auxiliary;
import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.IPainter;
import com.kitmaker.games.party.Constants;
import com.kitmaker.games.party.Game;
import com.kitmaker.games.party.PartyGame;
import com.kitmaker.games.party.TextBuffer;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ShowKaraokeGame
extends PartyGame {
    protected static final String[] SEXY_POSTURES_FILES = new String[]{"/posturas/01_Libelula.png", "/posturas/02_Abeja.png", "/posturas/03_Acrobata.png", "/posturas/04_Arco.png", "/posturas/05_Sometido.png", "/posturas/06_Caretilla.png", "/posturas/07_Profunda.png", "/posturas/08_Aspas_molino.png", "/posturas/09_Amazona.png", "/posturas/10_Sorpresa.png", "/posturas/11_Elefante.png", "/posturas/12_Luna.png", "/posturas/13_union_rana.png", "/posturas/14_La_barra.png", "/posturas/15_La_Gran_V.png", "/posturas/16_Missionario.png", "/posturas/17_El_Perrito.png", "/posturas/18_Esclavo.png", "/posturas/19_cucharra.png", "/posturas/20_Cangrejo.png", "/posturas/21_Jinete.png", "/posturas/22_Silla_Caliente.png", "/posturas/23_Diamante.png", "/posturas/24_Rana.png", "/posturas/25_Ying-Yang.png", "/posturas/26_Reverse-Oral.png", "/posturas/27_Triangulo-Amor.png", "/posturas/28_La_W.png", "/posturas/29_from_Behind.png", "/posturas/30_Perrito.png"};
    private String[] m_question;
    private String[] m_answers;
    private byte m_correctAnswer;
    private byte m_currentSelectedAnswer;
    private byte m_currentQuestion;
    private long m_questionTimer;
    private short m_questionCurrentCharacter;
    private long m_questionAnimationTimer;
    private long m_questionChangeDelay;
    private Image im;

    public ShowKaraokeGame(String playerName, String categoryBigImagePath, String categorySmallImagePath, String iconImagePath, byte partnerIndex, BitmapFont titleBitmapFont, byte correctCount, byte testIndex, int currentScore) {
        super(playerName, categoryBigImagePath, categorySmallImagePath, iconImagePath, 30000L, (short)75, (short)76, titleBitmapFont, -1237980, partnerIndex, correctCount, testIndex, currentScore);
    }

    protected void enterPlayingState(byte previousState) {
        super.enterPlayingState(previousState);
    }

    protected void exitPlayingState(byte nextState) {
        super.exitPlayingState(nextState);
    }

    protected void paintPlayingState(Graphics g, IPainter painter, int y, int width, int height) {
        super.paintPlayingState(g, painter, y, width, height);
        y += this.m_iconImage.getHeight() + m_font.getHeight() / 2;
        int x = 10;
        width -= 20;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(0, (int)this.m_bodyY, (int)Game.m_screenWidth, (int)this.m_bodyHeight);
        int lastY = y;
        y = Game.drawWrappedString(null, painter, this.m_question[this.m_currentQuestion], x, y, width, null, m_boldFont, false, true, -11454824);
        int h = y - lastY;
        y = this.m_bodyY;
        g.setColor(8721258);
        g.fillRect(0, y - 0, (int)Game.m_screenWidth, h + 0);
        g.setColor(-1);
        g.fillRect(0, y, (int)Game.m_screenWidth, h);
        y = Game.drawWrappedString(g, painter, this.m_question[this.m_currentQuestion], x, y, width, null, m_boldFont, false, true, -11454824);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        int anty = y;
        int ch = m_font.getHeight();
        y = this.m_bodyY + this.m_bodyHeight + 1;
        int posy = anty + (y - anty >> 1) - (this.im.getHeight() >> 1);
        int posx = 120 - (this.im.getWidth() >> 1);
        g.drawImage(this.im, posx, posy, 0);
        x = 10;
        int w = this.m_digitsBitmapFont.getCharWidth();
        h = this.m_digitsBitmapFont.getCharHeight();
        for (int i = 0; i < this.m_answers.length; ++i) {
            m_auxStringBuffer.setLength(0);
            m_auxStringBuffer.append(' ').append(this.m_answers[i]);
            int previousY = y;
            String str = m_auxStringBuffer.toString();
            int Color = -1;
            if (this.m_currentSelectedAnswer == i) {
                Color = 15464709;
            }
            y = Game.drawWrappedString(g, painter, str, x, y, m_font.stringWidth(str), null, m_font, false, true, Color);
        }
    }

    protected void runInitState() {
    }

    protected void controlPlayingStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1) {
            boolean fire;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean down = keyCode == 56 || gameAction == 6;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (up) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer - 1);
                if (this.m_currentSelectedAnswer < 0) {
                    this.m_currentSelectedAnswer = (byte)2;
                }
            } else if (down) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer + 1);
                if (this.m_currentSelectedAnswer == 3) {
                    this.m_currentSelectedAnswer = 0;
                }
            } else if (fire) {
                this.m_correct = this.m_currentSelectedAnswer == this.m_correctAnswer;
                this.m_nextGameState = (byte)3;
            }
        }
    }

    protected void initializeGame() throws Exception {
        int i;
        InputStream uis;
        TextBuffer gameTextBuffer = new TextBuffer();
        InputStream is = this.getClass().getResourceAsStream("/karaoke.txt");
        if (!gameTextBuffer.initialize(is, uis = this.getClass().getResourceAsStream("/karaoke_u.txt"), 2000, 120)) {
            throw new Exception();
        }
        try {
            is.close();
            uis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        is = null;
        uis = null;
        Game game = Game.getInstance(null);
        short ind = game.getQuestionIndex((byte)5);
        int index = ind * 120 / Constants.QUESTION_COUNT[5];
        game = null;
        this.im = Image.createImage((String)SEXY_POSTURES_FILES[ind]);
        this.m_question = new String[1];
        this.m_answers = new String[3];
        for (i = 0; i < this.m_question.length; i = (int)((byte)(i + 1))) {
            this.m_question[i] = gameTextBuffer.getText(index);
            ++index;
        }
        for (i = 0; i < this.m_answers.length; i = (int)((byte)(i + 1))) {
            String str = gameTextBuffer.getText(index);
            if (str.charAt(0) == '@') {
                this.m_correctAnswer = (byte)i;
                str = str.substring(1, str.length());
            }
            this.m_answers[i] = str;
            ++index;
        }
        gameTextBuffer.destroy();
        gameTextBuffer = null;
        this.m_currentQuestion = 0;
        this.m_questionCurrentCharacter = 0;
        this.m_questionTimer = System.currentTimeMillis();
        this.m_questionChangeDelay = this.m_maxTime / 1L * 5L / 9L;
    }

    public void destroy() {
        super.destroy();
        this.m_question = null;
        this.m_answers = null;
    }

    protected void runPlayingState() {
        super.runPlayingState();
        if (System.currentTimeMillis() - this.m_questionAnimationTimer > 300L) {
            int length = this.m_question[this.m_currentQuestion].length();
            this.m_questionCurrentCharacter = (short)(this.m_questionCurrentCharacter + 1);
            while (this.m_questionCurrentCharacter < length && this.m_question[this.m_currentQuestion].charAt(this.m_questionCurrentCharacter) != ' ') {
                this.m_questionCurrentCharacter = (short)(this.m_questionCurrentCharacter + 1);
            }
            if (this.m_questionCurrentCharacter > length) {
                this.m_questionCurrentCharacter = (short)length;
            }
            this.m_questionAnimationTimer = System.currentTimeMillis();
        }
        if (System.currentTimeMillis() - this.m_questionTimer > this.m_questionChangeDelay) {
            this.m_questionCurrentCharacter = 0;
            this.m_currentQuestion = (byte)(this.m_currentQuestion + 1);
            if (this.m_currentQuestion >= 1) {
                this.m_currentQuestion = 0;
            }
            this.m_questionTimer = System.currentTimeMillis();
        }
    }

    public byte getPeanutColor() {
        return 2;
    }
}

