/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.Auxiliary;
import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.IPainter;
import com.kitmaker.games.party.ArtAuxiliary;
import com.kitmaker.games.party.Constants;
import com.kitmaker.games.party.Game;
import com.kitmaker.games.party.PartyGame;
import com.kitmaker.games.party.TextBuffer;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ArtDrawingGame
extends PartyGame {
    private String[] m_answers;
    private byte m_correctAnswer;
    private byte m_currentSelectedAnswer;
    private short[][] m_points;
    private Image m_drawing;
    private Graphics m_drawingGraphics;
    private Image m_pencil;
    private boolean m_backwards;
    private long m_drawingTimer;
    private long m_drawingDelay;
    private byte m_currentPoint;
    private short m_drawingSize;

    public ArtDrawingGame(String playerName, String categoryBigImagePath, String categorySmallImagePath, String iconImagePath, byte partnerIndex, BitmapFont titleBitmapFont, byte correctCount, byte testIndex, int currentScore) {
        super(playerName, categoryBigImagePath, categorySmallImagePath, iconImagePath, 30000L, (short)68, (short)69, titleBitmapFont, -16734640, partnerIndex, correctCount, testIndex, currentScore);
    }

    protected void enterPlayingState(byte previousState) {
        super.enterPlayingState(previousState);
        this.m_pencil = Auxiliary.initializeImage("/lapiz.png");
        if (previousState != 4) {
            this.m_drawingTimer = System.currentTimeMillis();
        }
    }

    protected void exitPlayingState(byte nextState) {
        super.exitPlayingState(nextState);
        this.m_pencil = null;
    }

    protected void paintPlayingState(Graphics g, IPainter painter, int y, int width, int height) {
        super.paintPlayingState(g, painter, y, width, height);
        int w = this.m_drawingSize;
        int h = this.m_drawingSize;
        int x = 10 + (width -= 20) / 2 - w / 2;
        y = this.m_bodyY + this.m_bodyHeight / 2 - h / 2;
        g.setColor(-16777216);
        g.fillRect(x - 2, y - 2, w + 4, h + 4);
        painter.drawRegion(g, this.m_drawing, 0, 0, x, y, w, h, 0);
        w = this.m_pencil.getWidth();
        h = this.m_pencil.getHeight();
        short offsetX = this.m_points[this.m_currentPoint][0];
        short offsetY = this.m_points[this.m_currentPoint][1];
        if (offsetX == -1 || offsetY == -1) {
            offsetX = this.m_points[this.m_currentPoint - 1][0];
            offsetY = this.m_points[this.m_currentPoint - 1][1];
        }
        painter.drawRegion(g, this.m_pencil, 0, 0, x + offsetX, y + offsetY - h, w, h, 0);
        int ch = m_font.getHeight();
        y = this.m_bodyY + this.m_bodyHeight + 1;
        x = 10;
        w = this.m_digitsBitmapFont.getCharWidth();
        h = this.m_digitsBitmapFont.getCharHeight();
        for (int i = 0; i < this.m_answers.length; ++i) {
            m_auxStringBuffer.setLength(0);
            m_auxStringBuffer.append(' ').append(this.m_answers[i]);
            int previousY = y;
            String str = m_auxStringBuffer.toString();
            int Color = -1;
            if (this.m_currentSelectedAnswer == i) {
                Color = 15464709;
            }
            y = Game.drawWrappedString(g, painter, str, x, y, m_font.stringWidth(str), null, m_font, false, true, Color);
        }
    }

    protected void runInitState() {
    }

    protected void controlPlayingStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1) {
            boolean fire;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean down = keyCode == 56 || gameAction == 6;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (up) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer - 1);
                if (this.m_currentSelectedAnswer < 0) {
                    this.m_currentSelectedAnswer = (byte)2;
                }
            } else if (down) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer + 1);
                if (this.m_currentSelectedAnswer == 3) {
                    this.m_currentSelectedAnswer = 0;
                }
            } else if (fire) {
                this.m_correct = this.m_currentSelectedAnswer == this.m_correctAnswer;
                this.m_nextGameState = (byte)3;
            }
        }
    }

    protected void initializeGame() throws Exception {
        InputStream uis;
        this.m_drawingSize = this.m_bodyHeight < 100 ? this.m_bodyHeight : (short)100;
        TextBuffer gameTextBuffer = new TextBuffer();
        InputStream is = this.getClass().getResourceAsStream("/drawing.txt");
        if (!gameTextBuffer.initialize(is, uis = this.getClass().getResourceAsStream("/drawing_u.txt"), 2000, Constants.QUESTION_COUNT[6] * 3)) {
            throw new Exception();
        }
        try {
            is.close();
            uis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        is = null;
        uis = null;
        Game game = Game.getInstance(null);
        short initIndex = game.getQuestionIndex((byte)6);
        game = null;
        int index = initIndex * 3;
        this.m_answers = new String[3];
        for (int i = 0; i < this.m_answers.length; i = (int)((byte)(i + 1))) {
            String str;
            if ((str = gameTextBuffer.getText(index++)).charAt(0) == '@') {
                this.m_correctAnswer = (byte)i;
                str = str.substring(1, str.length());
            }
            this.m_answers[i] = str;
        }
        gameTextBuffer.destroy();
        gameTextBuffer = null;
        is = this.getClass().getResourceAsStream(Constants.ART_GAME_DRAWING_DRAWINGS_FILES[initIndex]);
        this.m_points = ArtAuxiliary.readDrawing(is, this.m_drawingSize);
        this.m_drawing = Image.createImage((int)this.m_drawingSize, (int)this.m_drawingSize);
        this.m_drawingGraphics = this.m_drawing.getGraphics();
        this.m_drawingGraphics.setColor(-1);
        this.m_drawingGraphics.fillRect(0, 0, (int)this.m_drawingSize, (int)this.m_drawingSize);
        this.m_drawingDelay = (this.m_maxTime - 5000L) / (long)this.m_points.length;
        if (Auxiliary.getRandomNumber(1, 100) < 50) {
            this.m_backwards = true;
            this.m_currentPoint = (byte)(this.m_points.length - 1);
        } else {
            this.m_backwards = false;
            this.m_currentPoint = 0;
        }
    }

    public void destroy() {
        super.destroy();
        this.m_answers = null;
        this.m_points = null;
        this.m_drawingGraphics = null;
        this.m_drawing = null;
        this.m_pencil = null;
    }

    protected void runPlayingState() {
        super.runPlayingState();
        if (System.currentTimeMillis() - this.m_drawingTimer > this.m_drawingDelay) {
            int x1 = -1;
            int x2 = -1;
            int y1 = -1;
            int y2 = -1;
            boolean mustDraw = false;
            if (!this.m_backwards) {
                if (this.m_currentPoint < this.m_points.length - 1) {
                    x1 = this.m_points[this.m_currentPoint][0];
                    y1 = this.m_points[this.m_currentPoint][1];
                    x2 = this.m_points[this.m_currentPoint + 1][0];
                    y2 = this.m_points[this.m_currentPoint + 1][1];
                    this.m_currentPoint = (byte)(this.m_currentPoint + 1);
                    mustDraw = true;
                }
            } else if (this.m_currentPoint > 0) {
                x1 = this.m_points[this.m_currentPoint][0];
                y1 = this.m_points[this.m_currentPoint][1];
                x2 = this.m_points[this.m_currentPoint - 1][0];
                y2 = this.m_points[this.m_currentPoint - 1][1];
                this.m_currentPoint = (byte)(this.m_currentPoint - 1);
                mustDraw = true;
            }
            if (mustDraw && x1 != -1 && x2 != -1 && y1 != -1 && y2 != -1) {
                this.m_drawingGraphics.setColor(-11454824);
                this.m_drawingGraphics.drawLine(x1, y1, x2, y2);
                Game.getInstance(null).playSound("/art.mid");
            }
            this.m_drawingTimer = System.currentTimeMillis();
        }
    }

    public byte getPeanutColor() {
        return 3;
    }
}

