/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.Auxiliary;
import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.IPainter;
import com.kitmaker.games.party.ArtAuxiliary;
import com.kitmaker.games.party.Constants;
import com.kitmaker.games.party.Game;
import com.kitmaker.games.party.PartyGame;
import com.kitmaker.games.party.TextBuffer;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ArtShapeGame
extends PartyGame {
    private String[] m_answers;
    private byte m_correctAnswer;
    private byte m_currentSelectedAnswer;
    private short[][] m_points;
    private Image[] m_drawings;
    private Graphics[] m_drawingsGraphics;
    private long m_orderTimer;
    private long m_orderDelay;
    private byte[] m_order;
    private byte[] m_outOfOrderPieces;
    private byte m_outOfOrderPiecesCount;
    private short m_drawingSize;
    boolean booltamstr;
    int tamstroff;
    long timetamstr;

    public ArtShapeGame(String playerName, String categoryBigImagePath, String categorySmallImagePath, String iconImagePath, byte partnerIndex, BitmapFont titleBitmapFont, byte correctCount, byte testIndex, int currentScore) {
        super(playerName, categoryBigImagePath, categorySmallImagePath, iconImagePath, 15000L, (short)71, (short)72, titleBitmapFont, -16734640, partnerIndex, correctCount, testIndex, currentScore);
    }

    protected void enterPlayingState(byte previousState) {
        super.enterPlayingState(previousState);
        if (previousState != 4) {
            this.m_orderTimer = System.currentTimeMillis();
        }
    }

    protected void exitPlayingState(byte nextState) {
        super.exitPlayingState(nextState);
    }

    protected void paintPlayingState(Graphics g, IPainter painter, int y, int width, int height) {
        super.paintPlayingState(g, painter, y, width, height);
        int w = this.m_drawingSize;
        int h = this.m_drawingSize;
        y = this.m_bodyY + this.m_bodyHeight / 2 - h / 2;
        int x = 10 + (width -= 20) / 2 - w / 2;
        g.setColor(-16777216);
        g.fillRect(x - 2, y - 2, w + 4, h + 4);
        int finalX = x;
        int finalY = y;
        int pos = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                pos = this.m_order[i * 3 + j];
                painter.drawRegion(g, this.m_drawings[pos], 0, 0, finalX, finalY, this.m_drawings[pos].getWidth(), this.m_drawings[pos].getHeight(), 0);
                finalX += this.m_drawings[pos].getWidth();
            }
            finalX = x;
            finalY += this.m_drawings[pos].getHeight();
        }
        int ch = m_font.getHeight();
        y = this.m_bodyY + this.m_bodyHeight + 1;
        x = 10;
        w = this.m_digitsBitmapFont.getCharWidth();
        h = this.m_digitsBitmapFont.getCharHeight();
        for (int i = 0; i < this.m_answers.length; ++i) {
            int tamstr;
            m_auxStringBuffer.setLength(0);
            m_auxStringBuffer.append(' ').append(this.m_answers[i]);
            int previousY = y;
            String str = m_auxStringBuffer.toString();
            int Color = -1;
            if (this.m_currentSelectedAnswer == i) {
                Color = 15464709;
            }
            if (System.currentTimeMillis() - this.timetamstr > 200L) {
                if (this.booltamstr) {
                    ++this.tamstroff;
                }
                this.timetamstr = System.currentTimeMillis();
            }
            if ((tamstr = m_font.stringWidth(str)) >= width - 5) {
                this.booltamstr = true;
                tamstr = m_font.stringWidth(str = str.substring(this.tamstroff));
                if (tamstr < width - 5) {
                    this.booltamstr = false;
                }
            }
            y = Game.drawWrappedString(g, painter, str, x, y, m_font.stringWidth(str), null, m_font, false, true, Color);
        }
    }

    protected void runInitState() {
    }

    protected void controlPlayingStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1) {
            boolean fire;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean down = keyCode == 56 || gameAction == 6;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (up) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer - 1);
                if (this.m_currentSelectedAnswer < 0) {
                    this.m_currentSelectedAnswer = (byte)2;
                }
            } else if (down) {
                this.m_currentSelectedAnswer = (byte)(this.m_currentSelectedAnswer + 1);
                if (this.m_currentSelectedAnswer == 3) {
                    this.m_currentSelectedAnswer = 0;
                }
            } else if (fire) {
                this.m_correct = this.m_currentSelectedAnswer == this.m_correctAnswer;
                this.m_nextGameState = (byte)3;
            }
        }
    }

    protected void initializeGame() throws Exception {
        int i;
        InputStream uis;
        this.m_drawingSize = this.m_bodyHeight < 100 ? this.m_bodyHeight : (short)100;
        TextBuffer gameTextBuffer = new TextBuffer();
        InputStream is = this.getClass().getResourceAsStream("/shape.txt");
        if (!gameTextBuffer.initialize(is, uis = this.getClass().getResourceAsStream("/shape_u.txt"), 2000, Constants.QUESTION_COUNT[7] * 3)) {
            throw new Exception();
        }
        try {
            is.close();
            uis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        is = null;
        uis = null;
        Game game = Game.getInstance(null);
        short initIndex = game.getQuestionIndex((byte)7);
        game = null;
        int index = initIndex * 3;
        this.m_answers = new String[3];
        for (int i2 = 0; i2 < this.m_answers.length; i2 = (int)((byte)(i2 + 1))) {
            String str;
            if ((str = gameTextBuffer.getText(index++)).charAt(0) == '@') {
                this.m_correctAnswer = (byte)i2;
                str = str.substring(1, str.length());
            }
            this.m_answers[i2] = str;
        }
        gameTextBuffer.destroy();
        gameTextBuffer = null;
        is = this.getClass().getResourceAsStream(Constants.ART_GAME_SHAPE_DRAWINGS_FILES[initIndex]);
        this.m_points = ArtAuxiliary.readDrawing(is, this.m_drawingSize);
        Image drawing = Image.createImage((int)this.m_drawingSize, (int)this.m_drawingSize);
        Graphics g = drawing.getGraphics();
        g.setColor(-1);
        g.fillRect(0, 0, (int)this.m_drawingSize, (int)this.m_drawingSize);
        g.setColor(-11454824);
        for (int i3 = 0; i3 < this.m_points.length - 1; ++i3) {
            if (this.m_points[i3][0] == -1 || this.m_points[i3][1] == -1 || this.m_points[i3 + 1][0] == -1 || this.m_points[i3 + 1][1] == -1) continue;
            g.drawLine((int)this.m_points[i3][0], (int)this.m_points[i3][1], (int)this.m_points[i3 + 1][0], (int)this.m_points[i3 + 1][1]);
        }
        g = null;
        this.initializeSubimages(drawing);
        drawing = null;
        this.m_orderDelay = (this.m_maxTime - 1000L) / 9L;
        Auxiliary.callGC();
        this.m_order = new byte[this.m_drawings.length];
        int count = this.m_order.length;
        byte[] auxOrder = new byte[count];
        this.m_outOfOrderPieces = new byte[count];
        this.m_outOfOrderPiecesCount = (byte)count;
        for (i = 0; i < count; i = (int)((byte)(i + 1))) {
            auxOrder[i] = i;
            this.m_outOfOrderPieces[i] = i;
        }
        i = 0;
        while (count > 0) {
            int pos = Auxiliary.getRandomNumber(0, --count);
            this.m_order[i++] = auxOrder[pos];
            auxOrder[pos] = auxOrder[count];
        }
        auxOrder = null;
        Auxiliary.callGC();
    }

    private void initializeSubimages(Image drawing) {
        this.m_drawings = new Image[9];
        this.m_drawingsGraphics = new Graphics[9];
        int w = this.m_drawingSize / 3;
        int h = this.m_drawingSize / 3;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                int pos = i * 3 + j;
                this.m_drawings[pos] = Image.createImage((int)w, (int)h);
                this.m_drawingsGraphics[pos] = this.m_drawings[pos].getGraphics();
                int x_src = w * j;
                int y_src = h * i;
                Game.m_painter.drawRegion(this.m_drawingsGraphics[pos], drawing, x_src, y_src, 0, 0, w, h, 0);
            }
        }
    }

    public void destroy() {
        super.destroy();
        this.m_answers = null;
        this.m_points = null;
        this.m_drawingsGraphics = null;
        this.m_drawings = null;
        this.m_order = null;
        this.m_outOfOrderPieces = null;
    }

    protected void runPlayingState() {
        super.runPlayingState();
        if (System.currentTimeMillis() - this.m_orderTimer > this.m_orderDelay) {
            if (this.m_outOfOrderPiecesCount > 0) {
                this.m_outOfOrderPiecesCount = (byte)(this.m_outOfOrderPiecesCount - 1);
                int index = Auxiliary.getRandomNumber(0, this.m_outOfOrderPiecesCount);
                byte currentPiece = this.m_outOfOrderPieces[index];
                this.m_outOfOrderPieces[index] = this.m_outOfOrderPieces[this.m_outOfOrderPiecesCount];
                this.reorderPiece(currentPiece);
                Game.getInstance(null).playSound("/art.mid");
            }
            this.m_orderTimer = System.currentTimeMillis();
        }
    }

    private void reorderPiece(int index) {
        int i = 0;
        boolean found = false;
        int count = this.m_order.length;
        while (i < count && !found) {
            if (this.m_order[i] == index) {
                found = true;
                continue;
            }
            ++i;
        }
        if (found) {
            byte aux = this.m_order[index];
            this.m_order[index] = (byte)index;
            this.m_order[i] = aux;
        }
    }

    public byte getPeanutColor() {
        return 3;
    }
}

