/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.party;

import com.kitmaker.games.common.Auxiliary;
import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.IPainter;
import com.kitmaker.games.party.Constants;
import com.kitmaker.games.party.Game;
import com.kitmaker.games.party.PartyGame;
import com.kitmaker.games.party.TextBuffer;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;

public class QuizTrueOrFalseGame
extends PartyGame {
    private String m_question;
    private boolean m_true;
    private boolean m_currentSelectedAnswer;
    private short m_bodyOffset;
    private short m_questionHeight;
    private long m_bodyScrollTimer;

    public QuizTrueOrFalseGame(String playerName, String categoryBigImagePath, String categorySmallImagePath, String iconImagePath, byte partnerIndex, BitmapFont titleBitmapFont, byte correctCount, byte testIndex, int currentScore) {
        super(playerName, categoryBigImagePath, categorySmallImagePath, iconImagePath, 30000L, (short)64, (short)65, titleBitmapFont, -16595713, partnerIndex, correctCount, testIndex, currentScore);
        this.m_footerHeight = (short)(this.m_footerHeight - Game.m_smallFont.getHeight());
        this.m_bodyHeight = (short)(Game.m_screenHeight - this.m_footerHeight - this.m_bodyY);
    }

    protected void enterPlayingState(byte previousState) {
        super.enterPlayingState(previousState);
        this.m_bodyScrollTimer = System.currentTimeMillis() + 1500L;
    }

    protected void exitPlayingState(byte nextState) {
        super.exitPlayingState(nextState);
    }

    protected void paintPlayingState(Graphics g, IPainter painter, int y, int width, int height) {
        super.paintPlayingState(g, painter, y, width, height);
        int x = 10;
        int lastY = y += 0 + this.m_iconImage.getHeight() + 10;
        y = Game.drawWrappedString(null, painter, this.m_question, x, y, width -= 20, null, m_boldFont, false, true, -11454824);
        int h = y - lastY;
        if (h > this.m_bodyHeight) {
            h = this.m_bodyHeight;
        }
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(0, (int)this.m_bodyY, (int)Game.m_screenWidth, (int)this.m_bodyHeight);
        y = this.m_bodyY + this.m_bodyHeight / 2 - h / 2;
        g.setColor(8721258);
        g.fillRect(0, y - 0, (int)Game.m_screenWidth, h + 0);
        g.setColor(-1);
        g.fillRect(0, y, (int)Game.m_screenWidth, h);
        Game.drawWrappedString(g, painter, this.m_question, x, y + this.m_bodyOffset, width, null, m_boldFont, true, true, -11454824);
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        y = this.m_bodyY + this.m_bodyHeight + 1;
        x = 10;
        int w = this.m_digitsBitmapFont.getCharWidth();
        h = this.m_digitsBitmapFont.getCharHeight();
        int ch = m_font.getHeight();
        int previousY = y;
        String str = Game.m_textBuffer.getText(66);
        m_auxStringBuffer.setLength(0);
        m_auxStringBuffer.append(' ').append(str);
        str = m_auxStringBuffer.toString();
        int Color = -1;
        if (this.m_currentSelectedAnswer) {
            Color = 15464709;
        }
        previousY = y = Game.drawWrappedString(g, painter, str, x, y, width, null, m_font, false, true, Color);
        str = Game.m_textBuffer.getText(67);
        m_auxStringBuffer.setLength(0);
        m_auxStringBuffer.append(' ').append(str);
        Color = -1;
        if (!this.m_currentSelectedAnswer) {
            Color = 15464709;
        }
        y = Game.drawWrappedString(g, painter, m_auxStringBuffer.toString(), x, y, width, null, m_font, false, true, Color);
    }

    protected void runInitState() {
    }

    protected void controlPlayingStateInput(int keyCode, int gameAction, int eventType) {
        if (eventType == 1) {
            boolean fire;
            boolean up = keyCode == 50 || gameAction == 1;
            boolean down = keyCode == 56 || gameAction == 6;
            boolean bl = fire = keyCode == 53 || gameAction == 8 || Auxiliary.isLeftSoftkeyPressed(keyCode, gameAction);
            if (up || down) {
                this.m_currentSelectedAnswer = !this.m_currentSelectedAnswer;
            } else if (fire) {
                this.m_correct = this.m_currentSelectedAnswer == this.m_true;
                this.m_nextGameState = (byte)3;
            }
        }
    }

    protected void initializeGame() throws Exception {
        InputStream uis;
        TextBuffer gameTextBuffer = new TextBuffer();
        InputStream is = this.getClass().getResourceAsStream("/tof.txt");
        if (!gameTextBuffer.initialize(is, uis = this.getClass().getResourceAsStream("/tof_u.txt"), 2000, Constants.QUESTION_COUNT[1])) {
            throw new Exception();
        }
        try {
            is.close();
            uis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        is = null;
        uis = null;
        Game game = Game.getInstance(null);
        short index = game.getQuestionIndex((byte)1);
        game = null;
        String str = gameTextBuffer.getText(index);
        this.m_true = str.charAt(0) == 'T';
        this.m_question = str.substring(1, str.length());
        this.m_questionHeight = (short)Game.drawWrappedString(null, null, this.m_question, 0, 0, Game.m_screenWidth - 20, null, m_boldFont, true, true, 0);
        gameTextBuffer.destroy();
        gameTextBuffer = null;
        this.m_currentSelectedAnswer = true;
    }

    public void destroy() {
        super.destroy();
        this.m_question = null;
    }

    public byte getPeanutColor() {
        return 0;
    }

    protected void runPlayingState() {
        super.runPlayingState();
        if (this.m_questionHeight > this.m_bodyHeight && System.currentTimeMillis() - this.m_bodyScrollTimer > 150L) {
            if (this.m_bodyOffset + this.m_questionHeight > this.m_bodyHeight) {
                this.m_bodyScrollTimer = System.currentTimeMillis();
                this.m_bodyOffset = (short)(this.m_bodyOffset - 1);
            } else if (System.currentTimeMillis() - this.m_bodyScrollTimer > 3000L) {
                this.m_bodyOffset = 0;
                this.m_bodyScrollTimer = System.currentTimeMillis() + 1500L;
            }
        }
    }
}

