/*
 * Decompiled with CFR 0.152.
 */
package com.kitmaker.games.common;

import com.kitmaker.games.common.BitmapFont;
import com.kitmaker.games.common.IPainter;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Auxiliary {
    private static Random m_random = new Random();
    private static StringBuffer m_auxStringBuffer = new StringBuffer();
    private static StringBuffer m_auxStringBuffer2 = new StringBuffer();
    private static StringBuffer m_auxStringBuffer3 = new StringBuffer();
    private static Vector m_auxVector = new Vector();

    public static final int getRandomNumber(int min, int max) {
        int r = Math.abs(m_random.nextInt() % (max - min + 1));
        return min + r;
    }

    public static final void callGC() {
        System.gc();
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static int[] getDivisors(int number, int max) {
        int[] res = null;
        if (number == 0) {
            res = new int[]{0};
        } else {
            number = Math.abs(number);
            max = Math.abs(max);
            int[] aux = new int[max];
            int count = 0;
            for (int i = 2; i <= max; ++i) {
                if (number % i != 0) continue;
                aux[count++] = i;
            }
            if (count != 0) {
                res = new int[count];
                System.arraycopy(aux, 0, res, 0, count);
            }
            Object var3_3 = null;
        }
        return res;
    }

    public static final boolean isLeftSoftkeyPressed(int keyCode, int gameAction) {
        return gameAction == 0 && keyCode == -21 || (gameAction == Integer.MIN_VALUE || gameAction == 0) && keyCode == -6 || (gameAction == 8 || gameAction == 0) && keyCode == -1 || gameAction == 0 && keyCode == 57345 || gameAction == 8 && keyCode == -6 || gameAction == 0 && keyCode == 21 || keyCode == -202;
    }

    public static final boolean isRightSoftkeyPressed(int keyCode, int gameAction) {
        return gameAction == 0 && keyCode == -22 || (gameAction == Integer.MIN_VALUE || gameAction == 0) && keyCode == -7 || (gameAction == 8 || gameAction == 0) && keyCode == -4 || gameAction == 0 && keyCode == 57346 || gameAction == 8 && keyCode == -7 || gameAction == 0 && keyCode == 22 || keyCode == -203;
    }

    public static final int getMax(int[] array) {
        int max = Integer.MIN_VALUE;
        if (array != null && array.length > 0) {
            max = array[0];
            for (int i = 1; i < array.length; ++i) {
                if (array[i] <= max) continue;
                max = array[i];
            }
        }
        return max;
    }

    public static final int getMin(int[] array) {
        int min = Integer.MAX_VALUE;
        if (array != null && array.length > 0) {
            min = array[0];
            for (int i = 1; i < array.length; ++i) {
                if (array[i] >= min) continue;
                min = array[i];
            }
        }
        return min;
    }

    public static final long add(long[] array) {
        long res = 0L;
        if (array != null && array.length > 0) {
            for (int i = 0; i < array.length; ++i) {
                res += array[i];
            }
        }
        return res;
    }

    public static BitmapFont initializeBitmapFont(String image, short rowCount, String representedChars, short gapDiff) {
        BitmapFont bitmapFont = null;
        try {
            bitmapFont = new BitmapFont();
        }
        catch (Exception e) {
            // empty catch block
        }
        return bitmapFont;
    }

    public static Image initializeImage(String image) {
        Image img = null;
        try {
            img = Image.createImage((String)image);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return img;
    }

    public static Vector wrap(String text, Font font, BitmapFont bf, int width) {
        m_auxVector.removeAllElements();
        if (text == null) {
            return m_auxVector;
        }
        try {
            boolean hasMore = true;
            int current = 0;
            int lineBreak = -1;
            int nextSpace = -1;
            while (hasMore) {
                int linewidth;
                do {
                    if ((lineBreak = nextSpace) == text.length() - 1) {
                        hasMore = false;
                        break;
                    }
                    nextSpace = text.indexOf(32, lineBreak + 1);
                    if (nextSpace != -1) continue;
                    nextSpace = text.length() - 1;
                } while ((linewidth = bf == null ? font.substringWidth(text, current, nextSpace - current) : bf.getStringWidth(text.substring(current, nextSpace))) <= width);
                String line = text.substring(current, lineBreak + 1);
                if (line.trim().indexOf(32) == -1) {
                    boolean ww;
                    line = line.trim();
                    if (bf == null) {
                        ww = font.stringWidth(line) > width;
                    } else {
                        boolean bl = ww = bf.getStringWidth(line) > width;
                    }
                    if (ww) {
                        int t = bf == null ? font.stringWidth(line) : bf.getStringWidth(line);
                        while (t > width) {
                            line = line.substring(0, line.length() - 2);
                            if (bf == null) {
                                t = font.stringWidth(line);
                                continue;
                            }
                            t = bf.getStringWidth(line);
                        }
                        lineBreak = current + (line = line + '-').length() - 2;
                        nextSpace = text.indexOf(32, lineBreak + 1);
                        if (nextSpace == -1) {
                            nextSpace = text.length() - 1;
                            m_auxVector.addElement(line);
                            line = text.substring(lineBreak + 1, text.length());
                        }
                    }
                }
                m_auxVector.addElement(line);
                current = lineBreak + 1;
            }
            return m_auxVector;
        }
        catch (Exception e) {
            return m_auxVector;
        }
    }

    public static int drawWrappedString(Graphics g, IPainter painter, String string, int x, int y, int width, BitmapFont bitmapFont, Font sysFont, boolean centered, boolean useSystemFont, int color) {
        if (string == null) {
            return y;
        }
        string = string.trim();
        if (g != null && useSystemFont) {
            g.setFont(sysFont);
            g.setColor(color);
        }
        int h = 0;
        h = useSystemFont ? sysFont.getHeight() : bitmapFont.getCharHeight();
        int destY = y;
        Vector v = Auxiliary.wrap(string, sysFont, useSystemFont ? null : bitmapFont, width);
        for (int i = 0; i < v.size(); ++i) {
            String s = (String)v.elementAt(i);
            int finalX = x;
            int anchor = 0;
            if (centered) {
                if (useSystemFont) {
                    finalX = x + width / 2;
                    anchor = 17;
                } else {
                    int finalWidth = bitmapFont.getStringWidth(s);
                    finalX = width / 2 + x - (finalWidth >> 1);
                }
            }
            if (g != null) {
                if (useSystemFont) {
                    g.drawString(s, finalX, destY, anchor);
                } else {
                    bitmapFont.drawString(g, painter, finalX, destY, s);
                }
            }
            destY += h;
        }
        return destY;
    }

    public static int drawWrappedStringLine(Graphics g, IPainter painter, String string, int x, int y, int width, BitmapFont bitmapFont, Font sysFont, boolean centered, boolean useSystemFont, int color) {
        if (string == null) {
            return y;
        }
        string = string.trim();
        if (g != null && useSystemFont) {
            g.setFont(sysFont);
            g.setColor(color);
        }
        int h = 0;
        h = useSystemFont ? sysFont.getHeight() : bitmapFont.getCharHeight();
        int destY = y;
        Vector v = Auxiliary.wrap(string, sysFont, useSystemFont ? null : bitmapFont, width);
        if (v.size() > 1) {
            String p = (String)v.elementAt(0);
            p = p.substring(0, p.length() - 3) + "...";
            v.insertElementAt(p, 0);
        }
        for (int i = 0; i < 1; ++i) {
            String s = (String)v.elementAt(i);
            int finalX = x;
            int anchor = 0;
            if (centered) {
                if (useSystemFont) {
                    finalX = x + width / 2;
                    anchor = 17;
                } else {
                    int finalWidth = bitmapFont.getStringWidth(s);
                    finalX = width / 2 + x - (finalWidth >> 1);
                }
            }
            if (g != null) {
                if (useSystemFont) {
                    g.drawString(s, finalX, destY, anchor);
                } else {
                    bitmapFont.drawString(g, painter, finalX, destY, s);
                }
            }
            destY += h;
        }
        return destY;
    }
}

