/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Form;

public class BackupFileFactory {
    public static final String FILE_PREFIX = "file:///";
    public static final String BACKUP_FS_ROOT = "E:/";
    public static final String BACKUP_DIR = "Backup";
    public static final String BACKUP_FILE_NAME_BASE = "Backup";
    private static String s_filesystemRoot = "E:/";

    public static void setFilesystemRoot(String filesystemRoot) {
        s_filesystemRoot = filesystemRoot;
        if (!s_filesystemRoot.endsWith("/")) {
            s_filesystemRoot = s_filesystemRoot + "/";
        }
    }

    public DataOutputStream openBackupFile(boolean createDir, Form form) throws IOException {
        String directory = s_filesystemRoot + "Backup";
        if (createDir) {
            this.createBackupDirectory(directory, form);
        }
        String filename = this.buildBackupFilename();
        String fullPath = FILE_PREFIX + directory + "/" + filename;
        this.statusMessage("Backing up to " + fullPath, form, true);
        FileConnection fileConn = (FileConnection)Connector.open((String)fullPath);
        if (!fileConn.exists()) {
            fileConn.create();
        }
        return fileConn.openDataOutputStream();
    }

    public DataInputStream openBackupFileForRead(Form form) throws IOException {
        String directory = s_filesystemRoot + "Backup";
        String filename = this.buildRestoreFilename();
        String fullPath = FILE_PREFIX + directory + "/" + filename;
        this.statusMessage("Restoring from " + fullPath, form, true);
        FileConnection fileConn = (FileConnection)Connector.open((String)fullPath);
        if (!fileConn.exists()) {
            throw new IllegalStateException("The backup file '" + fullPath + "' to restore from doesn't exist.");
        }
        return fileConn.openDataInputStream();
    }

    public void debugRestoreFile(Form form) {
        this.debugFile(form, this.buildRestoreFilename(), false);
    }

    public void debugBackupFile(Form form) {
        this.debugFile(form, this.buildBackupFilename(), true);
    }

    public void debugFile(Form form, String filename, boolean writeOrRead) {
        try {
            String directory = s_filesystemRoot + "Backup";
            this.statusMessage("Checking backup directory: " + directory, form, true);
            FileConnection directoryConn = (FileConnection)Connector.open((String)(FILE_PREFIX + directory));
            if (!directoryConn.exists()) {
                this.statusMessage("  Directory doesn't exist.", form, true);
            } else {
                if (!directoryConn.isDirectory()) {
                    this.statusMessage("  Not a directory", form, true);
                }
                this.statusMessage("  Readable: " + directoryConn.canRead(), form, true);
                this.statusMessage("  Writeable: " + directoryConn.canWrite(), form, true);
                String fullPath = directory + "/" + filename;
                this.statusMessage("Checking backup file: " + fullPath, form, true);
                FileConnection fileConn = (FileConnection)Connector.open((String)(FILE_PREFIX + fullPath));
                this.statusMessage("  Exists: " + fileConn.exists(), form, true);
                this.statusMessage("  Readable: " + fileConn.canRead(), form, true);
                this.statusMessage("  Writeable: " + fileConn.canWrite(), form, true);
                if (writeOrRead) {
                    this.statusMessage("Creating backup file", form, true);
                    fileConn.create();
                    this.statusMessage("  Exists: " + fileConn.exists(), form, true);
                    this.statusMessage("  Readable: " + fileConn.canRead(), form, true);
                    this.statusMessage("  Writeable: " + fileConn.canWrite(), form, true);
                    this.statusMessage("Trying DataOutputStream", form, true);
                    DataOutputStream dos = fileConn.openDataOutputStream();
                    this.statusMessage("Writing to DataOutputStream", form, true);
                    dos.writeChars("Test");
                    dos.flush();
                    dos.close();
                    fileConn.close();
                } else {
                    long fileSize = fileConn.fileSize();
                    this.statusMessage("Trying reading from file; it's size: " + fileSize + " [B]", form, true);
                    if (fileSize > 0L) {
                        DataInputStream dis = fileConn.openDataInputStream();
                        int readLen = (int)Math.min(15L, fileSize);
                        StringBuffer buffer = new StringBuffer(readLen);
                        for (int i = 0; i < readLen; ++i) {
                            buffer.append(dis.readChar());
                        }
                        int availableBytes = dis.available();
                        this.statusMessage("Reported available bytes (always 0): " + availableBytes + "; First " + readLen + " characters: " + buffer.toString(), form, true);
                    } else {
                        this.statusMessage("There is nothing to read - the file size is 0.", form, true);
                    }
                }
            }
            directoryConn.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public Enumeration getAllFilesystemRoots() {
        return FileSystemRegistry.listRoots();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String describeFileSystem(String fsRoot) {
        FileConnection fsRootConn = null;
        try {
            fsRootConn = (FileConnection)Connector.open((String)(FILE_PREFIX + fsRoot));
            String string = "\n  Used: " + fsRootConn.usedSize() + "\n  Available: " + fsRootConn.availableSize();
            return string;
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (fsRootConn != null) {
                try {
                    fsRootConn.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void createBackupDirectory(String directory, Form form) throws IOException {
        Backup.debug("BackupFileFactory: Checking for directory: " + directory);
        FileConnection directoryConn = (FileConnection)Connector.open((String)(FILE_PREFIX + directory));
        if (!directoryConn.isDirectory()) {
            this.statusMessage("Creating directory: " + directory, form, false);
            directoryConn.mkdir();
            if (!directoryConn.isDirectory()) {
                throw new IOException("Failed to create backup directory: " + directory);
            }
        }
        directoryConn.close();
    }

    private String buildBackupFilename() {
        Calendar calendar = Calendar.getInstance();
        String timestamp = "" + calendar.get(1) + calendar.get(2) + calendar.get(5);
        String filename = "Backup-" + timestamp + ".txt";
        return filename;
    }

    private String buildRestoreFilename() {
        String filename = "Backup.txt";
        return filename;
    }

    private void statusMessage(String message, Form form, boolean requireDebug) {
        if (!requireDebug || Backup.DEBUG) {
            Utils.showStatus(message, form);
        }
    }
}

