/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Logger.MTLogger;
import Tools.NetTools;
import TorrentEngine.MTNetworkStatusManager;
import TorrentEngine.MTPeer;
import TorrentEngine.MTPiece;
import TorrentEngine.MTPieceToDownload;
import TorrentEngine.MTTorrent;
import TorrentEngine.MTTorrentManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.microedition.io.SocketConnection;

public class MTPeerConnection {
    public static final int KMaxPieceRequests = 2;
    private final String ProtocolId;
    public static final int KMessageIdChoke = 0;
    public static final int KMessageIdUnchoke = 1;
    public static final int KMessageIdInterested = 2;
    public static final int KMessageIdNotInterested = 3;
    public static final int KMessageIdHave = 4;
    public static final int KMessageIdBitfield = 5;
    public static final int KMessageIdRequest = 6;
    public static final int KMessageIdPiece = 7;
    public static final int KMessageIdCancel = 8;
    public static final int KTcpConnectTimeout = 15;
    public static final int KHandshakeTimeout = 15;
    public static final int KPwConnectionTimeout = 120;
    public static final int KKeepAliveInterval = 120;
    public static final int KRequestTimeout = 60;
    private static final int KDefaultBlockLength = 16384;
    private static final int KFlagAmChoking = 1;
    private static final int KFlagAmInterested = 2;
    private static final int KFlagPeerChoking = 4;
    private static final int KFlagPeerInterested = 8;
    public static final int EPeerNotConnected = 0;
    public static final int EPeerTcpConnecting = 1;
    public static final int EPeerConnected = 2;
    public static final int EPeerPwHandshaking = 3;
    public static final int EPeerPwConnected = 4;
    public static final int EPeerClosing = 5;
    public static final int EDeletePeer = 0;
    public static final int EIncreaseErrorCounter = 1;
    public static final int ENotSpecified = 2;
    private MTPeer peer;
    private MTTorrent torrent;
    private MTTorrentManager torrentMgr;
    private boolean incomingConnection;
    private int retries;
    private int reconnectAfter;
    private int state;
    private int ellapsedTime;
    private int lastRequestTime;
    private int lastMessageReceivedTime;
    private int lastMessageSentTime;
    private int closeOrder;
    private boolean peerWireConnected = false;
    private final Vector piecesToDownload;
    private int statusFlags;
    private boolean hasPendingDownloadRequest;
    public Vector incomingRequests;
    private SocketConnection socket;
    private InputStream inputStream;
    private OutputStream outputStream;
    private boolean readEnabled;
    private ConnectThread connectThread = null;
    public static int tcpConnectionTimeoutNum = 0;
    public static boolean useLongConnection = false;

    private boolean readData(byte[] byArray) throws Exception {
        return this.readData(byArray, 0, byArray.length);
    }

    private boolean readData(byte[] byArray, int n, int n2) throws Exception {
        int n3;
        int n4 = n2;
        while (n4 > 0 && (n3 = this.inputStream.read(byArray, n, n4)) != -1) {
            n4 -= n3;
            n += n3;
        }
        return n4 == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void read() {
        int n = 0;
        while (this.readEnabled) {
            try {
                switch (this.state) {
                    case 3: {
                        int n2 = this.inputStream.read();
                        if (n2 == -1) {
                            this.close(1, "Peer disconnected!");
                            break;
                        }
                        int n3 = n2 + 48;
                        Object object = new byte[n3];
                        this.readData((byte[])object);
                        byte[] byArray = new byte[n2];
                        System.arraycopy(object, 0, byArray, 0, n2);
                        if (!"BitTorrent protocol".equals(new String(byArray))) {
                            this.close(0, "Protocol identifier doesn't match!");
                            break;
                        }
                        byte[] byArray2 = new byte[20];
                        System.arraycopy(object, 27, byArray2, 0, 20);
                        if (this.torrent != null) {
                            if (!NetTools.byteArrayEqual(byArray2, this.torrent.getInfoHashByteArray())) {
                                this.close(0, "Torrent infohash doesn't match!");
                                break;
                            }
                        } else if (this.torrentMgr.attachPeerToTorrent(byArray2, this.getPeerConnection()) != 0 || this.torrent == null) {
                            this.close(0, "Invalid infohash or peer is already connected or too many peers!");
                            break;
                        }
                        if (this.incomingConnection) {
                            this.torrentMgr.notifyTorrentObserver(this.torrent, 32768);
                            this.torrent.incIncomingConnectionsNum();
                            this.sendHandshakeMessage();
                            this.peer.resetAddress();
                        }
                        Object object2 = new byte[20];
                        System.arraycopy(object, 47, object2, 0, 20);
                        Object object3 = new String((byte[])object2);
                        if (this.peer.getPeerId() != null) {
                            if (!this.peer.getPeerId().equals(object3)) {
                                this.close(1, "Peer ID doesn't match!");
                                break;
                            }
                            if (((String)object3).equals(this.torrentMgr.getPeerID())) {
                                this.close(0, "Connected to ourselves!");
                                break;
                            }
                        } else {
                            this.peer.setPeerId((String)object3);
                        }
                        this.log("Handshake completed! Peer wire connected!");
                        this.changeState(4);
                        this.setPeerWireConnected();
                        if (this.torrent.getBitField().isNull()) break;
                        this.sendBitfieldMessage();
                        break;
                    }
                    case 4: {
                        Object object3;
                        Object object2;
                        byte[] byArray;
                        Object object;
                        byte[] byArray3 = new byte[4];
                        this.readData(byArray3);
                        n = this.getInt(byArray3);
                        this.lastMessageReceivedTime = this.ellapsedTime;
                        if (n == 0) {
                            this.issueDownload();
                            break;
                        }
                        int n3 = this.inputStream.read();
                        block11 : switch (n3) {
                            case 5: {
                                this.log("in BITFIELD");
                                if (n - 1 != this.peer.getBitField().lengthInBytes()) {
                                    this.close(1, "Received bitfield length doesn't match!");
                                    break;
                                }
                                int n4 = n - 1;
                                byArray = new byte[n4];
                                boolean bl = this.readData(byArray);
                                if (bl) {
                                    this.peer.havePieces(byArray, this.torrent);
                                    this.issueDownload();
                                    break;
                                }
                                this.close(1, "Could not read bitfield!");
                                break;
                            }
                            case 4: {
                                this.log("in HAVE");
                                int n5 = this.readInt(0);
                                if (n5 < 0 || n5 >= this.torrent.pieceCount()) break;
                                this.peer.havePiece(n5, this.torrent);
                                if (this.hasPendingDownloadRequest) break;
                                this.issueDownload();
                                break;
                            }
                            case 0: {
                                int n6;
                                this.peer.resetErrorCounter();
                                this.log("in CHOKE");
                                this.setPeerChoking(true);
                                Vector vector = this.piecesToDownload;
                                object = vector;
                                // MONITORENTER : vector
                                for (n6 = 0; n6 < this.piecesToDownload.size(); ++n6) {
                                    ((MTPieceToDownload)this.piecesToDownload.elementAt((int)n6)).hasPendingRequest = false;
                                }
                                for (n6 = 0; n6 < this.piecesToDownload.size(); ++n6) {
                                    this.torrent.removePieceFromDownloading(((MTPieceToDownload)this.piecesToDownload.elementAt((int)n6)).piece);
                                }
                                this.piecesToDownload.removeAllElements();
                                // MONITOREXIT : object
                                break;
                            }
                            case 1: {
                                this.peer.resetErrorCounter();
                                this.log("in UNCHOKE");
                                this.setPeerChoking(false);
                                this.issueDownload();
                                break;
                            }
                            case 2: {
                                this.peer.resetErrorCounter();
                                this.log("in INTERESTED");
                                this.setPeerInterested(true);
                                this.setChoking(false);
                                MTLogger.writeLine("--- INTERESTED ARRIVED ---");
                                break;
                            }
                            case 3: {
                                this.peer.resetErrorCounter();
                                this.log("in NOTINTERESTED");
                                this.setPeerInterested(false);
                                this.issueDownload();
                                break;
                            }
                            case 7: {
                                int n7;
                                this.peer.resetErrorCounter();
                                this.lastRequestTime = 0;
                                this.peer.setHadRequestTimeout(false);
                                int n8 = this.readInt(0);
                                int n9 = this.readInt(0);
                                int n10 = n - 9;
                                this.log("in PIECE Index: " + n8 + " Begin: " + n9 + " Length: " + n10);
                                object2 = null;
                                object3 = this.piecesToDownload;
                                // MONITORENTER : object3
                                for (n7 = 0; n7 < this.piecesToDownload.size(); ++n7) {
                                    if (((MTPieceToDownload)this.piecesToDownload.elementAt((int)n7)).piece.index() != n8) continue;
                                    object2 = (MTPieceToDownload)this.piecesToDownload.elementAt(n7);
                                    break;
                                }
                                // MONITOREXIT : object3
                                if (object2 == null) {
                                    this.close("Error, unexpected piece (there are no pending request for the received piece index)");
                                } else {
                                    MTLogger.writeMemoryInfo();
                                    object3 = new byte[n10];
                                    n7 = this.readData((byte[])object3) ? 1 : 0;
                                    if (n7 == 0) {
                                        this.close(1, "Reading piece failed!");
                                        return;
                                    }
                                    object2.hasPendingRequest = false;
                                    if (object2.piece.appendBlock((byte[])object3, n9, this.peer) != 0) {
                                        object3 = null;
                                        this.close("Writing to piece failed");
                                    } else {
                                        object3 = null;
                                        if (object2.piece.remaining() == 0 || object2.piece.remaining() == object2.piece.getTotalSize()) {
                                            Vector vector = this.piecesToDownload;
                                            // MONITORENTER : vector
                                            this.piecesToDownload.removeElement(object2);
                                            // MONITOREXIT : vector
                                        }
                                    }
                                }
                                System.gc();
                                this.issueDownload();
                                break;
                            }
                            case 6: {
                                this.peer.resetErrorCounter();
                                if (n < 13) {
                                    this.close(1, "Received request message length is smaller than 13!");
                                } else {
                                    int n11 = this.readInt(5);
                                    int n12 = this.readInt(9);
                                    int n13 = this.readInt(13);
                                    this.log("in REQUEST Index: " + n11 + " Begin: " + n12 + " Length: " + n13);
                                    this.ellapsedTime = 0;
                                    this.incomingRequests.addElement(new BlockRequest(n11, n12, n13));
                                    this.issueUpload();
                                }
                                MTLogger.writeLine("--- REQUEST ARRIVED ---");
                                break;
                            }
                            case 8: {
                                this.log("in CANCEL");
                                this.peer.resetErrorCounter();
                                if (n < 13) {
                                    this.close(1, "Received CANCEL message length is smaller than 13!");
                                    break;
                                }
                                int n14 = this.readInt(5);
                                int n15 = this.readInt(9);
                                int n16 = this.readInt(13);
                                for (int i = 0; i < this.incomingRequests.size(); ++i) {
                                    if (((BlockRequest)this.incomingRequests.elementAt((int)i)).pieceIndex != n14 || ((BlockRequest)this.incomingRequests.elementAt((int)i)).begin != n15 || ((BlockRequest)this.incomingRequests.elementAt((int)i)).length != n16) continue;
                                    this.incomingRequests.removeElementAt(i);
                                    break block11;
                                }
                            }
                        }
                        break;
                    }
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                this.close(1, "Read error");
                MTLogger.writeLine("--- PeerConnection interrupted exception: " + interruptedIOException.getMessage());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.close(1, "Read error");
                MTLogger.writeLine("--- PeerConnection ioexception: " + iOException.getMessage());
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.close(1, "Read error - CHECKOLNI!!!");
                MTLogger.writeLine("[Read Exception] " + exception.getMessage());
            }
        }
    }

    public int readInt(int n) {
        byte[] byArray = new byte[4];
        try {
            this.readData(byArray);
        }
        catch (IOException iOException) {
            this.close(1, "Read error");
            iOException.printStackTrace();
            return -1;
        }
        catch (Exception exception) {
            this.close(1, "Read error");
            exception.printStackTrace();
            return -1;
        }
        int n2 = byArray[0] < 0 ? 256 + byArray[0] << 24 : byArray[0] << 24;
        n2 = byArray[1] < 0 ? (n2 += 256 + byArray[1] << 16) : (n2 += byArray[1] << 16);
        n2 = byArray[2] < 0 ? (n2 += 256 + byArray[2] << 8) : (n2 += byArray[2] << 8);
        n2 = byArray[3] < 0 ? (n2 += 256 + byArray[3]) : (n2 += byArray[3]);
        return n2;
    }

    public int getInt(byte[] byArray) {
        int n = byArray[0] < 0 ? 256 + byArray[0] << 24 : byArray[0] << 24;
        n = byArray[1] < 0 ? (n += 256 + byArray[1] << 16) : (n += byArray[1] << 16);
        n = byArray[2] < 0 ? (n += 256 + byArray[2] << 8) : (n += byArray[2] << 8);
        n = byArray[3] < 0 ? (n += 256 + byArray[3]) : (n += byArray[3]);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void issueDownload() {
        int n = 0;
        Vector vector = this.piecesToDownload;
        synchronized (vector) {
            MTPiece mTPiece;
            while (this.piecesToDownload.size() < 2 && (mTPiece = this.torrent.getPieceToDownload(this.peer)) != null) {
                this.piecesToDownload.addElement(new MTPieceToDownload(mTPiece, this.ellapsedTime));
            }
            n = this.piecesToDownload.size();
        }
        if (n == 0) {
            this.setInterested(false);
            if (this.ellapsedTime > 15) {
                if (!this.isPeerInterested()) {
                    this.torrentMgr.notifyTorrentObserverMain(this.torrent, 7);
                    int n2 = 2;
                    if (this.torrent.isComplete()) {
                        n2 = 0;
                    }
                    this.close("No needed piecese and peer not interested");
                } else if (this.incomingRequests.size() == 0) {
                    this.close("No pieces need and peer is not interested");
                }
            }
        } else {
            this.setInterested(true);
            if (!this.isPeerChoking()) {
                vector = this.piecesToDownload;
                synchronized (vector) {
                    for (int i = 0; i < this.piecesToDownload.size(); ++i) {
                        if (((MTPieceToDownload)this.piecesToDownload.elementAt((int)i)).hasPendingRequest) continue;
                        this.sendRequestMessage((MTPieceToDownload)this.piecesToDownload.elementAt(i));
                        ((MTPieceToDownload)this.piecesToDownload.elementAt((int)i)).hasPendingRequest = true;
                    }
                }
            }
        }
    }

    public void issueUpload() {
        if (!this.isChoking()) {
            while (this.incomingRequests.size() > 0) {
                BlockRequest blockRequest = (BlockRequest)this.incomingRequests.elementAt(0);
                this.sendPieceMessage(blockRequest.pieceIndex, blockRequest.begin, blockRequest.length);
                this.incomingRequests.removeElementAt(0);
            }
        }
    }

    public MTPeerConnection(MTPeer mTPeer, MTTorrent mTTorrent, MTTorrentManager mTTorrentManager) {
        this.ProtocolId = "BitTorrent protocol";
        this.peer = mTPeer;
        this.torrent = mTTorrent;
        this.torrentMgr = mTTorrentManager;
        this.incomingConnection = false;
        this.setInterested(false);
        this.setPeerInterested(false);
        this.setChoking(true);
        this.setPeerChoking(true);
        this.piecesToDownload = new Vector();
        this.incomingRequests = new Vector();
        this.state = 0;
    }

    public void initializeIncomingConnection(SocketConnection socketConnection) {
        this.log("InitializeIncomingConnection from StreamConnection begin");
        this.incomingConnection = true;
        ++this.retries;
        this.socket = socketConnection;
        try {
            this.inputStream = this.socket.openInputStream();
            this.outputStream = this.socket.openOutputStream();
        }
        catch (IOException iOException) {
            this.close(1, "Opening streams failed - " + iOException.getMessage());
            this.torrentMgr.notifyStatusChanged("Opening streams failed on: " + this.peer.getAddress() + " | " + iOException.getMessage());
            return;
        }
        this.setInterested(false);
        this.setPeerInterested(false);
        this.setChoking(true);
        this.setPeerChoking(true);
        this.torrentMgr.incIncomingConnectionCount();
        this.changeState(3);
        this.readEnabled = true;
        this.log("InitializeIncomingConnection from StreamConnection end");
        this.read();
    }

    public void onTimer() {
        ++this.ellapsedTime;
        if (this.reconnectAfter > 0) {
            --this.reconnectAfter;
        }
        switch (this.state) {
            case 1: {
                if (this.ellapsedTime <= 15) break;
                ++tcpConnectionTimeoutNum;
                this.close(1, "Timeout while trying to connect");
                break;
            }
            case 3: {
                if (this.ellapsedTime <= 15) break;
                this.close(1, "Handshake timeout (no data received)");
                break;
            }
            case 4: {
                if (this.ellapsedTime - this.lastMessageReceivedTime > 120) {
                    this.close(1, "General timeout (no data received)");
                    break;
                }
                if (this.lastRequestTime > 0 && this.ellapsedTime - this.lastRequestTime > 60) {
                    this.lastRequestTime = this.ellapsedTime;
                    if (this.torrent.hasTimeoutlessPeer()) {
                        this.peer.setHadRequestTimeout(true);
                        this.close(1, "Request timeout");
                        break;
                    }
                }
                if (this.ellapsedTime > 10 && !this.isInterested() && !this.isPeerInterested()) {
                    this.torrentMgr.notifyTorrentObserverMain(this.torrent, 7);
                    this.close("Nobody interested!");
                }
                if (this.ellapsedTime - this.lastMessageSentTime >= 120) {
                    this.sendKeepAliveMessage();
                }
                if (this.piecesToDownload.size() != 0) break;
                this.issueDownload();
                break;
            }
        }
    }

    private void calculateLongConnection() {
        if (tcpConnectionTimeoutNum % 5 == 0) {
            useLongConnection = !useLongConnection;
        }
    }

    public void connect() {
        this.connectThread = new ConnectThread();
        this.connectThread.start();
    }

    public void startDownloading() {
        this.torrentMgr.notifyStatusChanged("Opening streams on: " + this.peer.getAddress());
        try {
            this.inputStream = this.socket.openInputStream();
            this.outputStream = this.socket.openOutputStream();
        }
        catch (IOException iOException) {
            this.close(1, "Opening streams failed - " + iOException.getMessage());
            this.torrentMgr.notifyStatusChanged("Opening streams failed on: " + this.peer.getAddress() + " | " + iOException.getMessage());
            return;
        }
        this.torrentMgr.notifyStatusChanged("Start download from: " + this.peer.getAddress());
        this.changeState(3);
        this.sendHandshakeMessage();
        this.ellapsedTime = 0;
        new Thread(){

            public void run() {
                MTPeerConnection.this.read();
            }
        }.start();
    }

    public void sendHandshakeMessage() {
        block6: {
            if (this.torrent != null) {
                this.log("Sending handshake");
                try {
                    if (this.outputStream != null) {
                        byte[] byArray = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byteArrayOutputStream.write((byte)"BitTorrent protocol".length());
                        byteArrayOutputStream.write("BitTorrent protocol".getBytes());
                        byteArrayOutputStream.write(byArray);
                        byteArrayOutputStream.write(this.torrent.getInfoHashByteArray());
                        byteArrayOutputStream.write(this.torrentMgr.getPeerID().getBytes());
                        this.outputStream.write(byteArrayOutputStream.toByteArray());
                        this.outputStream.flush();
                        this.log("Handshake sent");
                        break block6;
                    }
                    this.close("ERROR, while send handshake, outputstream is NULL");
                }
                catch (IOException iOException) {
                    this.log("ERROR, while send handshake");
                    this.close(1, "Error while writing");
                }
                catch (Exception exception) {
                    this.log("ERROR, while send handshake");
                    this.close(1, "Error while writing");
                }
            } else {
                this.log("ERROR, torrent is not specified, cannot send handshake");
            }
        }
    }

    public String remoteAddress() {
        return this.peer.getAddress() + ":" + this.peer.getPort();
    }

    public void changeState(int n) {
        this.state = n;
        this.ellapsedTime = 0;
    }

    public void log(String string) {
        MTLogger.writeLine("[Peer " + this.peer.getAddress() + ":" + this.peer.getPort() + " " + this.peer.getClient() + "]");
        MTLogger.writeLine("\t" + string);
    }

    public int state() {
        return this.state;
    }

    private void setPeerWireConnected() {
        this.peerWireConnected = true;
        this.torrent.increasePWConnectionCount();
    }

    public void close(String string) {
        this.close(2, string);
    }

    public void close(int n, String string) {
        this.log("Closing connection. Reason: " + string);
        if (this.state != 5) {
            this.closeOrder = n;
            this.readEnabled = false;
            this.changeState(5);
            if (this.torrent != null) {
                this.torrent.peerDisconnected(this.peer, this.peerWireConnected);
            }
            this.peerWireConnected = false;
            if (this.connectThread != null) {
                this.connectThread.setOk(false);
                if (this.connectThread.isAlive()) {
                    this.connectThread.interrupt();
                }
                this.connectThread = null;
            }
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                    this.inputStream = null;
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                    this.outputStream = null;
                }
                if (this.socket != null) {
                    this.socket.close();
                    this.socket = null;
                }
            }
            catch (Exception exception) {
                MTLogger.write("Exception while closing: " + exception.getMessage());
            }
            this.inputStream = null;
            this.outputStream = null;
            this.socket = null;
        }
    }

    private boolean isChoking() {
        return (1 & this.statusFlags) > 0;
    }

    private boolean isPeerChoking() {
        return (4 & this.statusFlags) > 0;
    }

    private void setChoking(boolean bl) {
        if (bl) {
            if (!this.isChoking()) {
                this.statusFlags |= 1;
                if (this.state == 4) {
                    this.sendChokeMessage();
                }
            }
        } else if (this.isChoking()) {
            this.statusFlags &= 0xFFFFFFFE;
            if (this.state == 4) {
                this.sendUnchokeMessage();
            }
        }
    }

    private void setPeerChoking(boolean bl) {
        this.statusFlags = bl ? (this.statusFlags |= 4) : (this.statusFlags &= 0xFFFFFFFB);
    }

    private boolean isInterested() {
        return (2 & this.statusFlags) > 0;
    }

    private boolean isPeerInterested() {
        return (8 & this.statusFlags) > 0;
    }

    private void setInterested(boolean bl) {
        if (bl) {
            if (!this.isInterested()) {
                this.statusFlags |= 2;
                if (this.state == 4) {
                    this.sendInterestedMessage();
                }
            }
        } else if (this.isInterested()) {
            this.statusFlags &= 0xFFFFFFFD;
            if (this.state == 4) {
                this.sendNotInterestedMessage();
                if (!this.isPeerInterested()) {
                    this.close("Nobody interested");
                }
            }
        }
    }

    private void setPeerInterested(boolean bl) {
        if (bl) {
            this.statusFlags |= 8;
        } else {
            this.statusFlags &= 0xFFFFFFF7;
            if (this.state == 4 && !this.isInterested()) {
                this.close("Nobody interested");
            }
        }
    }

    private byte[] putIntToSendBuffer(int n) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(n & 0xFF);
        byArray[2] = (byte)((n & 0xFF00) >> 8);
        byArray[1] = (byte)((n & 0xFF0000) >> 16);
        byArray[0] = (byte)((n & 0xFF000000) >> 24);
        return byArray;
    }

    public void sendKeepAliveMessage() {
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                this.outputStream.write(this.putIntToSendBuffer(0));
                this.outputStream.flush();
            } else {
                this.close("ERROR, while send keepalive, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close(1, "Error while writing keepalive");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close(1, "Error while writing keepalive");
        }
    }

    private void sendBitfieldMessage() {
        byte[] byArray = this.torrent.getBitField().data();
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(this.putIntToSendBuffer(1 + byArray.length));
                byteArrayOutputStream.write(5);
                byteArrayOutputStream.write(byArray);
                byteArrayOutputStream.flush();
                this.outputStream.write(byteArrayOutputStream.toByteArray());
                this.outputStream.flush();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                this.log("out BITFIELD");
            } else {
                this.close("ERROR, while send bitfield, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close(1, "Error while writing bitfield");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close(1, "Error while writing bitfield");
        }
    }

    private void sendFakeBitfieldMessage() {
        byte[] byArray = new byte[this.torrent.getBitField().lengthInBytes()];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = 0;
        }
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(this.putIntToSendBuffer(1 + byArray.length));
                byteArrayOutputStream.write(5);
                byteArrayOutputStream.write(byArray);
                byteArrayOutputStream.flush();
                this.outputStream.write(byteArrayOutputStream.toByteArray());
                this.outputStream.flush();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                this.log("out FAKEBITFIELD");
            } else {
                this.close("ERROR, while send bitfield, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close(1, "Error while writing bitfield");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close(1, "Error while writing bitfield");
        }
    }

    private void sendInterestedMessage() {
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(this.putIntToSendBuffer(1));
                byteArrayOutputStream.write(2);
                byteArrayOutputStream.flush();
                this.outputStream.write(byteArrayOutputStream.toByteArray());
                this.outputStream.flush();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                this.log("out INTERESTED");
            } else {
                this.close("ERROR, while send interested, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close(1, "Error while writing interested: " + iOException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close(1, "Error while writing interested: " + exception.getMessage());
        }
    }

    private void sendNotInterestedMessage() {
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(this.putIntToSendBuffer(1));
                byteArrayOutputStream.write(3);
                byteArrayOutputStream.flush();
                this.outputStream.write(byteArrayOutputStream.toByteArray());
                this.outputStream.flush();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                this.torrent.increaseNotInterestedMessages();
                this.log("out NOTINTERESTED");
            } else {
                this.close("ERROR, while send notinterested, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close(1, "Error while writing notinterested");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close(1, "Error while writing notinterested");
        }
    }

    private void sendChokeMessage() {
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(this.putIntToSendBuffer(1));
                byteArrayOutputStream.write(0);
                byteArrayOutputStream.flush();
                this.outputStream.write(byteArrayOutputStream.toByteArray());
                this.outputStream.flush();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                this.log("out CHOKE");
            } else {
                this.close("ERROR, while send choke, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close(1, "Error while writing choke");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close(1, "Error while writing choke");
        }
    }

    private void sendUnchokeMessage() {
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(this.putIntToSendBuffer(1));
                byteArrayOutputStream.write(1);
                byteArrayOutputStream.flush();
                this.outputStream.write(byteArrayOutputStream.toByteArray());
                this.outputStream.flush();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                this.log("out UNCHOKE");
            } else {
                this.close("ERROR, while send unchoke, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.close(1, "Error while writing unchoke");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.close(1, "Error while writing unchoke");
        }
    }

    private void sendRequestMessage(MTPieceToDownload mTPieceToDownload) {
        if (mTPieceToDownload != null) {
            try {
                if (this.outputStream != null) {
                    this.lastMessageSentTime = this.ellapsedTime;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byteArrayOutputStream.write(this.putIntToSendBuffer(13));
                    byteArrayOutputStream.write(6);
                    byteArrayOutputStream.write(this.putIntToSendBuffer(mTPieceToDownload.piece.index()));
                    byteArrayOutputStream.write(this.putIntToSendBuffer(mTPieceToDownload.piece.getDownloadedSize()));
                    int n = mTPieceToDownload.piece.getTotalSize() - mTPieceToDownload.piece.getDownloadedSize();
                    if (n > 16384) {
                        n = 16384;
                    }
                    byteArrayOutputStream.write(this.putIntToSendBuffer(n));
                    byteArrayOutputStream.flush();
                    this.outputStream.write(byteArrayOutputStream.toByteArray());
                    this.outputStream.flush();
                    byteArrayOutputStream.close();
                    byteArrayOutputStream = null;
                    mTPieceToDownload.lastRequestLength = n;
                    mTPieceToDownload.lastRequestBegin = mTPieceToDownload.piece.getDownloadedSize();
                    this.log("out REQUEST " + mTPieceToDownload.piece.index() + "from: " + mTPieceToDownload.piece.getDownloadedSize() + " (block length: " + n + ")");
                } else {
                    this.close("ERROR, while send request, outputstream is NULL");
                }
            }
            catch (IOException iOException) {
                this.close(1, "Error while writing request");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.close(1, "Error while writing request");
            }
        }
    }

    public void sendHaveMessage(int n) {
        try {
            if (this.outputStream != null) {
                this.lastMessageSentTime = this.ellapsedTime;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byteArrayOutputStream.write(this.putIntToSendBuffer(5));
                byteArrayOutputStream.write(4);
                byteArrayOutputStream.write(this.putIntToSendBuffer(n));
                byteArrayOutputStream.flush();
                this.outputStream.write(byteArrayOutputStream.toByteArray());
                this.outputStream.flush();
                byteArrayOutputStream.close();
                byteArrayOutputStream = null;
                this.log("out HAVE Piece: " + n);
            } else {
                this.close("ERROR, while send have, outputstream is NULL");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void sendPieceMessage(int n, int n2, int n3) {
        block8: {
            MTPiece mTPiece = this.torrent.piece(n);
            if (mTPiece != null) {
                this.log("Processing piece request " + n + " Begin: " + n2 + " Length: " + n3 + " while piece totalsize: " + mTPiece.getTotalSize());
                if (n2 + n3 > mTPiece.getTotalSize()) {
                    this.close("Bad PIECE request (index is out of bounds)");
                    return;
                }
                byte[] byArray = mTPiece.getBlock(n2, n3);
                if (byArray == null) {
                    this.close("Failed to extract block of piece");
                    return;
                }
                try {
                    if (this.outputStream != null) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        byteArrayOutputStream.write(this.putIntToSendBuffer(9 + n3));
                        byteArrayOutputStream.write(7);
                        byteArrayOutputStream.write(this.putIntToSendBuffer(n));
                        byteArrayOutputStream.write(this.putIntToSendBuffer(n2));
                        byteArrayOutputStream.write(byArray);
                        byteArrayOutputStream.flush();
                        this.outputStream.write(byteArrayOutputStream.toByteArray());
                        this.outputStream.flush();
                        byteArrayOutputStream.close();
                        byteArrayOutputStream = null;
                        this.torrent.updateBytesUploaded(n3, true);
                        this.lastMessageSentTime = this.ellapsedTime;
                        this.log("out PIECE Index: " + n + " Begin: " + n2 + " Length: " + n3);
                        break block8;
                    }
                    this.close("ERROR, while send piece, outputstream is NULL");
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.close(1, "Error while writing piece " + iOException.getMessage());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    this.close(1, "Error while writing piece(e) " + exception.getMessage());
                }
            } else {
                this.close("Bad PIECE index");
            }
        }
    }

    void sendCancelMessage(MTPieceToDownload mTPieceToDownload) {
        this.lastMessageSentTime = this.ellapsedTime;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(this.putIntToSendBuffer(13));
            byteArrayOutputStream.write(8);
            byteArrayOutputStream.write(this.putIntToSendBuffer(mTPieceToDownload.piece.index()));
            byteArrayOutputStream.write(this.putIntToSendBuffer(mTPieceToDownload.lastRequestBegin));
            byteArrayOutputStream.write(this.putIntToSendBuffer(mTPieceToDownload.lastRequestLength));
            byteArrayOutputStream.flush();
            this.outputStream.write(byteArrayOutputStream.toByteArray());
            this.outputStream.flush();
            byteArrayOutputStream.close();
            byteArrayOutputStream = null;
            this.log("out CANCEL[" + mTPieceToDownload.piece.index() + "] (block length: " + mTPieceToDownload.lastRequestTime + ")");
        }
        catch (IOException iOException) {
            this.close(1, "Error while writing cancel message");
        }
        catch (Exception exception) {
            this.close(1, "Error while writing cancel message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelPieceRequest(MTPiece mTPiece) {
        if (this.state == 4) {
            MTPieceToDownload mTPieceToDownload = null;
            Vector vector = this.piecesToDownload;
            synchronized (vector) {
                for (int i = 0; i < this.piecesToDownload.size(); ++i) {
                    MTPieceToDownload mTPieceToDownload2 = (MTPieceToDownload)this.piecesToDownload.elementAt(i);
                    if (!mTPieceToDownload2.piece.equals(mTPiece)) continue;
                    mTPieceToDownload = mTPieceToDownload2;
                    this.piecesToDownload.removeElementAt(i);
                    break;
                }
            }
            if (mTPieceToDownload != null && mTPieceToDownload.hasPendingRequest) {
                this.sendCancelMessage(mTPieceToDownload);
                this.issueDownload();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelAllPieceRequests() {
        if (this.state == 4) {
            MTPieceToDownload[] mTPieceToDownloadArray;
            int n = 0;
            Vector vector = this.piecesToDownload;
            synchronized (vector) {
                mTPieceToDownloadArray = new MTPieceToDownload[this.piecesToDownload.size()];
                for (int i = 0; i < this.piecesToDownload.size(); ++i) {
                    MTPieceToDownload mTPieceToDownload = (MTPieceToDownload)this.piecesToDownload.elementAt(i);
                    if (!mTPieceToDownload.hasPendingRequest) continue;
                    mTPieceToDownloadArray[n++] = mTPieceToDownload;
                }
            }
            for (int i = 0; i < n; ++i) {
                this.sendCancelMessage(mTPieceToDownloadArray[i]);
            }
            mTPieceToDownloadArray = null;
        }
    }

    public String getRemoteAddress() {
        return this.peer.getAddress();
    }

    public int getPort() {
        return this.peer.getPort();
    }

    public MTPeer getPeer() {
        return this.peer;
    }

    public MTPeerConnection getPeerConnection() {
        return this;
    }

    public int getCloseOrder() {
        return this.closeOrder;
    }

    public Vector getPiecesToDownload() {
        return this.piecesToDownload;
    }

    public void setTorrent(MTTorrent mTTorrent) {
        this.torrent = mTTorrent;
    }

    public SocketConnection getSocket() {
        return this.socket;
    }

    public boolean isIncomingConnection() {
        return this.incomingConnection;
    }

    class ConnectThread
    extends Thread {
        private boolean ok = true;

        ConnectThread() {
        }

        public void run() {
            try {
                MTPeerConnection.this.retries++;
                MTPeerConnection.this.reconnectAfter = 0;
                MTPeerConnection.this.changeState(1);
                MTPeerConnection.this.ellapsedTime = 0;
                if (MTPeerConnection.this.peer.isIpOK() || MTPeerConnection.this.peer.isIpCheckTimeout() && MTNetworkStatusManager.testIP(MTPeerConnection.this.peer.getAddress(), MTPeerConnection.this.peer.getPort(), MTPeerConnection.this.torrent, MTPeerConnection.this.torrentMgr.getSatistics())) {
                    MTPeerConnection.this.peer.setIpOK(true);
                    MTPeerConnection.this.peer.setLastIPCheckTime(System.currentTimeMillis());
                    String string = MTPeerConnection.this.remoteAddress();
                    try {
                        MTPeerConnection.this.torrentMgr.notifyStatusChanged("Trying to connect to: " + string);
                        MTPeerConnection.this.log("--- Trying to connect to: " + string);
                        if (useLongConnection) {
                            MTPeerConnection.this.socket = (SocketConnection)MTNetworkStatusManager.connect("socket://" + string, 3, true);
                        } else {
                            MTPeerConnection.this.socket = (SocketConnection)MTNetworkStatusManager.connect("socket://" + string);
                        }
                        if (!this.ok) {
                            MTLogger.writeLine("--- Connect thread finished after dead: " + string);
                            if (MTPeerConnection.this.socket != null) {
                                MTPeerConnection.this.socket.close();
                            }
                            MTPeerConnection.this.socket = null;
                            return;
                        }
                        MTPeerConnection.this.readEnabled = true;
                        MTPeerConnection.this.changeState(2);
                        MTPeerConnection.this.torrentMgr.notifyStatusChanged("Succesfull connection to: " + string);
                        MTPeerConnection.this.log("TCP connecting successed");
                        MTPeerConnection.this.startDownloading();
                    }
                    catch (IOException iOException) {
                        MTPeerConnection.this.close(1, "Connecting failed - " + iOException.getMessage());
                        MTPeerConnection.this.torrentMgr.notifyStatusChanged("Connection failed to (IO): " + string + " | " + iOException.getMessage());
                        MTPeerConnection.this.calculateLongConnection();
                    }
                    catch (Exception exception) {
                        MTPeerConnection.this.close(1, "Connecting failed (general)- " + exception.getMessage());
                        MTPeerConnection.this.torrentMgr.notifyStatusChanged("Connection failed to (general): " + string + " | " + exception.getMessage());
                    }
                } else {
                    MTPeerConnection.this.peer.setIpOK(false);
                    MTPeerConnection.this.peer.setLastIPCheckTime(System.currentTimeMillis());
                    MTPeerConnection.this.close(1, "Connecting failed - IPCheck failed");
                    MTPeerConnection.this.torrentMgr.notifyStatusChanged("Connection failed - IPCheck error: " + MTPeerConnection.this.peer.getAddress() + ":" + MTPeerConnection.this.peer.getPort());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void setOk(boolean bl) {
            this.ok = bl;
        }
    }

    class BlockRequest {
        public int pieceIndex;
        public int begin;
        public int length;

        public BlockRequest(int n, int n2, int n3) {
            this.pieceIndex = n;
            this.begin = n2;
            this.length = n3;
        }
    }
}

