/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Bencode.MTBencode;
import Bencode.MTBencodedDictionary;
import Bencode.MTBencodedInteger;
import Bencode.MTBencodedString;
import java.util.Date;

public class MTTracker {
    public static final int UNKNOWN = 0;
    public static final int WORKING = 1;
    public static final int FAILEDTOCONNECT = 2;
    private String url;
    private int status;
    private int interval;
    private int seeders;
    private int leechers;
    private String trackerId;
    private long lastRequest;
    private int failCount;

    public MTTracker(String string) {
        this.url = string;
        this.status = 0;
        this.seeders = -1;
        this.leechers = -1;
        this.lastRequest = -1L;
        this.failCount = 0;
    }

    public void processResponse(MTBencode mTBencode) {
        if (mTBencode.type() != MTBencode.BencodedDictionary) {
            return;
        }
        MTBencodedDictionary mTBencodedDictionary = (MTBencodedDictionary)mTBencode;
        if (mTBencodedDictionary.entryValue("failure reason") != null) {
            return;
        }
        try {
            this.interval = ((MTBencodedInteger)mTBencodedDictionary.entryValue("interval")).getValue();
            this.seeders = ((MTBencodedInteger)mTBencodedDictionary.entryValue("complete")).getValue();
            this.leechers = ((MTBencodedInteger)mTBencodedDictionary.entryValue("incomplete")).getValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        MTBencodedString mTBencodedString = (MTBencodedString)mTBencodedDictionary.entryValue("tracker id");
        if (mTBencodedString != null) {
            this.trackerId = mTBencodedString.getStringValue();
        }
        this.lastRequest = new Date().getTime();
        this.status = 1;
    }

    public boolean canRequest() {
        if (this.lastRequest < 0L) {
            return true;
        }
        long l = new Date().getTime() - this.lastRequest;
        return l > (long)this.interval * 1000L;
    }

    public int getInterval() {
        return this.interval;
    }

    public long getLastRequest() {
        return this.lastRequest;
    }

    public int getLeechers() {
        return this.leechers;
    }

    public int getSeeders() {
        return this.seeders;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int n) {
        if (n == 2) {
            ++this.failCount;
        }
        if (n == 1) {
            this.failCount = 0;
        }
        this.status = n;
    }

    public String getTrackerId() {
        return this.trackerId;
    }

    public String getUrl() {
        return this.url;
    }
}

