/*
 * Decompiled with CFR 0.152.
 */
package Bencode;

import Bencode.MTBencode;
import Bencode.MTBencodedDictionaryEntry;
import Bencode.MTBencodedString;
import Logger.MTLogger;
import Tools.NetTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;

public class MTBencodedDictionary
extends MTBencode {
    private Vector entries = new Vector();

    public int count() {
        return this.entries.size();
    }

    public int type() {
        return MTBencode.BencodedDictionary;
    }

    public void addEntry(MTBencodedDictionaryEntry mTBencodedDictionaryEntry) {
        if (this.entries.size() == 0) {
            this.entries.addElement(mTBencodedDictionaryEntry);
        } else {
            boolean bl = false;
            for (int i = 0; i < this.entries.size(); ++i) {
                MTBencodedDictionaryEntry mTBencodedDictionaryEntry2 = (MTBencodedDictionaryEntry)this.entries.elementAt(i);
                if (MTBencodedDictionaryEntry.compare(mTBencodedDictionaryEntry2, mTBencodedDictionaryEntry) <= 0) continue;
                this.entries.insertElementAt(mTBencodedDictionaryEntry, i);
                bl = true;
                break;
            }
            if (!bl) {
                this.entries.addElement(mTBencodedDictionaryEntry);
            }
        }
    }

    public void addEntry(MTBencodedString mTBencodedString, MTBencode mTBencode) {
        this.addEntry(new MTBencodedDictionaryEntry(mTBencodedString, mTBencode));
    }

    public void addEntry(byte[] byArray, MTBencode mTBencode) {
        this.addEntry(new MTBencodedDictionaryEntry(new MTBencodedString(byArray), mTBencode));
    }

    public MTBencode entryValue(String string) {
        for (int i = 0; i < this.entries.size(); ++i) {
            MTBencodedDictionaryEntry mTBencodedDictionaryEntry = (MTBencodedDictionaryEntry)this.entries.elementAt(i);
            if (!new String(mTBencodedDictionaryEntry.getKey().getValue()).equals(string)) continue;
            return mTBencodedDictionaryEntry.getValue();
        }
        return null;
    }

    public MTBencode entryValue(byte[] byArray) {
        for (int i = 0; i < this.entries.size(); ++i) {
            MTBencodedDictionaryEntry mTBencodedDictionaryEntry = (MTBencodedDictionaryEntry)this.entries.elementAt(i);
            if (!NetTools.byteArrayEqual(mTBencodedDictionaryEntry.getKey().getValue(), byArray)) continue;
            return mTBencodedDictionaryEntry.getValue();
        }
        return null;
    }

    public MTBencode entryValue(MTBencodedString mTBencodedString) {
        return this.entryValue(mTBencodedString.getValue());
    }

    public MTBencodedDictionaryEntry entry(int n) {
        return (MTBencodedDictionaryEntry)this.entries.elementAt(n);
    }

    public void toLog(int n) {
        for (int i = 0; i < this.entries.size(); ++i) {
            ((MTBencodedDictionaryEntry)this.entries.elementAt(i)).getKey().toLog(n + 1);
            MTLogger.write(" :");
            String string = new String(((MTBencodedDictionaryEntry)this.entries.elementAt(i)).getKey().getValue());
            if (!string.equals("pieces")) {
                ((MTBencodedDictionaryEntry)this.entries.elementAt(i)).getValue().toLog(n + 2);
            } else {
                MTLogger.write("[pieces]");
            }
            MTLogger.writeLine("");
        }
    }

    public byte[] Bencode() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write("d".getBytes());
            for (int i = 0; i < this.entries.size(); ++i) {
                byteArrayOutputStream.write(((MTBencodedDictionaryEntry)this.entries.elementAt(i)).getKey().Bencode());
                byteArrayOutputStream.write(((MTBencodedDictionaryEntry)this.entries.elementAt(i)).getValue().Bencode());
            }
            byteArrayOutputStream.write("e".getBytes());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

