/*
 * Decompiled with CFR 0.152.
 */
package TorrentEngine;

import Bencode.MTBencode;
import Logger.MTLogger;
import Settings.Preferences;
import Tools.NetTools;
import TorrentEngine.MTFileManager;
import TorrentEngine.MTNetworkManager;
import TorrentEngine.MTOpenTorrentResult;
import TorrentEngine.MTPeer;
import TorrentEngine.MTPeerConnection;
import TorrentEngine.MTTorrent;
import TorrentEngine.MTTorrentObserver;
import TorrentEngine.Statistics;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.microedition.io.SocketConnection;

public class MTTorrentManager {
    private Vector torrents;
    private String peerID;
    private long seed;
    private int key;
    private boolean enabledTimer = true;
    private TimerThread timerThread;
    private MTTorrentObserver os;
    private MTNetworkManager networkManager;
    private Vector incomingPeers;
    private int incomingConnectionCount = 0;
    private Statistics stats;

    public MTTorrentManager(MTTorrentObserver mTTorrentObserver) {
        this(mTTorrentObserver, null);
    }

    public MTTorrentManager(MTTorrentObserver mTTorrentObserver, Statistics statistics) {
        this.os = mTTorrentObserver;
        this.stats = statistics;
        this.torrents = new Vector();
        this.incomingPeers = new Vector();
        Date date = new Date();
        this.seed = date.getTime();
        Random random = new Random();
        random.setSeed(this.seed);
        this.key = Math.abs(random.nextInt());
        this.generatePeerId();
        this.networkManager = new MTNetworkManager(this);
        this.timerThread = new TimerThread();
        this.getTimerThread().start();
    }

    public void setAddressBooster(boolean bl) {
        Preferences.EnableAddressBooster = bl;
    }

    public MTOpenTorrentResult openTorrent(String string, String string2, boolean bl, byte[] byArray, String string3) {
        if (string3 == null) {
            return null;
        }
        MTTorrent mTTorrent = new MTTorrent(this, string3);
        this.torrents.addElement(mTTorrent);
        byte[] byArray2 = MTFileManager.viewFile(string);
        if (byArray2 == null) {
            return new MTOpenTorrentResult(-6, mTTorrent);
        }
        MTBencode mTBencode = MTBencode.parse(byArray2);
        if (mTBencode == null) {
            return new MTOpenTorrentResult(-6, mTTorrent);
        }
        mTTorrent.setTorrentNameWithoutPath(string2);
        mTTorrent.setTorrentFilePath(string);
        int n = mTTorrent.readFromBencodedData(mTBencode, bl);
        if (n == 0) {
            if (bl) {
                mTTorrent.initializeByBitfield(byArray);
            } else if (this.stats != null) {
                this.stats.onTorrentStarted(mTTorrent);
            }
            return new MTOpenTorrentResult(n, mTTorrent);
        }
        return new MTOpenTorrentResult(-6, mTTorrent);
    }

    public boolean thisTorrentAlreadyAdded(MTTorrent mTTorrent, String string) {
        for (int i = 0; i < this.torrents.size(); ++i) {
            String string2;
            MTTorrent mTTorrent2 = (MTTorrent)this.torrents.elementAt(i);
            if (mTTorrent2.equals(mTTorrent) || (string2 = mTTorrent2.getInfoHash()) == null || !string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private void generatePeerId() {
        this.peerID = "-MB0001-";
        Date date = new Date();
        date.getTime();
        Random random = new Random();
        random.setSeed(this.seed);
        for (int i = 0; i < 12; ++i) {
            this.peerID = this.peerID + (char)(Math.abs(random.nextInt()) % 25 + 97);
        }
    }

    public MTTorrent simpleTorrentAtIndex(int n) {
        if (this.torrents.size() > n) {
            return (MTTorrent)this.torrents.elementAt(n);
        }
        return null;
    }

    public int getSimpleTorrentsNum() {
        return this.torrents.size();
    }

    public int getSimpleTorrentIndexByName(String string) {
        MTTorrent mTTorrent = null;
        for (int i = 0; i < this.torrents.size(); ++i) {
            mTTorrent = (MTTorrent)this.torrents.elementAt(i);
            if (mTTorrent.getTorrentNameWithoutPath().indexOf(string) == -1) continue;
            return i;
        }
        return -1;
    }

    public int getTorrentIndex(MTTorrent mTTorrent) {
        return this.torrents.indexOf(mTTorrent);
    }

    public void removeSimpleTorrentFromVector(int n) {
        MTTorrent mTTorrent = (MTTorrent)this.torrents.elementAt(n);
        if (mTTorrent != null) {
            this.torrents.removeElementAt(n);
            mTTorrent = null;
            System.gc();
        }
    }

    public void removeTorrentFromVector(MTTorrent mTTorrent) {
        this.torrents.removeElement(mTTorrent);
        mTTorrent = null;
        System.gc();
    }

    public int attachPeerToTorrent(byte[] byArray, MTPeerConnection mTPeerConnection) {
        for (int i = 0; i < this.torrents.size(); ++i) {
            MTTorrent mTTorrent = (MTTorrent)this.torrents.elementAt(i);
            int n = this.executeAttachPeerToTorrent(byArray, mTPeerConnection, mTTorrent);
            if (n == -7) continue;
            return n;
        }
        return -6;
    }

    private int executeAttachPeerToTorrent(byte[] byArray, MTPeerConnection mTPeerConnection, MTTorrent mTTorrent) {
        if (NetTools.byteArrayEqual(mTTorrent.getInfoHashByteArray(), byArray)) {
            if (mTTorrent.getActiveConnectionCount() >= 7) {
                return -6;
            }
            MTPeer mTPeer = mTTorrent.peer(mTPeerConnection.getRemoteAddress(), mTPeerConnection.getPort());
            if (mTPeer != null) {
                if (mTPeer.state() != 0) {
                    return -6;
                }
                mTTorrent.removePeer(mTPeerConnection.getRemoteAddress(), mTPeerConnection.getPort());
                mTPeerConnection.getPeer().setBitFieldLength(mTTorrent.pieceCount());
                mTPeerConnection.setTorrent(mTTorrent);
                if (mTTorrent.addPeer(mTPeerConnection.getPeer()) != 0) {
                    return -6;
                }
                this.incomingPeers.removeElement(mTPeerConnection.getPeer());
                return 0;
            }
            mTPeerConnection.setTorrent(mTTorrent);
            mTPeerConnection.getPeer().setBitFieldLength(mTTorrent.pieceCount());
            if (mTTorrent.addPeer(mTPeerConnection.getPeer()) != 0) {
                return -6;
            }
            this.incomingPeers.removeElement(mTPeerConnection.getPeer());
            return 0;
        }
        return -7;
    }

    public String getPeerID() {
        return this.peerID;
    }

    public TimerThread getTimerThread() {
        return this.timerThread;
    }

    public void notifyTorrentObserver(MTTorrent mTTorrent, int n) {
        this.os.torrentChanged(mTTorrent, this.torrents.indexOf(mTTorrent), n);
    }

    public void notifyTorrentObserverMain(MTTorrent mTTorrent, int n) {
        this.os.torrentMainChanged(mTTorrent, this.torrents.indexOf(mTTorrent), n);
    }

    public void notifyOpenTorrentStateChanged(int n, MTTorrent mTTorrent, String string, double d) {
        this.os.openTorrentStateChanged(n, mTTorrent, string, d);
    }

    public void notifyStatusChanged(String string) {
        this.os.statusChanged(string);
    }

    public void incBytesUploaded(int n) {
    }

    public void registerIncomingConnection(SocketConnection socketConnection) {
        MTPeer mTPeer = new MTPeer(socketConnection, this);
        this.incomingPeers.addElement(mTPeer);
    }

    public void incIncomingConnectionCount() {
        ++this.incomingConnectionCount;
    }

    public void decIncomingConnectionCount() {
        --this.incomingConnectionCount;
    }

    public double getSimpleDownloadPercent(int n) {
        return ((MTTorrent)this.torrents.elementAt(n)).getDownloadPercent();
    }

    public void endTorrentManager() {
        MTLogger.writeLine("Closing application.");
        MTLogger.close();
        this.enabledTimer = false;
        for (int i = 0; i < this.torrents.size(); ++i) {
            ((MTTorrent)this.torrents.elementAt(i)).stop(false);
        }
        this.networkManager.stopListening();
    }

    public MTNetworkManager getNetworkManager() {
        return this.networkManager;
    }

    public int getKey() {
        return this.key;
    }

    public Statistics getSatistics() {
        return this.stats;
    }

    public void setStatistics(Statistics statistics) {
        this.stats = statistics;
    }

    class TimerThread
    extends Thread {
        TimerThread() {
        }

        public void run() {
            while (MTTorrentManager.this.enabledTimer) {
                try {
                    int n;
                    for (n = 0; n < MTTorrentManager.this.torrents.size(); ++n) {
                        MTTorrent mTTorrent = (MTTorrent)MTTorrentManager.this.torrents.elementAt(n);
                        mTTorrent.onTimer();
                    }
                    for (n = 0; n < MTTorrentManager.this.incomingPeers.size(); ++n) {
                        ((MTPeer)MTTorrentManager.this.incomingPeers.elementAt(n)).onTimer();
                    }
                    for (n = 0; n < MTTorrentManager.this.incomingPeers.size(); ++n) {
                        MTPeer mTPeer = (MTPeer)MTTorrentManager.this.incomingPeers.elementAt(n);
                        if (mTPeer.state() != 5 && mTPeer.state() != 0) continue;
                        mTPeer = null;
                        MTTorrentManager.this.incomingPeers.removeElementAt(n);
                        --n;
                    }
                    TimerThread.sleep(1000L);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.gc();
                }
            }
        }
    }
}

